/*
 * Decompiled with CFR 0.152.
 */
package userinterface.model.graphicModel;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.StringTokenizer;
import userinterface.model.graphicModel.State;
import userinterface.model.graphicModel.Transition;
import userinterface.util.PropertyException;
import userinterface.util.PropertyOwner;
import userinterface.util.SingleProperty;

public class StringLabel
extends SingleProperty {
    private double offsetX = 0.0;
    private double offsetY = 0.0;
    private Color theColour;
    private Font theFont;
    private Object parent;
    private boolean selected = false;
    public static boolean lineLabels;
    private ArrayList intersects = null;
    double maxX = Double.NEGATIVE_INFINITY;
    double maxY = Double.NEGATIVE_INFINITY;
    double minX = Double.POSITIVE_INFINITY;
    double minY = Double.POSITIVE_INFINITY;

    public StringLabel(String string, Object object) {
        this(string, object, "");
    }

    public StringLabel(String string, Object object, String string2) {
        this(string, object, string2, true, "");
    }

    public StringLabel(String string, Object object, String string2, boolean bl, String string3) {
        super((PropertyOwner)object, string2, string, "", bl, string3);
        this.theColour = Color.black;
        this.theFont = new Font("monospaced", 0, 10);
        this.parent = object;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public String getString() {
        return (String)this.getProperty();
    }

    public double getOffsetX() {
        return this.offsetX;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        this.intersects = new ArrayList();
        if (!this.getString().equals("")) {
            double d;
            double d2;
            if (this.parent instanceof State) {
                d2 = ((State)this.parent).getX();
                d = ((State)this.parent).getY();
            } else if (this.parent instanceof Transition) {
                d2 = ((Transition)this.parent).getMiddle().getX();
                d = ((Transition)this.parent).getMiddle().getY();
            } else {
                d2 = 0.0;
                d = 0.0;
            }
            double d3 = d2 + this.offsetX;
            double d4 = d + this.offsetY - 5.0;
            String string = "";
            if (lineLabels) {
                string = this.getName() + ": ";
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string + this.getRenderString(), "\n");
            int n = 0;
            boolean bl = false;
            while (stringTokenizer.hasMoreTokens() && !bl) {
                String string2 = stringTokenizer.nextToken().trim();
                double d5 = this.theFont.getSize2D();
                double d6 = (double)(this.theFont.getSize2D() * (float)string2.length()) * 0.625;
                this.intersects.add(new Rectangle2D.Double(d3, d4 + ((double)n * (d5 + 1.75) - 2.0), d6, d5));
                bl = new Rectangle2D.Double(d3, d4 + ((double)n * (d5 + 1.75) - 2.0), d6, d5).intersects(rectangle2D);
                ++n;
            }
            return bl;
        }
        return false;
    }

    public void setString(String string) {
        try {
            this.setProperty(string);
        }
        catch (PropertyException propertyException) {
            // empty catch block
        }
    }

    public void setOffsetX(double d) {
        this.offsetX = d;
    }

    public void move(double d, double d2) {
        if (this.getString().equals("")) {
            return;
        }
        this.offsetX += d;
        this.offsetY += d2;
    }

    public void setOffsetY(double d) {
        this.offsetY = d;
    }

    public void setColour(Color color) {
        this.theColour = color;
    }

    public void setFont(Font font) {
        this.theFont = font;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public Rectangle2D getBounds2D() {
        double d;
        double d2;
        StringTokenizer stringTokenizer = new StringTokenizer(this.getRenderString(), "\n");
        int n = stringTokenizer.countTokens();
        double d3 = this.theFont.getSize2D() * (float)n + 5.0f;
        double d4 = 0.0;
        while (stringTokenizer.hasMoreTokens()) {
            d2 = (double)(this.theFont.getSize2D() * (float)stringTokenizer.nextToken().length()) * 0.625;
            if (!(d2 > d4)) continue;
            d4 = d2;
        }
        if (this.parent instanceof State) {
            d2 = ((State)this.parent).getX();
            d = ((State)this.parent).getY();
        } else if (this.parent instanceof Transition) {
            d2 = ((Transition)this.parent).getMiddle().getX();
            d = ((Transition)this.parent).getMiddle().getY();
        } else {
            d2 = 0.0;
            d = 0.0;
        }
        double d5 = d2 + this.offsetX;
        double d6 = d + this.offsetY - 10.0;
        double d7 = d2 + d4 + this.offsetX;
        double d8 = d + d3 + this.offsetY - 10.0;
        return new Rectangle2D.Double(d5, d6, d7 - d5, d8 - d6);
    }

    public void workOutMinsAndMaxs() {
        double d;
        double d2;
        StringTokenizer stringTokenizer = new StringTokenizer(this.getRenderString(), "\n");
        int n = stringTokenizer.countTokens();
        double d3 = this.theFont.getSize2D() * (float)n + 5.0f;
        double d4 = 0.0;
        while (stringTokenizer.hasMoreTokens()) {
            d2 = (double)(this.theFont.getSize2D() * (float)stringTokenizer.nextToken().length()) * 0.625;
            if (!(d2 > d4)) continue;
            d4 = d2;
        }
        if (this.parent instanceof State) {
            d2 = ((State)this.parent).getX();
            d = ((State)this.parent).getY();
        } else if (this.parent instanceof Transition) {
            d2 = ((Transition)this.parent).getMiddle().getX();
            d = ((Transition)this.parent).getMiddle().getY();
        } else {
            d2 = 0.0;
            d = 0.0;
        }
        this.minX = d2 + this.offsetX - 5.0;
        this.minY = d + this.offsetY - 25.0;
        this.maxX = d2 + d4 + this.offsetX + 5.0;
        this.maxY = d + d3 + this.offsetY - 5.0;
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public void render(Graphics2D graphics2D, double d, double d2) {
        this.render(graphics2D, d, d2, false);
    }

    public String getRenderString() {
        if (this.getName().equals("sync")) {
            String string = this.getString();
            if (string.equals("")) {
                return this.getString();
            }
            return "[" + this.getString() + "]";
        }
        return this.getString();
    }

    public void render(Graphics2D graphics2D, double d, double d2, boolean bl) {
        this.intersects(new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0));
        StringTokenizer stringTokenizer = new StringTokenizer(this.getRenderString(), "\n");
        if (this.selected) {
            graphics2D.setColor(Color.green);
        } else {
            graphics2D.setColor(this.theColour);
        }
        graphics2D.setFont(this.theFont);
        int n = 0;
        boolean bl2 = false;
        while (stringTokenizer.hasMoreTokens()) {
            if (bl2) {
                graphics2D.drawString(stringTokenizer.nextToken(), (float)(d + this.offsetX), (float)(d2 + this.offsetY + (double)(n * (this.theFont.getSize() + 2))));
            } else if (!bl) {
                graphics2D.drawString(stringTokenizer.nextToken().trim(), (float)(d + this.offsetX), (float)(d2 + this.offsetY + (double)(n * this.theFont.getSize()) + 2.0));
            } else {
                graphics2D.drawString(this.getName() + ": " + stringTokenizer.nextToken().trim(), (float)(d + this.offsetX), (float)(d2 + this.offsetY + (double)(n * this.theFont.getSize()) + 2.0));
            }
            ++n;
            bl2 = true;
        }
    }
}

