/*
 * Decompiled with CFR 0.152.
 */
package userinterface.model.graphicModel;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import userinterface.GUIPrism;
import userinterface.model.GUIMultiModelHandler;
import userinterface.model.GUIMultiModelTree;
import userinterface.model.graphicModel.Decision;
import userinterface.model.graphicModel.ExpressionLabel;
import userinterface.model.graphicModel.GraphicModuleContainer;
import userinterface.model.graphicModel.GraphicSelection;
import userinterface.model.graphicModel.Nail;
import userinterface.model.graphicModel.ProbTransition;
import userinterface.model.graphicModel.State;
import userinterface.model.graphicModel.StringLabel;
import userinterface.model.graphicModel.Transition;
import userinterface.util.BooleanProperty;
import userinterface.util.PropertyOwner;
import userinterface.util.SelectionModel;

public class ModuleModel
extends SelectionModel
implements Observer {
    private GUIMultiModelHandler handler;
    private GUIMultiModelTree.ModuleNode corresponding;
    private GraphicModuleContainer container;
    private boolean modified;
    private String moduleName;
    private ArrayList variables;
    private ArrayList theStates;
    private ArrayList transitions;
    private ArrayList theNails;
    private int numStates;
    private int numTransitions;
    private int numNails;
    private double zoom;
    private double gridWidth;
    private double subdivisions;
    private boolean snap;
    private boolean showGrid;
    private boolean showLongLabels;
    private int currentWidth;
    private int currentHeight;
    private int viewingX;
    private int viewingY;
    private int scrOffsetX;
    private int scrOffsetY;
    private JPopupMenu transPopup;
    private JMenuItem addNailPop;
    private JMenuItem startTransition;
    private JMenuItem addState;
    private JMenuItem addChoice;
    private JMenuItem cut;
    private JMenuItem copy;
    private JMenuItem paste;
    private JMenuItem delete;
    private JMenuItem selectAll;
    private JMenuItem zoomIn;
    private JMenuItem zoomOut;
    private JMenuItem restoreZoom;
    private State starterState;
    private JPopupMenu modulePopup;
    private double popupX = Double.POSITIVE_INFINITY;
    private double popupY = Double.POSITIVE_INFINITY;
    private int mode;
    private boolean controlDown;
    public static final int EDIT = 0;
    public static final int ZOOM = 1;
    private boolean isSelecting;
    private double selStartX;
    private double selStartY;
    private double selEndX;
    private double selEndY;
    private boolean isZoomSelecting;
    private double zoomStartX;
    private double zoomStartY;
    private double zoomEndX;
    private double zoomEndY;
    private boolean zoomAreaChanged = false;
    private boolean isMoving;
    private boolean movingAbsolutes = true;
    private double lastX;
    private double lastY;
    private double currX;
    private double currY;
    private boolean drawingTrans;
    private double tranDrawX1;
    private double tranDrawY1;
    private double tranDrawX2;
    private double tranDrawY2;
    private State tempFromState;
    private Nail lastNail;
    private ArrayList tempNails;
    private boolean drawingProbTrans;
    private boolean tempProbNailDown;
    private boolean drawingExtraBranches;
    private double tempAddNailX;
    private double tempAddNailY;
    private State tempProbFrom;
    private Transition tempAddNailTrans;
    private Nail tempProbNail;
    private ArrayList tempProbNails;
    private Nail lastProbNail;
    private ArrayList tempProbTo;
    private boolean isOverMovable = false;
    private boolean overTransition = false;
    private Rectangle2D lastMouseBox = null;
    private double lastTranDrawX;
    private double lastTranDrawY;
    private double lastSelX;
    private double lastSelY;
    private double lastZoomX;
    private double lastZoomY;
    private boolean zoomChanged = false;
    private int centreX;
    private int centreY;
    private int cornerX;
    private int cornerY;
    private boolean rightClick;
    private boolean mouseDownWasReallySingleClick = false;
    boolean mutual = true;

    public ModuleModel(GUIMultiModelHandler gUIMultiModelHandler, GUIMultiModelTree.ModuleNode moduleNode) {
        this.handler = gUIMultiModelHandler;
        this.corresponding = moduleNode;
        moduleNode.setModel(this);
        this.modified = false;
        this.controlDown = false;
        this.moduleName = moduleNode.getName();
        this.variables = new ArrayList();
        this.theStates = new ArrayList();
        this.numStates = 0;
        this.transitions = new ArrayList();
        this.numTransitions = 0;
        this.theNails = new ArrayList();
        this.numNails = 0;
        this.zoom = 1.0;
        this.gridWidth = 30.0;
        this.subdivisions = 4.0;
        this.snap = true;
        this.showGrid = true;
        this.showLongLabels = false;
        this.isSelecting = false;
        this.selStartX = 0.0;
        this.selStartY = 0.0;
        this.selEndX = 0.0;
        this.selEndY = 0.0;
        this.isZoomSelecting = false;
        this.zoomStartX = 0.0;
        this.zoomStartY = 0.0;
        this.zoomEndX = 0.0;
        this.zoomEndY = 0.0;
        this.isMoving = false;
        this.lastX = 0.0;
        this.lastY = 0.0;
        this.currX = 0.0;
        this.currY = 0.0;
        this.drawingTrans = false;
        this.tranDrawX1 = 0.0;
        this.tranDrawX2 = 0.0;
        this.tranDrawY1 = 0.0;
        this.tranDrawY2 = 0.0;
        this.tempFromState = null;
        this.lastNail = null;
        this.tempNails = new ArrayList();
        this.drawingProbTrans = false;
        this.tempProbNailDown = false;
        this.tempAddNailX = 0.0;
        this.tempAddNailY = 0.0;
        this.tempProbFrom = null;
        this.tempAddNailTrans = null;
        this.tempProbNail = null;
        this.tempProbTo = new ArrayList();
        this.tempProbNails = new ArrayList();
        this.lastProbNail = null;
        this.transPopup = new JPopupMenu();
        this.modulePopup = new JPopupMenu();
        this.addNailPop = new JMenuItem("Add Point");
        this.addNailPop.setIcon(GUIPrism.getIconFromImage("smallAddNail.png"));
        this.addNailPop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ModuleModel.this.tempAddNailTrans != null) {
                    Nail nail = ModuleModel.this.isSnap() ? ModuleModel.this.tempAddNailTrans.addNail(ModuleModel.this.snapIt(ModuleModel.this.tempAddNailX), ModuleModel.this.snapIt(ModuleModel.this.tempAddNailY)) : ModuleModel.this.tempAddNailTrans.addNail(ModuleModel.this.tempAddNailX, ModuleModel.this.tempAddNailY);
                    if (nail != null) {
                        ModuleModel.this.theNails.add(nail);
                        ModuleModel.this.numNails++;
                    }
                    ModuleModel.this.setChanged();
                    ModuleModel.this.notifyObservers();
                }
            }
        });
        this.cut = new JMenuItem("Cut");
        this.cut.setIcon(GUIPrism.getIconFromImage("smallCut.png"));
        this.cut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModuleModel.this.cut();
            }
        });
        this.copy = new JMenuItem("Copy");
        this.copy.setIcon(GUIPrism.getIconFromImage("smallCopy.png"));
        this.copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModuleModel.this.copy();
            }
        });
        this.paste = new JMenuItem("Paste");
        this.paste.setIcon(GUIPrism.getIconFromImage("smallPaste.png"));
        this.paste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModuleModel.this.paste();
            }
        });
        this.delete = new JMenuItem("Delete");
        this.delete.setIcon(GUIPrism.getIconFromImage("smallDelete.png"));
        this.delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModuleModel.this.deleteSelected();
            }
        });
        this.zoomIn = new JMenuItem("Zoom In");
        this.zoomIn.setIcon(GUIPrism.getIconFromImage("smallZoomIn.png"));
        this.zoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModuleModel.this.zoom = ModuleModel.this.zoom * 1.1;
                ModuleModel.this.centreX = (int)(ModuleModel.this.popupX * ModuleModel.this.zoom);
                ModuleModel.this.centreY = (int)(ModuleModel.this.popupY * ModuleModel.this.zoom);
                ModuleModel.this.zoomChanged = true;
                ModuleModel.this.setChanged();
                ModuleModel.this.notifyObservers(null);
            }
        });
        this.zoomOut = new JMenuItem("Zoom Out");
        this.zoomOut.setIcon(GUIPrism.getIconFromImage("smallZoomOut.png"));
        this.zoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModuleModel.this.zoom = ModuleModel.this.zoom / 1.1;
                ModuleModel.this.centreX = (int)(ModuleModel.this.popupX * ModuleModel.this.zoom);
                ModuleModel.this.centreY = (int)(ModuleModel.this.popupY * ModuleModel.this.zoom);
                ModuleModel.this.zoomChanged = true;
                ModuleModel.this.setChanged();
                ModuleModel.this.notifyObservers(null);
            }
        });
        this.restoreZoom = new JMenuItem("Restore");
        this.restoreZoom.setIcon(GUIPrism.getIconFromImage("smallZoom.png"));
        this.restoreZoom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModuleModel.this.zoom = 1.0;
                ModuleModel.this.centreX = 0;
                ModuleModel.this.centreY = 0;
                ModuleModel.this.zoomChanged = true;
                ModuleModel.this.setChanged();
                ModuleModel.this.notifyObservers(null);
            }
        });
        this.startTransition = new JMenuItem("Start Transition");
        this.startTransition.setIcon(GUIPrism.getIconFromImage("smallAddTransition.png"));
        this.startTransition.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ModuleModel.this.starterState != null && !ModuleModel.this.drawingProbTrans && !ModuleModel.this.drawingExtraBranches) {
                    ModuleModel.this.isSelecting = false;
                    ModuleModel.this.isMoving = false;
                    ModuleModel.this.tempProbFrom = ModuleModel.this.starterState;
                    ModuleModel.this.tempProbTo = new ArrayList();
                    ModuleModel.this.drawingProbTrans = true;
                    ModuleModel.this.lastNail = null;
                    ModuleModel.this.tempNails = new ArrayList();
                    ModuleModel.this.deSelectAll();
                    ModuleModel.this.setChanged();
                    ModuleModel.this.notifyObservers(null);
                    return;
                }
            }
        });
        this.addState = new JMenuItem("Add State");
        this.addState.setIcon(GUIPrism.getIconFromImage("smallAddState.png"));
        this.addState.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!ModuleModel.this.drawingProbTrans) {
                    ModuleModel.this.deSelectAll();
                    if (ModuleModel.this.snap) {
                        ModuleModel.this.addState(ModuleModel.this.snapIt(ModuleModel.this.popupX), ModuleModel.this.snapIt(ModuleModel.this.popupY));
                    } else {
                        ModuleModel.this.addState(ModuleModel.this.popupX, ModuleModel.this.popupY);
                    }
                    ModuleModel.this.setChanged();
                    ModuleModel.this.notifyObservers(null);
                }
            }
        });
        this.addChoice = new JMenuItem("Add Probabilistic Choice");
        this.addChoice.setIcon(GUIPrism.getIconFromImage("smallAddChoice.png"));
        this.addChoice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!ModuleModel.this.drawingProbTrans && !ModuleModel.this.drawingExtraBranches) {
                    ModuleModel.this.isSelecting = false;
                    ModuleModel.this.isMoving = false;
                    ModuleModel.this.tempProbFrom = ModuleModel.this.starterState;
                    ModuleModel.this.tempProbTo = new ArrayList();
                    ModuleModel.this.drawingExtraBranches = true;
                    ModuleModel.this.lastNail = new Nail(ModuleModel.this.starterState.getX(), ModuleModel.this.starterState.getY(), null, null);
                    ModuleModel.this.deSelectAll();
                    ModuleModel.this.setChanged();
                    ModuleModel.this.notifyObservers();
                }
            }
        });
        this.transPopup.add(this.addNailPop);
        this.modulePopup.addSeparator();
        this.modulePopup.add(this.cut);
        this.modulePopup.add(this.copy);
        this.modulePopup.add(this.paste);
        this.modulePopup.add(this.delete);
        this.modulePopup.addSeparator();
        JMenu jMenu = new JMenu("Zoom");
        this.modulePopup.add(jMenu);
        jMenu.add(this.zoomIn);
        jMenu.add(this.zoomOut);
        jMenu.add(this.restoreZoom);
        this.mode = 0;
    }

    public void addToAllYs(double d) {
        for (int i = 0; i < this.getNumStates(); ++i) {
            State state = this.getState(i);
            state.move(0.0, d);
        }
    }

    public void addToAllXs(double d) {
        for (int i = 0; i < this.getNumStates(); ++i) {
            State state = this.getState(i);
            state.move(d, 0.0);
        }
    }

    public GUIMultiModelTree.ModuleNode getCorrespondingModuleNode() {
        return this.corresponding;
    }

    public boolean isShowLongLabels() {
        return this.showLongLabels;
    }

    public String toString() {
        return "module " + this.moduleName;
    }

    public boolean isTempProbNailDown() {
        return this.tempProbNailDown;
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean isZoomAreaChanged() {
        return this.zoomAreaChanged;
    }

    public boolean isZoomSelecting() {
        return this.isZoomSelecting;
    }

    public Nail getTempProbNail() {
        return this.tempProbNail;
    }

    public Nail getLastProbNail() {
        return this.lastProbNail;
    }

    public boolean isShowGrid() {
        return this.showGrid;
    }

    public ArrayList getVariables() {
        return this.variables;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public boolean isDrawingProbTrans() {
        return this.drawingProbTrans;
    }

    public State getTempProbFrom() {
        return this.tempProbFrom;
    }

    public ArrayList getTempProbTo() {
        return this.tempProbTo;
    }

    public State getTempFromState() {
        return this.tempFromState;
    }

    public Nail getTempNail(int n) {
        return (Nail)this.tempNails.get(n);
    }

    public Nail getTempProbNail(int n) {
        return (Nail)this.tempProbNails.get(n);
    }

    public int getNumTempProbNails() {
        return this.tempProbNails.size();
    }

    public int getNumTempNails() {
        return this.tempNails.size();
    }

    public Transition getTransition(int n) {
        return (Transition)this.transitions.get(n);
    }

    public int getNumTransitions() {
        return this.numTransitions;
    }

    public double getZoom() {
        return this.zoom;
    }

    public boolean isSnap() {
        return this.snap;
    }

    public double getGridWidth() {
        return this.gridWidth;
    }

    public State getState(int n) {
        return (State)this.theStates.get(n);
    }

    public int getNumStates() {
        return this.numStates;
    }

    public int getStateIndex(State state) {
        return this.theStates.indexOf(state);
    }

    public boolean isItSelecting() {
        return this.isSelecting;
    }

    public boolean isOverMovable() {
        return this.isOverMovable;
    }

    public double getSelStartX() {
        return this.selStartX;
    }

    public int getMode() {
        return this.mode;
    }

    public double getSelStartY() {
        return this.selStartY;
    }

    public double getSelEndX() {
        return this.selEndX;
    }

    public double getSelEndY() {
        return this.selEndY;
    }

    public double getZoomStartX() {
        return this.zoomStartX;
    }

    public double getZoomStartY() {
        return this.zoomStartY;
    }

    public double getZoomEndX() {
        return this.zoomEndX;
    }

    public double getZoomEndY() {
        return this.zoomEndY;
    }

    public boolean isItMoving() {
        return this.isMoving;
    }

    public boolean isDrawingTrans() {
        return this.drawingTrans;
    }

    public double getTranDrawX1() {
        return this.tranDrawX1;
    }

    public double getTranDrawX2() {
        return this.tranDrawX2;
    }

    public double getTranDrawY1() {
        return this.tranDrawY1;
    }

    public double getTranDrawY2() {
        return this.tranDrawY2;
    }

    public void setShowLongLabels(boolean bl) {
        this.showLongLabels = bl;
        StringLabel.lineLabels = bl;
        ExpressionLabel.lineLabels = bl;
        this.setChanged();
        this.notifyObservers(null);
    }

    public void setShowGrid(boolean bl) {
        this.showGrid = bl;
        this.setChanged();
        this.notifyObservers(null);
    }

    public void setModuleName(String string) {
        this.moduleName = string;
        this.modified = true;
    }

    public int addTransition(State state, State state2, boolean bl) {
        this.modified = true;
        if (bl) {
            ArrayList arrayList = (ArrayList)this.tempProbNails.clone();
            Transition transition = new Transition(state, state2, arrayList, this.handler.getGUIPlugin().getPrism());
            transition.registerObserver(this);
            this.transitions.add(transition);
            this.theNails.addAll(arrayList);
            for (int i = 0; i < arrayList.size(); ++i) {
                Nail nail = (Nail)arrayList.get(i);
                nail.registerObserver(this);
            }
            this.numNails += arrayList.size();
        } else {
            Transition transition = new Transition(state, state2, this.handler.getGUIPlugin().getPrism());
            transition.registerObserver(this);
            this.transitions.add(transition);
        }
        ++this.numTransitions;
        this.handler.hasModified(true);
        return this.numTransitions - 1;
    }

    public int addTransition(State state, State state2, ArrayList arrayList) {
        this.modified = true;
        this.tempNails = arrayList;
        this.tempProbNails = arrayList;
        return this.addTransition(state, state2, true);
    }

    public int addProbTransition(State state, State state2, Nail nail, String string) {
        this.modified = true;
        if (nail != null) {
            ArrayList<Nail> arrayList = new ArrayList<Nail>();
            arrayList.add(nail);
            ProbTransition probTransition = new ProbTransition(state, state2, arrayList, this.handler.getGUIPlugin().getPrism());
            probTransition.registerObserver(this);
            this.transitions.add(probTransition);
            if (string != null) {
                probTransition.setProbability(string);
            }
            this.theNails.addAll(arrayList);
            for (int i = 0; i < arrayList.size(); ++i) {
                Nail nail2 = (Nail)arrayList.get(i);
                nail2.registerObserver(this);
            }
            this.numNails += arrayList.size();
        } else {
            ProbTransition probTransition = new ProbTransition(state, state2, this.handler.getGUIPlugin().getPrism());
            probTransition.registerObserver(this);
            this.transitions.add(probTransition);
            if (string != null) {
                probTransition.setProbability(string);
            }
        }
        ++this.numTransitions;
        this.handler.hasModified(true);
        return this.numTransitions - 1;
    }

    public int addProbTransition(State state, State state2, Nail nail) {
        return this.addProbTransition(state, state2, nail, null);
    }

    public void deleteState(State state) {
        for (int i = 0; i < this.numTransitions; ++i) {
            Transition transition = (Transition)this.transitions.get(i);
            if (transition.getFrom() != state && transition.getTo() != state) continue;
            this.deleteTransition(transition);
        }
        this.theStates.remove(state);
        --this.numStates;
        this.orderStates();
        this.handler.hasModified(true);
    }

    public void deleteTransition(Transition transition) {
        block0: for (int i = 0; i < this.numNails; ++i) {
            for (int j = 0; j < transition.getNails().size(); ++j) {
                if (this.theNails.get(i) != transition.getNails().get(j)) continue;
                this.theNails.remove(i);
                --this.numNails;
                continue block0;
            }
        }
        transition.getFrom().disassociateTransition(transition);
        transition.getTo().disassociateTransition(transition);
        this.transitions.remove(transition);
        --this.numTransitions;
        this.handler.hasModified(true);
    }

    public void deleteNail(Nail nail) {
        nail.delete();
        this.theNails.remove(nail);
        --this.numNails;
    }

    public void setMode(int n) {
        this.modified = true;
        this.mode = n;
    }

    public void setTranDrawX2(double d) {
        this.lastTranDrawX = this.tranDrawX2;
        this.tranDrawX2 = d / this.zoom;
    }

    public void setTranDrawY2(double d) {
        this.lastTranDrawY = this.tranDrawY2;
        this.tranDrawY2 = d / this.zoom;
    }

    public void setSelEndX(double d) {
        this.lastSelX = this.selEndX;
        this.selEndX = d / this.zoom;
    }

    public void setSelEndY(double d) {
        this.lastSelY = this.selEndY;
        this.selEndY = d / this.zoom;
    }

    public void setSelStartX(double d) {
        this.selStartX = d / this.zoom;
    }

    public void setSelStartY(double d) {
        this.selStartY = d / this.zoom;
    }

    public void setMoveX(double d) {
        this.currX = d / this.zoom;
    }

    public void setMoveY(double d) {
        this.currY = d / this.zoom;
    }

    public void setZoom(double d) {
        this.zoom = d;
        this.setChanged();
        this.notifyObservers(null);
    }

    public int addDecision(double d, double d2) {
        this.modified = true;
        Decision decision = new Decision(d, d2);
        decision.registerObserver(this);
        this.theStates.add(decision);
        ++this.numStates;
        this.orderStates();
        this.handler.hasModified(true);
        return this.numStates - 1;
    }

    public void addState(double d, double d2) {
        State state = new State(d, d2);
        state.registerObserver(this);
        this.modified = true;
        this.theStates.add(state);
        ++this.numStates;
        this.orderStates();
        this.handler.hasModified(true);
    }

    public void addState(State state) {
        state.registerObserver(this);
        this.modified = true;
        this.theStates.add(state);
        ++this.numStates;
        this.orderStates();
        this.handler.hasModified(true);
    }

    public void setSnap(boolean bl) {
        this.snap = bl;
        this.setChanged();
        this.notifyObservers(null);
    }

    public void setGridWidth(double d) {
        this.gridWidth = d;
    }

    public void notifyDimensions(int n, int n2) {
        this.currentWidth = n;
        this.currentHeight = n2;
    }

    public void notifyViewingArea(int n, int n2) {
        this.viewingX = n;
        this.viewingY = n2;
    }

    public boolean zoomChanged() {
        return this.zoomChanged;
    }

    public boolean zoomAreaChanged() {
        return this.zoomAreaChanged;
    }

    public int getCentreX() {
        return this.centreX;
    }

    public int getCentreY() {
        return this.centreY;
    }

    public int getCornerX() {
        return this.cornerX;
    }

    public int getCornerY() {
        return this.cornerY;
    }

    public void doneZoom() {
        this.zoomChanged = false;
    }

    public void doneAreaZoom() {
        this.zoomAreaChanged = false;
    }

    public void setRightClick() {
        this.rightClick = true;
    }

    public void setScrOffsetX(int n) {
        this.scrOffsetX = n;
    }

    public void setScrOffsetY(int n) {
        this.scrOffsetY = n;
    }

    public void setZoomEndX(double d) {
        this.lastZoomX = this.zoomEndX;
        this.zoomEndX = d / this.zoom;
    }

    public void setZoomEndY(double d) {
        this.lastZoomY = this.zoomEndY;
        this.zoomEndY = d / this.zoom;
    }

    public void cut() {
        this.copy();
        this.deleteSelected();
    }

    public void copy() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        GraphicSelection graphicSelection = new GraphicSelection(this);
        clipboard.setContents(graphicSelection, null);
    }

    public void paste() {
        this.deSelectAll();
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(null);
        if (transferable == null) {
            return;
        }
        try {
            DataFlavor dataFlavor = new DataFlavor("application/x-java-serialized-object;class=userinterface.model.graphicModel.GraphicSelection$SelectionPair");
            if (transferable.isDataFlavorSupported(dataFlavor)) {
                double d;
                double d2;
                Serializable serializable;
                int n;
                GraphicSelection.SelectionPair selectionPair = (GraphicSelection.SelectionPair)transferable.getTransferData(dataFlavor);
                int[] nArray = new int[selectionPair.states.length];
                int[] nArray2 = new int[selectionPair.states.length];
                if (this.popupX == Double.POSITIVE_INFINITY || this.popupY == Double.POSITIVE_INFINITY) {
                    selectionPair.offsetX += 30.0;
                    selectionPair.offsetY += 30.0;
                } else {
                    selectionPair.offsetX = this.popupX - selectionPair.topX;
                    selectionPair.offsetY = this.popupY - selectionPair.topY;
                    this.popupX = Double.POSITIVE_INFINITY;
                    this.popupY = Double.POSITIVE_INFINITY;
                }
                for (n = 0; n < selectionPair.states.length; ++n) {
                    serializable = selectionPair.states[n];
                    nArray[n] = serializable.id;
                    d2 = selectionPair.topX;
                    d = selectionPair.topY;
                    if (!serializable.decision) {
                        State state = new State(d2 + (serializable.x - d2) + selectionPair.offsetX, d + (serializable.y - d) + selectionPair.offsetY);
                        this.addState(state);
                        nArray2[n] = this.theStates.indexOf(state);
                        state.setComment(serializable.comment);
                        state.getCommentLabel().setOffsetX(serializable.commentX);
                        state.getCommentLabel().setOffsetY(serializable.commentY);
                        state.setInitial(serializable.initial);
                        state.setSelected(true);
                        this.addToSelection(state, false);
                    } else {
                        nArray2[n] = this.addDecision(d2 + (serializable.x - d2) + selectionPair.offsetX, d + (serializable.y - d) + selectionPair.offsetY);
                        this.getState(nArray2[n]).setSelected(true);
                        this.addToSelection(this.getState(nArray2[n]), false);
                    }
                    clipboard.setContents(new GraphicSelection(selectionPair), null);
                }
                for (n = 0; n < selectionPair.transitions.length; ++n) {
                    Object object;
                    serializable = selectionPair.transitions[n];
                    d2 = selectionPair.topX;
                    d = selectionPair.topY;
                    int n2 = -1;
                    int n3 = -1;
                    for (int i = 0; i < nArray.length; ++i) {
                        if (nArray[i] == ((GraphicSelection.TransitionSelect)serializable).from.id) {
                            n2 = nArray2[i];
                        }
                        if (nArray[i] != ((GraphicSelection.TransitionSelect)serializable).to.id) continue;
                        n3 = nArray2[i];
                    }
                    if (n2 == -1 || n3 == -1) break;
                    State state = this.getState(n2);
                    State state2 = this.getState(n3);
                    int n4 = -1;
                    if (((GraphicSelection.TransitionSelect)serializable).nails.length == 0) {
                        n4 = !((GraphicSelection.TransitionSelect)serializable).prob ? this.addTransition(state, state2, false) : this.addProbTransition(state, state2, null);
                    } else {
                        Nail nail;
                        object = new ArrayList();
                        for (int i = 0; i < ((GraphicSelection.TransitionSelect)serializable).nails.length; ++i) {
                            GraphicSelection.NailSelect nailSelect = ((GraphicSelection.TransitionSelect)serializable).nails[i];
                            nail = new Nail(d2 + (nailSelect.x - d2) + selectionPair.offsetX, d + (nailSelect.y - d) + selectionPair.offsetY, null, null);
                            ((ArrayList)object).add(nail);
                        }
                        Nail nail2 = (Nail)((ArrayList)object).get(0);
                        nail2.setFrom(state);
                        nail2.setSelected(true);
                        for (int i = 1; i < ((ArrayList)object).size(); ++i) {
                            nail = (Nail)((ArrayList)object).get(i);
                            nail.setSelected(true);
                            nail2.setTo(nail);
                            nail.setFrom(nail2);
                            nail2 = nail;
                        }
                        nail2.setTo(state2);
                        n4 = !((GraphicSelection.TransitionSelect)serializable).prob ? this.addTransition(state, state2, (ArrayList)object) : this.addProbTransition(state, state2, (Nail)((ArrayList)object).get(0));
                    }
                    object = this.getTransition(n4);
                    ((Transition)object).setAssignment(((GraphicSelection.TransitionSelect)serializable).assignment);
                    ((Transition)object).getAssignmentLabel().setOffsetX(((GraphicSelection.TransitionSelect)serializable).assignmentX);
                    ((Transition)object).getAssignmentLabel().setOffsetY(((GraphicSelection.TransitionSelect)serializable).assignmentY);
                    ((Transition)object).setSync(((GraphicSelection.TransitionSelect)serializable).sync);
                    ((Transition)object).getSyncLabel().setOffsetX(((GraphicSelection.TransitionSelect)serializable).syncX);
                    ((Transition)object).getSyncLabel().setOffsetY(((GraphicSelection.TransitionSelect)serializable).syncY);
                    ((Transition)object).setGuard(((GraphicSelection.TransitionSelect)serializable).guard);
                    ((Transition)object).getGuardLabel().setOffsetX(((GraphicSelection.TransitionSelect)serializable).guardX);
                    ((Transition)object).getGuardLabel().setOffsetY(((GraphicSelection.TransitionSelect)serializable).guardY);
                    ((Transition)object).setProbability(((GraphicSelection.TransitionSelect)serializable).probability);
                    ((Transition)object).getProbabilityLabel().setOffsetX(((GraphicSelection.TransitionSelect)serializable).probabilityX);
                    ((Transition)object).getProbabilityLabel().setOffsetY(((GraphicSelection.TransitionSelect)serializable).probabilityY);
                    ((Transition)object).setSelected(true);
                    this.addToSelection((PropertyOwner)object, false);
                }
            }
            this.fireSelectionChanged();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            unsupportedFlavorException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void deleteSelected() {
        int n;
        Transition transition;
        int n2;
        PropertyOwner propertyOwner;
        int n3;
        this.modified = true;
        ArrayList<PropertyOwner> arrayList = new ArrayList<PropertyOwner>();
        ArrayList<PropertyOwner> arrayList2 = new ArrayList<PropertyOwner>();
        for (n3 = 0; n3 < this.numTransitions; ++n3) {
            propertyOwner = (Transition)this.transitions.get(n3);
            if (!((Transition)propertyOwner).isSelected()) continue;
            if (((Transition)propertyOwner).getTo() instanceof Decision) {
                arrayList.add(propertyOwner);
                for (n2 = 0; n2 < this.numTransitions; ++n2) {
                    transition = (Transition)this.transitions.get(n2);
                    if (!(transition instanceof ProbTransition) || transition.getFrom() != ((Transition)propertyOwner).getTo()) continue;
                    arrayList.add(transition);
                }
                arrayList2.add(((Transition)propertyOwner).getTo());
                continue;
            }
            arrayList.add(propertyOwner);
        }
        for (n3 = 0; n3 < this.numStates; ++n3) {
            propertyOwner = (State)this.theStates.get(n3);
            if (!((State)propertyOwner).isSelected()) continue;
            arrayList2.add(propertyOwner);
            for (n2 = 0; n2 < this.numTransitions; ++n2) {
                transition = (Transition)this.transitions.get(n2);
                if (transition.getFrom() != propertyOwner && transition.getTo() != propertyOwner) continue;
                if (transition.getFrom() == propertyOwner && transition.getTo() instanceof Decision) {
                    arrayList2.add(transition.getTo());
                    Decision decision = (Decision)transition.getTo();
                    for (int i = 0; i < this.numTransitions; ++i) {
                        Transition transition2 = (Transition)this.transitions.get(i);
                        if (transition2.getFrom() != decision) continue;
                        arrayList.add(transition2);
                    }
                }
                arrayList.add(transition);
            }
        }
        ArrayList<Nail> arrayList3 = new ArrayList<Nail>();
        for (n = 0; n < this.numNails; ++n) {
            Nail nail = (Nail)this.theNails.get(n);
            if (!nail.isSelected()) continue;
            arrayList3.add(nail);
        }
        for (n = 0; n < arrayList3.size(); ++n) {
            Nail nail = (Nail)arrayList3.get(n);
            this.deleteNail(nail);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            Transition transition3 = (Transition)arrayList.get(n);
            transition3.getFrom().disassociateTransition(transition3);
            transition3.getTo().disassociateTransition(transition3);
        }
        this.transitions.removeAll(arrayList);
        this.theStates.removeAll(arrayList2);
        this.numStates = this.theStates.size();
        this.numTransitions = this.transitions.size();
        this.orderStates();
        this.handler.hasModified(true);
        this.setChanged();
        this.notifyObservers(null);
    }

    public void deSelectAll() {
        int n;
        for (n = 0; n < this.numStates; ++n) {
            ((State)this.theStates.get(n)).setSelected(false);
            ((State)this.theStates.get(n)).getCommentLabel().setSelected(false);
        }
        for (n = 0; n < this.numNails; ++n) {
            ((Nail)this.theNails.get(n)).setSelected(false);
        }
        for (n = 0; n < this.numTransitions; ++n) {
            ((Transition)this.transitions.get(n)).setSelected(false);
            ((Transition)this.transitions.get(n)).getGuardLabel().setSelected(false);
            ((Transition)this.transitions.get(n)).getProbabilityLabel().setSelected(false);
            ((Transition)this.transitions.get(n)).getSyncLabel().setSelected(false);
            ((Transition)this.transitions.get(n)).getAssignmentLabel().setSelected(false);
            Transition transition = (Transition)this.transitions.get(n);
            if (!(transition instanceof ProbTransition)) continue;
            ((ProbTransition)transition).getProbabilityLabel().setSelected(false);
        }
        this.clearSelection(true);
    }

    public void finaliseTempBranch() {
        boolean bl;
        int n;
        if (this.tempProbTo.size() == 0) {
            this.drawingProbTrans = false;
            this.tempProbFrom = null;
            this.tempProbTo = new ArrayList();
            this.tempProbNailDown = false;
            this.tempProbNail = null;
            this.tempProbNails.clear();
            this.lastProbNail = null;
            this.handler.hasModified(true);
            return;
        }
        if (this.tempProbTo.size() == 1) {
            if (this.tempProbNails.size() > 0) {
                this.addTransition(this.tempProbFrom, (State)this.tempProbTo.get(0), this.tempProbNails);
            } else {
                this.addTransition(this.tempProbFrom, (State)this.tempProbTo.get(0), false);
            }
            this.drawingProbTrans = false;
            this.tempProbFrom = null;
            this.tempProbTo = new ArrayList();
            this.tempProbNailDown = false;
            this.tempProbNail = null;
            this.tempProbNails.clear();
            this.lastProbNail = null;
            this.handler.hasModified(true);
            return;
        }
        int n2 = this.tempProbTo.size();
        if (!this.tempProbNailDown) {
            double d = this.tempProbFrom.getX() + 15.0;
            double d2 = this.tempProbFrom.getY() + 15.0;
            double d3 = this.tempProbFrom.getX() + 15.0;
            double d4 = this.tempProbFrom.getY() + 15.0;
            for (int i = 0; i < this.tempProbTo.size(); ++i) {
                d = Math.min(((State)this.tempProbTo.get(i)).getX() + 15.0, d);
                d3 = Math.max(((State)this.tempProbTo.get(i)).getX() + 15.0, d3);
                d2 = Math.min(((State)this.tempProbTo.get(i)).getY() + 15.0, d2);
                d4 = Math.max(((State)this.tempProbTo.get(i)).getY() + 15.0, d4);
            }
            double d5 = (d + d3) / 2.0;
            double d6 = (d2 + d4) / 2.0;
            n = this.addDecision(this.snapIt(d5 + 2.5) - 2.5, this.snapIt(d6 + 2.5) - 2.5);
            this.addTransition(this.tempProbFrom, this.getState(n), false);
        } else {
            n = this.addDecision(this.lastProbNail.getX(), this.lastProbNail.getY());
            if (this.lastProbNail.getFrom() instanceof Nail) {
                Nail nail = (Nail)this.lastProbNail.getFrom();
                nail.setTo(this.getState(n));
                this.tempProbNails.remove(this.lastProbNail);
            } else {
                this.tempProbNails.remove(this.lastProbNail);
            }
            this.addTransition(this.tempProbFrom, this.getState(n), this.tempProbNails);
        }
        boolean bl2 = bl = this.tempProbTo.size() > 0;
        while (bl) {
            int n3;
            State state = (State)this.tempProbTo.get(0);
            ArrayList<State> arrayList = new ArrayList<State>();
            arrayList.add(state);
            int n4 = 1;
            for (n3 = 1; n3 < this.tempProbTo.size(); ++n3) {
                State state2 = (State)this.tempProbTo.get(n3);
                if (state2 != state) continue;
                ++n4;
                arrayList.add(state2);
            }
            if (n4 == 1) {
                if (state != this.tempProbFrom) {
                    this.addProbTransition(this.getState(n), state, null, "1/" + n2);
                } else {
                    this.addProbTransition(this.getState(n), state, new Nail((this.getState(n).getX() + state.getX()) / 2.0 + 30.0, (this.getState(n).getY() + state.getY()) / 2.0 + 30.0, this.getState(n), state), "1/" + n2);
                }
            } else {
                for (n3 = 0; n3 < n4; ++n3) {
                    double d = -((n4 - 1) * 30 / 2) + n3 * 30;
                    double d7 = this.getState(n).getX() + 3.0;
                    double d8 = this.getState(n).getY() + 3.0;
                    double d9 = state.getX() + 15.0;
                    double d10 = state.getY() + 15.0;
                    double d11 = (d7 + d9) / 2.0 + Math.sin(1.5707963267948966 - Math.atan((d7 - d9) / 2.0 / ((d8 - d10) / 2.0))) * d;
                    double d12 = (d8 + d10) / 2.0 - Math.cos(1.5707963267948966 - Math.atan((d7 - d9) / 2.0 / ((d8 - d10) / 2.0))) * d;
                    this.addProbTransition(this.getState(n), state, new Nail(d11, d12, this.getState(n), state), "1/" + n2);
                }
            }
            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                this.tempProbTo.remove(arrayList.get(n3));
            }
            bl = this.tempProbTo.size() > 0;
        }
        this.drawingProbTrans = false;
        this.tempProbFrom = null;
        this.tempProbTo = new ArrayList();
        this.tempProbNailDown = false;
        this.tempProbNail = null;
        this.tempProbNails.clear();
        this.lastProbNail = null;
        this.handler.hasModified(true);
    }

    public void finaliseExtraBranches() {
        boolean bl;
        if (this.tempProbTo.size() == 0) {
            this.drawingExtraBranches = false;
            this.tempProbFrom = null;
            this.tempProbTo = new ArrayList();
            this.tempProbNailDown = false;
            this.tempProbNail = null;
            this.tempProbNails.clear();
            this.lastProbNail = null;
            this.handler.hasModified(true);
            return;
        }
        int n = this.tempProbTo.size();
        int n2 = this.theStates.indexOf(this.tempProbFrom);
        boolean bl2 = bl = this.tempProbTo.size() > 0;
        while (bl) {
            int n3;
            State state = (State)this.tempProbTo.get(0);
            ArrayList<State> arrayList = new ArrayList<State>();
            arrayList.add(state);
            int n4 = 1;
            for (n3 = 1; n3 < this.tempProbTo.size(); ++n3) {
                State state2 = (State)this.tempProbTo.get(n3);
                if (state2 != state) continue;
                ++n4;
                arrayList.add(state2);
            }
            if (n4 == 1) {
                if (state != this.tempProbFrom) {
                    this.addProbTransition(this.getState(n2), state, null, "1/" + n);
                } else {
                    this.addProbTransition(this.getState(n2), state, new Nail((this.getState(n2).getX() + state.getX()) / 2.0 + 30.0, (this.getState(n2).getY() + state.getY()) / 2.0 + 30.0, this.getState(n2), state), "1/" + n);
                }
            } else {
                for (n3 = 0; n3 < n4; ++n3) {
                    double d = -((n4 - 1) * 30 / 2) + n3 * 30;
                    double d2 = this.getState(n2).getX() + 3.0;
                    double d3 = this.getState(n2).getY() + 3.0;
                    double d4 = state.getX() + 15.0;
                    double d5 = state.getY() + 15.0;
                    double d6 = (d2 + d4) / 2.0 + Math.sin(1.5707963267948966 - Math.atan((d2 - d4) / 2.0 / ((d3 - d5) / 2.0))) * d;
                    double d7 = (d3 + d5) / 2.0 - Math.cos(1.5707963267948966 - Math.atan((d2 - d4) / 2.0 / ((d3 - d5) / 2.0))) * d;
                    this.addProbTransition(this.getState(n2), state, new Nail(d6, d7, this.getState(n2), state), "1/" + n);
                }
            }
            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                this.tempProbTo.remove(arrayList.get(n3));
            }
            bl = this.tempProbTo.size() > 0;
        }
        this.drawingExtraBranches = false;
        this.tempProbFrom = null;
        this.tempProbTo = new ArrayList();
        this.tempProbNailDown = false;
        this.tempProbNail = null;
        this.tempProbNails.clear();
        this.lastProbNail = null;
        this.handler.hasModified(true);
    }

    public void zoomInOn(Rectangle2D rectangle2D) {
        if (rectangle2D.getWidth() < 30.0 || rectangle2D.getHeight() < 30.0) {
            return;
        }
        double d = rectangle2D.getX();
        double d2 = rectangle2D.getY();
        d = this.snapIt(d);
        d2 = this.snapIt(d2);
        double d3 = (double)this.currentWidth / this.zoom / rectangle2D.getWidth();
        double d4 = (double)this.currentHeight / this.zoom / rectangle2D.getHeight();
        this.zoom = Math.min(d3, d4);
        this.cornerX = (int)(d * this.zoom);
        this.cornerY = (int)(d2 * this.zoom);
        this.zoomAreaChanged = true;
        this.setChanged();
        this.notifyObservers(null);
    }

    public void processDoubleClick(double d, double d2) {
        this.mouseDownWasReallySingleClick = false;
        double d3 = d / this.zoom;
        double d4 = d2 / this.zoom;
        Rectangle2D.Double double_ = new Rectangle2D.Double(d3 - 1.0, d4 - 1.0, 2.0, 2.0);
        this.setLastMouseBox(double_);
        if (this.mode == 0) {
            PropertyOwner propertyOwner;
            int n;
            for (n = 0; n < this.numStates; ++n) {
                propertyOwner = (State)this.theStates.get(n);
                if (((State)propertyOwner).intersects(double_) && !(propertyOwner instanceof Decision)) {
                    if (!this.drawingProbTrans && !this.drawingExtraBranches) {
                        this.isSelecting = false;
                        this.isMoving = false;
                        this.tempProbFrom = propertyOwner;
                        this.tempProbTo = new ArrayList();
                        this.drawingProbTrans = true;
                        this.lastNail = null;
                        this.tempNails = new ArrayList();
                        this.deSelectAll();
                        this.setChanged();
                        this.notifyObservers(null);
                        return;
                    }
                    if (this.drawingProbTrans) {
                        this.isSelecting = false;
                        this.isMoving = false;
                        this.finaliseTempBranch();
                        this.deSelectAll();
                        this.setChanged();
                        this.notifyObservers(null);
                        return;
                    }
                    if (this.drawingExtraBranches) {
                        this.isSelecting = false;
                        this.isMoving = false;
                        this.finaliseExtraBranches();
                        this.deSelectAll();
                        this.setChanged();
                        this.notifyObservers(null);
                        return;
                    }
                }
                if (!((State)propertyOwner).intersects(double_) || !(propertyOwner instanceof Decision) || this.drawingProbTrans || this.drawingExtraBranches) continue;
                this.isSelecting = false;
                this.isMoving = false;
                this.tempProbFrom = propertyOwner;
                this.tempProbTo = new ArrayList();
                this.drawingExtraBranches = true;
                this.lastNail = new Nail(((State)propertyOwner).getX(), ((State)propertyOwner).getY(), null, null);
                this.deSelectAll();
                this.setChanged();
                this.notifyObservers();
            }
            for (n = 0; n < this.numTransitions; ++n) {
                ProbTransition probTransition;
                propertyOwner = (Transition)this.transitions.get(n);
                if (((Transition)propertyOwner).intersects(double_) || ((Transition)propertyOwner).getGuardLabel().intersects(double_) || ((Transition)propertyOwner).getSyncLabel().intersects(double_) || ((Transition)propertyOwner).getAssignmentLabel().intersects(double_) || ((Transition)propertyOwner).getProbabilityLabel().intersects(double_)) {
                    return;
                }
                if (!(propertyOwner instanceof ProbTransition) || !(probTransition = (ProbTransition)propertyOwner).getProbabilityLabel().intersects(double_)) continue;
                return;
            }
            if (!this.drawingProbTrans && !this.drawingExtraBranches) {
                this.deSelectAll();
                if (this.snap) {
                    this.addState(this.snapIt(d3) - 15.0, this.snapIt(d4) - 15.0);
                } else {
                    this.addState(d3 - 15.0, d4 - 15.0);
                }
            }
        }
        this.setChanged();
        this.notifyObservers(null);
    }

    public void processControlDown() {
        this.controlDown = true;
    }

    public void processControlUp() {
        this.controlDown = false;
    }

    public void processScrollWheel(double d, double d2, boolean bl) {
        if (this.mode == 1 && !this.zoomChanged || this.mode == 0 && !this.zoomChanged && this.controlDown) {
            double d3 = d / this.zoom;
            double d4 = d2 / this.zoom;
            d3 = this.snapIt(d3);
            d4 = this.snapIt(d4);
            Rectangle2D.Double double_ = new Rectangle2D.Double(d3, d4, 1.0, 1.0);
            this.zoom = !bl ? (this.zoom /= 1.1) : (this.zoom *= 1.1);
            int n = this.viewingX / 2;
            int n2 = this.viewingY / 2;
            int n3 = (int)(d - (double)this.scrOffsetX);
            int n4 = (int)(d2 - (double)this.scrOffsetY);
            this.centreX = (int)(d3 * this.zoom) + (n - n3);
            this.centreY = (int)(d4 * this.zoom) + (n2 - n4);
            this.zoomChanged = true;
            this.setChanged();
            this.notifyObservers(null);
        }
    }

    public void processSingleClick(double d, double d2) {
        boolean bl = this.mouseDownWasReallySingleClick;
        this.mouseDownWasReallySingleClick = false;
        double d3 = d / this.zoom;
        double d4 = d2 / this.zoom;
        Rectangle2D.Double double_ = new Rectangle2D.Double(d3 - 1.0, d4 - 1.0, 2.0, 2.0);
        this.setLastMouseBox(double_);
        if (this.mode == 1) {
            this.zoom *= 1.1;
            this.centreX = (int)(d3 * this.zoom);
            this.centreY = (int)(d4 * this.zoom);
            this.zoomChanged = true;
            this.setChanged();
            this.notifyObservers(null);
        } else if (this.mode == 0) {
            if (this.drawingProbTrans) {
                State state = null;
                boolean bl2 = false;
                for (int i = 0; i < this.numStates; ++i) {
                    state = (State)this.theStates.get(i);
                    if (!state.intersects(new Rectangle2D.Double(d3, d4, 1.0, 1.0)) || state instanceof Decision) continue;
                    bl2 = true;
                    if (state == this.tempProbFrom) {
                        if (this.tempProbTo.size() > 0 || this.tempProbNailDown) {
                            this.tempProbTo.add(state);
                        }
                    } else {
                        this.tempProbTo.add(state);
                    }
                    this.setChanged();
                    this.notifyObservers(null);
                    return;
                }
                if (this.lastProbNail == null) {
                    Nail nail = this.snap ? new Nail(this.snapIt(d3), this.snapIt(d4), this.tempProbFrom, null) : new Nail(d3, d4, this.tempProbFrom, null);
                    this.lastProbNail = nail;
                    this.tempProbNails.add(nail);
                    this.tempProbNailDown = true;
                    if (this.snap) {
                        this.tranDrawX1 = this.snapIt(d3);
                        this.tranDrawY1 = this.snapIt(d4);
                    } else {
                        this.tranDrawX1 = d3;
                        this.tranDrawY1 = d4;
                    }
                } else {
                    Nail nail = this.snap ? new Nail(this.snapIt(d3), this.snapIt(d4), this.lastProbNail, null) : new Nail(d3, d4, this.lastProbNail, null);
                    this.lastProbNail.setTo(nail);
                    this.lastProbNail = nail;
                    this.tempProbNails.add(nail);
                    if (this.snap) {
                        this.tranDrawX1 = this.snapIt(d3);
                        this.tranDrawY1 = this.snapIt(d4);
                    } else {
                        this.tranDrawX1 = d3;
                        this.tranDrawY1 = d4;
                    }
                }
                this.isMoving = false;
            } else if (this.drawingExtraBranches) {
                State state = null;
                for (int i = 0; i < this.numStates; ++i) {
                    state = (State)this.theStates.get(i);
                    if (!state.intersects(new Rectangle2D.Double(d3, d4, 1.0, 1.0)) || state instanceof Decision) continue;
                    this.tempProbTo.add(state);
                    this.setChanged();
                    this.notifyObservers(null);
                    return;
                }
            }
            this.setChanged();
            this.notifyObservers(null);
        }
    }

    public void processRightClick(double d, double d2, MouseEvent mouseEvent) {
        this.mouseDownWasReallySingleClick = false;
        double d3 = d / this.zoom;
        double d4 = d2 / this.zoom;
        Rectangle2D.Double double_ = new Rectangle2D.Double(d3 - 1.0, d4 - 1.0, 2.0, 2.0);
        this.setLastMouseBox(double_);
        if (this.mode == 1) {
            if (this.isZoomSelecting) {
                this.isZoomSelecting = false;
                return;
            }
            this.zoom /= 1.1;
            this.centreX = (int)(d3 * this.zoom);
            this.centreY = (int)(d4 * this.zoom);
            this.zoomChanged = true;
            this.setChanged();
            this.notifyObservers(null);
        } else if (this.mode == 0) {
            if (this.drawingProbTrans) {
                if (this.tempProbTo.size() > 0) {
                    this.finaliseTempBranch();
                } else {
                    this.drawingProbTrans = false;
                    this.tempProbFrom = null;
                    this.tempProbTo = new ArrayList();
                    this.tempProbNailDown = false;
                    this.tempProbNail = null;
                    this.lastProbNail = null;
                    this.tempNails = new ArrayList();
                    this.tempProbNails = new ArrayList();
                }
                this.setChanged();
                this.notifyObservers(null);
            } else if (this.drawingExtraBranches) {
                if (this.tempProbTo.size() > 0) {
                    this.finaliseExtraBranches();
                } else {
                    this.drawingExtraBranches = false;
                    this.tempProbFrom = null;
                    this.tempProbTo = new ArrayList();
                    this.tempProbNailDown = false;
                    this.tempProbNail = null;
                }
            } else {
                PropertyOwner propertyOwner;
                int n;
                Component component = this.modulePopup.getComponent(0);
                while (!(component instanceof JSeparator)) {
                    if (this.modulePopup.getComponentCount() > 0) {
                        this.modulePopup.remove(0);
                    }
                    component = this.modulePopup.getComponent(0);
                }
                boolean bl = false;
                PropertyOwner propertyOwner2 = null;
                for (n = 0; n < this.getNumTransitions(); ++n) {
                    propertyOwner = this.getTransition(n);
                    if (!bl && ((Transition)propertyOwner).intersects(double_) && ((Transition)propertyOwner).isSelected()) {
                        bl = true;
                        propertyOwner2 = propertyOwner;
                        continue;
                    }
                    if (!bl || !((Transition)propertyOwner).isSelected()) continue;
                    bl = false;
                }
                if (bl && propertyOwner2 != null) {
                    this.modulePopup.insert(this.addNailPop, 0);
                    this.modulePopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    this.tempAddNailTrans = propertyOwner2;
                    this.tempAddNailX = d3;
                    this.tempAddNailY = d4;
                } else {
                    for (n = 0; n < this.getNumStates(); ++n) {
                        propertyOwner = this.getState(n);
                        if (((State)propertyOwner).intersects(double_) && !(propertyOwner instanceof Decision)) {
                            this.modulePopup.insert(this.startTransition, 0);
                            this.modulePopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                            this.starterState = propertyOwner;
                            this.popupX = d3 - 15.0;
                            this.popupY = d4 - 15.0;
                            return;
                        }
                        if (!((State)propertyOwner).intersects(double_) || !(propertyOwner instanceof Decision)) continue;
                        this.modulePopup.insert(this.addChoice, 0);
                        this.modulePopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                        this.starterState = propertyOwner;
                        this.popupX = d3 - 15.0;
                        this.popupY = d4 - 15.0;
                        return;
                    }
                    this.modulePopup.insert(this.addState, 0);
                    this.modulePopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
                this.popupX = d3 - 15.0;
                this.popupY = d4 - 15.0;
            }
        }
    }

    public void processMouseDown(double d, double d2) {
        this.popupX = Double.POSITIVE_INFINITY;
        this.popupY = Double.POSITIVE_INFINITY;
        double d3 = d / this.zoom;
        double d4 = d2 / this.zoom;
        Rectangle2D.Double double_ = new Rectangle2D.Double(d3 - 1.0, d4 - 1.0, 2.0, 2.0);
        this.setLastMouseBox(double_);
        if (this.mode == 1) {
            this.isZoomSelecting = true;
            this.zoomStartX = d3;
            this.zoomStartY = d4;
            this.zoomEndX = d3;
            this.zoomEndY = d4;
            this.setChanged();
            this.notifyObservers(null);
        } else if (this.mode == 0) {
            PropertyOwner propertyOwner;
            int n;
            this.mouseDownWasReallySingleClick = true;
            if (this.isDrawingProbTrans() || this.isDrawingExtraBranches()) {
                return;
            }
            for (n = 0; n < this.numStates; ++n) {
                propertyOwner = (State)this.theStates.get(n);
                if (((State)propertyOwner).intersects(double_)) {
                    if (!((State)propertyOwner).isSelected() && !this.controlDown) {
                        this.deSelectAll();
                    }
                    if (((State)propertyOwner).isSelected() && this.controlDown) {
                        ((State)propertyOwner).setSelected(false);
                        ((State)propertyOwner).getCommentLabel().setSelected(false);
                        this.removeFromSelection(propertyOwner, true);
                        this.setChanged();
                        this.notifyObservers(null);
                        return;
                    }
                    ((State)propertyOwner).setSelected(true);
                    ((State)propertyOwner).getCommentLabel().setSelected(true);
                    this.lastX = d3;
                    this.lastY = d4;
                    this.currX = d3;
                    this.currY = d4;
                    this.isMoving = true;
                    this.movingAbsolutes = true;
                    this.isSelecting = false;
                    this.addToSelection(propertyOwner, true);
                    this.setChanged();
                    this.notifyObservers(null);
                    return;
                }
                if (!((State)propertyOwner).getCommentLabel().intersects(double_)) continue;
                if (!((State)propertyOwner).getCommentLabel().isSelected() && !this.controlDown) {
                    this.deSelectAll();
                }
                if (((State)propertyOwner).getCommentLabel().isSelected() && this.controlDown) {
                    ((State)propertyOwner).setSelected(false);
                    ((State)propertyOwner).getCommentLabel().setSelected(false);
                    this.removeFromSelection(propertyOwner, true);
                    this.setChanged();
                    this.notifyObservers(null);
                    return;
                }
                ((State)propertyOwner).getCommentLabel().setSelected(true);
                ((State)propertyOwner).setSelected(true);
                this.lastX = d3;
                this.lastY = d4;
                this.currX = d3;
                this.currY = d4;
                this.isMoving = true;
                this.movingAbsolutes = false;
                this.isSelecting = false;
                this.addToSelection(propertyOwner, true);
                this.setChanged();
                this.notifyObservers(null);
                return;
            }
            for (n = 0; n < this.numNails; ++n) {
                propertyOwner = (Nail)this.theNails.get(n);
                if (!((Nail)propertyOwner).intersects(double_)) continue;
                if (!((State)propertyOwner).isSelected() && !this.controlDown) {
                    this.deSelectAll();
                }
                if (((State)propertyOwner).isSelected() && this.controlDown) {
                    ((State)propertyOwner).setSelected(false);
                    this.removeFromSelection(propertyOwner, true);
                    this.setChanged();
                    this.notifyObservers(null);
                    return;
                }
                ((State)propertyOwner).setSelected(true);
                this.lastX = d3;
                this.lastY = d4;
                this.currX = d3;
                this.currY = d4;
                this.isMoving = true;
                this.movingAbsolutes = true;
                this.isSelecting = false;
                this.addToSelection(propertyOwner, true);
                this.setChanged();
                this.notifyObservers(null);
                return;
            }
            for (n = 0; n < this.numTransitions; ++n) {
                propertyOwner = (Transition)this.transitions.get(n);
                if (((Transition)propertyOwner).getGuardLabel().intersects(double_)) {
                    if (!((Transition)propertyOwner).getGuardLabel().isSelected() && !this.controlDown) {
                        this.deSelectAll();
                    }
                    if (((Transition)propertyOwner).getGuardLabel().isSelected() && this.controlDown) {
                        ((Transition)propertyOwner).getGuardLabel().setSelected(false);
                        this.setChanged();
                        this.notifyObservers(null);
                        return;
                    }
                    ((Transition)propertyOwner).getGuardLabel().setSelected(true);
                    this.lastX = d3;
                    this.lastY = d4;
                    this.currX = d3;
                    this.currY = d4;
                    this.isMoving = true;
                    this.movingAbsolutes = false;
                    this.isSelecting = false;
                    ((Transition)propertyOwner).setSelected(true);
                    this.addToSelection(propertyOwner, true);
                    this.setChanged();
                    this.notifyObservers(null);
                    return;
                }
                if (((Transition)propertyOwner).getProbabilityLabel().intersects(double_)) {
                    if (!((Transition)propertyOwner).getProbabilityLabel().isSelected() && !this.controlDown) {
                        this.deSelectAll();
                    }
                    if (((Transition)propertyOwner).getProbabilityLabel().isSelected() && this.controlDown) {
                        ((Transition)propertyOwner).getProbabilityLabel().setSelected(false);
                        this.setChanged();
                        this.notifyObservers(null);
                        return;
                    }
                    ((Transition)propertyOwner).getProbabilityLabel().setSelected(true);
                    this.lastX = d3;
                    this.lastY = d4;
                    this.currX = d3;
                    this.currY = d4;
                    this.isMoving = true;
                    this.movingAbsolutes = false;
                    this.isSelecting = false;
                    ((Transition)propertyOwner).setSelected(true);
                    this.addToSelection(propertyOwner, true);
                    this.setChanged();
                    this.notifyObservers(null);
                    return;
                }
                if (((Transition)propertyOwner).getSyncLabel().intersects(double_)) {
                    if (!((Transition)propertyOwner).getSyncLabel().isSelected() && !this.controlDown) {
                        this.deSelectAll();
                    }
                    if (((Transition)propertyOwner).getSyncLabel().isSelected() && this.controlDown) {
                        ((Transition)propertyOwner).getSyncLabel().setSelected(false);
                        this.setChanged();
                        this.notifyObservers(null);
                        return;
                    }
                    ((Transition)propertyOwner).getSyncLabel().setSelected(true);
                    this.lastX = d3;
                    this.lastY = d4;
                    this.currX = d3;
                    this.currY = d4;
                    this.isMoving = true;
                    this.movingAbsolutes = false;
                    this.isSelecting = false;
                    ((Transition)propertyOwner).setSelected(true);
                    this.addToSelection(propertyOwner, true);
                    this.setChanged();
                    this.notifyObservers(null);
                    return;
                }
                if (((Transition)propertyOwner).getAssignmentLabel().intersects(double_)) {
                    if (!((Transition)propertyOwner).getAssignmentLabel().isSelected() && !this.controlDown) {
                        this.deSelectAll();
                    }
                    if (((Transition)propertyOwner).getAssignmentLabel().isSelected() && this.controlDown) {
                        ((Transition)propertyOwner).getAssignmentLabel().setSelected(false);
                        this.setChanged();
                        this.notifyObservers(null);
                        return;
                    }
                    ((Transition)propertyOwner).getAssignmentLabel().setSelected(true);
                    this.lastX = d3;
                    this.lastY = d4;
                    this.currX = d3;
                    this.currY = d4;
                    this.isMoving = true;
                    this.movingAbsolutes = false;
                    this.isSelecting = false;
                    ((Transition)propertyOwner).setSelected(true);
                    this.addToSelection(propertyOwner, true);
                    this.setChanged();
                    this.notifyObservers(null);
                    return;
                }
                if (!((Transition)propertyOwner).intersects(double_)) continue;
                if (!((Transition)propertyOwner).isSelected() && !this.controlDown) {
                    this.deSelectAll();
                }
                if (((Transition)propertyOwner).isSelected() && this.controlDown) {
                    ((Transition)propertyOwner).setSelected(false);
                    ((Transition)propertyOwner).getAssignmentLabel().setSelected(false);
                    ((Transition)propertyOwner).getSyncLabel().setSelected(false);
                    ((Transition)propertyOwner).getProbabilityLabel().setSelected(false);
                    ((Transition)propertyOwner).getGuardLabel().setSelected(false);
                    this.setChanged();
                    this.notifyObservers(null);
                    return;
                }
                ((Transition)propertyOwner).setSelected(true);
                this.lastX = d3;
                ((Transition)propertyOwner).getAssignmentLabel().setSelected(true);
                ((Transition)propertyOwner).getSyncLabel().setSelected(true);
                ((Transition)propertyOwner).getProbabilityLabel().setSelected(true);
                ((Transition)propertyOwner).getGuardLabel().setSelected(true);
                this.lastY = d4;
                this.currX = d3;
                this.currY = d4;
                this.isMoving = true;
                this.movingAbsolutes = false;
                this.isSelecting = false;
                ((Transition)propertyOwner).setSelected(true);
                this.addToSelection(propertyOwner, true);
                this.setChanged();
                this.notifyObservers(null);
                return;
            }
            if (!this.controlDown) {
                this.deSelectAll();
            }
            this.isSelecting = true;
            this.selStartX = d3;
            this.selStartY = d4;
            this.selEndX = d3;
            this.selEndY = d4;
            this.setChanged();
            this.notifyObservers(null);
        }
    }

    public void processMouseUp(double d, double d2) {
        double d3 = d / this.zoom;
        double d4 = d2 / this.zoom;
        if (this.mode == 1) {
            if (this.isZoomSelecting) {
                Rectangle2D.Double double_ = new Rectangle2D.Double(this.zoomStartX, this.zoomStartY, this.zoomEndX - this.zoomStartX, this.zoomEndY - this.zoomStartY);
                this.zoomInOn(double_);
                this.isZoomSelecting = false;
                this.setChanged();
                this.notifyObservers(null);
            }
        } else if (this.mode == 0) {
            if (this.drawingProbTrans) {
                return;
            }
            if (this.isSelecting) {
                PropertyOwner propertyOwner;
                int n;
                double d5;
                double d6;
                double d7;
                double d8;
                double d9 = this.getSelStartX();
                double d10 = this.getSelStartY();
                double d11 = this.getSelEndX();
                double d12 = this.getSelEndY();
                if (d9 < d11) {
                    d8 = d9;
                    d7 = d11 - d9;
                } else {
                    d8 = d11;
                    d7 = d9 - d11;
                }
                if (d10 < d12) {
                    d6 = d10;
                    d5 = d12 - d10;
                } else {
                    d6 = d12;
                    d5 = d10 - d12;
                }
                Rectangle2D.Double double_ = new Rectangle2D.Double(d8, d6, d7, d5);
                if (!this.controlDown) {
                    for (n = 0; n < this.getNumStates(); ++n) {
                        propertyOwner = (State)this.theStates.get(n);
                        ((State)propertyOwner).setSelected(false);
                        this.removeFromSelection(propertyOwner, false);
                    }
                    for (n = 0; n < this.numNails; ++n) {
                        propertyOwner = (Nail)this.theNails.get(n);
                        ((State)propertyOwner).setSelected(false);
                        this.removeFromSelection(propertyOwner, false);
                    }
                    for (n = 0; n < this.getNumTransitions(); ++n) {
                        propertyOwner = this.getTransition(n);
                        ((Transition)propertyOwner).setSelected(false);
                        this.removeFromSelection(propertyOwner, false);
                    }
                }
                for (n = 0; n < this.getNumStates(); ++n) {
                    propertyOwner = (State)this.theStates.get(n);
                    if (double_.contains(((State)propertyOwner).getBounds2D())) {
                        if (!((State)propertyOwner).isSelected()) {
                            ((State)propertyOwner).setSelected(true);
                            ((State)propertyOwner).getCommentLabel().setSelected(true);
                            this.addToSelection(propertyOwner, false);
                            continue;
                        }
                        ((State)propertyOwner).setSelected(false);
                        ((State)propertyOwner).getCommentLabel().setSelected(false);
                        this.removeFromSelection(propertyOwner, false);
                        continue;
                    }
                    if (!double_.contains(((State)propertyOwner).getCommentLabel().getBounds2D())) continue;
                    if (!((State)propertyOwner).isSelected()) {
                        ((State)propertyOwner).setSelected(true);
                        ((State)propertyOwner).getCommentLabel().setSelected(true);
                        this.addToSelection(propertyOwner, false);
                        continue;
                    }
                    ((State)propertyOwner).setSelected(false);
                    ((State)propertyOwner).getCommentLabel().setSelected(false);
                    this.removeFromSelection(propertyOwner, false);
                }
                for (n = 0; n < this.getNumTransitions(); ++n) {
                    propertyOwner = this.getTransition(n);
                    if (double_.contains(((Transition)propertyOwner).getBounds2D())) {
                        if (((Transition)propertyOwner).isSelected()) {
                            ((Transition)propertyOwner).setSelected(false);
                            ((Transition)propertyOwner).getAssignmentLabel().setSelected(false);
                            ((Transition)propertyOwner).getSyncLabel().setSelected(false);
                            ((Transition)propertyOwner).getProbabilityLabel().setSelected(false);
                            ((Transition)propertyOwner).getGuardLabel().setSelected(false);
                            this.removeFromSelection(propertyOwner, true);
                            continue;
                        }
                        ((Transition)propertyOwner).setSelected(true);
                        ((Transition)propertyOwner).getAssignmentLabel().setSelected(true);
                        ((Transition)propertyOwner).getSyncLabel().setSelected(true);
                        ((Transition)propertyOwner).getProbabilityLabel().setSelected(true);
                        ((Transition)propertyOwner).getGuardLabel().setSelected(true);
                        this.addToSelection(propertyOwner, true);
                        continue;
                    }
                    if (double_.contains(((Transition)propertyOwner).getGuardLabel().getBounds2D())) {
                        if (((Transition)propertyOwner).getGuardLabel().isSelected()) {
                            ((Transition)propertyOwner).getGuardLabel().setSelected(false);
                            continue;
                        }
                        ((Transition)propertyOwner).getGuardLabel().setSelected(true);
                        ((Transition)propertyOwner).setSelected(true);
                        this.addToSelection(propertyOwner, true);
                        continue;
                    }
                    if (double_.contains(((Transition)propertyOwner).getProbabilityLabel().getBounds2D())) {
                        if (((Transition)propertyOwner).getProbabilityLabel().isSelected()) {
                            ((Transition)propertyOwner).getProbabilityLabel().setSelected(false);
                            continue;
                        }
                        ((Transition)propertyOwner).getProbabilityLabel().setSelected(true);
                        ((Transition)propertyOwner).setSelected(true);
                        this.addToSelection(propertyOwner, true);
                        continue;
                    }
                    if (double_.contains(((Transition)propertyOwner).getSyncLabel().getBounds2D())) {
                        if (((Transition)propertyOwner).getSyncLabel().isSelected()) {
                            ((Transition)propertyOwner).getSyncLabel().setSelected(false);
                            continue;
                        }
                        ((Transition)propertyOwner).getSyncLabel().setSelected(true);
                        ((Transition)propertyOwner).setSelected(true);
                        this.addToSelection(propertyOwner, true);
                        continue;
                    }
                    if (!double_.contains(((Transition)propertyOwner).getAssignmentLabel().getBounds2D())) continue;
                    if (((Transition)propertyOwner).getAssignmentLabel().isSelected()) {
                        ((Transition)propertyOwner).getAssignmentLabel().setSelected(false);
                        continue;
                    }
                    ((Transition)propertyOwner).getAssignmentLabel().setSelected(true);
                    ((Transition)propertyOwner).setSelected(true);
                    this.addToSelection(propertyOwner, true);
                }
                for (n = 0; n < this.numNails; ++n) {
                    propertyOwner = (Nail)this.theNails.get(n);
                    if (!new Rectangle2D.Double(d8, d6, d7, d5).contains(((State)propertyOwner).getBounds2D())) continue;
                    if (!((State)propertyOwner).isSelected()) {
                        ((State)propertyOwner).setSelected(true);
                        this.addToSelection(propertyOwner, false);
                        continue;
                    }
                    ((State)propertyOwner).setSelected(false);
                    this.removeFromSelection(propertyOwner, false);
                }
                this.fireSelectionChanged();
            } else if (this.isMoving && this.snap) {
                State state;
                int n;
                for (n = 0; n < this.numStates; ++n) {
                    state = (State)this.theStates.get(n);
                    if (!state.isSelected()) continue;
                    double d13 = state.getWidth() / 2.0;
                    state.setPosition(this.snapIt(state.getX() + d13) - d13, this.snapIt(state.getY() + d13) - d13);
                    state.stopMoving();
                }
                for (n = 0; n < this.numNails; ++n) {
                    state = (Nail)this.theNails.get(n);
                    if (!state.isSelected()) continue;
                    state.setPosition(this.snapIt(state.getX()), this.snapIt(state.getY()));
                    state.stopMoving();
                }
            }
        }
        this.isMoving = false;
        this.isSelecting = false;
        this.setChanged();
        this.notifyObservers();
    }

    public void processDrag() {
        this.mouseDownWasReallySingleClick = false;
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = 0.0;
        double d4 = 0.0;
        boolean bl = false;
        if (this.mode != 1 && this.mode == 0) {
            if (this.isMoving) {
                double d5;
                PropertyOwner propertyOwner;
                int n;
                for (n = 0; n < this.theStates.size(); ++n) {
                    propertyOwner = this.getState(n);
                    if (((State)propertyOwner).isSelected() && this.movingAbsolutes) {
                        d5 = ((State)propertyOwner).getWidth() / 2.0;
                        if (((State)propertyOwner).getMinX() < d) {
                            d = ((State)propertyOwner).getMinX();
                        }
                        if (((State)propertyOwner).getMinY() < d2) {
                            d2 = ((State)propertyOwner).getMinY();
                        }
                        if (((State)propertyOwner).getMaxX() > d3) {
                            d3 = ((State)propertyOwner).getMaxX();
                        }
                        if (((State)propertyOwner).getMaxY() > d4) {
                            d4 = ((State)propertyOwner).getMaxY();
                        }
                        ((State)propertyOwner).move(this.currX - this.lastX, this.currY - this.lastY);
                        if (((State)propertyOwner).getMinX() < d) {
                            d = ((State)propertyOwner).getMinX();
                        }
                        if (((State)propertyOwner).getMinY() < d2) {
                            d2 = ((State)propertyOwner).getMinY();
                        }
                        if (((State)propertyOwner).getMaxX() > d3) {
                            d3 = ((State)propertyOwner).getMaxX();
                        }
                        if (((State)propertyOwner).getMaxY() > d4) {
                            d4 = ((State)propertyOwner).getMaxY();
                        }
                        if (this.snap) {
                            ((State)propertyOwner).movingSnap(d5, this.gridWidth, this.subdivisions);
                        }
                    }
                    if (!((State)propertyOwner).getCommentLabel().isSelected() || this.movingAbsolutes) continue;
                    ((State)propertyOwner).getCommentLabel().move(this.currX - this.lastX, this.currY - this.lastY);
                }
                for (n = 0; n < this.theNails.size(); ++n) {
                    propertyOwner = (Nail)this.theNails.get(n);
                    if (!((State)propertyOwner).isSelected() || !this.movingAbsolutes) continue;
                    d5 = ((State)propertyOwner).getWidth() / 2.0;
                    if (((State)propertyOwner).getMinX() < d) {
                        d = ((State)propertyOwner).getMinX();
                    }
                    if (((State)propertyOwner).getMinY() < d2) {
                        d2 = ((State)propertyOwner).getMinY();
                    }
                    if (((State)propertyOwner).getMaxX() > d3) {
                        d3 = ((State)propertyOwner).getMaxX();
                    }
                    if (((State)propertyOwner).getMaxY() > d4) {
                        d4 = ((State)propertyOwner).getMaxY();
                    }
                    ((State)propertyOwner).move(this.currX - this.lastX, this.currY - this.lastY);
                    if (((State)propertyOwner).getMinX() < d) {
                        d = ((State)propertyOwner).getMinX();
                    }
                    if (((State)propertyOwner).getMinY() < d2) {
                        d2 = ((State)propertyOwner).getMinY();
                    }
                    if (((State)propertyOwner).getMaxX() > d3) {
                        d3 = ((State)propertyOwner).getMaxX();
                    }
                    if (((State)propertyOwner).getMaxY() > d4) {
                        d4 = ((State)propertyOwner).getMaxY();
                    }
                    if (!this.snap) continue;
                    ((State)propertyOwner).movingSnap(d5, this.gridWidth, this.subdivisions);
                }
                for (n = 0; n < this.transitions.size(); ++n) {
                    propertyOwner = (Transition)this.transitions.get(n);
                    if (((Transition)propertyOwner).getMaxX() > d3) {
                        d3 = ((Transition)propertyOwner).getMaxX();
                    }
                    if (((Transition)propertyOwner).getMinX() < d) {
                        d = ((Transition)propertyOwner).getMinX();
                    }
                    if (((Transition)propertyOwner).getMaxY() > d4) {
                        d4 = ((Transition)propertyOwner).getMaxY();
                    }
                    if (!(((Transition)propertyOwner).getMinY() < d2)) continue;
                    d2 = ((Transition)propertyOwner).getMinY();
                }
                if (!this.movingAbsolutes) {
                    for (n = 0; n < this.numTransitions; ++n) {
                        propertyOwner = (Transition)this.transitions.get(n);
                        if (((Transition)propertyOwner).getGuardLabel().isSelected()) {
                            ((Transition)propertyOwner).getGuardLabel().move(this.currX - this.lastX, this.currY - this.lastY);
                        }
                        if (((Transition)propertyOwner).getProbabilityLabel().isSelected()) {
                            ((Transition)propertyOwner).getProbabilityLabel().move(this.currX - this.lastX, this.currY - this.lastY);
                        }
                        if (((Transition)propertyOwner).getSyncLabel().isSelected()) {
                            ((Transition)propertyOwner).getSyncLabel().move(this.currX - this.lastX, this.currY - this.lastY);
                        }
                        if (!((Transition)propertyOwner).getAssignmentLabel().isSelected()) continue;
                        ((Transition)propertyOwner).getAssignmentLabel().move(this.currX - this.lastX, this.currY - this.lastY);
                    }
                }
                this.lastX = this.currX;
                this.lastY = this.currY;
            }
            if (this.isDrawingProbTrans()) {
                bl = true;
            }
            if (this.isDrawingExtraBranches()) {
                State state = this.getTempProbFrom();
                if (state.getMinX() < d) {
                    d = state.getMinX();
                }
                if (state.getMinY() < d2) {
                    d2 = state.getMinY();
                }
                if (state.getMaxX() > d3) {
                    d3 = state.getMaxX();
                }
                if (state.getMaxY() > d4) {
                    d4 = state.getMaxY();
                }
                for (int i = 0; i < this.tempProbTo.size(); ++i) {
                    state = (State)this.getTempProbTo().get(i);
                    if (state.getMinX() < d) {
                        d = state.getMinX();
                    }
                    if (state.getMinY() < d2) {
                        d2 = state.getMinY();
                    }
                    if (state.getMaxX() > d3) {
                        d3 = state.getMaxX();
                    }
                    if (!(state.getMaxY() > d4)) continue;
                    d4 = state.getMaxY();
                }
                if (this.getNumTempProbNails() > 0) {
                    Nail nail = this.getTempProbNail(this.getNumTempProbNails() - 1);
                    if (nail.getMinX() < d) {
                        d = nail.getMinX();
                    }
                    if (nail.getMinY() < d2) {
                        d2 = nail.getMinY();
                    }
                    if (nail.getMaxX() > d3) {
                        d3 = nail.getMaxX();
                    }
                    if (nail.getMaxY() > d4) {
                        d4 = nail.getMaxY();
                    }
                } else {
                    state = this.getTempProbFrom();
                    if (state.getMinX() < d) {
                        d = state.getMinX();
                    }
                    if (state.getMinY() < d2) {
                        d2 = state.getMinY();
                    }
                    if (state.getMaxX() > d3) {
                        d3 = state.getMaxX();
                    }
                    if (state.getMaxY() > d4) {
                        d4 = state.getMaxY();
                    }
                }
                if (this.lastTranDrawX < d) {
                    d = this.lastTranDrawX - 10.0;
                }
                if (this.lastTranDrawX > d3) {
                    d3 = this.lastTranDrawX + 10.0;
                }
                if (this.lastTranDrawY < d2) {
                    d2 = this.lastTranDrawY - 10.0;
                }
                if (this.lastTranDrawY > d4) {
                    d4 = this.lastTranDrawY + 10.0;
                }
                if (this.tranDrawX2 < d) {
                    d = this.tranDrawX2 - 10.0;
                }
                if (this.tranDrawX2 > d3) {
                    d3 = this.tranDrawX2 + 10.0;
                }
                if (this.tranDrawY2 < d2) {
                    d2 = this.tranDrawY2 - 10.0;
                }
                if (this.tranDrawY2 > d4) {
                    d4 = this.tranDrawY2 + 10.0;
                }
            }
            if (this.isSelecting) {
                if (this.selStartX < d) {
                    d = this.selStartX - 15.0;
                }
                if (this.selStartX > d3) {
                    d3 = this.selStartX + 15.0;
                }
                if (this.selStartY < d2) {
                    d2 = this.selStartY - 15.0;
                }
                if (this.selStartY > d4) {
                    d4 = this.selStartY + 15.0;
                }
                if (this.selEndX < d) {
                    d = this.selEndX - 15.0;
                }
                if (this.selEndX > d3) {
                    d3 = this.selEndX + 15.0;
                }
                if (this.selEndY < d2) {
                    d2 = this.selEndY - 15.0;
                }
                if (this.selEndY > d4) {
                    d4 = this.selEndY + 15.0;
                }
                if (this.lastSelX < d) {
                    d = this.lastSelX - 15.0;
                }
                if (this.lastSelX > d3) {
                    d3 = this.lastSelX + 15.0;
                }
                if (this.lastSelY < d2) {
                    d2 = this.lastSelY - 15.0;
                }
                if (this.lastSelY > d4) {
                    d4 = this.lastSelY + 15.0;
                }
            }
            if (this.isZoomSelecting()) {
                if (this.zoomStartX < d) {
                    d = this.zoomStartX - 15.0;
                }
                if (this.zoomStartX > d3) {
                    d3 = this.zoomStartX + 15.0;
                }
                if (this.zoomStartY < d2) {
                    d2 = this.zoomStartY - 15.0;
                }
                if (this.zoomStartY > d4) {
                    d4 = this.zoomStartY + 15.0;
                }
                if (this.zoomEndX < d) {
                    d = this.zoomEndX - 15.0;
                }
                if (this.zoomEndX > d3) {
                    d3 = this.zoomEndX + 15.0;
                }
                if (this.zoomEndY < d2) {
                    d2 = this.zoomEndY - 15.0;
                }
                if (this.zoomEndY > d4) {
                    d4 = this.zoomEndY + 15.0;
                }
                if (this.lastZoomX < d) {
                    d = this.lastZoomX - 15.0;
                }
                if (this.lastZoomX > d3) {
                    d3 = this.lastZoomX + 15.0;
                }
                if (this.lastZoomY < d2) {
                    d2 = this.lastZoomY - 15.0;
                }
                if (this.lastZoomY > d4) {
                    d4 = this.lastZoomY + 15.0;
                }
            }
        }
        this.setChanged();
        if (!bl && d < Double.POSITIVE_INFINITY && d2 < Double.POSITIVE_INFINITY) {
            Rectangle rectangle = new Rectangle((int)(d * this.zoom), (int)(d2 * this.zoom), (int)((d3 - d) * this.zoom), (int)((d4 - d2) * this.zoom));
            this.notifyObservers(rectangle);
        } else {
            this.notifyObservers();
        }
    }

    public void processMouseMoved(double d, double d2) {
        this.mouseDownWasReallySingleClick = false;
        if (this.mode == 0) {
            double d3 = d / this.zoom;
            double d4 = d2 / this.zoom;
            Rectangle2D.Double double_ = new Rectangle2D.Double(d3 - 1.0, d4 - 1.0, 2.0, 2.0);
            this.setLastMouseBox(double_);
            if (!(this.isMoving || this.isDrawingProbTrans() || this.isSelecting || this.isZoomSelecting)) {
                PropertyOwner propertyOwner;
                int n;
                for (n = 0; n < this.numStates; ++n) {
                    propertyOwner = (State)this.theStates.get(n);
                    if (((State)propertyOwner).intersects(double_)) {
                        this.isOverMovable = true;
                        this.setOverTransition(false);
                        return;
                    }
                    if (!((State)propertyOwner).getCommentLabel().intersects(double_)) continue;
                    this.isOverMovable = true;
                    this.setOverTransition(false);
                    return;
                }
                for (n = 0; n < this.numNails; ++n) {
                    propertyOwner = (Nail)this.theNails.get(n);
                    if (!((Nail)propertyOwner).intersects(double_)) continue;
                    this.isOverMovable = true;
                    this.setOverTransition(false);
                    return;
                }
                for (n = 0; n < this.numTransitions; ++n) {
                    propertyOwner = (Transition)this.transitions.get(n);
                    if (((Transition)propertyOwner).getGuardLabel().intersects(double_)) {
                        this.isOverMovable = true;
                        this.setOverTransition(false);
                        return;
                    }
                    if (((Transition)propertyOwner).getProbabilityLabel().intersects(double_)) {
                        this.isOverMovable = true;
                        this.setOverTransition(false);
                        return;
                    }
                    if (((Transition)propertyOwner).getSyncLabel().intersects(double_)) {
                        this.isOverMovable = true;
                        this.setOverTransition(false);
                        return;
                    }
                    if (((Transition)propertyOwner).getAssignmentLabel().intersects(double_)) {
                        this.isOverMovable = true;
                        this.setOverTransition(false);
                        return;
                    }
                    if (!(propertyOwner instanceof ProbTransition) || !((ProbTransition)propertyOwner).getProbabilityLabel().intersects(double_)) continue;
                    this.isOverMovable = true;
                    this.setOverTransition(false);
                    return;
                }
                this.isOverMovable = false;
                for (n = 0; n < this.numTransitions; ++n) {
                    propertyOwner = (Transition)this.transitions.get(n);
                    if (!((Transition)propertyOwner).intersects(double_)) continue;
                    this.setOverTransition(true);
                    return;
                }
                this.setOverTransition(false);
            } else {
                this.isOverMovable = false;
                this.setOverTransition(false);
            }
        }
    }

    public void processDeletePressed() {
        if (this.mode == 0) {
            for (int i = 0; i < this.numStates; ++i) {
                State state = (State)this.theStates.get(i);
                if (!state.isSelected()) continue;
                this.deleteState(state);
            }
        }
    }

    public double snapIt(double d) {
        d /= this.gridWidth / this.subdivisions;
        d = Math.round(d);
        return d *= this.gridWidth / this.subdivisions;
    }

    public void orderStates() {
        int n;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        for (n = 0; n < this.theStates.size(); ++n) {
            Object e = this.theStates.get(n);
            if (e instanceof Decision) {
                arrayList2.add(e);
                continue;
            }
            arrayList.add(e);
        }
        this.theStates = new ArrayList();
        this.theStates.addAll(arrayList);
        for (n = 0; n < arrayList.size(); ++n) {
            this.getState(n).setDescriptor(n);
        }
        this.theStates.addAll(arrayList2);
        n = 0;
        for (int i = 0; i < this.getNumStates(); ++i) {
            State state = this.getState(i);
            if (!state.isInitial()) continue;
            n = i;
        }
        if (arrayList.size() == 0) {
            this.synchTreeStateVar(n, 0);
        } else {
            this.synchTreeStateVar(n, arrayList.size() - 1);
        }
    }

    public void synchTreeStateVar(int n, int n2) {
        try {
            GUIMultiModelTree.StateVarNode stateVarNode = (GUIMultiModelTree.StateVarNode)this.corresponding.getChildAt(0);
            stateVarNode.setInitial(this.handler.getGUIPlugin().getPrism().parseSingleExpressionString("" + n));
            stateVarNode.setMax(this.handler.getGUIPlugin().getPrism().parseSingleExpressionString("" + n2));
            this.corresponding.childrenChanged();
        }
        catch (Exception exception) {
            return;
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        State state;
        int n;
        if (observable instanceof BooleanProperty) {
            BooleanProperty booleanProperty = (BooleanProperty)observable;
            if (this.mutual) {
                this.mutual = false;
                if (booleanProperty.getName().equals("initial") && booleanProperty.getBoolValue()) {
                    for (n = 0; n < this.getNumStates(); ++n) {
                        state = this.getState(n);
                        if (booleanProperty.getOwner() == state) continue;
                        state.setInitial(false);
                    }
                }
                this.mutual = true;
            }
        }
        int n2 = 0;
        for (n = 0; n < this.getNumStates(); ++n) {
            state = this.getState(n);
            if (!state.isInitial()) continue;
            n2 = n;
        }
        this.orderStates();
        this.setChanged();
        this.notifyObservers(null);
    }

    public GraphicModuleContainer getContainer() {
        return this.container;
    }

    public void setContainer(GraphicModuleContainer graphicModuleContainer) {
        this.container = graphicModuleContainer;
    }

    public Rectangle2D getLastMouseBox() {
        return this.lastMouseBox;
    }

    public void setLastMouseBox(Rectangle2D rectangle2D) {
        this.lastMouseBox = rectangle2D;
    }

    public boolean isOverTransition() {
        return this.overTransition;
    }

    public void setOverTransition(boolean bl) {
        this.overTransition = bl;
    }

    public boolean isDrawingExtraBranches() {
        return this.drawingExtraBranches;
    }

    public void setDrawingExtraBranches(boolean bl) {
        this.drawingExtraBranches = bl;
    }
}

