/*
 * Decompiled with CFR 0.152.
 */
package userinterface.model.graphicModel;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import userinterface.GUIPrism;
import userinterface.model.graphicModel.GraphicModuleContainer;
import userinterface.model.graphicModel.ModuleModel;
import userinterface.model.graphicModel.State;

public class ModuleDrawingPane
extends JPanel
implements Observer,
MouseListener,
MouseWheelListener,
FocusListener,
MouseMotionListener,
Printable,
Scrollable,
KeyListener {
    public static final int EDGE = 90;
    private ModuleModel theModel;
    private Color gridColor;
    private Color selectionColour;
    private Color zoomColour;
    private double minX = 200.0;
    private double minY = 200.0;
    private double maxX;
    private double maxY;
    private double borderOffsetX = 0.0;
    private double borderOffsetY = 0.0;
    private double printZoom;
    private BufferedImage bi;
    private Rectangle rect;
    private GraphicModuleContainer container;
    Cursor zoom = Toolkit.getDefaultToolkit().createCustomCursor(GUIPrism.getIconFromImage("mouseZoom.png").getImage(), new Point(0, 0), "ZoomMouse");
    Cursor mouse = Toolkit.getDefaultToolkit().createCustomCursor(GUIPrism.getIconFromImage("mouse.png").getImage(), new Point(0, 0), "NormalMouse");
    Cursor cross = Toolkit.getDefaultToolkit().createCustomCursor(GUIPrism.getIconFromImage("mouseCross.png").getImage(), new Point(6, 6), "Cross");
    Cursor crossZoom = Toolkit.getDefaultToolkit().createCustomCursor(GUIPrism.getIconFromImage("mouseCrossZoom.png").getImage(), new Point(6, 6), "CrossZoom");
    Cursor mouseAndMove = Toolkit.getDefaultToolkit().createCustomCursor(GUIPrism.getIconFromImage("mouseAndMove.png").getImage(), new Point(0, 0), "MouseAndMove");
    Cursor mouseAndTransition = Toolkit.getDefaultToolkit().createCustomCursor(GUIPrism.getIconFromImage("mouseAndTransition.png").getImage(), new Point(0, 0), "MouseAndTransition");
    boolean doNotRender = false;

    public ModuleDrawingPane(ModuleModel moduleModel) {
        this.theModel = moduleModel;
        this.gridColor = new Color(240, 240, 240);
        this.selectionColour = new Color(255, 0, 0);
        this.zoomColour = new Color(0, 0, 255);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.addKeyListener(this);
        this.addFocusListener(this);
        this.maxX = 200.0;
        this.maxY = 200.0;
        this.printZoom = 1.0;
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    public void setContainer(GraphicModuleContainer graphicModuleContainer) {
        this.container = graphicModuleContainer;
    }

    public ModuleModel getModel() {
        return this.theModel;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n >= 1) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pageFormat.getImageableX() + 2.0, pageFormat.getImageableY() + 2.0);
        double d = this.getWidth();
        double d2 = this.getHeight();
        double d3 = d / (pageFormat.getWidth() - pageFormat.getImageableX() * 2.0);
        double d4 = d2 / (pageFormat.getHeight() - pageFormat.getImageableY() * 2.0);
        this.printZoom = 1.0 / Math.max(d3, d4);
        this.paintComponent(graphics2D, true);
        return 0;
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object instanceof Rectangle) {
            this.rect = (Rectangle)object;
            this.repaint(this.rect);
        } else {
            this.repaint();
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.paintComponent(graphics, false);
    }

    public void setModel(ModuleModel moduleModel) {
        this.theModel = moduleModel;
        this.repaint();
    }

    public void doSize(double d) {
        this.setPreferredSize(new Dimension((int)(this.maxX * d), (int)(this.maxY * d)));
        this.theModel.notifyDimensions((int)(this.maxX * d), (int)(this.maxY * d));
        if (this.container != null) {
            this.container.doPack();
        }
        this.validate();
        this.theModel.notifyViewingArea(this.getViewableWidth(), this.getViewableHeight());
    }

    public int getViewOffsetX() {
        if (this.container != null) {
            return this.container.getViewOffsetX();
        }
        return 0;
    }

    public int getViewOffsetY() {
        if (this.container != null) {
            return this.container.getViewOffsetY();
        }
        return 0;
    }

    public int getViewableWidth() {
        if (this.container != null) {
            return this.container.getViewableWidth();
        }
        return 0;
    }

    public int getViewableHeight() {
        if (this.container != null) {
            return this.container.getViewableHeight();
        }
        return 0;
    }

    public void paintComponent(Graphics graphics, boolean bl) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        int n;
        double d7;
        double d8;
        double d9;
        double d10;
        int n2;
        double d11;
        int n3;
        Rectangle rectangle = (Rectangle)graphics.getClipBounds().clone();
        if (rectangle == null) {
            rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        }
        while (rectangle.x % 2 != 0) {
            --rectangle.x;
            ++rectangle.width;
        }
        while (rectangle.y % 2 != 0) {
            --rectangle.y;
            ++rectangle.height;
        }
        rectangle.x = (int)((double)rectangle.x / this.theModel.getZoom());
        rectangle.y = (int)((double)rectangle.y / this.theModel.getZoom());
        rectangle.width = (int)((double)rectangle.width / this.theModel.getZoom());
        rectangle.height = (int)((double)rectangle.height / this.theModel.getZoom());
        rectangle.width += 10;
        rectangle.height += 10;
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = graphics2D.getTransform();
        double d12 = bl ? this.printZoom : this.theModel.getZoom();
        affineTransform.scale(d12, d12);
        graphics2D.setTransform(affineTransform);
        if (this.theModel == null) {
            graphics2D.setColor(Color.lightGray);
            return;
        }
        double d13 = this.container.getMaxX() / d12 - 90.0;
        double d14 = this.container.getMaxY() / d12 - 90.0;
        for (n3 = 0; n3 < this.theModel.getNumStates(); ++n3) {
            State state = this.theModel.getState(n3);
            if (state.getX() > d13) {
                d13 = state.getX();
            }
            if (!(state.getY() > d14)) continue;
            d14 = state.getY();
        }
        n3 = 0;
        d14 += 90.0;
        if ((int)((d13 += 90.0) * d12) != this.getWidth()) {
            n3 = 1;
        }
        if ((int)(d14 * d12) != this.getHeight()) {
            n3 = 1;
        }
        this.maxX = d13;
        this.maxY = d14;
        if (n3 != 0) {
            this.doNotRender = true;
            this.doSize(d12);
            this.doNotRender = false;
            if (this.container != null && (this.theModel.zoomAreaChanged() || this.theModel.zoomChanged())) {
                return;
            }
        } else {
            if (this.container != null && this.theModel.zoomChanged()) {
                this.doNotRender = true;
                this.container.centreScrollTo(this.theModel.getCentreX(), this.theModel.getCentreY());
                this.doNotRender = false;
                this.repaint();
                return;
            }
            if (this.container != null && this.theModel.zoomAreaChanged()) {
                this.doNotRender = true;
                this.container.cornerScrollTo(this.theModel.getCornerX(), this.theModel.getCornerY());
                this.doNotRender = false;
                this.repaint();
                return;
            }
        }
        if (this.doNotRender) {
            return;
        }
        boolean bl2 = this.theModel.isShowLongLabels();
        double d15 = this.getWidth();
        double d16 = this.getHeight();
        graphics2D.setColor(Color.white);
        graphics2D.fill(rectangle);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (this.theModel.isShowGrid()) {
            Line2D.Double double_;
            double d17 = this.theModel.getGridWidth();
            float[] fArray = new float[]{1.0f, 2.0f};
            graphics2D.setColor(this.gridColor);
            for (d11 = -this.borderOffsetX; d11 < d15 / d12; d11 += d17) {
                double_ = new Line2D.Double(d11, rectangle.y, d11, rectangle.y + rectangle.height);
                if (!double_.intersects(rectangle)) continue;
                graphics2D.draw(double_);
            }
            for (d11 = -this.borderOffsetY; d11 < d16 / d12; d11 += d17) {
                double_ = new Line2D.Double(rectangle.x, d11, rectangle.x + rectangle.width, d11);
                if (!double_.intersects(rectangle)) continue;
                graphics2D.draw(double_);
            }
            graphics2D.setStroke(new BasicStroke());
        }
        for (n2 = 0; n2 < this.theModel.getNumTransitions(); ++n2) {
            this.theModel.getTransition(n2).render(graphics2D, bl2);
        }
        for (n2 = 0; n2 < this.theModel.getNumStates(); ++n2) {
            State state = this.theModel.getState(n2);
            state.render(graphics2D, n2, bl2);
        }
        if (this.theModel.isDrawingTrans()) {
            graphics2D.setColor(Color.gray);
            double d18 = this.theModel.getTempFromState().getX() + 15.0;
            double d19 = this.theModel.getTempFromState().getY() + 15.0;
            for (int i = 0; i < this.theModel.getNumTempProbNails(); ++i) {
                double d20 = this.theModel.getTempProbNail(i).getX();
                d10 = this.theModel.getTempProbNail(i).getY();
                graphics2D.draw(new Line2D.Double(d18, d19, d20, d10));
                d18 = d20;
                d19 = d10;
            }
            graphics2D.setColor(Color.green);
            graphics2D.draw(new Line2D.Double(this.theModel.getTranDrawX1(), this.theModel.getTranDrawY1(), this.theModel.getTranDrawX2(), this.theModel.getTranDrawY2()));
        }
        if (this.theModel.isDrawingProbTrans() && this.theModel.getTempProbFrom() != null) {
            double d21;
            graphics2D.setColor(Color.gray);
            double d22 = this.theModel.getTempProbFrom().getX() + 15.0;
            double d23 = this.theModel.getTempProbFrom().getY() + 15.0;
            if (!this.theModel.isTempProbNailDown()) {
                double d24 = d22;
                double d25 = d23;
                d9 = d22;
                d8 = d23;
                for (int i = 0; i < this.theModel.getTempProbTo().size(); ++i) {
                    State state = (State)this.theModel.getTempProbTo().get(i);
                    d24 = Math.min(state.getX() + 15.0, d24);
                    d9 = Math.max(state.getX() + 15.0, d9);
                    d25 = Math.min(state.getY() + 15.0, d25);
                    d8 = Math.max(state.getY() + 15.0, d8);
                }
                d24 = Math.min(this.theModel.getTranDrawX2(), d24);
                d9 = Math.max(this.theModel.getTranDrawX2(), d9);
                d25 = Math.min(this.theModel.getTranDrawY2(), d25);
                d8 = Math.max(this.theModel.getTranDrawY2(), d8);
                d21 = (d24 + d9) / 2.0;
                d7 = (d25 + d8) / 2.0;
            } else {
                for (int i = 0; i < this.theModel.getNumTempProbNails(); ++i) {
                    double d26 = this.theModel.getTempProbNail(i).getX();
                    double d27 = this.theModel.getTempProbNail(i).getY();
                    graphics2D.draw(new Line2D.Double(d22, d23, d26, d27));
                    d22 = d26;
                    d23 = d27;
                }
                d21 = this.theModel.getLastProbNail().getX();
                d7 = this.theModel.getLastProbNail().getY();
            }
            if (this.theModel.getTempProbTo().size() == 0) {
                graphics2D.setColor(Color.green);
            }
            graphics2D.draw(new Line2D.Double(d22, d23, d21, d7));
            for (n = 0; n < this.theModel.getTempProbTo().size(); ++n) {
                int n4;
                State state = (State)this.theModel.getTempProbTo().get(n);
                int n5 = 0;
                for (n4 = 0; n4 < this.theModel.getTempProbTo().size(); ++n4) {
                    State state2 = (State)this.theModel.getTempProbTo().get(n4);
                    if (state2 != state) continue;
                    ++n5;
                }
                if (n5 == 1) {
                    double d28 = state.getX() + 15.0;
                    d6 = state.getY() + 15.0;
                    if (this.theModel.getTempProbFrom() != state) {
                        graphics2D.draw(new Line2D.Double(d21, d7, d28, d6));
                        continue;
                    }
                    graphics2D.draw(new Line2D.Double(d21, d7, (d21 + d28) / 2.0 + 30.0, (d7 + d6) / 2.0 + 30.0));
                    graphics2D.draw(new Line2D.Double((d21 + d28) / 2.0 + 30.0, (d7 + d6) / 2.0 + 30.0, d28, d6));
                    continue;
                }
                for (n4 = 0; n4 < n5; ++n4) {
                    d9 = -((n5 - 1) * 30 / 2) + n4 * 30;
                    d8 = d21;
                    double d29 = d7;
                    d5 = state.getX() + 15.0;
                    d4 = state.getY() + 15.0;
                    d3 = (d8 + d5) / 2.0 + Math.sin(1.5707963267948966 - Math.atan((d8 - d5) / 2.0 / ((d29 - d4) / 2.0))) * d9;
                    d2 = (d29 + d4) / 2.0 - Math.cos(1.5707963267948966 - Math.atan((d8 - d5) / 2.0 / ((d29 - d4) / 2.0))) * d9;
                    graphics2D.draw(new Line2D.Double(d21, d7, d3, d2));
                    graphics2D.draw(new Line2D.Double(d3, d2, d5, d4));
                }
            }
            graphics2D.setColor(Color.green);
            graphics2D.draw(new Line2D.Double(d21, d7, this.theModel.getTranDrawX2(), this.theModel.getTranDrawY2()));
        }
        if (this.theModel.isDrawingExtraBranches() && this.theModel.getTempProbFrom() != null) {
            graphics2D.setColor(Color.gray);
            double d30 = this.theModel.getTempProbFrom().getX() + 3.0;
            double d31 = this.theModel.getTempProbFrom().getY() + 3.0;
            double d32 = this.theModel.getTempProbFrom().getX() + 3.0;
            d7 = this.theModel.getTempProbFrom().getY() + 3.0;
            for (n = 0; n < this.theModel.getTempProbTo().size(); ++n) {
                int n6;
                State state = (State)this.theModel.getTempProbTo().get(n);
                int n7 = 0;
                for (n6 = 0; n6 < this.theModel.getTempProbTo().size(); ++n6) {
                    State state3 = (State)this.theModel.getTempProbTo().get(n6);
                    if (state3 != state) continue;
                    ++n7;
                }
                if (n7 == 1) {
                    double d33 = state.getX() + 15.0;
                    d6 = state.getY() + 15.0;
                    if (this.theModel.getTempProbFrom() != state) {
                        graphics2D.draw(new Line2D.Double(d32, d7, d33, d6));
                        continue;
                    }
                    graphics2D.draw(new Line2D.Double(d32, d7, (d32 + d33) / 2.0 + 30.0, (d7 + d6) / 2.0 + 30.0));
                    graphics2D.draw(new Line2D.Double((d32 + d33) / 2.0 + 30.0, (d7 + d6) / 2.0 + 30.0, d33, d6));
                    continue;
                }
                for (n6 = 0; n6 < n7; ++n6) {
                    d9 = -((n7 - 1) * 30 / 2) + n6 * 30;
                    d8 = d32;
                    double d34 = d7;
                    d5 = state.getX() + 15.0;
                    d4 = state.getY() + 15.0;
                    d3 = (d8 + d5) / 2.0 + Math.sin(1.5707963267948966 - Math.atan((d8 - d5) / 2.0 / ((d34 - d4) / 2.0))) * d9;
                    d2 = (d34 + d4) / 2.0 - Math.cos(1.5707963267948966 - Math.atan((d8 - d5) / 2.0 / ((d34 - d4) / 2.0))) * d9;
                    graphics2D.draw(new Line2D.Double(d32, d7, d3, d2));
                    graphics2D.draw(new Line2D.Double(d3, d2, d5, d4));
                }
            }
            graphics2D.setColor(Color.green);
            graphics2D.draw(new Line2D.Double(d32, d7, this.theModel.getTranDrawX2(), this.theModel.getTranDrawY2()));
        }
        if (this.theModel.isItSelecting()) {
            double d35;
            double d36;
            float[] fArray = new float[]{6.0f, 2.0f};
            graphics2D.setStroke(new BasicStroke(1.0f, 0, 0, 1.0f, fArray, 0.0f));
            graphics2D.setColor(this.selectionColour);
            double d37 = this.theModel.getSelStartX();
            double d38 = this.theModel.getSelStartY();
            d6 = this.theModel.getSelEndX();
            d = this.theModel.getSelEndY();
            if (d37 < d6) {
                d36 = d37;
                d35 = d6 - d37;
            } else {
                d36 = d6;
                d35 = d37 - d6;
            }
            if (d38 < d) {
                d11 = d38;
                d10 = d - d38;
            } else {
                d11 = d;
                d10 = d38 - d;
            }
            float f = 0.0625f;
            graphics2D.setComposite(AlphaComposite.getInstance(3, f));
            graphics2D.fill(new Rectangle2D.Double(d36, d11, d35, d10));
            f = 1.0f;
            graphics2D.setComposite(AlphaComposite.getInstance(3, f));
            graphics2D.draw(new Rectangle2D.Double(d36, d11, d35, d10));
            graphics2D.setStroke(new BasicStroke());
        }
        if (this.theModel.isZoomSelecting()) {
            double d39;
            double d40;
            float[] fArray = new float[]{6.0f, 2.0f};
            graphics2D.setStroke(new BasicStroke(1.0f, 0, 0, 1.0f, fArray, 0.0f));
            graphics2D.setColor(this.zoomColour);
            double d41 = this.theModel.getZoomStartX();
            double d42 = this.theModel.getZoomStartY();
            d6 = this.theModel.getZoomEndX();
            d = this.theModel.getZoomEndY();
            if (d41 < d6) {
                d40 = d41;
                d39 = d6 - d41;
            } else {
                d40 = d6;
                d39 = d41 - d6;
            }
            if (d42 < d) {
                d11 = d42;
                d10 = d - d42;
            } else {
                d11 = d;
                d10 = d42 - d;
            }
            float f = 0.0625f;
            graphics2D.setComposite(AlphaComposite.getInstance(3, f));
            graphics2D.fill(new Rectangle2D.Double(d40, d11, d39, d10));
            f = 1.0f;
            graphics2D.setComposite(AlphaComposite.getInstance(3, f));
            graphics2D.draw(new Rectangle2D.Double(d40, d11, d39, d10));
            graphics2D.setStroke(new BasicStroke());
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.theModel == null) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n > this.getWidth()) {
            n = this.getWidth();
        }
        if (n2 > this.getHeight()) {
            n2 = this.getHeight();
        }
        if (this.theModel.isItSelecting()) {
            this.theModel.setSelEndX(n);
            this.theModel.setSelEndY(n2);
        } else if (this.theModel.isZoomSelecting()) {
            this.theModel.setZoomEndX(n);
            this.theModel.setZoomEndY(n2);
        } else if (this.theModel.isItMoving()) {
            this.theModel.setMoveX(n);
            this.theModel.setMoveY(n2);
        } else if (this.theModel.isDrawingTrans()) {
            this.theModel.setTranDrawX2(n);
            this.theModel.setTranDrawY2(n2);
        } else if (this.theModel.isDrawingExtraBranches()) {
            this.theModel.setTranDrawX2(n);
            this.theModel.setTranDrawY2(n2);
        }
        this.theModel.processDrag();
        this.setAppropriateCursor();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.theModel == null) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n > this.getWidth()) {
            n = this.getWidth();
        }
        if (n2 > this.getHeight()) {
            n2 = this.getHeight();
        }
        this.theModel.setTranDrawX2(n);
        this.theModel.setTranDrawY2(n2);
        if (this.theModel.isDrawingTrans() || this.theModel.isDrawingProbTrans() || this.theModel.isZoomSelecting() || this.theModel.isDrawingExtraBranches()) {
            this.theModel.processDrag();
        }
        this.theModel.processMouseMoved(mouseEvent.getX(), mouseEvent.getY());
        this.setAppropriateCursor();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.requestFocusInWindow();
        if (this.theModel == null) {
            return;
        }
        if (mouseEvent.isPopupTrigger()) {
            this.theModel.setRightClick();
            this.theModel.processRightClick(mouseEvent.getX(), mouseEvent.getY(), mouseEvent);
        } else if (mouseEvent.getButton() == 1) {
            if (mouseEvent.getClickCount() >= 2) {
                this.theModel.processDoubleClick(mouseEvent.getX(), mouseEvent.getY());
            } else {
                this.theModel.processSingleClick(mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.setAppropriateCursor();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.setCursor(new Cursor(0));
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.requestFocusInWindow();
        if (this.theModel == null) {
            return;
        }
        if (mouseEvent.isPopupTrigger()) {
            this.theModel.setRightClick();
            this.theModel.processRightClick(mouseEvent.getX(), mouseEvent.getY(), mouseEvent);
        } else if (mouseEvent.getButton() == 1) {
            this.theModel.processMouseDown(mouseEvent.getX(), mouseEvent.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.requestFocusInWindow();
        if (this.theModel == null) {
            return;
        }
        if (mouseEvent.isPopupTrigger()) {
            this.theModel.processRightClick(mouseEvent.getX(), mouseEvent.getY(), mouseEvent);
        } else if (mouseEvent.getButton() == 1) {
            this.theModel.processMouseUp(mouseEvent.getX(), mouseEvent.getY());
        }
        this.setAppropriateCursor();
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return new Dimension(20, 20);
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return 20;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return 40;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 17) {
            this.theModel.processControlDown();
        } else if (keyEvent.getKeyCode() == 127) {
            this.theModel.deleteSelected();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 17) {
            this.theModel.processControlUp();
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        this.requestFocusInWindow();
        if (this.theModel == null) {
            return;
        }
        if (mouseWheelEvent.getWheelRotation() > 0) {
            this.theModel.processScrollWheel(mouseWheelEvent.getX(), mouseWheelEvent.getY(), false);
        } else if (mouseWheelEvent.getWheelRotation() < 0) {
            this.theModel.processScrollWheel(mouseWheelEvent.getX(), mouseWheelEvent.getY(), true);
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.theModel.processControlUp();
    }

    public void setAppropriateCursor() {
        if (this.theModel.getMode() == 0) {
            if (this.theModel.isItSelecting()) {
                this.setCursor(this.cross);
            } else if (this.theModel.isItMoving()) {
                this.setCursor(new Cursor(13));
            } else if (this.theModel.isOverMovable()) {
                this.setCursor(this.mouseAndMove);
            } else if (this.theModel.isOverTransition()) {
                this.setCursor(this.mouseAndTransition);
            } else {
                this.setCursor(this.mouse);
            }
        } else if (this.theModel.getMode() == 1) {
            if (this.theModel.isZoomSelecting()) {
                this.setCursor(this.crossZoom);
            } else {
                this.setCursor(this.zoom);
            }
        } else {
            this.setCursor(new Cursor(0));
        }
    }
}

