/*
 * Decompiled with CFR 0.152.
 */
package userinterface.model.graphicModel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyVetoException;
import javax.swing.AbstractAction;
import javax.swing.BoundedRangeModel;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import userinterface.GUIPrism;
import userinterface.model.graphicModel.ModuleDrawingPane;
import userinterface.model.graphicModel.ModuleModel;
import userinterface.model.graphicModel.ModulesPanel;

public class GraphicModuleContainer
implements FocusListener,
AdjustmentListener {
    public static final int DEFAULT_X_SIZE = 400;
    public static final int DEFAULT_Y_SIZE = 300;
    private ModuleModel theModel;
    private ModuleDrawingPane theView;
    private ModulesPanel owner;
    private GUIPrism gui;
    private JPanel pan;
    private JScrollPane scroller;
    private GraphicModuleContainer thisgmc;
    private boolean docked;
    private boolean visible;
    private int xSize = 400;
    private int ySize = 300;
    private int lastInternalX = -1;
    private int lastInternalY = -1;
    private int lastExternalX = -1;
    private int lastExternalY = -1;
    private JPopupMenu framePopup;
    private JDialog externalFrame;
    private JInternalFrame internalFrame;

    public GraphicModuleContainer(GUIPrism gUIPrism, ModuleModel moduleModel, ModuleDrawingPane moduleDrawingPane, ModulesPanel modulesPanel) {
        this.theModel = moduleModel;
        this.theView = moduleDrawingPane;
        this.owner = modulesPanel;
        this.gui = gUIPrism;
        moduleModel.setContainer(this);
        this.thisgmc = this;
        this.docked = false;
        this.framePopup = new JPopupMenu();
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GraphicModuleContainer.this.setVisible(false);
            }
        };
        abstractAction.putValue("LongDescription", "Hides this graphical module");
        abstractAction.putValue("MnemonicKey", new Integer(72));
        abstractAction.putValue("Name", "Hide");
        this.framePopup.add(abstractAction);
        this.setDocked(true);
        this.setVisible(true);
        moduleDrawingPane.setContainer(this);
    }

    public void cornerScrollTo(int n, int n2) {
        if (this.theModel.zoomAreaChanged()) {
            this.theModel.doneAreaZoom();
            BoundedRangeModel boundedRangeModel = this.scroller.getVerticalScrollBar().getModel();
            int n3 = boundedRangeModel.getExtent();
            int n4 = boundedRangeModel.getMaximum();
            int n5 = boundedRangeModel.getMinimum();
            double d = (double)n2 / (double)this.theView.getHeight();
            int n6 = (int)((double)n4 * d);
            if (n6 + n3 > n4) {
                n6 = n4 - n3;
            }
            if (n6 < n5) {
                n6 = n5;
            }
            boundedRangeModel.setValue(n6);
            boundedRangeModel = this.scroller.getHorizontalScrollBar().getModel();
            n3 = boundedRangeModel.getExtent();
            n4 = boundedRangeModel.getMaximum();
            n5 = boundedRangeModel.getMinimum();
            d = (double)n / (double)this.theView.getWidth();
            n6 = (int)((double)n4 * d);
            if (n6 + n3 > n4) {
                n6 = n4 - n3;
            }
            if (n6 < n5) {
                n6 = n5;
            }
            boundedRangeModel.setValue(n6);
        }
    }

    public void setRectangle(Rectangle rectangle) {
        if (this.isDocked()) {
            this.internalFrame.setLocation(rectangle.x, rectangle.y);
            this.internalFrame.setSize(rectangle.width, rectangle.height);
        }
    }

    public Rectangle getRectangle() {
        if (this.isDocked()) {
            return new Rectangle(this.internalFrame.getX(), this.internalFrame.getY(), this.internalFrame.getWidth(), this.internalFrame.getHeight());
        }
        return new Rectangle(0, 0, 200, 200);
    }

    public void centreScrollTo(int n, int n2) {
        if (this.theModel.zoomChanged()) {
            this.theModel.doneZoom();
            BoundedRangeModel boundedRangeModel = this.scroller.getVerticalScrollBar().getModel();
            int n3 = boundedRangeModel.getExtent();
            int n4 = boundedRangeModel.getMaximum();
            int n5 = boundedRangeModel.getMinimum();
            double d = (double)n2 / (double)this.theView.getHeight();
            int n6 = (int)((double)n4 * d - (double)(n3 / 2));
            if (n6 + n3 > n4) {
                n6 = n4 - n3;
            }
            if (n6 < n5) {
                n6 = n5;
            }
            boundedRangeModel.setValue(n6);
            boundedRangeModel = this.scroller.getHorizontalScrollBar().getModel();
            n3 = boundedRangeModel.getExtent();
            n4 = boundedRangeModel.getMaximum();
            n5 = boundedRangeModel.getMinimum();
            d = (double)n / (double)this.theView.getWidth();
            n6 = (int)((double)n4 * d - (double)(n3 / 2));
            if (n6 + n3 > n4) {
                n6 = n4 - n3;
            }
            if (n6 < n5) {
                n6 = n5;
            }
            boundedRangeModel.setValue(n6);
        }
    }

    public void setTitle(String string) {
        if (this.docked) {
            this.internalFrame.setTitle(string);
        } else {
            this.externalFrame.setTitle(string);
        }
    }

    public void setDocked(boolean bl) {
        if (bl) {
            if (this.isDocked()) {
                return;
            }
            if (this.externalFrame != null) {
                this.xSize = this.externalFrame.getWidth();
                this.ySize = this.externalFrame.getHeight();
                this.externalFrame.dispose();
                this.lastExternalX = this.externalFrame.getX();
                this.lastExternalY = this.externalFrame.getY();
            }
            this.externalFrame = null;
            this.internalFrame = new JInternalFrame(this.getName(), true, false, true, true);
            this.internalFrame.getContentPane().setLayout(new BorderLayout());
            UIManager.put("ScrollBar.width", new Integer(10));
            this.scroller = new JScrollPane();
            this.scroller.getVerticalScrollBar().addAdjustmentListener(this);
            this.scroller.getHorizontalScrollBar().addAdjustmentListener(this);
            this.pan = new JPanel();
            this.internalFrame.getContentPane().add((Component)this.scroller, "Center");
            this.scroller.setViewportView(this.pan);
            this.pan.setLayout(new GridBagLayout());
            this.pan.add((Component)this.theView, new GridBagConstraints());
            this.theView.doSize(this.theModel.getZoom());
            this.internalFrame.pack();
            this.internalFrame.setSize(this.xSize, this.ySize);
            this.internalFrame.setBorder(new LineBorder(Color.black, 2, false));
            this.internalFrame.setFrameIcon(GUIPrism.getIconFromImage("smallModule.png"));
            this.internalFrame.addComponentListener(this.owner);
            this.internalFrame.addFocusListener(this);
            this.internalFrame.addInternalFrameListener(new InternalFrameListener(){

                @Override
                public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
                }

                @Override
                public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
                }

                @Override
                public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                    GraphicModuleContainer.this.owner.a_hide(GraphicModuleContainer.this.thisgmc);
                }

                @Override
                public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
                }

                @Override
                public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
                    GraphicModuleContainer.this.owner.a_show(GraphicModuleContainer.this.thisgmc);
                }

                @Override
                public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
                    GraphicModuleContainer.this.owner.a_hide(GraphicModuleContainer.this.thisgmc);
                }

                @Override
                public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
                }
            });
            this.internalFrame.addMouseListener(new MouseListener(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (mouseEvent.isPopupTrigger()) {
                        GraphicModuleContainer.this.framePopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    }
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    if (mouseEvent.isPopupTrigger()) {
                        GraphicModuleContainer.this.framePopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    }
                }

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                }
            });
            this.owner.dock(this.internalFrame);
            if (this.lastInternalX > -1 && this.lastInternalY > -1) {
                this.internalFrame.setLocation(this.lastInternalX, this.lastInternalY);
            }
            this.docked = true;
            UIManager.put("ScrollBar.width", new Integer(16));
        } else {
            if (!this.isDocked()) {
                return;
            }
            if (this.internalFrame != null) {
                this.xSize = this.internalFrame.getWidth();
                this.ySize = this.internalFrame.getHeight();
                this.lastInternalX = this.internalFrame.getX();
                this.lastInternalY = this.internalFrame.getY();
            }
            this.externalFrame = new JDialog(this.gui, this.getName(), false);
            this.externalFrame.getContentPane().setLayout(new BorderLayout());
            this.externalFrame.getContentPane().add((Component)this.theView, "Center");
            this.externalFrame.getContentPane().setSize(this.xSize, this.ySize);
            this.externalFrame.addWindowListener(new WindowListener(){

                @Override
                public void windowActivated(WindowEvent windowEvent) {
                }

                @Override
                public void windowClosed(WindowEvent windowEvent) {
                }

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    GraphicModuleContainer.this.owner.a_hide(GraphicModuleContainer.this.thisgmc);
                }

                @Override
                public void windowDeactivated(WindowEvent windowEvent) {
                }

                @Override
                public void windowDeiconified(WindowEvent windowEvent) {
                }

                @Override
                public void windowIconified(WindowEvent windowEvent) {
                }

                @Override
                public void windowOpened(WindowEvent windowEvent) {
                }
            });
            this.externalFrame.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    GraphicModuleContainer.this.owner.desktopLoseFocus();
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    GraphicModuleContainer.this.owner.ensureFocusIsViewable();
                }
            });
            this.externalFrame.addFocusListener(this);
            UIManager.put("ScrollBar.width", new Integer(10));
            this.scroller = new JScrollPane();
            this.scroller.getVerticalScrollBar().addAdjustmentListener(this);
            this.scroller.getHorizontalScrollBar().addAdjustmentListener(this);
            this.pan = new JPanel();
            this.externalFrame.getContentPane().add((Component)this.scroller, "Center");
            this.scroller.setViewportView(this.pan);
            this.pan.setLayout(new GridBagLayout());
            this.pan.add((Component)this.theView, new GridBagConstraints());
            this.theView.doSize(this.theModel.getZoom());
            this.externalFrame.setSize(this.xSize, this.ySize);
            if (this.lastExternalX > -1 && this.lastExternalY > -1) {
                this.externalFrame.setLocation(this.lastExternalX, this.lastExternalY);
            } else if (this.lastInternalX > -1 && this.lastInternalY > -1 && this.internalFrame != null) {
                int n = this.internalFrame.getX();
                int n2 = this.internalFrame.getY();
                Container container = this.internalFrame;
                while (container.getParent() instanceof Container) {
                    container = container.getParent();
                    n += container.getX();
                    n2 += container.getY();
                }
                this.externalFrame.setLocation(n, n2);
            }
            this.docked = false;
            this.owner.undock(this.internalFrame);
            if (this.internalFrame != null) {
                this.internalFrame.dispose();
            }
            this.internalFrame = null;
        }
    }

    public boolean isDocked() {
        return this.docked;
    }

    public void setVisible(boolean bl) {
        if (this.isDocked()) {
            this.setDocked(true);
            try {
                this.internalFrame.setIcon(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.internalFrame.setVisible(bl);
        } else {
            this.externalFrame.setVisible(bl);
        }
        this.visible = bl;
    }

    public boolean isVisible() {
        if (this.docked) {
            return this.internalFrame.isVisible();
        }
        return this.externalFrame.isVisible();
    }

    public String getName() {
        return this.theModel.getModuleName();
    }

    public ModuleModel getModuleModel() {
        return this.theModel;
    }

    public JInternalFrame getInternalFrame() {
        return this.internalFrame;
    }

    public boolean isSelectedModule() {
        if (this.docked) {
            return this.internalFrame.isSelected();
        }
        return this.externalFrame.isFocusOwner();
    }

    public void doPack() {
        this.pan.revalidate();
        this.pan.repaint();
    }

    public void setSelected() {
        if (this.docked) {
            try {
                this.internalFrame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {}
        } else {
            this.externalFrame.requestFocus();
        }
    }

    public double getMaxX() {
        return this.scroller.getViewport().getWidth();
    }

    public double getMaxY() {
        return this.scroller.getViewport().getHeight();
    }

    public int getViewableWidth() {
        return (int)this.scroller.getViewport().getExtentSize().getWidth();
    }

    public int getViewableHeight() {
        return (int)this.scroller.getViewport().getExtentSize().getHeight();
    }

    public int getViewOffsetX() {
        return this.scroller.getHorizontalScrollBar().getModel().getValue();
    }

    public int getViewOffsetY() {
        return this.scroller.getVerticalScrollBar().getModel().getValue();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.theModel.setScrOffsetX(this.getViewOffsetX());
        this.theModel.setScrOffsetY(this.getViewOffsetY());
    }
}

