/*
 * Decompiled with CFR 0.152.
 */
package userinterface.model.computation;

import java.awt.Rectangle;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import parser.type.Type;
import parser.type.TypeBool;
import parser.type.TypeInt;
import prism.PrismException;
import userinterface.GUIPlugin;
import userinterface.model.GUIModelEditor;
import userinterface.model.GUIMultiModelHandler;
import userinterface.model.graphicModel.Decision;
import userinterface.model.graphicModel.GUIGraphicModelEditor;
import userinterface.model.graphicModel.ModuleModel;
import userinterface.model.graphicModel.Nail;
import userinterface.model.graphicModel.ProbTransition;
import userinterface.model.graphicModel.State;
import userinterface.model.graphicModel.Transition;
import userinterface.util.GUIComputationEvent;

public class SaveGraphicModelThread
extends Thread {
    private GUIModelEditor theEditor;
    private GUIMultiModelHandler handler;
    private File f;
    private GUIPlugin plug;
    private boolean error;

    public SaveGraphicModelThread(File file, GUIMultiModelHandler gUIMultiModelHandler, GUIModelEditor gUIModelEditor) {
        this.theEditor = gUIModelEditor;
        this.handler = gUIMultiModelHandler;
        this.f = file;
        this.error = false;
        this.plug = gUIMultiModelHandler.getGUIPlugin();
    }

    @Override
    public void run() {
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    SaveGraphicModelThread.this.plug.startProgress();
                    SaveGraphicModelThread.this.plug.notifyEventListeners(new GUIComputationEvent(0, SaveGraphicModelThread.this.plug));
                    SaveGraphicModelThread.this.plug.setTaskBarText("Saving model...");
                }
            });
            if (!(this.theEditor instanceof GUIGraphicModelEditor)) {
                throw new PrismException("Wrong model type");
            }
            GUIGraphicModelEditor gUIGraphicModelEditor = (GUIGraphicModelEditor)this.theEditor;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement("gmo");
            String string = gUIGraphicModelEditor.getModelType().toString().toLowerCase();
            element.setAttribute("type", string);
            element.setAttribute("filename", this.f.getPath());
            element.setAttribute("autolayout", "" + gUIGraphicModelEditor.isAutolayout());
            ModuleModel[] moduleModelArray = document.createElement("constants");
            Object object6 = gUIGraphicModelEditor.getEditableConstantNames();
            ArrayList<ArrayList<Type>> arrayList = gUIGraphicModelEditor.getEditableConstantValues();
            ArrayList<ArrayList<Type>> arrayList2 = gUIGraphicModelEditor.getEditableConstantTypes();
            for (int i = 0; i < arrayList2.size(); ++i) {
                object5 = arrayList.get(i);
                String string2 = (String)((ArrayList)object6).get(i);
                object4 = null;
                object4 = document.createElement(((Type)arrayList2.get(i)).getTypeString() + "Constant");
                object4.setAttribute("name", string2);
                if (object5 != null) {
                    object4.setAttribute("value", (String)object5);
                }
                if (object4 == null) continue;
                moduleModelArray.appendChild((Node)object4);
            }
            element.appendChild((Node)moduleModelArray);
            moduleModelArray = document.createElement("globals");
            object6 = gUIGraphicModelEditor.getEditableGlobalNames();
            arrayList = gUIGraphicModelEditor.getEditableGlobalMins();
            arrayList2 = gUIGraphicModelEditor.getEditableGlobalMaxs();
            ArrayList<ArrayList<Type>> arrayList3 = gUIGraphicModelEditor.getEditableGlobalInits();
            object5 = gUIGraphicModelEditor.getEditableGlobalTypes();
            for (int i = 0; i < ((ArrayList)object5).size(); ++i) {
                object4 = (Type)((ArrayList)object5).get(i);
                object3 = (String)((ArrayList)object6).get(i);
                object2 = null;
                if (object4 instanceof TypeInt) {
                    object2 = document.createElement("variable");
                    object2.setAttribute("name", (String)object3);
                    object2.setAttribute("min", (String)arrayList.get(i));
                    object2.setAttribute("max", (String)arrayList2.get(i));
                    object = arrayList3.get(i);
                    if (object != null) {
                        object2.setAttribute("init", (String)arrayList3.get(i));
                    }
                } else if (object4 instanceof TypeBool) {
                    object2 = document.createElement("boolVariable");
                    object2.setAttribute("name", (String)object3);
                    object = arrayList3.get(i);
                    if (object != null) {
                        object2.setAttribute("init", (String)arrayList3.get(i));
                    }
                }
                if (object2 == null) continue;
                moduleModelArray.appendChild((Node)object2);
            }
            element.appendChild((Node)moduleModelArray);
            moduleModelArray = document.createElement("systemDescription");
            object6 = gUIGraphicModelEditor.getTextEditorString();
            arrayList = document.createTextNode((String)object6);
            moduleModelArray.appendChild((Node)((Object)arrayList));
            element.appendChild((Node)moduleModelArray);
            moduleModelArray = gUIGraphicModelEditor.getModuleArray();
            for (int i = 0; i < moduleModelArray.length; ++i) {
                int n;
                Object object7;
                Object object8;
                Object object9;
                Object object10;
                Object object11;
                int n2;
                arrayList = new ArrayList<ArrayList<Type>>();
                arrayList2 = new ArrayList<ArrayList<Type>>();
                arrayList3 = new ArrayList<ArrayList<Type>>();
                object5 = document.createElement("module");
                object5.setAttribute("name", moduleModelArray[i].getCorrespondingModuleNode().getName());
                Rectangle rectangle = moduleModelArray[i].getContainer().getRectangle();
                object5.setAttribute("x", "" + rectangle.x);
                object5.setAttribute("y", "" + rectangle.y);
                object5.setAttribute("width", "" + rectangle.width);
                object5.setAttribute("height", "" + rectangle.height);
                object5.setAttribute("zoom", "" + moduleModelArray[i].getZoom());
                for (n2 = 0; n2 < moduleModelArray[i].getNumStates(); ++n2) {
                    object3 = moduleModelArray[i].getState(n2);
                    if (object3 instanceof Decision) {
                        arrayList.add((ArrayList<Type>)object3);
                        continue;
                    }
                    object2 = document.createElement("state");
                    object2.setAttribute("id", "" + n2);
                    object2.setAttribute("initial", "" + ((State)object3).isInitial());
                    double d = ((State)object3).getX();
                    double d2 = ((State)object3).getY();
                    object11 = document.createElement("position");
                    object11.setAttribute("x", "" + d);
                    object11.setAttribute("y", "" + d2);
                    object2.appendChild((Node)object11);
                    object11 = ((State)object3).getCommentLabel().getString();
                    if (!((String)object11).equals("")) {
                        object10 = document.createElement("sName");
                        object10.setAttribute("name", (String)object11);
                        double d3 = ((State)object3).getCommentLabel().getOffsetX();
                        double d4 = ((State)object3).getCommentLabel().getOffsetY();
                        object9 = document.createElement("position");
                        object9.setAttribute("x", "" + d3);
                        object9.setAttribute("y", "" + d4);
                        object10.appendChild((Node)object9);
                        object2.appendChild((Node)object10);
                    }
                    object5.appendChild((Node)object2);
                }
                for (n2 = 0; n2 < moduleModelArray[i].getNumTransitions(); ++n2) {
                    double d;
                    object3 = moduleModelArray[i].getTransition(n2);
                    if (object3 instanceof ProbTransition) {
                        arrayList3.add((ArrayList<Type>)object3);
                        continue;
                    }
                    if (((Transition)object3).getTo() instanceof Decision) {
                        arrayList2.add((ArrayList<Type>)object3);
                        continue;
                    }
                    object2 = document.createElement("transition");
                    int n3 = moduleModelArray[i].getStateIndex(((Transition)object3).getFrom());
                    int n4 = moduleModelArray[i].getStateIndex(((Transition)object3).getTo());
                    object2.setAttribute("from", "" + n3);
                    object2.setAttribute("to", "" + n4);
                    String string3 = ((Transition)object3).getGuardLabel().getString();
                    if (!string3.equals("")) {
                        object8 = document.createElement("guard");
                        object8.setAttribute("value", string3);
                        double d5 = ((Transition)object3).getGuardLabel().getOffsetX();
                        double d6 = ((Transition)object3).getGuardLabel().getOffsetY();
                        Element element2 = document.createElement("position");
                        element2.setAttribute("x", "" + d5);
                        element2.setAttribute("y", "" + d6);
                        object8.appendChild(element2);
                        object2.appendChild((Node)object8);
                    }
                    if (!((String)(object8 = ((Transition)object3).getSyncLabel().getString())).equals("")) {
                        Element element3 = document.createElement("sync");
                        element3.setAttribute("value", (String)object8);
                        double d7 = ((Transition)object3).getSyncLabel().getOffsetX();
                        d = ((Transition)object3).getSyncLabel().getOffsetY();
                        Element element4 = document.createElement("position");
                        element4.setAttribute("x", "" + d7);
                        element4.setAttribute("y", "" + d);
                        element3.appendChild(element4);
                        object2.appendChild(element3);
                    }
                    if (!((String)(object11 = ((Transition)object3).getAssignmentLabel().getString())).equals("")) {
                        Element element5 = document.createElement("assign");
                        element5.setAttribute("value", (String)object11);
                        double d8 = ((Transition)object3).getAssignmentLabel().getOffsetX();
                        double d9 = ((Transition)object3).getAssignmentLabel().getOffsetY();
                        object9 = document.createElement("position");
                        object9.setAttribute("x", "" + d8);
                        object9.setAttribute("y", "" + d9);
                        element5.appendChild((Node)object9);
                        object2.appendChild(element5);
                    }
                    if (!((String)(object10 = ((Transition)object3).getProbabilityLabel().getString())).equals("")) {
                        Element element6 = document.createElement("tranProb");
                        element6.setAttribute("value", (String)object10);
                        d = ((Transition)object3).getProbabilityLabel().getOffsetX();
                        double d10 = ((Transition)object3).getProbabilityLabel().getOffsetY();
                        object7 = document.createElement("position");
                        object7.setAttribute("x", "" + d);
                        object7.setAttribute("y", "" + d10);
                        element6.appendChild((Node)object7);
                        object2.appendChild(element6);
                    }
                    for (int j = 0; j < ((Transition)object3).getNails().size(); ++j) {
                        Nail nail = (Nail)((Transition)object3).getNails().get(j);
                        Element element7 = document.createElement("nail");
                        if (nail.getFrom() instanceof Nail) {
                            element7.setAttribute("from", "" + ((Transition)object3).getNails().indexOf(nail.getFrom()));
                        } else {
                            element7.setAttribute("from", "FROMSTATE");
                        }
                        if (nail.getTo() instanceof Nail) {
                            element7.setAttribute("to", "" + ((Transition)object3).getNails().indexOf(nail.getTo()));
                        } else {
                            element7.setAttribute("to", "TOSTATE");
                        }
                        element7.setAttribute("id", "" + j);
                        double d11 = nail.getX();
                        double d12 = nail.getY();
                        Element element8 = document.createElement("position");
                        element8.setAttribute("x", "" + d11);
                        element8.setAttribute("y", "" + d12);
                        element7.appendChild(element8);
                        object2.appendChild(element7);
                    }
                    object5.appendChild((Node)object2);
                }
                object4 = gUIGraphicModelEditor.getVariableNames(moduleModelArray[i]);
                object3 = gUIGraphicModelEditor.getVariableTypes(moduleModelArray[i]);
                object2 = gUIGraphicModelEditor.getVariableInits(moduleModelArray[i]);
                object = gUIGraphicModelEditor.getVariableMins(moduleModelArray[i]);
                ArrayList arrayList4 = gUIGraphicModelEditor.getVariableMaxs(moduleModelArray[i]);
                for (n = 0; n < ((ArrayList)object3).size(); ++n) {
                    object8 = ((ArrayList)object3).get(n);
                    object11 = null;
                    object10 = (String)((ArrayList)object4).get(n);
                    Object e = ((ArrayList)object2).get(n);
                    if (object8 instanceof TypeInt) {
                        object11 = document.createElement("variable");
                        object11.setAttribute("name", (String)object10);
                        object11.setAttribute("min", (String)((ArrayList)object).get(n));
                        object11.setAttribute("max", (String)arrayList4.get(n));
                        if (e != null) {
                            object11.setAttribute("init", (String)e);
                        }
                    } else if (object8 instanceof TypeBool) {
                        object11 = document.createElement("boolVariable");
                        object11.setAttribute("name", (String)object10);
                        if (e != null) {
                            object11.setAttribute("init", (String)e);
                        }
                    }
                    if (object11 == null) continue;
                    object5.appendChild((Node)object11);
                }
                for (n = 0; n < arrayList.size(); ++n) {
                    Object object12;
                    int n5;
                    int n6;
                    object8 = (Decision)arrayList.get(n);
                    object11 = document.createElement("branchtrans");
                    object10 = null;
                    for (n6 = 0; n6 < moduleModelArray[i].getNumTransitions(); ++n6) {
                        Transition transition = moduleModelArray[i].getTransition(n6);
                        if (transition.getTo() != object8) continue;
                        object10 = transition;
                        break;
                    }
                    if (object10 != null) {
                        n6 = 0;
                        for (int j = 0; j < moduleModelArray[i].getNumStates(); ++j) {
                            if (moduleModelArray[i].getState(j) != ((Transition)object10).getFrom()) continue;
                            n6 = j;
                            break;
                        }
                        object11.setAttribute("from", "" + n6);
                    } else {
                        object11.setAttribute("from", "0");
                    }
                    double d = ((State)object8).getX();
                    double d13 = ((State)object8).getY();
                    object9 = document.createElement("position");
                    object9.setAttribute("x", "" + d);
                    object9.setAttribute("y", "" + d13);
                    object11.appendChild((Node)object9);
                    object9 = new ArrayList();
                    for (n5 = 0; n5 < arrayList3.size(); ++n5) {
                        object12 = (ProbTransition)arrayList3.get(n5);
                        if (((Transition)object12).getFrom() != object8) continue;
                        ((ArrayList)object9).add(object12);
                    }
                    for (n5 = 0; n5 < ((ArrayList)object9).size(); ++n5) {
                        Object object13;
                        String string4;
                        double d14;
                        object12 = (ProbTransition)((ArrayList)object9).get(n5);
                        Element element9 = document.createElement("branch");
                        int n7 = 0;
                        for (int j = 0; j < moduleModelArray[i].getNumStates(); ++j) {
                            if (moduleModelArray[i].getState(j) != ((Transition)object12).getTo()) continue;
                            n7 = j;
                            break;
                        }
                        element9.setAttribute("to", "" + n7);
                        if (((Transition)object12).getNails().size() > 0) {
                            double d15 = ((Nail)((Transition)object12).getNails().get(0)).getX();
                            d14 = ((Nail)((Transition)object12).getNails().get(0)).getY();
                            Element element10 = document.createElement("position");
                            element10.setAttribute("x", "" + d15);
                            element10.setAttribute("y", "" + d14);
                            element9.appendChild(element10);
                        }
                        if (!(string4 = ((Transition)object12).getAssignmentLabel().getString()).equals("")) {
                            object13 = document.createElement("assign");
                            object13.setAttribute("value", string4);
                            d14 = ((Transition)object12).getAssignmentLabel().getOffsetX();
                            double d16 = ((Transition)object12).getAssignmentLabel().getOffsetY();
                            Element element11 = document.createElement("position");
                            element11.setAttribute("x", "" + d14);
                            element11.setAttribute("y", "" + d16);
                            object13.appendChild(element11);
                            element9.appendChild((Node)object13);
                        }
                        if (!((String)(object13 = ((ProbTransition)object12).getProbabilityLabel().getString())).equals("")) {
                            Element element12 = document.createElement("tranProb");
                            element12.setAttribute("value", (String)object13);
                            double d17 = ((ProbTransition)object12).getProbabilityLabel().getOffsetX();
                            double d18 = ((ProbTransition)object12).getProbabilityLabel().getOffsetY();
                            Element element13 = document.createElement("position");
                            element13.setAttribute("x", "" + d17);
                            element13.setAttribute("y", "" + d18);
                            element12.appendChild(element13);
                            element9.appendChild(element12);
                        }
                        object11.appendChild(element9);
                    }
                    try {
                        object7 = ((Transition)object10).getGuardLabel().getString();
                        if (!((String)object7).equals("")) {
                            object12 = document.createElement("guard");
                            object12.setAttribute("value", (String)object7);
                            double d19 = ((Transition)object10).getGuardLabel().getOffsetX();
                            double d20 = ((Transition)object10).getGuardLabel().getOffsetY();
                            Element element14 = document.createElement("position");
                            element14.setAttribute("x", "" + d19);
                            element14.setAttribute("y", "" + d20);
                            object12.appendChild(element14);
                            object11.appendChild((Node)object12);
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    try {
                        object7 = ((Transition)object10).getSyncLabel().getString();
                        if (!((String)object7).equals("")) {
                            object12 = document.createElement("sync");
                            object12.setAttribute("value", (String)object7);
                            double d21 = ((Transition)object10).getSyncLabel().getOffsetX();
                            double d22 = ((Transition)object10).getSyncLabel().getOffsetY();
                            Element element15 = document.createElement("position");
                            element15.setAttribute("x", "" + d21);
                            element15.setAttribute("y", "" + d22);
                            object12.appendChild(element15);
                            object11.appendChild((Node)object12);
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    object5.appendChild((Node)object11);
                }
                element.appendChild((Node)object5);
            }
            document.appendChild(element);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("doctype-system", "gmo.dtd");
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(document), new StreamResult(new FileOutputStream(this.f)));
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    SaveGraphicModelThread.this.plug.stopProgress();
                    SaveGraphicModelThread.this.plug.setTaskBarText("Saving model... done.");
                    SaveGraphicModelThread.this.plug.notifyEventListeners(new GUIComputationEvent(1, SaveGraphicModelThread.this.plug));
                    SaveGraphicModelThread.this.handler.graphicFileWasSaved(SaveGraphicModelThread.this.f);
                }
            });
        }
        catch (DOMException dOMException) {
            System.err.println("DOM Exception: " + dOMException);
            dOMException.printStackTrace();
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        SaveGraphicModelThread.this.plug.stopProgress();
                        SaveGraphicModelThread.this.plug.notifyEventListeners(new GUIComputationEvent(2, SaveGraphicModelThread.this.plug));
                        SaveGraphicModelThread.this.plug.setTaskBarText("Saving model... error.");
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.plug.error("Problem saving file: " + dOMException.getMessage());
            return;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.err.println("Parser Exception: " + parserConfigurationException);
            parserConfigurationException.printStackTrace();
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        SaveGraphicModelThread.this.plug.stopProgress();
                        SaveGraphicModelThread.this.plug.notifyEventListeners(new GUIComputationEvent(2, SaveGraphicModelThread.this.plug));
                        SaveGraphicModelThread.this.plug.setTaskBarText("Saving model... error.");
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.plug.error("Problem saving file: " + parserConfigurationException.getMessage());
            return;
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            transformerConfigurationException.printStackTrace();
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        SaveGraphicModelThread.this.plug.stopProgress();
                        SaveGraphicModelThread.this.plug.notifyEventListeners(new GUIComputationEvent(2, SaveGraphicModelThread.this.plug));
                        SaveGraphicModelThread.this.plug.setTaskBarText("Saving model... error.");
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.plug.error("Problem saving file: " + transformerConfigurationException.getMessage());
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("File not found: " + fileNotFoundException);
            fileNotFoundException.printStackTrace();
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        SaveGraphicModelThread.this.plug.stopProgress();
                        SaveGraphicModelThread.this.plug.notifyEventListeners(new GUIComputationEvent(2, SaveGraphicModelThread.this.plug));
                        SaveGraphicModelThread.this.plug.setTaskBarText("Saving model... error.");
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.plug.error("Problem saving file: " + fileNotFoundException.getMessage());
            return;
        }
        catch (TransformerException transformerException) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        SaveGraphicModelThread.this.plug.stopProgress();
                        SaveGraphicModelThread.this.plug.notifyEventListeners(new GUIComputationEvent(2, SaveGraphicModelThread.this.plug));
                        SaveGraphicModelThread.this.plug.setTaskBarText("Saving model... error.");
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.plug.error("Problem saving file: " + transformerException.getMessage());
            return;
        }
        catch (PrismException prismException) {
            prismException.printStackTrace();
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        SaveGraphicModelThread.this.plug.stopProgress();
                        SaveGraphicModelThread.this.plug.notifyEventListeners(new GUIComputationEvent(2, SaveGraphicModelThread.this.plug));
                        SaveGraphicModelThread.this.plug.setTaskBarText("Saving model... error.");
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.plug.error("Problem saving file: " + prismException.getMessage());
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        SaveGraphicModelThread.this.plug.stopProgress();
                        SaveGraphicModelThread.this.plug.notifyEventListeners(new GUIComputationEvent(2, SaveGraphicModelThread.this.plug));
                        SaveGraphicModelThread.this.plug.setTaskBarText("Saving model... error.");
                    }
                });
            }
            catch (Exception exception2) {
                // empty catch block
            }
            this.plug.error("Problem saving file: " + exception.getMessage());
            return;
        }
    }
}

