/*
 * Decompiled with CFR 0.152.
 */
package userinterface.model.computation;

import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import userinterface.GUIPlugin;
import userinterface.model.GUIMultiModelHandler;
import userinterface.model.GUIMultiModelTree;
import userinterface.model.graphicModel.GUIGraphicModelEditor;
import userinterface.model.graphicModel.ModuleModel;
import userinterface.model.graphicModel.Nail;
import userinterface.model.graphicModel.ProbTransition;
import userinterface.model.graphicModel.State;
import userinterface.model.graphicModel.Transition;
import userinterface.util.GUIComputationEvent;

public class LoadGraphicModelThread
extends Thread
implements EntityResolver {
    private GUIMultiModelHandler handler;
    private File f;
    private GUIPlugin plug;
    private GUIGraphicModelEditor graphicEdit;
    private boolean error;

    public LoadGraphicModelThread(GUIMultiModelHandler gUIMultiModelHandler, File file) {
        this.handler = gUIMultiModelHandler;
        this.f = file;
        this.plug = gUIMultiModelHandler.getGUIPlugin();
        this.error = false;
    }

    @Override
    public void run() {
        this.graphicEdit = new GUIGraphicModelEditor(this.handler, this.handler.getTree(), this.handler.getPropModel());
        this.graphicEdit.newModel();
        this.graphicEdit.setBusy(true);
        ArrayList<Constant> arrayList = new ArrayList<Constant>();
        ArrayList<Variable> arrayList2 = new ArrayList<Variable>();
        ArrayList arrayList3 = new ArrayList();
        String string = "";
        String string2 = "";
        String string3 = "";
        boolean bl = true;
        try {
            String string4;
            Object object;
            Object object2;
            Object object3;
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    LoadGraphicModelThread.this.plug.startProgress();
                    LoadGraphicModelThread.this.plug.notifyEventListeners(new GUIComputationEvent(0, LoadGraphicModelThread.this.plug));
                    LoadGraphicModelThread.this.plug.setTaskBarText("Loading model...");
                }
            });
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(true);
            documentBuilderFactory.setIgnoringElementContentWhitespace(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(this);
            Document document = documentBuilder.parse(this.f);
            Element element = document.getDocumentElement();
            string2 = element.getAttribute("type");
            bl = Boolean.getBoolean(element.getAttribute("autolayout"));
            NodeList nodeList = element.getChildNodes();
            Element element2 = (Element)nodeList.item(0);
            NodeList nodeList2 = element2.getChildNodes();
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                String string5;
                object3 = (Element)nodeList2.item(i);
                if (object3.getTagName().equals("integerConstant")) {
                    string5 = object3.getAttribute("name");
                    object2 = object3.getAttribute("value");
                    if (object2 != "") {
                        arrayList.add(new IntegerConstant(string5, (String)object2));
                        continue;
                    }
                    arrayList.add(new IntegerConstant(string5));
                    continue;
                }
                if (object3.getTagName().equals("booleanConstant")) {
                    string5 = object3.getAttribute("name");
                    object2 = object3.getAttribute("value");
                    if (object2 != "") {
                        arrayList.add(new BooleanConstant(string5, (String)object2));
                        continue;
                    }
                    arrayList.add(new BooleanConstant(string5));
                    continue;
                }
                if (!object3.getTagName().equals("doubleConstant")) continue;
                string5 = object3.getAttribute("name");
                object2 = object3.getAttribute("value");
                if (object2 != "") {
                    arrayList.add(new DoubleConstant(string5, (String)object2));
                    continue;
                }
                arrayList.add(new DoubleConstant(string5));
            }
            Element element3 = (Element)nodeList.item(1);
            object3 = element3.getChildNodes();
            for (int i = 0; i < object3.getLength(); ++i) {
                String string6;
                object2 = (Element)object3.item(i);
                if (object2.getTagName().equals("variable")) {
                    string6 = object2.getAttribute("name");
                    object = object2.getAttribute("min");
                    string4 = object2.getAttribute("max");
                    String string7 = object2.getAttribute("init");
                    if (!string7.equals("")) {
                        arrayList2.add(new IntegerVariable(string6, (String)object, string4, string7));
                        continue;
                    }
                    arrayList2.add(new IntegerVariable(string6, (String)object, string4));
                    continue;
                }
                if (!object2.getTagName().equals("boolVariable")) continue;
                string6 = object2.getAttribute("name");
                object = object2.getAttribute("init");
                if (!((String)object).equals("")) {
                    arrayList2.add(new BooleanVariable(string6, (String)object));
                    continue;
                }
                arrayList2.add(new BooleanVariable(string6));
            }
            Element element4 = (Element)nodeList.item(2);
            object2 = (Text)element4.getChildNodes().item(0);
            string3 = object2 != null ? object2.getData() : "";
            this.graphicEdit.loadAllExceptModules(string, string2, arrayList2, arrayList, string3);
            ModuleModel[] moduleModelArray = new ModuleModel[nodeList.getLength() - 3];
            Rectangle[] rectangleArray = new Rectangle[nodeList.getLength() - 3];
            ArrayList[] arrayListArray = new ArrayList[nodeList.getLength() - 3];
            arrayList3 = new ArrayList(nodeList.getLength() - 3);
            for (int i = 3; i < nodeList.getLength(); ++i) {
                Object object4;
                double d;
                double d2;
                Object object5;
                String string8;
                Element element5;
                int n;
                double d3;
                object = (Element)nodeList.item(i);
                string4 = object.getAttribute("name");
                try {
                    d3 = Double.parseDouble(object.getAttribute("zoom"));
                }
                catch (NumberFormatException numberFormatException) {
                    d3 = 1.0;
                }
                int n2 = 0;
                int n3 = 0;
                int n4 = 200;
                int n5 = 200;
                try {
                    n2 = Integer.parseInt(object.getAttribute("x"));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                try {
                    n3 = Integer.parseInt(object.getAttribute("y"));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                try {
                    n4 = Integer.parseInt(object.getAttribute("width"));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                try {
                    n5 = Integer.parseInt(object.getAttribute("height"));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                GUIMultiModelTree.ModuleNode moduleNode = this.graphicEdit.requestNewModule(string4);
                ModuleModel moduleModel = this.graphicEdit.getModuleModel(moduleNode);
                moduleModel.getContainer().setRectangle(new Rectangle(n2, n3, n4, n5));
                ArrayList arrayList4 = new ArrayList();
                NodeList nodeList3 = object.getChildNodes();
                for (n = 0; n < nodeList3.getLength(); ++n) {
                    Object object6;
                    Object object7;
                    Object object8;
                    Object object9;
                    element5 = (Element)nodeList3.item(n);
                    string8 = element5.getTagName();
                    if (string8.equals("variable")) {
                        String string9 = element5.getAttribute("name");
                        String string10 = element5.getAttribute("min");
                        object5 = element5.getAttribute("max");
                        String string11 = element5.getAttribute("init");
                        if (string11.equals("")) {
                            string11 = "&&&Default&&&";
                        }
                        this.graphicEdit.addIntegerVariable(moduleNode, new IntegerVariable(string9, string10, (String)object5, string11));
                        continue;
                    }
                    if (string8.equals("boolVariable")) {
                        String string12 = element5.getAttribute("name");
                        String string13 = element5.getAttribute("init");
                        if (string13.equals("")) {
                            string13 = "&&&Default&&&";
                        }
                        this.graphicEdit.addBooleanVariable(moduleNode, new BooleanVariable(string12, string13));
                        continue;
                    }
                    if (!string8.equals("state")) continue;
                    int n6 = Integer.parseInt(element5.getAttribute("id"));
                    boolean bl2 = Boolean.getBoolean(element5.getAttribute("initial"));
                    object5 = (Element)element5.getChildNodes().item(0);
                    double d4 = Double.parseDouble(object5.getAttribute("x"));
                    double d5 = Double.parseDouble(object5.getAttribute("y"));
                    if (element5.getChildNodes().getLength() == 3) {
                        object9 = (Element)element5.getChildNodes().item(1);
                        object8 = object9.getAttribute("name");
                        object7 = (Element)object9.getChildNodes().item(0);
                        d2 = Double.parseDouble(object7.getAttribute("x"));
                        d = Double.parseDouble(object7.getAttribute("y"));
                        Element element6 = (Element)element5.getChildNodes().item(2);
                        object6 = element6.getAttribute("name");
                        Element element7 = (Element)element6.getChildNodes().item(0);
                        double d6 = Double.parseDouble(element7.getAttribute("x"));
                        double d7 = Double.parseDouble(element7.getAttribute("y"));
                        object4 = new State(d4, d5);
                        if (!((String)object8).equals("")) {
                            ((State)object4).setComment((String)object6 + "\n" + (String)object8);
                        } else {
                            ((State)object4).setComment((String)object6);
                        }
                        ((State)object4).setInitial(bl2);
                        ((State)object4).getCommentLabel().setOffsetX(d6);
                        ((State)object4).getCommentLabel().setOffsetY(d7);
                        moduleModel.addState((State)object4);
                        continue;
                    }
                    if (element5.getChildNodes().getLength() == 2) {
                        double d8;
                        double d9;
                        Element element8;
                        object9 = (Element)element5.getChildNodes().item(1);
                        if (object9.getTagName().equals("invariant")) {
                            object8 = (Element)element5.getChildNodes().item(1);
                            object7 = object8.getAttribute("name");
                            element8 = (Element)object8.getChildNodes().item(0);
                            d9 = Double.parseDouble(element8.getAttribute("x"));
                            d8 = Double.parseDouble(element8.getAttribute("y"));
                            object6 = new State(d4, d5);
                            ((State)object6).setComment((String)object7);
                            ((State)object6).setInitial(bl2);
                            ((State)object6).getCommentLabel().setOffsetX(d9);
                            ((State)object6).getCommentLabel().setOffsetY(d8);
                            moduleModel.addState((State)object6);
                            continue;
                        }
                        object8 = (Element)element5.getChildNodes().item(1);
                        object7 = object8.getAttribute("name");
                        element8 = (Element)object8.getChildNodes().item(0);
                        d9 = Double.parseDouble(element8.getAttribute("x"));
                        d8 = Double.parseDouble(element8.getAttribute("y"));
                        object6 = new State(d4, d5);
                        ((State)object6).setComment((String)object7);
                        ((State)object6).setInitial(bl2);
                        ((State)object6).getCommentLabel().setOffsetX(d9);
                        ((State)object6).getCommentLabel().setOffsetY(d8);
                        moduleModel.addState((State)object6);
                        continue;
                    }
                    object9 = new State(d4, d5);
                    ((State)object9).setInitial(bl2);
                    moduleModel.addState((State)object9);
                }
                for (n = 0; n < nodeList3.getLength(); ++n) {
                    int n7;
                    Object object10;
                    Object object11;
                    Object object12;
                    double d10;
                    double d11;
                    double d12;
                    double d13;
                    double d14;
                    String string14;
                    int n8;
                    element5 = (Element)nodeList3.item(n);
                    string8 = element5.getTagName();
                    if (string8.equals("transition")) {
                        int n9;
                        int n10;
                        int n11;
                        Object object13;
                        n8 = Integer.parseInt(element5.getAttribute("from"));
                        int n12 = Integer.parseInt(element5.getAttribute("to"));
                        object5 = "";
                        string14 = "";
                        String string15 = "";
                        String string16 = "";
                        d14 = 0.0;
                        d13 = 0.0;
                        d2 = 0.0;
                        d = 0.0;
                        d12 = 0.0;
                        d11 = 0.0;
                        d10 = 0.0;
                        double d15 = 0.0;
                        ArrayList<Object> arrayList5 = new ArrayList<Object>();
                        object12 = element5.getChildNodes();
                        for (int j = 0; j < object12.getLength(); ++j) {
                            Element element9;
                            object13 = (Element)object12.item(j);
                            object11 = object13.getTagName();
                            if (((String)object11).equals("guard")) {
                                element9 = (Element)object13.getChildNodes().item(0);
                                d14 = Double.parseDouble(element9.getAttribute("x"));
                                d13 = Double.parseDouble(element9.getAttribute("y"));
                                object5 = object13.getAttribute("value");
                                continue;
                            }
                            if (((String)object11).equals("sync")) {
                                element9 = (Element)object13.getChildNodes().item(0);
                                d2 = Double.parseDouble(element9.getAttribute("x"));
                                d = Double.parseDouble(element9.getAttribute("y"));
                                string14 = object13.getAttribute("value");
                                continue;
                            }
                            if (((String)object11).equals("assign")) {
                                element9 = (Element)object13.getChildNodes().item(0);
                                d12 = Double.parseDouble(element9.getAttribute("x"));
                                d11 = Double.parseDouble(element9.getAttribute("y"));
                                string15 = object13.getAttribute("value");
                                continue;
                            }
                            if (((String)object11).equals("tranProb")) {
                                element9 = (Element)object13.getChildNodes().item(0);
                                d10 = Double.parseDouble(element9.getAttribute("x"));
                                d15 = Double.parseDouble(element9.getAttribute("y"));
                                string16 = object13.getAttribute("value");
                                continue;
                            }
                            if (!((String)object11).equals("nail")) continue;
                            arrayList5.add(object13);
                        }
                        ArrayList<Nail> arrayList6 = new ArrayList<Nail>();
                        object13 = new ArrayList();
                        object11 = new ArrayList();
                        for (n11 = 0; n11 < arrayList5.size(); ++n11) {
                            block63: {
                                block62: {
                                    object10 = (Element)arrayList5.get(n11);
                                    n10 = 0;
                                    try {
                                        n10 = Integer.parseInt(object10.getAttribute("from"));
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        if (!object10.getAttribute("from").equals("FROMSTATE")) break block62;
                                        n10 = -1;
                                    }
                                }
                                n9 = 0;
                                try {
                                    n9 = Integer.parseInt(object10.getAttribute("to"));
                                }
                                catch (NumberFormatException numberFormatException) {
                                    if (!object10.getAttribute("to").equals("TOSTATE")) break block63;
                                    n9 = -1;
                                }
                            }
                            Element element10 = (Element)object10.getChildNodes().item(0);
                            double d16 = Double.parseDouble(element10.getAttribute("x"));
                            double d17 = Double.parseDouble(element10.getAttribute("y"));
                            Nail nail = new Nail(d16, d17, null, null);
                            arrayList6.add(nail);
                            ((ArrayList)object13).add(new Integer(n10));
                            ((ArrayList)object11).add(new Integer(n9));
                        }
                        for (n11 = 0; n11 < arrayList6.size(); ++n11) {
                            object10 = (Nail)arrayList6.get(n11);
                            n10 = (Integer)((ArrayList)object13).get(n11);
                            n9 = (Integer)((ArrayList)object11).get(n11);
                            if (n10 != -1) {
                                ((Nail)object10).setFrom((Nail)arrayList6.get(n10));
                            } else {
                                ((Nail)object10).setFrom(moduleModel.getState(n8));
                            }
                            if (n9 != -1) {
                                ((Nail)object10).setTo((Nail)arrayList6.get(n9));
                                continue;
                            }
                            ((Nail)object10).setTo(moduleModel.getState(n12));
                        }
                        n11 = 0;
                        n11 = arrayList6.size() > 0 ? moduleModel.addTransition(moduleModel.getState(n8), moduleModel.getState(n12), arrayList6) : moduleModel.addTransition(moduleModel.getState(n8), moduleModel.getState(n12), false);
                        moduleModel.getTransition(n11).setGuard((String)object5);
                        moduleModel.getTransition(n11).setSync(string14);
                        moduleModel.getTransition(n11).setAssignment(string15);
                        moduleModel.getTransition(n11).setProbability(string16);
                        moduleModel.getTransition(n11).getGuardLabel().setOffsetX(d14);
                        moduleModel.getTransition(n11).getGuardLabel().setOffsetY(d13);
                        moduleModel.getTransition(n11).getSyncLabel().setOffsetX(d2);
                        moduleModel.getTransition(n11).getSyncLabel().setOffsetY(d);
                        moduleModel.getTransition(n11).getAssignmentLabel().setOffsetX(d12);
                        moduleModel.getTransition(n11).getAssignmentLabel().setOffsetY(d11);
                        moduleModel.getTransition(n11).getProbabilityLabel().setOffsetX(d10);
                        moduleModel.getTransition(n11).getProbabilityLabel().setOffsetY(d15);
                        continue;
                    }
                    if (!string8.equals("branchtrans")) continue;
                    n8 = Integer.parseInt(element5.getAttribute("from"));
                    String string17 = "";
                    object5 = "";
                    string14 = "";
                    double d18 = 0.0;
                    d14 = 0.0;
                    d13 = -100.0;
                    d2 = -100.0;
                    d = 0.0;
                    d12 = 0.0;
                    d11 = 0.0;
                    d10 = 0.0;
                    ArrayList<Branch> arrayList7 = new ArrayList<Branch>();
                    object4 = (Element)element5.getChildNodes().item(0);
                    d13 = Double.parseDouble(object4.getAttribute("x"));
                    d2 = Double.parseDouble(object4.getAttribute("y"));
                    for (n7 = 1; n7 < element5.getChildNodes().getLength(); ++n7) {
                        object12 = (Element)element5.getChildNodes().item(n7);
                        String string18 = object12.getTagName();
                        if (string18.equals("branch")) {
                            int n13 = Integer.parseInt(object12.getAttribute("to"));
                            object11 = object12.getChildNodes();
                            String string19 = "";
                            object10 = "";
                            double d19 = 0.0;
                            double d20 = 0.0;
                            double d21 = 0.0;
                            double d22 = 0.0;
                            boolean bl3 = false;
                            double d23 = 0.0;
                            double d24 = 0.0;
                            for (int j = 0; j < object11.getLength(); ++j) {
                                Element element11;
                                Element element12 = (Element)object11.item(j);
                                String string20 = element12.getTagName();
                                if (string20.equals("position")) {
                                    bl3 = true;
                                    d23 = Double.parseDouble(element12.getAttribute("x"));
                                    d24 = Double.parseDouble(element12.getAttribute("y"));
                                    continue;
                                }
                                if (string20.equals("assign")) {
                                    object10 = element12.getAttribute("value");
                                    element11 = (Element)element12.getChildNodes().item(0);
                                    d21 = Double.parseDouble(element11.getAttribute("x"));
                                    d22 = Double.parseDouble(element11.getAttribute("y"));
                                    continue;
                                }
                                if (!string20.equals("tranProb")) continue;
                                string19 = element12.getAttribute("value");
                                element11 = (Element)element12.getChildNodes().item(0);
                                d19 = Double.parseDouble(element11.getAttribute("x"));
                                d20 = Double.parseDouble(element11.getAttribute("y"));
                            }
                            Branch branch = new Branch();
                            branch.to = n13;
                            branch.prob = string19;
                            branch.assignment = object10;
                            branch.probX = d19;
                            branch.probY = d20;
                            branch.assignX = d21;
                            branch.assignY = d22;
                            branch.hasNail = bl3;
                            branch.nailX = d23;
                            branch.nailY = d24;
                            arrayList7.add(branch);
                            continue;
                        }
                        if (string18.equals("guard")) {
                            string17 = object12.getAttribute("value");
                            object4 = (Element)object12.getChildNodes().item(0);
                            d = Double.parseDouble(object4.getAttribute("x"));
                            d12 = Double.parseDouble(object4.getAttribute("y"));
                            continue;
                        }
                        if (string18.equals("sync")) {
                            object5 = object12.getAttribute("value");
                            object4 = (Element)object12.getChildNodes().item(0);
                            d11 = Double.parseDouble(object4.getAttribute("x"));
                            d10 = Double.parseDouble(object4.getAttribute("y"));
                            continue;
                        }
                        if (!string18.equals("assign")) continue;
                        string14 = object12.getAttribute("value");
                        object4 = (Element)object12.getChildNodes().item(0);
                        d18 = Double.parseDouble(object4.getAttribute("x"));
                        d14 = Double.parseDouble(object4.getAttribute("y"));
                    }
                    n7 = moduleModel.addDecision(d13, d2);
                    int n14 = moduleModel.addTransition(moduleModel.getState(n8), moduleModel.getState(n7), false);
                    moduleModel.getTransition(n14).setGuard(string17);
                    moduleModel.getTransition(n14).setSync((String)object5);
                    moduleModel.getTransition(n14).getGuardLabel().setOffsetX(d);
                    moduleModel.getTransition(n14).getGuardLabel().setOffsetY(d12);
                    moduleModel.getTransition(n14).getSyncLabel().setOffsetX(d11);
                    moduleModel.getTransition(n14).getSyncLabel().setOffsetY(d10);
                    for (int j = 0; j < arrayList7.size(); ++j) {
                        Branch branch = (Branch)arrayList7.get(j);
                        object11 = null;
                        if (branch.hasNail) {
                            object11 = new Nail(branch.nailX, branch.nailY, moduleModel.getState(n7), moduleModel.getState(branch.to));
                        }
                        int n15 = moduleModel.addProbTransition(moduleModel.getState(n7), moduleModel.getState(branch.to), (Nail)object11);
                        object10 = (ProbTransition)moduleModel.getTransition(n15);
                        ((ProbTransition)object10).getProbabilityLabel().setString(branch.prob);
                        ((ProbTransition)object10).getProbabilityLabel().setOffsetX(branch.probX);
                        ((ProbTransition)object10).getProbabilityLabel().setOffsetY(branch.probY);
                        ((Transition)object10).getAssignmentLabel().setString(branch.assignment);
                        ((Transition)object10).getAssignmentLabel().setOffsetX(branch.assignX);
                        ((Transition)object10).getAssignmentLabel().setOffsetY(branch.assignY);
                    }
                }
                moduleModel.setModuleName(string4);
                moduleModel.setZoom(d3);
                moduleModel.deSelectAll();
            }
            this.graphicEdit.setAutolayout(bl);
            this.graphicEdit.setBusy(false);
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    LoadGraphicModelThread.this.plug.stopProgress();
                    LoadGraphicModelThread.this.plug.setTaskBarText("Loading model... done.");
                    LoadGraphicModelThread.this.plug.notifyEventListeners(new GUIComputationEvent(1, LoadGraphicModelThread.this.plug));
                    LoadGraphicModelThread.this.handler.graphicModelLoaded(LoadGraphicModelThread.this.graphicEdit, LoadGraphicModelThread.this.f);
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (Exception exception) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        LoadGraphicModelThread.this.plug.stopProgress();
                        LoadGraphicModelThread.this.plug.notifyEventListeners(new GUIComputationEvent(2, LoadGraphicModelThread.this.plug));
                        LoadGraphicModelThread.this.plug.setTaskBarText("Loading model... error.");
                    }
                });
            }
            catch (Exception exception2) {
                // empty catch block
            }
            exception.printStackTrace();
            this.plug.error("Problem reading file: " + exception.getMessage());
            return;
        }
    }

    @Override
    public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
        InputStream inputStream;
        InputSource inputSource = null;
        if (string2.endsWith("dtd") && (inputStream = LoadGraphicModelThread.class.getClassLoader().getResourceAsStream("dtds/gmo.dtd")) != null) {
            inputSource = new InputSource(inputStream);
        }
        return inputSource;
    }

    public class BooleanVariable
    extends Variable {
        public String init;

        public BooleanVariable(String string, String string2) {
            this.init = "false";
            this.init = string2;
            this.name = string;
        }

        public BooleanVariable(String string) {
            this.init = "false";
            this.name = string;
        }
    }

    public class IntegerVariable
    extends Variable {
        public String min;
        public String max;
        public String init;

        public IntegerVariable(String string, String string2, String string3, String string4) {
            this.init = "0";
            this.name = string;
            this.min = string2;
            this.max = string3;
            this.init = string4;
        }

        public IntegerVariable(String string, String string2, String string3) {
            this.init = "0";
            this.name = string;
            this.min = string2;
            this.max = string3;
        }
    }

    public class Variable {
        public String name;
    }

    public class BooleanConstant
    extends Constant {
        public BooleanConstant(String string, String string2) {
            this.name = string;
            this.value = string2;
        }

        public BooleanConstant(String string) {
            this.name = string;
        }
    }

    public class DoubleConstant
    extends Constant {
        public DoubleConstant(String string, String string2) {
            this.name = string;
            this.value = string2;
        }

        public DoubleConstant(String string) {
            this.name = string;
        }
    }

    public class IntegerConstant
    extends Constant {
        public IntegerConstant(String string, String string2) {
            this.name = string;
            this.value = string2;
        }

        public IntegerConstant(String string) {
            this.name = string;
        }
    }

    public abstract class Constant {
        public String name;
        public String value = null;
    }

    class Branch {
        int to;
        String prob;
        String assignment;
        double probX;
        double probY;
        double assignX;
        double assignY;
        double nailX;
        double nailY;
        boolean hasNail;

        Branch() {
        }
    }
}

