/*
 * Decompiled with CFR 0.152.
 */
package userinterface.model.computation;

import java.io.File;
import javax.swing.SwingUtilities;
import prism.PrismException;
import userinterface.GUIComputationThread;
import userinterface.model.GUIMultiModelHandler;
import userinterface.util.GUIComputationEvent;

public class ComputeSteadyStateThread
extends GUIComputationThread {
    private GUIMultiModelHandler handler;
    private int exportType;
    private File exportFile;

    public ComputeSteadyStateThread(GUIMultiModelHandler gUIMultiModelHandler) {
        this(gUIMultiModelHandler, 1, null);
    }

    public ComputeSteadyStateThread(GUIMultiModelHandler gUIMultiModelHandler, int n, File file) {
        super(gUIMultiModelHandler.getGUIPlugin());
        this.handler = gUIMultiModelHandler;
        this.exportType = n;
        this.exportFile = file;
    }

    @Override
    public void run() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ComputeSteadyStateThread.this.plug.startProgress();
                ComputeSteadyStateThread.this.plug.notifyEventListeners(new GUIComputationEvent(0, ComputeSteadyStateThread.this.plug));
                ComputeSteadyStateThread.this.plug.setTaskBarText("Computing steady-state probabilities...");
            }
        });
        try {
            this.prism.doSteadyState(this.exportType, this.exportFile, null);
        }
        catch (PrismException prismException) {
            this.error(prismException.getMessage());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ComputeSteadyStateThread.this.plug.notifyEventListeners(new GUIComputationEvent(2, ComputeSteadyStateThread.this.plug));
                    ComputeSteadyStateThread.this.plug.setTaskBarText("Computing steady-state probabilities... error.");
                    ComputeSteadyStateThread.this.plug.stopProgress();
                }
            });
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ComputeSteadyStateThread.this.plug.setTaskBarText("Computing steady-state probabilities... done.");
                ComputeSteadyStateThread.this.plug.notifyEventListeners(new GUIComputationEvent(1, ComputeSteadyStateThread.this.plug));
                ComputeSteadyStateThread.this.plug.stopProgress();
            }
        });
    }
}

