/*
 * Decompiled with CFR 0.152.
 */
package userinterface.model;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PlainView;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import parser.PrismSyntaxHighlighter;
import prism.PrismLangException;
import userinterface.model.GUIMultiModelHandler;
import userinterface.model.Style;

class PrismView
extends PlainView {
    static final Style PLAIN_S = new Style(Color.black, 0);
    private GUIMultiModelHandler handler;

    public PrismView(Element element, GUIMultiModelHandler gUIMultiModelHandler) {
        super(element);
        this.handler = gUIMultiModelHandler;
    }

    @Override
    protected int drawUnselectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
        Object object;
        int n5 = n3;
        int n6 = n4;
        if (graphics instanceof Graphics2D) {
            object = (Graphics2D)graphics;
            ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        try {
            graphics.setColor(Color.green);
            object = this.getDocument();
            String string = object.getText(n5, n6 - n5);
            Style[] styleArray = this.highlight(string, n3 - n5, n4 - n3);
            boolean bl = false;
            boolean bl2 = false;
            Object var13_14 = null;
            String string2 = this.handler.getPrismEditorFontFast().getName();
            int n7 = this.handler.getPrismEditorFontFast().getSize();
            for (int i = 0; i < styleArray.length; ++i) {
                Style style = styleArray[i];
                graphics.setColor(style.c);
                graphics.setFont(new Font(string2, style.style, n7));
                Segment segment = new Segment();
                object.getText(n3 + i, 1, segment);
                n = Utilities.drawTabbedText(segment, n, n2, graphics, (TabExpander)this, n3 + i);
            }
            graphics.setColor(Color.black);
            graphics.setFont(new Font(string2, 0, n7));
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        return n;
    }

    @Override
    protected int drawSelectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
        Object object;
        int n5 = n3;
        int n6 = n4;
        if (graphics instanceof Graphics2D) {
            object = (Graphics2D)graphics;
            ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        try {
            graphics.setColor(Color.green);
            object = this.getDocument();
            String string = object.getText(n5, n6 - n5);
            Style[] styleArray = this.highlight(string, n3 - n5, n4 - n3);
            boolean bl = false;
            boolean bl2 = false;
            Object var13_14 = null;
            String string2 = this.handler.getPrismEditorFontFast().getName();
            int n7 = this.handler.getPrismEditorFontFast().getSize();
            for (int i = 0; i < styleArray.length; ++i) {
                Style style = styleArray[i];
                graphics.setColor(style.c);
                graphics.setFont(new Font(string2, style.style, n7));
                Segment segment = new Segment();
                object.getText(n3 + i, 1, segment);
                n = Utilities.drawTabbedText(segment, n, n2, graphics, (TabExpander)this, n3 + i);
            }
            graphics.setColor(Color.black);
            graphics.setFont(new Font(string2, 0, n7));
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        return n;
    }

    private synchronized Style[] highlight(String string, int n, int n2) {
        int n3;
        int[] nArray;
        if (!string.endsWith("\n")) {
            string = string + "\n";
        }
        try {
            nArray = PrismSyntaxHighlighter.lineForPrismGUI(string);
        }
        catch (PrismLangException prismLangException) {
            int n4 = string.length();
            nArray = new int[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                nArray[n3] = 0;
            }
        }
        Style[] styleArray = new Style[n2];
        for (n3 = 0; n3 < n2; ++n3) {
            if (n3 + n < nArray.length) {
                switch (nArray[n3 + n]) {
                    case 0: {
                        styleArray[n3] = PLAIN_S;
                        break;
                    }
                    case 1: {
                        styleArray[n3] = this.handler.getPrismEditorCommentFast();
                        break;
                    }
                    case 2: {
                        styleArray[n3] = PLAIN_S;
                        break;
                    }
                    case 3: {
                        styleArray[n3] = this.handler.getPrismEditorKeywordFast();
                        break;
                    }
                    case 4: {
                        styleArray[n3] = this.handler.getPrismEditorNumericFast();
                        break;
                    }
                    case 5: {
                        styleArray[n3] = this.handler.getPrismEditorVariableFast();
                        break;
                    }
                    default: {
                        styleArray[n3] = PLAIN_S;
                        break;
                    }
                }
                continue;
            }
            styleArray[n3] = PLAIN_S;
        }
        return styleArray;
    }
}

