/*
 * Decompiled with CFR 0.152.
 */
package userinterface.graph;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.Printable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.epsgraphics.ColorMode;
import net.sf.epsgraphics.EpsGraphics;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItemSource;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.encoders.KeypointPNGEncoderAdapter;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.RectangleEdge;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import prism.Prism;
import prism.PrismException;
import settings.BooleanSetting;
import settings.ChoiceSetting;
import settings.FontColorPair;
import settings.FontColorSetting;
import settings.MultipleLineStringSetting;
import settings.Setting;
import settings.SettingDisplay;
import settings.SettingException;
import settings.SettingOwner;
import userinterface.graph.AxisSettings;
import userinterface.graph.DisplaySettings;
import userinterface.graph.GraphException;
import userinterface.graph.PrismXYSeries;
import userinterface.graph.SeriesSettings;
import userinterface.graph.SeriesSettingsList;

public class Graph
extends ChartPanel
implements SettingOwner,
EntityResolver,
Observer,
Printable {
    private static final long updateInterval = 250L;
    private JFreeChart chart;
    private XYPlot plot;
    private XYSeriesCollection seriesCollection;
    private HashMap<SeriesKey, XYSeries> keyToSeries;
    private HashMap<SeriesKey, SeriesSettings> keyToGraphSeries;
    private HashMap<SeriesKey, LinkedList<XYDataItem>> graphCache = new HashMap();
    private SettingDisplay display;
    private MultipleLineStringSetting graphTitle;
    private FontColorSetting titleFont;
    private BooleanSetting legendVisible;
    private ChoiceSetting legendPosition;
    private FontColorSetting legendFont;
    private AxisSettings xAxisSettings;
    private AxisSettings yAxisSettings;
    private DisplaySettings displaySettings;
    private SeriesSettingsList seriesList;
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int BOTTOM = 2;
    public static final int TOP = 3;

    public Graph() {
        this("");
    }

    public Graph(String string) {
        super(ChartFactory.createXYLineChart((String)string, (String)"X", (String)"Y", (XYDataset)new XYSeriesCollection(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false));
        this.keyToSeries = new HashMap();
        this.keyToGraphSeries = new HashMap();
        this.graphTitle = new MultipleLineStringSetting("title", string, "The main title heading for the chart.", (SettingOwner)this, false);
        this.titleFont = new FontColorSetting("title font", new FontColorPair(new Font("SansSerif", 0, 14), Color.black), "The font for the chart's title", (SettingOwner)this, false);
        this.legendVisible = new BooleanSetting("legend visible?", new Boolean(true), "Should the legend, which displays all of the series headings, be displayed?", (SettingOwner)this, false);
        String[] stringArray = new String[]{"Left", "Right", "Bottom", "Top"};
        this.legendPosition = new ChoiceSetting("legend position", stringArray, stringArray[1], "The position of the legend", this, false);
        this.legendFont = new FontColorSetting("legend font", new FontColorPair(new Font("SansSerif", 0, 11), Color.black), "The font for the legend", (SettingOwner)this, false);
        this.chart = super.getChart();
        this.plot = this.chart.getXYPlot();
        this.plot.setBackgroundPaint((Paint)Color.white);
        this.seriesCollection = (XYSeriesCollection)this.plot.getDataset();
        this.xAxisSettings = new AxisSettings("X", true, this);
        this.yAxisSettings = new AxisSettings("Y", false, this);
        this.xAxisSettings.addObserver(this);
        this.yAxisSettings.addObserver(this);
        this.displaySettings = new DisplaySettings(this);
        this.displaySettings.addObserver(this);
        this.seriesList = new SeriesSettingsList(this);
        XYItemRenderer xYItemRenderer = this.plot.getRenderer();
        if (xYItemRenderer instanceof XYLineAndShapeRenderer) {
            XYLineAndShapeRenderer xYLineAndShapeRenderer = (XYLineAndShapeRenderer)xYItemRenderer;
            xYLineAndShapeRenderer.setBaseShapesVisible(true);
            xYLineAndShapeRenderer.setBaseShapesFilled(true);
            xYLineAndShapeRenderer.setDrawSeriesLineAsPath(true);
            xYLineAndShapeRenderer.setAutoPopulateSeriesPaint(true);
            xYLineAndShapeRenderer.setAutoPopulateSeriesShape(true);
        }
        this.plot.setDrawingSupplier((DrawingSupplier)new DefaultDrawingSupplier(SeriesSettings.DEFAULT_PAINTS, DefaultDrawingSupplier.DEFAULT_OUTLINE_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_STROKE_SEQUENCE, SeriesSettings.DEFAULT_SHAPES));
        super.setPopupMenu(null);
        this.updateGraph();
        new Timer().scheduleAtFixedRate((TimerTask)new GraphUpdateTask(), 0L, 250L);
    }

    public int compareTo(Object object) {
        if (object instanceof SettingOwner) {
            SettingOwner settingOwner = (SettingOwner)object;
            if (this.getSettingOwnerID() < settingOwner.getSettingOwnerID()) {
                return -1;
            }
            if (this.getSettingOwnerID() > settingOwner.getSettingOwnerID()) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    @Override
    public int getNumSettings() {
        return 5;
    }

    @Override
    public Setting getSetting(int n) {
        switch (n) {
            case 0: {
                return this.graphTitle;
            }
            case 1: {
                return this.titleFont;
            }
            case 2: {
                return this.legendVisible;
            }
            case 3: {
                return this.legendPosition;
            }
            case 4: {
                return this.legendFont;
            }
        }
        return null;
    }

    @Override
    public String getSettingOwnerClassName() {
        return "Model";
    }

    @Override
    public int getSettingOwnerID() {
        return 10;
    }

    @Override
    public String getSettingOwnerName() {
        return this.graphTitle.getStringValue();
    }

    public void doEnables() {
        this.legendPosition.setEnabled(this.legendVisible.getBooleanValue());
        this.legendFont.setEnabled(this.legendVisible.getBooleanValue());
    }

    @Override
    public void update(Observable observable, Object object) {
        if (observable == this.xAxisSettings) {
            super.repaint();
        } else if (observable == this.yAxisSettings) {
            super.repaint();
        } else if (observable == this.displaySettings) {
            super.repaint();
        } else {
            for (Map.Entry<SeriesKey, SeriesSettings> entry : this.keyToGraphSeries.entrySet()) {
                if (!entry.getValue().equals(observable)) continue;
                this.repaint();
            }
        }
    }

    @Override
    public void notifySettingChanged(Setting setting) {
        this.updateGraph();
    }

    private void updateGraph() {
        LegendTitle legendTitle;
        if (!this.chart.getTitle().equals((Object)this.graphTitle)) {
            this.chart.setTitle(this.graphTitle.getStringValue());
        }
        if (!this.titleFont.getFontColorValue().f.equals(this.chart.getTitle().getFont())) {
            this.chart.getTitle().setFont(this.titleFont.getFontColorValue().f);
        }
        if (!this.titleFont.getFontColorValue().c.equals(this.chart.getTitle().getPaint())) {
            this.chart.getTitle().setPaint((Paint)this.titleFont.getFontColorValue().c);
        }
        if (this.legendVisible.getBooleanValue() != (this.chart.getLegend() != null)) {
            if (!this.legendVisible.getBooleanValue()) {
                this.chart.removeLegend();
            } else {
                legendTitle = new LegendTitle((LegendItemSource)this.plot.getRenderer());
                legendTitle.setBackgroundPaint((Paint)Color.white);
                legendTitle.setBorder(1.0, 1.0, 1.0, 1.0);
                this.chart.addLegend(legendTitle);
            }
        }
        if (this.chart.getLegend() != null) {
            legendTitle = this.chart.getLegend();
            if (this.legendPosition.getCurrentIndex() == 0 && !legendTitle.getPosition().equals((Object)RectangleEdge.LEFT)) {
                legendTitle.setPosition(RectangleEdge.LEFT);
            }
            if (this.legendPosition.getCurrentIndex() == 1 && !legendTitle.getPosition().equals((Object)RectangleEdge.RIGHT)) {
                legendTitle.setPosition(RectangleEdge.RIGHT);
            }
            if (this.legendPosition.getCurrentIndex() == 3 && !legendTitle.getPosition().equals((Object)RectangleEdge.TOP)) {
                legendTitle.setPosition(RectangleEdge.TOP);
            }
            if (this.legendPosition.getCurrentIndex() == 2 && !legendTitle.getPosition().equals((Object)RectangleEdge.BOTTOM)) {
                legendTitle.setPosition(RectangleEdge.BOTTOM);
            }
            if (!legendTitle.getItemFont().equals(this.legendFont.getFontColorValue().f)) {
                legendTitle.setItemFont(this.legendFont.getFontColorValue().f);
            }
            if (!legendTitle.getItemPaint().equals(this.legendFont.getFontColorValue().c)) {
                legendTitle.setItemPaint((Paint)this.legendFont.getFontColorValue().c);
            }
        }
        super.repaint();
        this.doEnables();
    }

    @Override
    public void setDisplay(SettingDisplay settingDisplay) {
        this.display = settingDisplay;
    }

    @Override
    public SettingDisplay getDisplay() {
        return this.display;
    }

    public Object getSeriesLock() {
        return this.seriesCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<SeriesKey> getAllSeriesKeys() {
        XYSeriesCollection xYSeriesCollection = this.seriesCollection;
        synchronized (xYSeriesCollection) {
            Vector<SeriesKey> vector = new Vector<SeriesKey>();
            for (Map.Entry<SeriesKey, XYSeries> entry : this.keyToSeries.entrySet()) {
                vector.add(entry.getKey());
            }
            return vector;
        }
    }

    public SeriesSettingsList getGraphSeriesList() {
        return this.seriesList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SeriesSettings getGraphSeries(SeriesKey seriesKey) {
        XYSeriesCollection xYSeriesCollection = this.seriesCollection;
        synchronized (xYSeriesCollection) {
            if (this.keyToGraphSeries.containsKey(seriesKey)) {
                return this.keyToGraphSeries.get(seriesKey);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XYSeries getXYSeries(SeriesKey seriesKey) {
        XYSeriesCollection xYSeriesCollection = this.seriesCollection;
        synchronized (xYSeriesCollection) {
            if (this.keyToSeries.containsKey(seriesKey)) {
                return this.keyToSeries.get(seriesKey);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getJFreeChartIndex(SeriesKey seriesKey) {
        XYSeriesCollection xYSeriesCollection = this.seriesCollection;
        synchronized (xYSeriesCollection) {
            XYSeries xYSeries = this.keyToSeries.get(seriesKey);
            for (int i = 0; i < this.seriesCollection.getSeriesCount(); ++i) {
                if (!this.seriesCollection.getSeries(i).equals((Object)xYSeries)) continue;
                return i;
            }
            return -1;
        }
    }

    public String getTitle() {
        return this.graphTitle.getStringValue();
    }

    public void setTitle(String string) {
        try {
            this.graphTitle.setValue(string);
            this.doEnables();
            this.updateGraph();
        }
        catch (SettingException settingException) {
            // empty catch block
        }
    }

    public FontColorPair getTitleFont() {
        return this.titleFont.getFontColorValue();
    }

    public void setTitleFont(FontColorPair fontColorPair) {
        try {
            this.titleFont.setValue(fontColorPair);
            this.doEnables();
            this.updateGraph();
        }
        catch (SettingException settingException) {
            // empty catch block
        }
    }

    public FontColorPair getLegendFont() {
        return this.legendFont.getFontColorValue();
    }

    public void setLegendFont(FontColorPair fontColorPair) {
        try {
            this.legendFont.setValue(fontColorPair);
            this.doEnables();
            this.updateGraph();
        }
        catch (SettingException settingException) {
            // empty catch block
        }
    }

    public boolean isLegendVisible() {
        return this.legendVisible.getBooleanValue();
    }

    public void setLegendVisible(boolean bl) {
        try {
            this.legendVisible.setValue(bl);
            this.doEnables();
            this.updateGraph();
        }
        catch (SettingException settingException) {
            // empty catch block
        }
    }

    public int getLegendPosition() {
        return this.legendPosition.getCurrentIndex();
    }

    public void setLegendPosition(int n) throws SettingException {
        this.legendPosition.setSelectedIndex(n);
        this.doEnables();
        this.updateGraph();
    }

    public AxisSettings getXAxisSettings() {
        return this.xAxisSettings;
    }

    public AxisSettings getYAxisSettings() {
        return this.yAxisSettings;
    }

    public DisplaySettings getDisplaySettings() {
        return this.displaySettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUniqueSeriesName(String string) {
        XYSeriesCollection xYSeriesCollection = this.seriesCollection;
        synchronized (xYSeriesCollection) {
            int n = 0;
            String string2 = string;
            while (true) {
                boolean bl = false;
                for (Map.Entry<SeriesKey, XYSeries> entry : this.keyToSeries.entrySet()) {
                    if (!string2.equals(entry.getValue().getKey())) continue;
                    bl = true;
                    break;
                }
                if (!bl) break;
                string2 = string + " (" + ++n + ")";
            }
            return string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveUp(Vector<SeriesKey> vector) {
        XYSeriesCollection xYSeriesCollection = this.seriesCollection;
        synchronized (xYSeriesCollection) {
            XYSeries[] xYSeriesArray = new XYSeries[this.seriesCollection.getSeriesCount()];
            Vector<XYSeries> vector2 = new Vector<XYSeries>();
            for (int i = 0; i < xYSeriesArray.length; ++i) {
                xYSeriesArray[i] = this.seriesCollection.getSeries(i);
            }
            for (SeriesKey seriesKey : vector) {
                if (!this.keyToSeries.containsKey(seriesKey)) continue;
                vector2.add(this.keyToSeries.get(seriesKey));
            }
            for (int i = 1; i < xYSeriesArray.length; ++i) {
                SeriesKey seriesKey;
                if (!vector2.contains(xYSeriesArray[i])) continue;
                seriesKey = xYSeriesArray[i];
                xYSeriesArray[i] = xYSeriesArray[i - 1];
                xYSeriesArray[i - 1] = seriesKey;
            }
            XYSeriesCollection xYSeriesCollection2 = new XYSeriesCollection();
            for (int i = 0; i < xYSeriesArray.length; ++i) {
                xYSeriesCollection2.addSeries(xYSeriesArray[i]);
            }
            this.plot.setDataset((XYDataset)xYSeriesCollection2);
            this.seriesCollection = xYSeriesCollection2;
            this.seriesList.updateSeriesList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveDown(Vector<SeriesKey> vector) {
        XYSeriesCollection xYSeriesCollection = this.seriesCollection;
        synchronized (xYSeriesCollection) {
            XYSeries[] xYSeriesArray = new XYSeries[this.seriesCollection.getSeriesCount()];
            Vector<XYSeries> vector2 = new Vector<XYSeries>();
            for (int i = 0; i < xYSeriesArray.length; ++i) {
                xYSeriesArray[i] = this.seriesCollection.getSeries(i);
            }
            for (SeriesKey seriesKey : vector) {
                if (!this.keyToSeries.containsKey(seriesKey)) continue;
                vector2.add(this.keyToSeries.get(seriesKey));
            }
            for (int i = xYSeriesArray.length - 2; i >= 0; --i) {
                SeriesKey seriesKey;
                if (!vector2.contains(xYSeriesArray[i])) continue;
                seriesKey = xYSeriesArray[i];
                xYSeriesArray[i] = xYSeriesArray[i + 1];
                xYSeriesArray[i + 1] = seriesKey;
            }
            XYSeriesCollection xYSeriesCollection2 = new XYSeriesCollection();
            for (int i = 0; i < xYSeriesArray.length; ++i) {
                xYSeriesCollection2.addSeries(xYSeriesArray[i]);
            }
            this.plot.setDataset((XYDataset)xYSeriesCollection2);
            this.seriesCollection = xYSeriesCollection2;
            this.seriesList.updateSeriesList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SeriesKey addSeries(String string) {
        SeriesKey seriesKey;
        XYSeriesCollection xYSeriesCollection = this.seriesCollection;
        synchronized (xYSeriesCollection) {
            string = this.getUniqueSeriesName(string);
            PrismXYSeries prismXYSeries = new PrismXYSeries((Comparable)((Object)string));
            this.seriesCollection.addSeries((XYSeries)prismXYSeries);
            seriesKey = new SeriesKey();
            this.keyToSeries.put(seriesKey, prismXYSeries);
            this.graphCache.put(seriesKey, new LinkedList());
            SeriesSettings seriesSettings = new SeriesSettings(this, seriesKey);
            this.keyToGraphSeries.put(seriesKey, seriesSettings);
            seriesSettings.addObserver(this);
            this.seriesList.updateSeriesList();
        }
        return seriesKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeSeriesName(SeriesKey seriesKey, String string) {
        XYSeriesCollection xYSeriesCollection = this.seriesCollection;
        synchronized (xYSeriesCollection) {
            string = this.getUniqueSeriesName(string);
            if (this.keyToSeries.containsKey(seriesKey)) {
                XYSeries xYSeries = this.keyToSeries.get(seriesKey);
                xYSeries.setKey((Comparable)((Object)string));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSeries(SeriesKey seriesKey) {
        XYSeriesCollection xYSeriesCollection = this.seriesCollection;
        synchronized (xYSeriesCollection) {
            if (this.keyToSeries.containsKey(seriesKey)) {
                XYSeries xYSeries = this.keyToSeries.get(seriesKey);
                this.seriesCollection.removeSeries(xYSeries);
                this.keyToSeries.remove(seriesKey);
            }
            if (this.graphCache.containsKey(seriesKey)) {
                this.graphCache.remove(seriesKey);
            }
            if (this.keyToGraphSeries.containsKey(seriesKey)) {
                this.keyToGraphSeries.get(seriesKey).deleteObservers();
                this.keyToGraphSeries.remove(seriesKey);
            }
            this.seriesList.updateSeriesList();
        }
        this.seriesList.updateSeriesList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPointToSeries(SeriesKey seriesKey, XYDataItem xYDataItem) {
        XYSeriesCollection xYSeriesCollection = this.seriesCollection;
        synchronized (xYSeriesCollection) {
            if (this.graphCache.containsKey(seriesKey)) {
                LinkedList<XYDataItem> linkedList = this.graphCache.get(seriesKey);
                linkedList.add(xYDataItem);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllPoints(SeriesKey seriesKey) {
        XYSeriesCollection xYSeriesCollection = this.seriesCollection;
        synchronized (xYSeriesCollection) {
            XYSeries xYSeries;
            if (this.graphCache.containsKey(seriesKey)) {
                xYSeries = this.graphCache.get(seriesKey);
                xYSeries.clear();
            }
            if (this.keyToSeries.containsKey(seriesKey)) {
                xYSeries = this.keyToSeries.get(seriesKey);
                xYSeries.clear();
            }
        }
    }

    @Override
    public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
        InputStream inputStream;
        InputSource inputSource = null;
        if (string2.endsWith("dtd") && (inputStream = Graph.class.getClassLoader().getResourceAsStream("dtds/chartformat.dtd")) != null) {
            inputSource = new InputSource(inputStream);
        }
        return inputSource;
    }

    public static void parseAxis(ValueAxis valueAxis, String string, String string2, String string3, String string4) {
        double d;
        double d2;
        double d3;
        double d4;
        if (valueAxis == null) {
            return;
        }
        try {
            d4 = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            d4 = 0.0;
        }
        try {
            d3 = Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            d3 = d4 < 1.0 ? 1.0 : d4 + 1.0;
        }
        try {
            d2 = Double.parseDouble(string3);
        }
        catch (NumberFormatException numberFormatException) {
            d2 = d3 / 5.0;
        }
        try {
            d = Double.parseDouble(string4);
        }
        catch (NumberFormatException numberFormatException) {
            d = d2 / 10.0;
        }
        valueAxis.setLowerBound(d4);
        valueAxis.setUpperBound(d3);
        valueAxis.setTickMarkInsideLength((float)d);
        valueAxis.setTickMarkInsideLength((float)d2);
    }

    public static boolean parseBoolean(String string) {
        return "true".equals(string);
    }

    public static int parseInt(String string) {
        try {
            int n = Integer.parseInt(string);
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static double parseDouble(String string) {
        try {
            double d = Double.parseDouble(string);
            return d;
        }
        catch (NumberFormatException numberFormatException) {
            return Double.NaN;
        }
    }

    public static Font parseFont(String string, String string2, String string3) {
        int n;
        int n2;
        try {
            n2 = Integer.parseInt(string3);
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            n2 = 14;
            n = 0;
        }
        if (n2 <= 0) {
            n2 = 12;
        }
        if (string.equals("")) {
            string = "SansSerif";
        }
        return new Font(string, n, n2);
    }

    public static Color parseColor(String string, String string2, String string3) {
        int n;
        int n2;
        int n3;
        try {
            n3 = Integer.parseInt(string);
            n2 = Integer.parseInt(string2);
            n = Integer.parseInt(string3);
            if (n3 > 255) {
                n3 = 255;
            }
            if (n3 < 0) {
                n3 = 0;
            }
            if (n2 > 255) {
                n2 = 255;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (n > 255) {
                n = 255;
            }
            if (n < 0) {
                n = 0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            n3 = 0;
            n2 = 0;
            n = 0;
        }
        return new Color(n3, n2, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Graph load(File file) throws GraphException {
        Graph graph = new Graph();
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(true);
            documentBuilderFactory.setIgnoringElementContentWhitespace(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(graph);
            Document document = documentBuilder.parse(file);
            Element element = document.getDocumentElement();
            graph.setTitle(element.getAttribute("graphTitle"));
            String string = element.getAttribute("titleFontName");
            String string2 = element.getAttribute("titleFontSize");
            String string3 = element.getAttribute("titleFontStyle");
            Font font = Graph.parseFont(string, string3, string2);
            String string4 = element.getAttribute("titleFontColourR");
            String string5 = element.getAttribute("titleFontColourG");
            String string6 = element.getAttribute("titleFontColourB");
            Color color = Graph.parseColor(string4, string5, string6);
            graph.setTitleFont(new FontColorPair(font, color));
            graph.setLegendVisible(Graph.parseBoolean(element.getAttribute("legendVisible")));
            String string7 = element.getAttribute("legendPosition");
            if (element.getAttribute("versionString").equals("")) {
                graph.setLegendPosition(1);
            } else if (string7.equals("left")) {
                graph.setLegendPosition(0);
            } else if (string7.equals("right")) {
                graph.setLegendPosition(1);
            } else if (string7.equals("bottom")) {
                graph.setLegendPosition(2);
            } else if (string7.equals("top")) {
                graph.setLegendPosition(3);
            } else {
                graph.setLegendPosition(1);
            }
            NodeList nodeList = element.getChildNodes();
            Element element2 = (Element)nodeList.item(0);
            Element element3 = (Element)nodeList.item(1);
            Element element4 = (Element)nodeList.item(2);
            graph.getXAxisSettings().load(element3);
            graph.getYAxisSettings().load(element4);
            for (int i = 3; i < nodeList.getLength(); ++i) {
                Element element5 = (Element)nodeList.item(i);
                SeriesKey seriesKey = graph.addSeries(element5.getAttribute("seriesHeading"));
                Object object = graph.getSeriesLock();
                synchronized (object) {
                    SeriesSettings seriesSettings = graph.getGraphSeries(seriesKey);
                    seriesSettings.load(element5);
                    NodeList nodeList2 = element5.getChildNodes();
                    for (int j = 0; j < nodeList2.getLength(); ++j) {
                        Element element6 = (Element)nodeList2.item(j);
                        graph.addPointToSeries(seriesKey, new XYDataItem(Graph.parseDouble(element6.getAttribute("x")), Graph.parseDouble(element6.getAttribute("y"))));
                    }
                    continue;
                }
            }
            return graph;
        }
        catch (Exception exception) {
            throw new GraphException("Error in loading chart: " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file) throws PrismException {
        try {
            JFreeChart jFreeChart = this.getChart();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement("chartFormat");
            element.setAttribute("versionString", Prism.getVersion());
            element.setAttribute("graphTitle", this.getTitle());
            Font font = this.getTitleFont().f;
            element.setAttribute("titleFontName", font.getName());
            element.setAttribute("titleFontSize", "" + font.getSize());
            element.setAttribute("titleFontStyle", "" + font.getStyle());
            Color color = this.getTitleFont().c;
            element.setAttribute("titleFontColourR", "" + color.getRed());
            element.setAttribute("titleFontColourG", "" + color.getGreen());
            element.setAttribute("titleFontColourB", "" + color.getBlue());
            element.setAttribute("legendVisible", this.isLegendVisible() ? "true" : "false");
            Font font2 = this.getLegendFont().f;
            element.setAttribute("legendFontName", "" + font2.getName());
            element.setAttribute("legendFontSize", "" + font2.getSize());
            element.setAttribute("legendFontStyle", "" + font2.getStyle());
            Color color2 = this.getLegendFont().c;
            element.setAttribute("legendFontColourR", "" + color2.getRed());
            element.setAttribute("legendFontColourG", "" + color2.getGreen());
            element.setAttribute("legendFontColourB", "" + color2.getBlue());
            switch (this.getLegendPosition()) {
                case 0: {
                    element.setAttribute("legendPosition", "left");
                    break;
                }
                case 2: {
                    element.setAttribute("legendPosition", "bottom");
                    break;
                }
                case 3: {
                    element.setAttribute("legendPosition", "top");
                    break;
                }
                default: {
                    element.setAttribute("legendPosition", "right");
                }
            }
            Element element2 = document.createElement("layout");
            element.appendChild(element2);
            Element element3 = document.createElement("axis");
            this.getXAxisSettings().save(element3);
            element.appendChild(element3);
            Element element4 = document.createElement("axis");
            this.getYAxisSettings().save(element4);
            element.appendChild(element4);
            Object object = this.getSeriesLock();
            synchronized (object) {
                for (int i = 0; i < this.seriesList.getSize(); ++i) {
                    SeriesKey seriesKey = this.seriesList.getKeyAt(i);
                    Element element5 = document.createElement("graph");
                    SeriesSettings seriesSettings = this.getGraphSeries(seriesKey);
                    seriesSettings.save(element5);
                    XYSeries xYSeries = this.getXYSeries(seriesKey);
                    for (int j = 0; j < xYSeries.getItemCount(); ++j) {
                        Element element6 = document.createElement("point");
                        element6.setAttribute("x", "" + xYSeries.getX(j));
                        element6.setAttribute("y", "" + xYSeries.getY(j));
                        element5.appendChild(element6);
                    }
                    element.appendChild(element5);
                }
            }
            document.appendChild(element);
            object = TransformerFactory.newInstance().newTransformer();
            ((Transformer)object).setOutputProperty("doctype-system", "chartformat.dtd");
            ((Transformer)object).setOutputProperty("indent", "yes");
            ((Transformer)object).transform(new DOMSource(document), new StreamResult(new FileOutputStream(file)));
        }
        catch (IOException iOException) {
            throw new PrismException(iOException.getMessage());
        }
        catch (DOMException dOMException) {
            throw new PrismException("Problem saving graph: DOM Exception: " + dOMException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new PrismException("Problem saving graph: Parser Exception: " + parserConfigurationException);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new PrismException("Problem saving graph: Error in creating XML: " + transformerConfigurationException);
        }
        catch (TransformerException transformerException) {
            throw new PrismException("Problem saving graph: Transformer Exception: " + transformerException);
        }
        catch (SettingException settingException) {
            throw new PrismException(settingException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportToMatlab(File file) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileWriter(file));
        printWriter.println("%=========================================");
        printWriter.println("%Generated by PRISM Chart Package");
        printWriter.println("%=========================================");
        printWriter.println();
        Object object = this.getSeriesLock();
        synchronized (object) {
            Object object2;
            Object object3;
            int n;
            Object object4;
            CharSequence charSequence;
            int n2;
            for (n2 = 0; n2 < this.seriesList.getSize(); ++n2) {
                StringBuffer stringBuffer = new StringBuffer("x" + n2 + " = [");
                charSequence = new StringBuffer("y" + n2 + " = [");
                object4 = this.seriesList.getKeyAt(n2);
                XYSeries xYSeries = this.getXYSeries((SeriesKey)object4);
                for (n = 0; n < xYSeries.getItemCount(); ++n) {
                    stringBuffer.append(xYSeries.getX(n) + " ");
                    charSequence.append(xYSeries.getY(n) + " ");
                }
                stringBuffer.append("];");
                charSequence.append("];");
                printWriter.println(stringBuffer.toString());
                printWriter.println(charSequence.toString());
            }
            printWriter.println();
            printWriter.println("figure1 = figure('Color', [1 1 1], 'PaperPosition',[0.6345 6.345 20.3 15.23],'PaperSize',[20.98 29.68]);");
            n2 = this.getXAxisSettings().isLogarithmic() ? 1 : 0;
            boolean bl = this.getYAxisSettings().isLogarithmic();
            printWriter.println();
            if (n2 != 0 && bl) {
                printWriter.println("axes1 = axes('Parent', figure1, 'FontSize', 16, 'XScale', 'log', 'YScale', 'log');");
            } else if (n2 != 0) {
                printWriter.println("axes1 = axes('Parent', figure1, 'FontSize', 16, 'XScale', 'log');");
            } else if (bl) {
                printWriter.println("axes1 = axes('Parent', figure1, 'FontSize', 16, 'YScale', 'log');");
            } else {
                printWriter.println("axes1 = axes('Parent', figure1, 'FontSize', 16);");
            }
            printWriter.println("xlabel(axes1, '" + this.getXAxisSettings().getHeading() + "');");
            printWriter.println("ylabel(axes1, '" + this.getYAxisSettings().getHeading() + "');");
            printWriter.println("box(axes1, 'on');");
            printWriter.println("hold(axes1, 'all');");
            printWriter.println();
            charSequence = "";
            object4 = new StringTokenizer(this.getTitle(), "\n");
            int n3 = ((StringTokenizer)object4).countTokens();
            for (n = 0; n < n3; ++n) {
                charSequence = (String)charSequence + "'" + ((StringTokenizer)object4).nextToken() + "'";
                if (n >= n3 - 1) continue;
                charSequence = (String)charSequence + ", char(10),";
            }
            printWriter.println("title(axes1,[" + (String)charSequence + "])");
            String string = "plot";
            if (this.seriesList.getSize() > 0) {
                if (n2 != 0 && bl) {
                    string = "loglog";
                } else if (n2 != 0) {
                    string = "semilogx";
                } else if (bl) {
                    string = "semilogy";
                }
            }
            for (int i = 0; i < this.seriesList.getSize(); ++i) {
                SeriesKey seriesKey = this.seriesList.getKeyAt(i);
                object3 = this.getGraphSeries(seriesKey);
                object2 = "'";
                if (((SeriesSettings)object3).showPoints() && ((SeriesSettings)object3).getSeriesShape() != 5) {
                    switch (((SeriesSettings)object3).getSeriesShape()) {
                        case 0: {
                            object2 = (String)object2 + "o";
                            break;
                        }
                        case 1: {
                            object2 = (String)object2 + "s";
                            break;
                        }
                        case 2: {
                            object2 = (String)object2 + "^";
                            break;
                        }
                        case 3: {
                            object2 = (String)object2 + "d";
                            break;
                        }
                        case 4: {
                            object2 = (String)object2 + "x";
                        }
                    }
                }
                if (((SeriesSettings)object3).showLines()) {
                    switch (((SeriesSettings)object3).getLineStyle()) {
                        case 0: {
                            object2 = (String)object2 + "-";
                            break;
                        }
                        case 1: {
                            object2 = (String)object2 + "--";
                            break;
                        }
                        case 2: {
                            object2 = (String)object2 + "-.";
                        }
                    }
                }
                object2 = (String)object2 + "'";
                printWriter.println("plot" + i + " = " + string + "(x" + i + ", y" + i + ", " + (String)object2 + ", 'Parent', axes1, 'LineWidth', 2);");
            }
            String string2 = "";
            for (int i = 0; i < this.seriesList.getSize(); ++i) {
                object3 = this.seriesList.getKeyAt(i);
                object2 = this.getGraphSeries((SeriesKey)object3);
                string2 = string2 + "'" + ((SeriesSettings)object2).getSeriesHeading() + "'";
                if (i >= this.seriesList.getSize() - 1) continue;
                string2 = string2 + ", ";
            }
            String string3 = "";
            switch (this.legendPosition.getCurrentIndex()) {
                case 0: {
                    string3 = "'WestOutside'";
                    break;
                }
                case 1: {
                    string3 = "'EastOutside'";
                    break;
                }
                case 2: {
                    string3 = "'SouthOutside'";
                    break;
                }
                case 3: {
                    string3 = "'NorthOutside'";
                }
            }
            if (this.isLegendVisible()) {
                printWriter.println("legend1 = legend(axes1,{" + string2 + "},'Location', " + string3 + ");");
            }
            printWriter.flush();
            printWriter.close();
        }
    }

    public void exportToJPEG(File file, int n, int n2) throws GraphException, IOException {
        ChartUtilities.saveChartAsJPEG((File)file, (float)1.0f, (JFreeChart)this.chart, (int)n, (int)n2);
    }

    public void exportToEPS(File file, int n, int n2) throws GraphException, IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        EpsGraphics epsGraphics = new EpsGraphics(this.getTitle(), (OutputStream)fileOutputStream, 0, 0, n, n2, ColorMode.COLOR_RGB);
        this.chart.draw((Graphics2D)epsGraphics, (Rectangle2D)new Rectangle(n, n2));
        epsGraphics.close();
        epsGraphics.dispose();
    }

    public void exportToPNG(File file, int n, int n2, boolean bl) throws GraphException, IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        KeypointPNGEncoderAdapter keypointPNGEncoderAdapter = new KeypointPNGEncoderAdapter();
        keypointPNGEncoderAdapter.setEncodingAlpha(bl);
        Paint paint = this.chart.getBackgroundPaint();
        if (bl) {
            this.chart.setBackgroundPaint(null);
        }
        BufferedImage bufferedImage = this.chart.createBufferedImage(n, n2, bl ? 2 : 1, null);
        if (bl) {
            this.chart.setBackgroundPaint(paint);
        }
        keypointPNGEncoderAdapter.encode(bufferedImage, (OutputStream)fileOutputStream);
        fileOutputStream.flush();
        fileOutputStream.close();
    }

    public void exportToCSV(File file) throws GraphException {
    }

    public class SeriesKey {
        public SeriesKey next = null;
    }

    private class GraphUpdateTask
    extends TimerTask {
        private GraphUpdateTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processGraphCache(HashMap<SeriesKey, LinkedList<XYDataItem>> hashMap) {
            XYSeriesCollection xYSeriesCollection = Graph.this.seriesCollection;
            synchronized (xYSeriesCollection) {
                for (Map.Entry<SeriesKey, LinkedList<XYDataItem>> entry : hashMap.entrySet()) {
                    if (!Graph.this.keyToSeries.containsKey(entry.getKey())) continue;
                    XYSeries xYSeries = (XYSeries)Graph.this.keyToSeries.get(entry.getKey());
                    LinkedList<XYDataItem> linkedList = entry.getValue();
                    while (!linkedList.isEmpty()) {
                        XYDataItem xYDataItem = linkedList.removeFirst();
                        xYSeries.addOrUpdate(xYDataItem.getX(), xYDataItem.getY());
                    }
                }
            }
        }

        @Override
        public void run() {
            this.processGraphCache(Graph.this.graphCache);
        }
    }
}

