/*
 * Decompiled with CFR 0.152.
 */
package simulator.sampler;

import parser.ast.ExpressionTemporal;
import prism.PrismException;
import prism.PrismLangException;
import simulator.Path;
import simulator.TransitionList;
import simulator.sampler.SamplerDouble;

public class SamplerRewardCumulDisc
extends SamplerDouble {
    private int timeBound;
    private int rewardStructIndex;

    public SamplerRewardCumulDisc(ExpressionTemporal expressionTemporal, int n) throws PrismException {
        if (expressionTemporal.getOperator() != 11) {
            throw new PrismException("Error creating Sampler");
        }
        this.timeBound = expressionTemporal.getUpperBound().evaluateInt();
        this.rewardStructIndex = n;
        this.reset();
        this.resetStats();
    }

    @Override
    public boolean update(Path path, TransitionList transitionList) throws PrismLangException {
        if (this.valueKnown) {
            return true;
        }
        if (path.size() == (long)this.timeBound) {
            this.valueKnown = true;
            this.value = path.getTotalCumulativeReward(this.rewardStructIndex);
        }
        return this.valueKnown;
    }

    @Override
    public boolean needsBoundedNumSteps() {
        return true;
    }
}

