/*
 * Decompiled with CFR 0.152.
 */
package simulator.networking;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Observable;
import java.util.StringTokenizer;
import prism.PrismException;

public class SimulatorResultsFile
extends Observable {
    private ArrayList results = new ArrayList();

    public void tellObservers() {
        this.setChanged();
        this.notifyObservers(null);
    }

    public synchronized void mergeResultsFile(File file) throws PrismException {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            int n = 0;
            while (bufferedReader.ready()) {
                if (n >= this.results.size()) {
                    this.results.add(new SimulatorResult(bufferedReader.readLine()));
                } else {
                    ((SimulatorResult)this.results.get(n)).merge(bufferedReader.readLine());
                }
                ++n;
            }
        }
        catch (Exception exception) {
            throw new PrismException(exception.getMessage());
        }
    }

    public double getResult(int n) {
        if (n < this.results.size()) {
            SimulatorResult simulatorResult = (SimulatorResult)this.results.get(n);
            return simulatorResult.result / (double)simulatorResult.iterations;
        }
        return -1.0;
    }

    public int getIterations(int n) {
        if (n < this.results.size()) {
            SimulatorResult simulatorResult = (SimulatorResult)this.results.get(n);
            return simulatorResult.iterations;
        }
        return -1;
    }

    public double getSum(int n) {
        if (n < this.results.size()) {
            SimulatorResult simulatorResult = (SimulatorResult)this.results.get(n);
            return simulatorResult.result;
        }
        return -1.0;
    }

    public void reset() {
        this.results = new ArrayList();
        this.tellObservers();
    }

    public String toString() {
        String string = "";
        for (int i = 0; i < this.results.size(); ++i) {
            string = string + this.results.get(i).toString() + "\n";
        }
        return string;
    }

    public int getNumResults() {
        return this.results.size();
    }

    class SimulatorResult {
        int index;
        int iterations;
        double result;

        public SimulatorResult(int n, int n2, double d) {
            this.index = n;
            this.iterations = n2;
            this.result = d;
        }

        public SimulatorResult(String string) throws Exception {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            this.index = Integer.parseInt(string2);
            this.iterations = Integer.parseInt(string3);
            this.result = Double.parseDouble(string4);
        }

        public String toString() {
            return this.index + "\t" + this.iterations + "\t" + this.result;
        }

        public void merge(String string) throws PrismException {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            if (this.index != Integer.parseInt(string2)) {
                throw new PrismException("Invalid results file, bad merge");
            }
            this.iterations += Integer.parseInt(string3);
            this.result += Double.parseDouble(string4);
        }
    }
}

