/*
 * Decompiled with CFR 0.152.
 */
package simulator.networking;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.TreeNode;
import prism.PrismException;
import settings.Setting;
import settings.SettingDisplay;
import settings.SettingOwner;
import settings.SingleLineStringSetting;
import simulator.networking.SSHHost;
import simulator.networking.SimulatorNetworkHandler;

public class FileSystem
implements SettingOwner,
TreeNode {
    private SimulatorNetworkHandler network;
    private SingleLineStringSetting fsName;
    private SingleLineStringSetting inputDir;
    private SingleLineStringSetting outputDir;
    private Vector hosts;
    SettingDisplay display;

    public FileSystem(SimulatorNetworkHandler simulatorNetworkHandler, String string, String string2, String string3) {
        this.network = simulatorNetworkHandler;
        this.fsName = new SingleLineStringSetting("name", string, "A convienience name to identify this network cluster.", (SettingOwner)this, true);
        this.inputDir = new SingleLineStringSetting("simulator input directory", string2, "The location on the network cluster's filesystem to which the binary file containing information about the verification task will be sent.", (SettingOwner)this, true);
        this.outputDir = new SingleLineStringSetting("simulator output directory", string3, "The location on the network cluster's filesystem to which verification results will be written.", (SettingOwner)this, true);
        this.hosts = new Vector();
    }

    public String getName() {
        return this.fsName.getStringValue();
    }

    public String getInputDir() {
        return this.inputDir.getStringValue();
    }

    public String getOutputDir() {
        return this.outputDir.getStringValue();
    }

    public String toString() {
        return this.getSettingOwnerClassName() + " " + this.getSettingOwnerName();
    }

    public int compareTo(Object object) {
        if (object instanceof SettingOwner) {
            SettingOwner settingOwner = (SettingOwner)object;
            if (this.getSettingOwnerID() < settingOwner.getSettingOwnerID()) {
                return -1;
            }
            if (this.getSettingOwnerID() > settingOwner.getSettingOwnerID()) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    @Override
    public SettingDisplay getDisplay() {
        return this.display;
    }

    @Override
    public int getNumSettings() {
        return 3;
    }

    @Override
    public Setting getSetting(int n) {
        switch (n) {
            case 0: {
                return this.fsName;
            }
            case 1: {
                return this.inputDir;
            }
        }
        return this.outputDir;
    }

    @Override
    public String getSettingOwnerClassName() {
        return "Network Cluster";
    }

    @Override
    public int getSettingOwnerID() {
        return 17;
    }

    @Override
    public String getSettingOwnerName() {
        return this.getName();
    }

    @Override
    public void notifySettingChanged(Setting setting) {
        this.notifyChange(this);
    }

    @Override
    public void setDisplay(SettingDisplay settingDisplay) {
        this.display = settingDisplay;
    }

    public void addHost(String string, String string2) {
        SSHHost sSHHost = new SSHHost(string, string2, this);
        this.hosts.add(sSHHost);
    }

    public void deleteHost(SSHHost sSHHost) {
        this.hosts.remove(sSHHost);
        this.network.notifyChanged(this);
    }

    public SSHHost getHost(int n) {
        return (SSHHost)this.hosts.get(n);
    }

    public int getNumHosts() {
        return this.hosts.size();
    }

    public void sendFiles(File file) throws PrismException {
        boolean bl = false;
        for (int i = 0; !bl && i < this.hosts.size(); ++i) {
            try {
                this.getHost(i).sendFilesToFileSystem(file);
                bl = true;
                continue;
            }
            catch (PrismException prismException) {
                prismException.printStackTrace();
            }
        }
        if (!bl) {
            throw new PrismException("Could not connect to any hosts on fileserver " + this.getName());
        }
    }

    public boolean stillRunning() {
        boolean bl = false;
        for (int i = 0; i < this.hosts.size() && !bl; ++i) {
            bl = this.getHost(i).getHostState() == 3 || this.getHost(i).getHostState() == 1;
        }
        return bl;
    }

    public Enumeration children() {
        return this.hosts.elements();
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public TreeNode getChildAt(int n) {
        return (TreeNode)this.hosts.get(n);
    }

    @Override
    public int getChildCount() {
        return this.hosts.size();
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        return this.hosts.indexOf(treeNode);
    }

    @Override
    public TreeNode getParent() {
        return this.network;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public void notifyChange(TreeNode treeNode) {
        this.network.notifyChanged(treeNode);
    }
}

