/*
 * Decompiled with CFR 0.152.
 */
package simulator;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import parser.State;
import parser.Values;
import parser.VarList;
import parser.ast.Expression;
import parser.ast.ExpressionFilter;
import parser.ast.ExpressionProb;
import parser.ast.ExpressionReward;
import parser.ast.ExpressionTemporal;
import parser.ast.LabelList;
import parser.ast.ModulesFile;
import parser.ast.PropertiesFile;
import parser.type.Type;
import prism.ModelType;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismFileLog;
import prism.PrismLangException;
import prism.PrismLog;
import prism.PrismUtils;
import prism.ResultsCollection;
import prism.UndefinedConstants;
import simulator.Choice;
import simulator.Path;
import simulator.PathFull;
import simulator.PathFullInfo;
import simulator.PathFullPrefix;
import simulator.PathOnTheFly;
import simulator.RandomNumberGenerator;
import simulator.TransitionList;
import simulator.Updater;
import simulator.method.SimulationMethod;
import simulator.sampler.Sampler;
import strat.Strategy;
import userinterface.graph.Graph;

public class SimulatorEngine
extends PrismComponent {
    private ModulesFile modulesFile = null;
    private ModelType modelType = null;
    private VarList varList = null;
    private int numVars = 0;
    private Values mfConstants = null;
    private List<State> reachableStates;
    private Strategy strategy;
    protected List<Expression> labels = null;
    private List<Expression> properties = null;
    private List<Sampler> propertySamplers = null;
    protected Path path = null;
    protected boolean onTheFly = true;
    protected State currentState = null;
    protected TransitionList transitionList = null;
    protected boolean transitionListBuilt = false;
    protected State transitionListState = null;
    protected double[] tmpStateRewards = null;
    protected double[] tmpTransitionRewards = null;
    protected Updater updater = null;
    private RandomNumberGenerator rng = new RandomNumberGenerator();

    public SimulatorEngine(PrismComponent prismComponent) {
        super(prismComponent);
    }

    public void checkModelForSimulation(ModulesFile modulesFile) throws PrismException {
        if (modulesFile.getModelType() == ModelType.PTA) {
            throw new PrismException("Sorry - the simulator does not currently support PTAs");
        }
        if (modulesFile.getSystemDefn() != null) {
            throw new PrismException("Sorry - the simulator does not currently handle the system...endsystem construct");
        }
    }

    public void createNewPath(ModulesFile modulesFile) throws PrismException {
        this.loadModulesFile(modulesFile);
        this.path = new PathFull(modulesFile);
        this.onTheFly = false;
    }

    public void createNewOnTheFlyPath(ModulesFile modulesFile) throws PrismException {
        this.loadModulesFile(modulesFile);
        this.path = new PathOnTheFly(modulesFile);
        this.onTheFly = true;
    }

    public void initialisePath(State state) throws PrismException {
        if (state != null) {
            this.currentState.copy(state);
        } else if (this.modulesFile.getInitialStates() == null) {
            this.currentState.copy(this.modulesFile.getDefaultInitialState());
        } else {
            throw new PrismException("Random choice of multiple initial states not yet supported");
        }
        this.updater.calculateStateRewards(this.currentState, this.tmpStateRewards);
        this.path.initialise(this.currentState, this.tmpStateRewards);
        this.transitionListBuilt = false;
        this.transitionListState = null;
        this.resetSamplers();
        this.updateSamplers();
        this.initialiseStrategy();
    }

    public void manualTransition(int n) throws PrismException {
        TransitionList transitionList = this.getTransitionList();
        int n2 = transitionList.getChoiceIndexOfTransition(n);
        int n3 = transitionList.getChoiceOffsetOfTransition(n);
        if (this.modelType.continuousTime()) {
            double d = transitionList.getProbabilitySum();
            this.executeTimedTransition(n2, n3, this.rng.randomExpDouble(d), n);
        } else {
            this.executeTransition(n2, n3, n);
        }
    }

    public void manualTransition(int n, double d) throws PrismException {
        TransitionList transitionList = this.getTransitionList();
        int n2 = transitionList.getChoiceIndexOfTransition(n);
        int n3 = transitionList.getChoiceOffsetOfTransition(n);
        this.executeTimedTransition(n2, n3, d, n);
    }

    public boolean automaticTransition() throws PrismException {
        TransitionList transitionList = this.getTransitionList();
        int n = transitionList.getNumChoices();
        if (n == 0) {
            return false;
        }
        switch (this.modelType) {
            case DTMC: {
                double d = this.rng.randomUnifDouble();
                TransitionList.Ref ref = new TransitionList.Ref(transitionList);
                transitionList.getChoiceIndexByProbabilitySum(d, ref);
                this.executeTransition(ref.i, ref.offset, -1);
                break;
            }
            case MDP: {
                int n2 = this.rng.randomUnifInt(n);
                Choice choice = transitionList.getChoice(n2);
                double d = this.rng.randomUnifDouble();
                int n3 = choice.getIndexByProbabilitySum(d);
                this.executeTransition(n2, n3, -1);
                break;
            }
            case CTMC: {
                double d = transitionList.getProbabilitySum();
                double d2 = this.rng.randomUnifDouble(d);
                TransitionList.Ref ref = new TransitionList.Ref(transitionList);
                transitionList.getChoiceIndexByProbabilitySum(d2, ref);
                this.executeTimedTransition(ref.i, ref.offset, this.rng.randomExpDouble(d), -1);
            }
        }
        return true;
    }

    public int automaticTransitions(int n, boolean bl) throws PrismException {
        int n2;
        for (n2 = 0; !(n2 >= n || bl && this.path.isLooping() || !this.automaticTransition()); ++n2) {
        }
        return n2;
    }

    public int automaticTransitions(double d, boolean bl) throws PrismException {
        if (!this.modelType.continuousTime()) {
            return this.automaticTransitions((int)Math.ceil(d), false);
        }
        int n = 0;
        double d2 = this.path.getTotalTime() + d;
        while (this.path.getTotalTime() < d2 && this.automaticTransition()) {
            ++n;
        }
        return n;
    }

    public void backtrackTo(int n) throws PrismException {
        if (n < 0) {
            throw new PrismException("Cannot backtrack to a negative step index");
        }
        if ((long)n > this.path.size()) {
            throw new PrismException("There is no step " + n + " to backtrack to");
        }
        ((PathFull)this.path).backtrack(n);
        this.currentState.copy(this.path.getCurrentState());
        this.transitionListBuilt = false;
        this.transitionListState = null;
        this.recomputeSamplers();
    }

    public void backtrackTo(double d) throws PrismException {
        int n;
        if (d < 0.0) {
            throw new PrismException("Cannot backtrack to a negative time point");
        }
        if (d > this.path.getTotalTime()) {
            throw new PrismException("There is no time point " + d + " to backtrack to");
        }
        PathFull pathFull = (PathFull)this.path;
        long l = this.path.size();
        if (l > Integer.MAX_VALUE) {
            throw new PrismException("PathFull cannot deal with paths over length 2147483647");
        }
        int n2 = (int)l;
        for (n = 0; n <= n2 && pathFull.getCumulativeTime(n) < d; ++n) {
        }
        this.backtrackTo(n);
    }

    public void removePrecedingStates(int n) throws PrismException {
        if (n < 0) {
            throw new PrismException("Cannot remove states before a negative step index");
        }
        if ((long)n > this.path.size()) {
            throw new PrismException("There is no step " + n + " in the path");
        }
        ((PathFull)this.path).removePrecedingStates(n);
        this.recomputeSamplers();
    }

    public void computeTransitionsForStep(int n) throws PrismException {
        this.updater.calculateTransitions(((PathFull)this.path).getState(n), this.transitionList);
        this.transitionListBuilt = true;
        this.transitionListState = new State(((PathFull)this.path).getState(n));
    }

    public void computeTransitionsForCurrentState() throws PrismException {
        this.updater.calculateTransitions(this.path.getCurrentState(), this.transitionList);
        this.transitionListBuilt = true;
        this.transitionListState = null;
    }

    public void loadReachableStates(List<State> list) {
        this.reachableStates = list;
    }

    public void loadStrategy(Strategy strategy) {
        this.strategy = strategy;
    }

    public void loadPath(ModulesFile modulesFile, PathFullInfo pathFullInfo) throws PrismException {
        this.createNewPath(modulesFile);
        long l = pathFullInfo.size();
        if (l > Integer.MAX_VALUE) {
            throw new PrismException("PathFull cannot deal with paths over length 2147483647");
        }
        int n = (int)l;
        State state = pathFullInfo.getState(0);
        this.initialisePath(state);
        for (int i = 0; i < n; ++i) {
            State state2 = pathFullInfo.getState(i + 1);
            TransitionList transitionList = this.getTransitionList();
            int n2 = transitionList.getNumTransitions();
            boolean bl = false;
            for (int j = 0; j < n2; ++j) {
                if (!transitionList.computeTransitionTarget(j, state).equals(state2)) continue;
                bl = true;
                if (this.modelType.continuousTime() && pathFullInfo.hasTimeInfo()) {
                    this.manualTransition(j, pathFullInfo.getTime(i));
                    break;
                }
                this.manualTransition(j);
                break;
            }
            if (!bl) {
                throw new PrismException("Path loading failed at step " + (i + 1));
            }
            state = state2;
        }
    }

    public int addLabel(Expression expression) throws PrismLangException {
        return this.addLabel(expression, null);
    }

    public int addLabel(Expression expression, PropertiesFile propertiesFile) throws PrismLangException {
        Expression expression2 = expression.deepCopy();
        expression2 = (Expression)expression2.replaceConstants(this.mfConstants);
        if (propertiesFile != null) {
            expression2 = (Expression)expression2.replaceConstants(propertiesFile.getConstantValues());
        }
        expression2 = (Expression)expression2.simplify();
        this.labels.add(expression2);
        return this.labels.size() - 1;
    }

    public int addProperty(Expression expression) throws PrismException {
        return this.addProperty(expression, null);
    }

    public int addProperty(Expression expression, PropertiesFile propertiesFile) throws PrismException {
        Expression expression2 = expression.deepCopy();
        LabelList labelList = propertiesFile == null ? this.modulesFile.getLabelList() : propertiesFile.getCombinedLabelList();
        expression2 = (Expression)expression2.expandPropRefsAndLabels(propertiesFile, labelList);
        expression2 = (Expression)expression2.replaceConstants(this.mfConstants);
        if (propertiesFile != null) {
            expression2 = (Expression)expression2.replaceConstants(propertiesFile.getConstantValues());
        }
        expression2 = (Expression)expression2.simplify();
        Sampler sampler = Sampler.createSampler(expression2, this.modulesFile);
        this.properties.add(expression2);
        this.propertySamplers.add(sampler);
        return this.properties.size() - 1;
    }

    public boolean queryLabel(int n) throws PrismLangException {
        return this.labels.get(n).evaluateBoolean(this.path.getCurrentState());
    }

    public boolean queryLabel(int n, int n2) throws PrismLangException {
        return this.labels.get(n).evaluateBoolean(((PathFull)this.path).getState(n2));
    }

    public boolean queryIsInitial() throws PrismLangException {
        return this.path.getCurrentState().equals(this.modulesFile.getDefaultInitialState());
    }

    public boolean queryIsInitial(int n) throws PrismLangException {
        return ((PathFull)this.path).getState(n).equals(this.modulesFile.getDefaultInitialState());
    }

    public boolean queryIsDeadlock() throws PrismException {
        return this.getTransitionList().isDeadlock();
    }

    public boolean queryIsDeadlock(int n) throws PrismException {
        return (long)n == this.path.size() ? this.getTransitionList().isDeadlock() : false;
    }

    public Object queryProperty(int n) {
        if (n < 0 || n >= this.propertySamplers.size()) {
            this.mainLog.printWarning("Can't query property " + n + ".");
            return null;
        }
        Sampler sampler = this.propertySamplers.get(n);
        return sampler.isCurrentValueKnown() ? sampler.getCurrentValue() : null;
    }

    private void loadModulesFile(ModulesFile modulesFile) throws PrismException {
        this.modulesFile = modulesFile;
        this.modelType = modulesFile.getModelType();
        this.mfConstants = modulesFile.getConstantValues();
        this.checkModelForSimulation(modulesFile);
        this.varList = modulesFile.createVarList();
        this.numVars = this.varList.getNumVars();
        modulesFile = (ModulesFile)modulesFile.deepCopy().replaceConstants(this.mfConstants).simplify();
        this.currentState = new State(this.numVars);
        this.tmpStateRewards = new double[modulesFile.getNumRewardStructs()];
        this.tmpTransitionRewards = new double[modulesFile.getNumRewardStructs()];
        this.transitionList = new TransitionList();
        this.updater = new Updater(modulesFile, this.varList, this);
        this.strategy = null;
        this.labels = new ArrayList<Expression>();
        this.properties = new ArrayList<Expression>();
        this.propertySamplers = new ArrayList<Sampler>();
    }

    private void executeTransition(int n, int n2, int n3) throws PrismException {
        TransitionList transitionList = this.getTransitionList();
        Choice choice = transitionList.getChoice(n);
        if (!this.onTheFly && n3 == -1) {
            n3 = transitionList.getTotalIndexOfTransition(n, n2);
        }
        double d = choice.getProbability(n2);
        this.updater.calculateTransitionRewards(this.path.getCurrentState(), choice, this.tmpTransitionRewards);
        choice.computeTarget(n2, this.path.getCurrentState(), this.currentState);
        this.updater.calculateStateRewards(this.currentState, this.tmpStateRewards);
        this.path.addStep(n3, choice.getModuleOrActionIndex(), d, this.tmpTransitionRewards, this.currentState, this.tmpStateRewards, transitionList);
        this.transitionListBuilt = false;
        this.transitionListState = null;
        this.updateSamplers();
        this.updateStrategy();
    }

    private void executeTimedTransition(int n, int n2, double d, int n3) throws PrismException {
        TransitionList transitionList = this.getTransitionList();
        Choice choice = transitionList.getChoice(n);
        if (!this.onTheFly && n3 == -1) {
            n3 = transitionList.getTotalIndexOfTransition(n, n2);
        }
        double d2 = choice.getProbability(n2);
        this.updater.calculateTransitionRewards(this.path.getCurrentState(), choice, this.tmpTransitionRewards);
        choice.computeTarget(n2, this.path.getCurrentState(), this.currentState);
        this.updater.calculateStateRewards(this.currentState, this.tmpStateRewards);
        this.path.addStep(d, n3, choice.getModuleOrActionIndex(), d2, this.tmpTransitionRewards, this.currentState, this.tmpStateRewards, transitionList);
        this.transitionListBuilt = false;
        this.transitionListState = null;
        this.updateSamplers();
        this.updateStrategy();
    }

    private void resetSamplers() throws PrismLangException {
        for (Sampler sampler : this.propertySamplers) {
            sampler.reset();
        }
    }

    private void updateSamplers() throws PrismException {
        for (Sampler sampler : this.propertySamplers) {
            sampler.update(this.path, this.getTransitionList());
        }
    }

    private void recomputeSamplers() throws PrismLangException {
        this.resetSamplers();
        long l = this.path.size();
        if (l > Integer.MAX_VALUE) {
            throw new PrismLangException("PathFull cannot deal with paths over length 2147483647");
        }
        int n = (int)l;
        PathFullPrefix pathFullPrefix = new PathFullPrefix((PathFull)this.path, 0);
        for (int i = 0; i <= n; ++i) {
            pathFullPrefix.setPrefixLength(i);
            for (Sampler sampler : this.propertySamplers) {
                sampler.update(pathFullPrefix, null);
            }
        }
    }

    private void initialiseStrategy() {
        if (this.strategy != null) {
            State state = this.getCurrentState();
            int n = this.reachableStates.indexOf(state);
            this.strategy.initialise(n);
        }
    }

    private void updateStrategy() {
        if (this.strategy != null) {
            State state = this.getCurrentState();
            int n = this.reachableStates.indexOf(state);
            String string = this.path.getPreviousModuleOrAction();
            this.strategy.update(string, n);
        }
    }

    public int getNumVariables() {
        return this.numVars;
    }

    public String getVariableName(int n) {
        return n < this.numVars && n >= 0 ? this.varList.getName(n) : null;
    }

    public Type getVariableType(int n) {
        return n < this.numVars && n >= 0 ? this.varList.getType(n) : null;
    }

    public int getIndexOfVar(String string) throws PrismException {
        return this.varList.getIndex(string);
    }

    public TransitionList getTransitionList() throws PrismException {
        if (!this.transitionListBuilt) {
            this.updater.calculateTransitions(this.currentState, this.transitionList);
            this.transitionListBuilt = true;
        }
        return this.transitionList;
    }

    public int getNumChoices() throws PrismException {
        return this.getTransitionList().getNumChoices();
    }

    public int getNumTransitions() throws PrismException {
        return this.getTransitionList().getNumTransitions();
    }

    public int getNumTransitions(int n) throws PrismException {
        return this.getTransitionList().getChoice(n).size();
    }

    public int getChoiceIndexOfTransition(int n) throws PrismException {
        return this.getTransitionList().getChoiceIndexOfTransition(n);
    }

    public String getTransitionModuleOrAction(int n, int n2) throws PrismException {
        TransitionList transitionList = this.getTransitionList();
        return transitionList.getTransitionModuleOrAction(transitionList.getTotalIndexOfTransition(n, n2));
    }

    public String getTransitionModuleOrAction(int n) throws PrismException {
        return this.getTransitionList().getTransitionModuleOrAction(n);
    }

    public int getTransitionModuleOrActionIndex(int n, int n2) throws PrismException {
        TransitionList transitionList = this.getTransitionList();
        return transitionList.getTransitionModuleOrActionIndex(transitionList.getTotalIndexOfTransition(n, n2));
    }

    public int getTransitionModuleOrActionIndex(int n) throws PrismException {
        return this.getTransitionList().getTransitionModuleOrActionIndex(n);
    }

    public String getTransitionAction(int n, int n2) throws PrismException {
        TransitionList transitionList = this.getTransitionList();
        int n3 = transitionList.getTransitionModuleOrActionIndex(transitionList.getTotalIndexOfTransition(n, n2));
        return n3 < 0 ? null : this.modulesFile.getSynch(n3 - 1);
    }

    public String getTransitionAction(int n) throws PrismException {
        int n2 = this.getTransitionList().getTransitionModuleOrActionIndex(n);
        return n2 < 0 ? null : this.modulesFile.getSynch(n2 - 1);
    }

    public double getTransitionProbability(int n, int n2) throws PrismException {
        TransitionList transitionList = this.getTransitionList();
        return transitionList.getChoice(n).getProbability(n2);
    }

    public double getTransitionProbability(int n) throws PrismException {
        TransitionList transitionList = this.getTransitionList();
        return transitionList.getTransitionProbability(n);
    }

    public String getTransitionUpdateString(int n) throws PrismException {
        State state = this.transitionListState == null ? this.path.getCurrentState() : this.transitionListState;
        return this.getTransitionList().getTransitionUpdateString(n, state);
    }

    public String getTransitionUpdateStringFull(int n) throws PrismException {
        return this.getTransitionList().getTransitionUpdateStringFull(n);
    }

    public State computeTransitionTarget(int n, int n2) throws PrismException {
        State state = this.transitionListState == null ? this.path.getCurrentState() : this.transitionListState;
        return this.getTransitionList().getChoice(n).computeTarget(n2, state);
    }

    public State computeTransitionTarget(int n) throws PrismException {
        State state = this.transitionListState == null ? this.path.getCurrentState() : this.transitionListState;
        return this.getTransitionList().computeTransitionTarget(n, state);
    }

    public Path getPath() {
        return this.path;
    }

    public long getPathSize() {
        return this.path.size();
    }

    public State getCurrentState() {
        return this.path.getCurrentState();
    }

    public State getPreviousState() {
        return this.path.getPreviousState();
    }

    public double getTotalTimeForPath() {
        return this.path.getTotalTime();
    }

    public double getTotalCumulativeRewardForPath(int n) {
        return this.path.getTotalCumulativeReward(n);
    }

    public PathFull getPathFull() {
        return (PathFull)this.path;
    }

    public Object getVariableValueOfPathStep(int n, int n2) {
        return ((PathFull)this.path).getState((int)n).varValues[n2];
    }

    public State getStateOfPathStep(int n) {
        return ((PathFull)this.path).getState(n);
    }

    public double getStateRewardOfPathStep(int n, int n2) {
        return ((PathFull)this.path).getStateReward(n, n2);
    }

    public double getCumulativeTimeUpToPathStep(int n) {
        return ((PathFull)this.path).getCumulativeTime(n);
    }

    public double getCumulativeRewardUpToPathStep(int n, int n2) {
        return ((PathFull)this.path).getCumulativeReward(n, n2);
    }

    public double getTimeSpentInPathStep(int n) {
        return ((PathFull)this.path).getTime(n);
    }

    public int getChoiceOfPathStep(int n) {
        return ((PathFull)this.path).getChoice(n);
    }

    public int getModuleOrActionIndexOfPathStep(int n) {
        return ((PathFull)this.path).getModuleOrActionIndex(n);
    }

    public String getModuleOrActionOfPathStep(int n) {
        return ((PathFull)this.path).getModuleOrAction(n);
    }

    public double getTransitionRewardOfPathStep(int n, int n2) {
        return ((PathFull)this.path).getTransitionReward(n, n2);
    }

    public boolean isPathLooping() {
        return this.path.isLooping();
    }

    public long loopStart() {
        return this.path.loopStart();
    }

    public long loopEnd() {
        return this.path.loopEnd();
    }

    public void exportPath(File file) throws PrismException {
        this.exportPath(file, false, " ", null);
    }

    public void exportPath(File file, boolean bl, String string, ArrayList<Integer> arrayList) throws PrismException {
        PrismLog prismLog;
        if (this.path == null) {
            throw new PrismException("There is no path to export");
        }
        if (file != null) {
            prismLog = new PrismFileLog(file.getPath());
            if (!prismLog.ready()) {
                throw new PrismException("Could not open file \"" + file + "\" for output");
            }
            this.mainLog.println("\nExporting path to file \"" + file + "\"...");
        } else {
            prismLog = this.mainLog;
            prismLog.println();
        }
        ((PathFull)this.path).exportToLog(prismLog, bl, string, arrayList);
        if (file != null) {
            prismLog.close();
        }
    }

    public void plotPath(Graph graph) throws PrismException {
        ((PathFull)this.path).plotOnGraph(graph);
    }

    public boolean isPropertyOKForSimulation(Expression expression) {
        return this.isPropertyOKForSimulationString(expression) == null;
    }

    public void checkPropertyForSimulation(Expression expression) throws PrismException {
        String string = this.isPropertyOKForSimulationString(expression);
        if (string != null) {
            throw new PrismException(string);
        }
    }

    private String isPropertyOKForSimulationString(Expression expression) {
        Expression expression2;
        if (!(expression instanceof ExpressionProb) && !(expression instanceof ExpressionReward)) {
            if (expression instanceof ExpressionFilter && (((ExpressionFilter)expression).getOperand() instanceof ExpressionProb || ((ExpressionFilter)expression).getOperand() instanceof ExpressionReward)) {
                return "Simulator cannot handle P or R properties with filters";
            }
            return "Simulator can only handle P or R properties";
        }
        try {
            if (expression.computeProbNesting() > 1) {
                return "Simulator cannot handle nested P, R or S operators";
            }
        }
        catch (PrismException prismException) {
            return "Simulator cannot handle this property: " + prismException.getMessage();
        }
        if (expression instanceof ExpressionReward && (expression2 = ((ExpressionReward)expression).getExpression()) instanceof ExpressionTemporal && ((ExpressionTemporal)expression2).getOperator() == 11 && ((ExpressionTemporal)expression2).getUpperBound() == null) {
            return "Simulator cannot handle cumulative reward properties without time bounds";
        }
        return null;
    }

    public Object modelCheckSingleProperty(ModulesFile modulesFile, PropertiesFile propertiesFile, Expression expression, State state, long l, SimulationMethod simulationMethod) throws PrismException {
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        arrayList.add(expression);
        Object[] objectArray = this.modelCheckMultipleProperties(modulesFile, propertiesFile, arrayList, state, l, simulationMethod);
        if (objectArray[0] instanceof PrismException) {
            throw (PrismException)objectArray[0];
        }
        return objectArray[0];
    }

    public Object[] modelCheckMultipleProperties(ModulesFile modulesFile, PropertiesFile propertiesFile, List<Expression> list, State state, long l, SimulationMethod simulationMethod) throws PrismException {
        Object object;
        int n;
        this.createNewOnTheFlyPath(modulesFile);
        simulationMethod.computeMissingParameterBeforeSim();
        this.mainLog.println("\nSimulation method: " + simulationMethod.getName() + " (" + simulationMethod.getFullName() + ")");
        this.mainLog.println("Simulation method parameters: " + simulationMethod.getParametersString());
        this.mainLog.println("Simulation parameters: max path length=" + l);
        Object[] objectArray = new Object[list.size()];
        int[] nArray = new int[list.size()];
        int n2 = 0;
        for (n = 0; n < list.size(); ++n) {
            try {
                this.checkPropertyForSimulation(list.get(n));
                nArray[n] = this.addProperty(list.get(n), propertiesFile);
                ++n2;
                object = simulationMethod.clone();
                this.propertySamplers.get(nArray[n]).setSimulationMethod((SimulationMethod)object);
                try {
                    ((SimulationMethod)object).setExpression(this.properties.get(nArray[n]));
                    continue;
                }
                catch (PrismException prismException) {
                    this.properties.remove(nArray[n]);
                    this.propertySamplers.remove(nArray[n]);
                    throw prismException;
                }
            }
            catch (PrismException prismException) {
                objectArray[n] = prismException;
                nArray[n] = -1;
            }
        }
        if (n2 > 0) {
            this.doSampling(state, l);
        }
        for (n = 0; n < objectArray.length; ++n) {
            if (nArray[n] == -1) continue;
            object = this.propertySamplers.get(nArray[n]);
            SimulationMethod simulationMethod2 = ((Sampler)object).getSimulationMethod();
            simulationMethod2.computeMissingParameterAfterSim();
            try {
                objectArray[n] = simulationMethod2.getResult((Sampler)object);
                continue;
            }
            catch (PrismException prismException) {
                objectArray[n] = prismException;
            }
        }
        if (objectArray.length == 1) {
            this.mainLog.print("\nSimulation method parameters: ");
            this.mainLog.println(nArray[0] == -1 ? "no simulation" : this.propertySamplers.get(nArray[0]).getSimulationMethod().getParametersString());
            this.mainLog.print("\nSimulation result details: ");
            this.mainLog.println(nArray[0] == -1 ? "no simulation" : this.propertySamplers.get(nArray[0]).getSimulationMethodResultExplanation());
            if (!(objectArray[0] instanceof PrismException)) {
                this.mainLog.println("\nResult: " + objectArray[0]);
            }
        } else {
            this.mainLog.println("\nSimulation method parameters:");
            for (n = 0; n < objectArray.length; ++n) {
                this.mainLog.print(list.get(n) + " : ");
                this.mainLog.println(nArray[n] == -1 ? "no simulation" : this.propertySamplers.get(nArray[n]).getSimulationMethod().getParametersString());
            }
            this.mainLog.println("\nSimulation result details:");
            for (n = 0; n < objectArray.length; ++n) {
                this.mainLog.print(list.get(n) + " : ");
                this.mainLog.println(nArray[n] == -1 ? "no simulation" : this.propertySamplers.get(nArray[n]).getSimulationMethodResultExplanation());
            }
            this.mainLog.println("\nResults:");
            for (n = 0; n < objectArray.length; ++n) {
                this.mainLog.println(list.get(n) + " : " + objectArray[n]);
            }
        }
        return objectArray;
    }

    public void modelCheckExperiment(ModulesFile modulesFile, PropertiesFile propertiesFile, UndefinedConstants undefinedConstants, ResultsCollection resultsCollection, Expression expression, State state, long l, SimulationMethod simulationMethod) throws PrismException, InterruptedException {
        Object object;
        int n;
        this.createNewOnTheFlyPath(modulesFile);
        simulationMethod.computeMissingParameterBeforeSim();
        this.mainLog.println("\nSimulation method: " + simulationMethod.getName() + " (" + simulationMethod.getFullName() + ")");
        this.mainLog.println("Simulation method parameters: " + simulationMethod.getParametersString());
        this.mainLog.println("Simulation parameters: max path length=" + l);
        int n2 = undefinedConstants.getNumPropertyIterations();
        Values values = new Values();
        Object[] objectArray = new Object[n2];
        Values[] valuesArray = new Values[n2];
        int[] nArray = new int[n2];
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            valuesArray[n] = values = undefinedConstants.getPFConstantValues();
            propertiesFile.setSomeUndefinedConstants(values);
            try {
                this.checkPropertyForSimulation(expression);
                nArray[n] = this.addProperty(expression, propertiesFile);
                ++n3;
                object = simulationMethod.clone();
                this.propertySamplers.get(nArray[n]).setSimulationMethod((SimulationMethod)object);
                try {
                    ((SimulationMethod)object).setExpression(this.properties.get(nArray[n]));
                }
                catch (PrismException prismException) {
                    this.properties.remove(nArray[n]);
                    this.propertySamplers.remove(nArray[n]);
                    throw prismException;
                }
            }
            catch (PrismException prismException) {
                objectArray[n] = prismException;
                nArray[n] = -1;
            }
            undefinedConstants.iterateProperty();
        }
        if (n3 > 0) {
            this.doSampling(state, l);
        }
        for (n = 0; n < n2; ++n) {
            if (nArray[n] != -1) {
                object = this.propertySamplers.get(nArray[n]);
                SimulationMethod simulationMethod2 = ((Sampler)object).getSimulationMethod();
                simulationMethod2.computeMissingParameterAfterSim();
                try {
                    objectArray[n] = simulationMethod2.getResult((Sampler)object);
                }
                catch (PrismException prismException) {
                    objectArray[n] = prismException;
                }
            }
            resultsCollection.setResult(undefinedConstants.getMFConstantValues(), valuesArray[n], objectArray[n]);
        }
        this.mainLog.println("\nSimulation method parameters:");
        for (n = 0; n < objectArray.length; ++n) {
            this.mainLog.print(valuesArray[n] + " : ");
            this.mainLog.println(nArray[n] == -1 ? "no simulation" : this.propertySamplers.get(nArray[n]).getSimulationMethod().getParametersString());
        }
        this.mainLog.println("\nSimulation result details:");
        for (n = 0; n < objectArray.length; ++n) {
            this.mainLog.print(valuesArray[n] + " : ");
            this.mainLog.println(nArray[n] == -1 ? "no simulation" : this.propertySamplers.get(nArray[n]).getSimulationMethodResultExplanation());
        }
        this.mainLog.println("\nResults:");
        this.mainLog.print(resultsCollection.toStringPartial(undefinedConstants.getMFConstantValues(), true, " ", " : ", false));
    }

    private void doSampling(State state, long l) throws PrismException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        double d = 0.0;
        long l2 = 0L;
        long l3 = 0L;
        int n = 0;
        int n2 = 0;
        long l4 = System.currentTimeMillis();
        this.mainLog.print("\nSampling progress: [");
        this.mainLog.flush();
        int n3 = 0;
        while (!bl6) {
            long l5;
            bl3 = true;
            for (Sampler sampler : this.propertySamplers) {
                if (sampler.getSimulationMethod().shouldStopNow(n3, sampler)) continue;
                bl3 = false;
            }
            if (bl3) break;
            n2 = 0;
            for (Sampler sampler : this.propertySamplers) {
                n2 = Math.min(n2, sampler.getSimulationMethod().getProgress(n3, sampler));
            }
            if (n2 > n) {
                n = n2;
                this.mainLog.print(" " + n + "%");
                this.mainLog.flush();
            }
            ++n3;
            this.initialisePath(state);
            bl4 = false;
            bl5 = false;
            for (l5 = 0L; !bl4 && l5 < l || bl5; ++l5) {
                bl4 = true;
                bl5 = false;
                for (Sampler sampler : this.propertySamplers) {
                    if (sampler.isCurrentValueKnown()) continue;
                    bl4 = false;
                    if (!sampler.needsBoundedNumSteps()) continue;
                    bl5 = true;
                }
                if ((bl4 || l5 >= l) && !bl5) break;
                this.automaticTransition();
            }
            d = (d * (double)(n3 - 1) + (double)l5) / (double)n3;
            l2 = n3 == 1 ? l5 : Math.min(l2, l5);
            long l6 = l3 = n3 == 1 ? l5 : Math.max(l3, l5);
            if (!bl4) {
                bl = true;
                break;
            }
            for (Sampler sampler : this.propertySamplers) {
                sampler.updateStats();
            }
        }
        if (!bl) {
            if (!bl6) {
                this.mainLog.print(" 100% ]");
            }
            this.mainLog.println();
            long l7 = System.currentTimeMillis();
            double d2 = (double)(l7 - l4) / 1000.0;
            this.mainLog.print("\nSampling complete: ");
            this.mainLog.print(n3 + " iterations in " + d2 + " seconds (average " + PrismUtils.formatDouble(2, d2 / (double)n3) + ")\n");
            this.mainLog.print("Path length statistics: average " + PrismUtils.formatDouble(2, d) + ", min " + l2 + ", max " + l3 + "\n");
        } else {
            this.mainLog.print(" ...\n\nSampling terminated early after " + n3 + " iterations.\n");
        }
        if (bl2) {
            this.mainLog.printWarning("Deadlocks were found during simulation: self-loops were added.");
        }
        if (bl6) {
            this.mainLog.printWarning("Simulation was terminated before completion.");
        }
        if (bl) {
            throw new PrismException("One or more of the properties being sampled could not be checked on a sample. Consider increasing the maximum path length");
        }
    }

    public void stopSampling() {
    }
}

