/*
 * Decompiled with CFR 0.152.
 */
package simulator;

import explicit.Utils;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import org.jfree.data.xy.XYDataItem;
import parser.State;
import parser.ast.ModulesFile;
import parser.type.TypeDouble;
import prism.PrismException;
import simulator.PathDisplayer;
import userinterface.graph.Graph;

public class PathToGraph
extends PathDisplayer {
    private Graph graphModel = null;
    private List<Graph.SeriesKey> varSeriesKeys = null;
    private List<Graph.SeriesKey> rewardSeriesKeys = null;
    private ModulesFile modulesFile;
    private int numVars;
    private int numRewardStructs;
    private double lastTime;
    private State lastState;
    private double[] lastStateRewards;
    private BitSet skippedVars = new BitSet();
    private BitSet skippedRewards = new BitSet();

    public PathToGraph(Graph graph, ModulesFile modulesFile) {
        this.graphModel = graph;
        this.modulesFile = modulesFile;
        this.numVars = modulesFile.getNumVars();
        this.numRewardStructs = modulesFile.getNumRewardStructs();
    }

    @Override
    public void startDisplay(State state, double[] dArray) {
        int n;
        this.graphModel.getXAxisSettings().setHeading("Time");
        this.graphModel.getYAxisSettings().setHeading("Value");
        this.varSeriesKeys = new ArrayList<Graph.SeriesKey>();
        if (this.varsToShow == null) {
            for (n = 0; n < this.numVars; ++n) {
                this.varSeriesKeys.add(this.graphModel.addSeries(this.modulesFile.getVarName(n)));
            }
        } else {
            for (n = 0; n < this.numVars; ++n) {
                if (this.varsToShow != null && this.varsToShow.contains(n)) {
                    this.varSeriesKeys.add(this.graphModel.addSeries(this.modulesFile.getVarName(n)));
                    continue;
                }
                this.varSeriesKeys.add(null);
            }
        }
        if (this.showRewards) {
            this.rewardSeriesKeys = new ArrayList<Graph.SeriesKey>();
            for (n = 0; n < this.numRewardStructs; ++n) {
                this.rewardSeriesKeys.add(this.graphModel.addSeries(this.modulesFile.getRewardStruct(n).getName()));
            }
        }
        this.lastState = new State(state.varValues.length);
        if (this.showRewards) {
            this.lastStateRewards = Utils.cloneDoubleArray(dArray);
        }
        this.displayState(0.0, state, dArray, true);
    }

    @Override
    public void displayStep(double d, double d2, Object object, double d3, double[] dArray, long l, State state, double[] dArray2) {
        this.displayState(d2, state, dArray2, !this.showChangesOnly);
    }

    @Override
    public void displaySnapshot(double d, long l, State state, double[] dArray) {
        this.displayState(d, state, dArray, !this.showChangesOnly);
    }

    private void displayState(double d, State state, double[] dArray, boolean bl) {
        boolean bl2;
        int n;
        if (this.varsToShow == null) {
            for (n = 0; n < this.numVars; ++n) {
                boolean bl3;
                Object object = state.varValues[n];
                boolean bl4 = bl3 = bl || !object.equals(this.lastState.varValues[n]);
                if (bl3) {
                    if (this.skippedVars.get(n)) {
                        this.addPoint(this.varSeriesKeys.get(n), this.lastTime, this.lastState.varValues[n]);
                    }
                    this.addPoint(this.varSeriesKeys.get(n), d, object);
                }
                this.skippedVars.set(n, !bl3);
            }
        } else {
            Iterator iterator = this.varsToShow.iterator();
            while (iterator.hasNext()) {
                int n2 = (Integer)iterator.next();
                Object object = state.varValues[n2];
                boolean bl5 = bl2 = bl || !object.equals(this.lastState.varValues[n2]);
                if (bl2) {
                    if (this.skippedVars.get(n2)) {
                        this.addPoint(this.varSeriesKeys.get(n2), this.lastTime, this.lastState.varValues[n2]);
                    }
                    this.addPoint(this.varSeriesKeys.get(n2), d, object);
                }
                this.skippedVars.set(n2, !bl2);
            }
        }
        if (this.showRewards) {
            for (n = 0; n < this.numRewardStructs; ++n) {
                double d2 = dArray[n];
                boolean bl6 = bl2 = bl || this.lastStateRewards[n] != dArray[n];
                if (bl2) {
                    if (this.skippedRewards.get(n)) {
                        this.graphModel.addPointToSeries(this.rewardSeriesKeys.get(n), new XYDataItem(this.lastTime, this.lastStateRewards[n]));
                    }
                    this.graphModel.addPointToSeries(this.rewardSeriesKeys.get(n), new XYDataItem(d, d2));
                }
                this.skippedRewards.set(n, !bl2);
            }
        }
        this.lastTime = d;
        this.lastState.copy(state);
        if (this.showRewards) {
            Utils.copyDoubleArray(dArray, this.lastStateRewards);
        }
    }

    private void addPoint(Graph.SeriesKey seriesKey, double d, Object object) {
        block2: {
            try {
                double d2 = TypeDouble.getInstance().castValueTo(object);
                this.graphModel.addPointToSeries(seriesKey, new XYDataItem(d, d2));
            }
            catch (PrismException prismException) {
                if (!(object instanceof Boolean)) break block2;
                double d3 = (Boolean)object != false ? 1.0 : 0.0;
                this.graphModel.addPointToSeries(seriesKey, new XYDataItem(d, d3));
            }
        }
    }

    @Override
    public void endDisplay() {
        this.displayState(this.lastTime, this.lastState, this.lastStateRewards, true);
    }
}

