/*
 * Decompiled with CFR 0.152.
 */
package simulator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import parser.State;
import parser.VarList;
import parser.ast.Command;
import parser.ast.Update;
import prism.ModelType;
import prism.PrismException;
import prism.PrismLangException;
import simulator.Choice;

public class ChoiceListFlexi
implements Choice {
    protected int moduleOrActionIndex;
    protected List<List<Update>> updates;
    protected List<Double> probability;

    public ChoiceListFlexi() {
        this.updates = new ArrayList<List<Update>>();
        this.probability = new ArrayList<Double>();
    }

    public ChoiceListFlexi(ChoiceListFlexi choiceListFlexi) {
        this.moduleOrActionIndex = choiceListFlexi.moduleOrActionIndex;
        this.updates = new ArrayList<List<Update>>(choiceListFlexi.updates.size());
        for (List<Update> list : choiceListFlexi.updates) {
            ArrayList<Update> arrayList = new ArrayList<Update>(list.size());
            this.updates.add(arrayList);
            for (Update update : list) {
                arrayList.add(update);
            }
        }
        this.probability = new ArrayList<Double>(choiceListFlexi.size());
        Iterator<Object> iterator = choiceListFlexi.probability.iterator();
        while (iterator.hasNext()) {
            double d = (Double)iterator.next();
            this.probability.add(d);
        }
    }

    public void setModuleOrActionIndex(int n) {
        this.moduleOrActionIndex = n;
    }

    public void add(double d, List<Update> list) {
        this.updates.add(list);
        this.probability.add(d);
    }

    @Override
    public void scaleProbabilitiesBy(double d) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            this.probability.set(i, this.probability.get(i) * d);
        }
    }

    public void productWith(ChoiceListFlexi choiceListFlexi) {
        int n;
        double d;
        int n2 = choiceListFlexi.size();
        int n3 = this.size();
        for (int i = 1; i < n2; ++i) {
            d = choiceListFlexi.getProbability(i);
            for (n = 0; n < n3; ++n) {
                ArrayList<Update> arrayList = new ArrayList<Update>(this.updates.get(n).size() + choiceListFlexi.updates.get(i).size());
                for (Update update : this.updates.get(n)) {
                    arrayList.add(update);
                }
                for (Update update : choiceListFlexi.updates.get(i)) {
                    arrayList.add(update);
                }
                this.add(d * this.getProbability(n), arrayList);
            }
        }
        d = choiceListFlexi.getProbability(0);
        for (n = 0; n < n3; ++n) {
            for (Update update : choiceListFlexi.updates.get(0)) {
                this.updates.get(n).add(update);
            }
            this.probability.set(n, d * this.probability.get(n));
        }
    }

    @Override
    public int getModuleOrActionIndex() {
        return this.moduleOrActionIndex;
    }

    @Override
    public String getModuleOrAction() {
        Update update = this.updates.get(0).get(0);
        Command command = update.getParent().getParent();
        if ("".equals(command.getSynch())) {
            return command.getParent().getName();
        }
        return "[" + command.getSynch() + "]";
    }

    @Override
    public int size() {
        return this.probability.size();
    }

    @Override
    public String getUpdateString(int n, State state) throws PrismLangException {
        String string = "";
        boolean bl = true;
        for (Update update : this.updates.get(n)) {
            int n2 = update.getNumElements();
            for (int i = 0; i < n2; ++i) {
                if (bl) {
                    bl = false;
                } else {
                    string = string + ", ";
                }
                string = string + update.getVar(i) + "'=" + update.getExpression(i).evaluate(state);
            }
        }
        return string;
    }

    @Override
    public String getUpdateStringFull(int n) {
        String string = "";
        boolean bl = true;
        for (Update update : this.updates.get(n)) {
            if (update.getNumElements() == 0) continue;
            if (bl) {
                bl = false;
            } else {
                string = string + " & ";
            }
            string = string + update;
        }
        return string;
    }

    @Override
    public State computeTarget(int n, State state) throws PrismLangException {
        State state2 = new State(state);
        for (Update update : this.updates.get(n)) {
            update.update(state, state2);
        }
        return state2;
    }

    @Override
    public void computeTarget(int n, State state, State state2) throws PrismLangException {
        for (Update update : this.updates.get(n)) {
            update.update(state, state2);
        }
    }

    @Override
    public double getProbability(int n) {
        return this.probability.get(n);
    }

    @Override
    public double getProbabilitySum() {
        double d = 0.0;
        for (double d2 : this.probability) {
            d += d2;
        }
        return d;
    }

    @Override
    public int getIndexByProbabilitySum(double d) {
        int n;
        int n2 = this.size();
        double d2 = 0.0;
        for (n = 0; d >= d2 && n < n2; d2 += this.probability.get(n).doubleValue(), ++n) {
        }
        return n - 1;
    }

    @Override
    public void checkValid(ModelType modelType) throws PrismException {
    }

    @Override
    public void checkForErrors(State state, VarList varList) throws PrismException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            for (Update update : this.updates.get(i)) {
                update.checkUpdate(state, varList);
            }
        }
    }

    public String toString() {
        boolean bl = true;
        String string = "";
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (bl) {
                bl = false;
            } else {
                string = string + " + ";
            }
            string = string + this.getProbability(i) + ":" + this.updates.get(i);
        }
        return string;
    }
}

