/*
 * Decompiled with CFR 0.152.
 */
package settings;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import settings.Setting;
import settings.SettingEditor;
import settings.SettingException;

public class IntegerEditor
implements SettingEditor,
CaretListener,
FocusListener {
    private JTextField field;
    private Font font = new Font("monospaced", 0, 12);
    private Font font2 = new Font("monospaced", 0, 12);
    private JTable lastTable = null;
    private int tableCol = -1;
    private int tableRow = -1;
    private boolean valueGot = true;

    public IntegerEditor() {
        this.field = new JTextField();
        this.field.addCaretListener(this);
        this.field.addFocusListener(this);
    }

    @Override
    public Object getEditorValue() throws SettingException {
        if (this.field.getText().equals("")) {
            return "$%^&*NOTCHANGED*&^%$";
        }
        this.valueGot = true;
        try {
            return new Integer(this.field.getText());
        }
        catch (NumberFormatException numberFormatException) {
            throw new SettingException("The value entered is not a valid number.");
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Setting setting, Object object, boolean bl, int n, int n2) {
        ArrayList arrayList;
        this.field.setMargin(new Insets(0, 2, 4, 2));
        if (bl) {
            this.field.setForeground(jTable.getSelectionForeground());
            this.field.setBackground(jTable.getSelectionBackground());
        } else {
            this.field.setForeground(jTable.getForeground());
            this.field.setBackground(jTable.getBackground());
        }
        this.field.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        if (object instanceof Integer) {
            Integer n3 = (Integer)object;
            this.field.setText(n3.toString());
            this.field.setCaretColor(Color.black);
            this.field.setFont(this.font);
        } else if (object instanceof ArrayList && (arrayList = (ArrayList)object).size() > 0) {
            Integer n4 = null;
            boolean bl2 = true;
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!(arrayList.get(i) instanceof Integer)) continue;
                Integer n5 = (Integer)arrayList.get(i);
                if (n4 != null) {
                    if (!n5.equals(n4)) {
                        bl2 = false;
                        break;
                    }
                    n4 = n5;
                    continue;
                }
                n4 = n5;
            }
            if (bl2) {
                this.field.setText("" + n4);
                this.field.setFont(this.font);
            } else {
                this.field.setText("");
                this.field.setFont(this.font2);
            }
        }
        this.lastTable = jTable;
        this.tableRow = n;
        this.tableCol = n2;
        this.valueGot = false;
        return this.field;
    }

    @Override
    public void stopEditing() {
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        this.field.getCaret().setVisible(true);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (!this.valueGot && this.lastTable != null) {
            Object object;
            this.valueGot = true;
            if (this.field.getText().equals("")) {
                object = "$%^&*NOTCHANGED*&^%$";
            } else {
                try {
                    object = new Integer(this.field.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    object = new SettingException("The value entered is not a valid number.");
                }
            }
            this.lastTable.setValueAt(object, this.tableRow, this.tableCol);
            if (this.lastTable.getCellEditor() != null) {
                this.lastTable.removeEditor();
            }
        }
    }
}

