/*
 * Decompiled with CFR 0.152.
 */
package settings;

import settings.ChoiceEditor;
import settings.ChoiceRenderer;
import settings.Setting;
import settings.SettingEditor;
import settings.SettingException;
import settings.SettingOwner;
import settings.SettingRenderer;
import settings.StringConstraint;

public class ChoiceSetting
extends Setting {
    private static ChoiceRenderer renderer = new ChoiceRenderer();
    private String[] values;
    private ChoiceEditor editor;

    public ChoiceSetting(String string, String[] stringArray, String string2, String string3, SettingOwner settingOwner, boolean bl) {
        super(string, (Object)string2, string3, settingOwner, bl);
        this.editor = new ChoiceEditor(stringArray);
        this.values = stringArray;
    }

    public ChoiceSetting(String string, String[] stringArray, String string2, String string3, SettingOwner settingOwner, boolean bl, StringConstraint stringConstraint) {
        super(string, string2, string3, settingOwner, bl, stringConstraint);
        this.editor = new ChoiceEditor(stringArray);
        this.values = stringArray;
    }

    @Override
    public void checkObjectWithConstraints(Object object) throws SettingException {
        super.checkObjectWithConstraints(object);
        boolean bl = false;
        for (int i = 0; i < this.values.length; ++i) {
            if (!object.toString().equals(this.values[i])) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw new SettingException("Invalid Setting: " + object.toString() + " is not part of the enumeration.");
        }
    }

    @Override
    public SettingEditor getSettingEditor() {
        return this.editor;
    }

    @Override
    public SettingRenderer getSettingRenderer() {
        return renderer;
    }

    @Override
    public Class getValueClass() {
        return String.class;
    }

    public String getStringValue() {
        return this.getValue().toString();
    }

    public int getCurrentIndex() {
        for (int i = 0; i < this.values.length; ++i) {
            if (!this.getValue().toString().equals(this.values[i])) continue;
            return i;
        }
        return -1;
    }

    public void setSelectedIndex(int n) throws SettingException {
        this.setValue(this.values[n]);
    }

    @Override
    public Object parseStringValue(String string) throws SettingException {
        return string;
    }

    @Override
    public String toString() {
        return this.getStringValue();
    }
}

