/*
 * Decompiled with CFR 0.152.
 */
package pta;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import prism.PrismException;
import pta.Constraint;
import pta.PTA;
import pta.Transition;

public class Edge {
    private Transition parent;
    private double prob;
    private int dest;
    private HashMap<Integer, Integer> resets;

    public Edge(Transition transition, double d, int n) {
        this.parent = transition;
        this.prob = d;
        this.dest = n;
        this.resets = new HashMap();
    }

    public Edge(Edge edge) {
        this(edge.parent, edge.prob, edge.dest);
        for (Map.Entry<Integer, Integer> entry : edge.resets.entrySet()) {
            this.addReset(entry.getKey(), entry.getValue());
        }
    }

    public void setProb(double d) {
        this.prob = d;
    }

    public void setDestination(int n) {
        this.dest = n;
    }

    public void setParent(Transition transition) {
        this.parent = transition;
    }

    public void addReset(int n) {
        this.addReset(n, 0);
    }

    public void addReset(int n, int n2) {
        this.resets.put(n, n2);
    }

    public Transition getParent() {
        return this.parent;
    }

    public int getDestination() {
        return this.dest;
    }

    public double getProbability() {
        return this.prob;
    }

    public Iterable<Map.Entry<Integer, Integer>> getResets() {
        return this.resets.entrySet();
    }

    public void check() throws PrismException {
    }

    public String toString() {
        boolean bl = true;
        String string = "";
        string = string + this.prob + " : {";
        for (Map.Entry<Integer, Integer> entry : this.resets.entrySet()) {
            if (bl) {
                bl = false;
            } else {
                string = string + ",";
            }
            string = string + this.parent.getParent().getClockName(entry.getKey());
            string = string + "=" + entry.getValue();
        }
        string = string + "}" + this.parent.getParent().getLocationName(this.dest);
        return string;
    }

    public void writeToDesFile(Writer writer, String string, Iterable<Constraint> iterable) throws PrismException, IOException {
        PTA pTA = this.parent.getParent();
        writer.write("\t" + string + "tran  ");
        writer.write(pTA.getLocationName(this.dest).toString().replace(':', '_') + "; ");
        writer.write(Constraint.toStringList(pTA, iterable));
        writer.write("; ");
        boolean bl = true;
        for (Map.Entry<Integer, Integer> entry : this.resets.entrySet()) {
            if (bl) {
                bl = false;
            } else {
                writer.write(",");
            }
            writer.write(pTA.getClockName(entry.getKey()) + "=" + entry.getValue());
        }
        if (bl) {
            writer.write("null");
        }
        writer.write("; " + this.prob + "\n");
    }
}

