/*
 * Decompiled with CFR 0.152.
 */
package pta;

import pta.Constraint;
import pta.DB;
import pta.DBMFactory;
import pta.DBMList;
import pta.PTA;
import pta.Zone;

public class DBM
extends Zone {
    protected PTA pta;
    protected int[][] d;

    public DBM(PTA pTA) {
        this.pta = pTA;
        this.d = new int[pTA.numClocks + 1][pTA.numClocks + 1];
    }

    @Override
    public PTA getPTA() {
        return this.pta;
    }

    @Override
    public void addConstraint(int n, int n2, int n3) {
        if (DB.add(this.d[n2][n], n3) < 1) {
            this.d[0][0] = -1;
        } else if (n3 < this.d[n][n2]) {
            int n4;
            int n5;
            int n6;
            this.d[n][n2] = n3;
            int n7 = this.pta.numClocks;
            for (n6 = 0; n6 < n7 + 1; ++n6) {
                for (n5 = 0; n5 < n7 + 1; ++n5) {
                    n4 = DB.add(this.d[n6][n], this.d[n][n5]);
                    if (n4 >= this.d[n6][n5]) continue;
                    this.d[n6][n5] = n4;
                }
            }
            for (n6 = 0; n6 < n7 + 1; ++n6) {
                for (n5 = 0; n5 < n7 + 1; ++n5) {
                    n4 = DB.add(this.d[n6][n2], this.d[n2][n5]);
                    if (n4 >= this.d[n6][n5]) continue;
                    this.d[n6][n5] = n4;
                }
            }
        }
    }

    @Override
    public void addConstraint(Constraint constraint) {
        this.addConstraint(constraint.x, constraint.y, constraint.db);
    }

    @Override
    public void addConstraints(Iterable<Constraint> iterable) {
        for (Constraint constraint : iterable) {
            this.addConstraint(constraint);
        }
    }

    @Override
    public void intersect(Zone zone) {
        DBM dBM = (DBM)zone;
        int n = this.pta.numClocks;
        for (int i = 0; i < n + 1; ++i) {
            for (int j = 0; j < n + 1; ++j) {
                if (i == j || DB.isInfty(dBM.d[i][j])) continue;
                this.addConstraint(i, j, dBM.d[i][j]);
            }
        }
    }

    @Override
    public void up(Iterable<Constraint> iterable) {
        int n = this.pta.numClocks;
        for (int i = 1; i < n + 1; ++i) {
            this.d[i][0] = Integer.MAX_VALUE;
        }
        if (iterable != null) {
            for (Constraint constraint : iterable) {
                this.addConstraint(constraint);
            }
        }
    }

    @Override
    public void down(Iterable<Constraint> iterable) {
        int n = this.pta.numClocks;
        for (int i = 1; i < n + 1; ++i) {
            this.d[0][i] = 1;
            for (int j = 1; j < n + 1; ++j) {
                if (this.d[j][i] >= this.d[0][i]) continue;
                this.d[0][i] = this.d[j][i];
            }
        }
        if (iterable != null) {
            for (Constraint constraint : iterable) {
                this.addConstraint(constraint);
            }
        }
    }

    @Override
    public void free(int n) {
        int n2 = this.pta.numClocks;
        for (int i = 0; i < n2 + 1; ++i) {
            if (i == n) continue;
            this.d[n][i] = Integer.MAX_VALUE;
            this.d[i][n] = this.d[i][0];
        }
    }

    @Override
    public void reset(int n, int n2) {
        int n3 = this.pta.numClocks;
        for (int i = 0; i < n3 + 1; ++i) {
            this.d[n][i] = DB.add(DB.createLeq(n2), this.d[0][i]);
            this.d[i][n] = DB.add(this.d[i][0], DB.createLeq(-n2));
        }
    }

    @Override
    public void backReset(int n, int n2) {
        this.addConstraint(n, 0, DB.createLeq(n2));
        this.addConstraint(0, n, DB.createLeq(-n2));
        this.free(n);
    }

    @Override
    public void cClosure(int n) {
        if (this.isEmpty()) {
            return;
        }
        int n2 = this.pta.numClocks;
        for (int i = 0; i < n2 + 1; ++i) {
            for (int j = 0; j < n2 + 1; ++j) {
                if (!DB.isInfty(this.d[i][j]) && DB.createLeq(n) < this.d[i][j]) {
                    this.d[i][j] = Integer.MAX_VALUE;
                    continue;
                }
                if (DB.isInfty(this.d[i][j]) || this.d[i][j] >= DB.createLt(-n)) continue;
                this.d[i][j] = DB.createLt(-n);
            }
        }
        this.canonicalise();
    }

    @Override
    public DBMList createComplement() {
        DBMList dBMList = new DBMList(this.pta);
        if (this.isEmpty()) {
            dBMList.addDBM(DBM.createTrue(this.pta));
            return dBMList;
        }
        int n = this.d.length - 1;
        for (int i = 0; i < n + 1; ++i) {
            for (int j = 0; j < n + 1; ++j) {
                if (i == j || DB.isInfty(this.d[i][j])) continue;
                DBM dBM = new DBMFactory().createTrue(this.pta);
                dBM.addConstraint(j, i, DB.dual(this.d[i][j]));
                if (dBM.isEmpty()) continue;
                dBMList.addDBM(dBM);
            }
        }
        return dBMList;
    }

    @Override
    public boolean isEmpty() {
        return this.d[0][0] < 0;
    }

    @Override
    public boolean isSatisfied(Constraint constraint) {
        return DB.add(constraint.db, this.d[constraint.y][constraint.x]) > 0;
    }

    @Override
    public boolean includes(DBM dBM) {
        int[][] nArray = dBM.d;
        int n = this.pta.numClocks;
        for (int i = 0; i < n + 1; ++i) {
            for (int j = 0; j < n + 1; ++j) {
                if (this.d[i][j] >= nArray[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int getClockMin(int n) {
        return -DB.getSignedDiff(this.d[0][n]);
    }

    @Override
    public int getClockMax(int n) {
        return DB.getSignedDiff(this.d[n][0]);
    }

    @Override
    public boolean clockIsUnbounded(int n) {
        return DB.isInfty(this.d[n][0]);
    }

    @Override
    public boolean allClocksAreUnbounded() {
        int n = this.pta.numClocks;
        for (int i = 1; i < n + 1; ++i) {
            if (DB.isInfty(this.d[i][0])) continue;
            return false;
        }
        return true;
    }

    @Override
    public DBM deepCopy() {
        DBM dBM = new DBM(this.pta);
        int n = this.pta.numClocks;
        dBM.d = new int[n + 1][n + 1];
        for (int i = 0; i < n + 1; ++i) {
            for (int j = 0; j < n + 1; ++j) {
                dBM.d[i][j] = this.d[i][j];
            }
        }
        return dBM;
    }

    @Override
    public String storageInfo() {
        return "DBM with " + this.pta.numClocks + " clocks";
    }

    @Override
    public int hashCode() {
        int n = this.pta.numClocks + 1;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                n2 = n2 * 7 + this.d[i][j];
            }
        }
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        DBM dBM;
        if (object == null) {
            return false;
        }
        try {
            dBM = (DBM)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        int n = this.pta.numClocks;
        for (int i = 0; i < n + 1; ++i) {
            for (int j = 0; j < n + 1; ++j) {
                if (this.d[i][j] == dBM.d[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return this.toStringTextual();
    }

    public String toStringTextual() {
        boolean bl = true;
        String string = "";
        int n = this.pta.numClocks;
        if (this.isEmpty()) {
            return "empty";
        }
        for (int i = 0; i < n + 1; ++i) {
            for (int j = i + 1; j < n + 1; ++j) {
                String string2 = null;
                if (!DB.isInfty(this.d[i][j])) {
                    string2 = !DB.isInfty(this.d[j][i]) ? DB.constraintPairToString(i, j, this.d[i][j], this.d[j][i], this.pta) : DB.constraintToString(i, j, this.d[i][j], this.pta);
                } else if (!DB.isInfty(this.d[j][i])) {
                    string2 = DB.constraintToString(j, i, this.d[j][i], this.pta);
                }
                if (string2 == null) continue;
                if (!bl) {
                    string = string + ",";
                } else {
                    bl = false;
                }
                string = string + string2;
            }
        }
        if ("".equals(string)) {
            return "true";
        }
        return "{" + string + "}";
    }

    public String toStringDBM() {
        String string = "[ ";
        int n = this.pta.numClocks;
        for (int i = 0; i < n + 1; ++i) {
            for (int j = 0; j < n + 1; ++j) {
                if (j > 0) {
                    string = string + " ";
                }
                string = string + DB.toString(this.d[i][j]);
            }
            if (i >= n) continue;
            string = string + ", ";
        }
        string = string + " ]";
        return string;
    }

    private void canonicalise() {
        int n = this.pta.numClocks;
        for (int i = 0; i < n + 1; ++i) {
            for (int j = 0; j < n + 1; ++j) {
                for (int k = 0; k < n + 1; ++k) {
                    int n2 = DB.add(this.d[j][i], this.d[i][k]);
                    if (n2 >= this.d[j][k]) continue;
                    this.d[j][k] = n2;
                }
            }
        }
    }

    public static DBM createZero(PTA pTA) {
        DBM dBM = new DBM(pTA);
        int n = pTA.numClocks;
        for (int i = 0; i < n + 1; ++i) {
            for (int j = 0; j < n + 1; ++j) {
                dBM.d[i][j] = 1;
            }
        }
        return dBM;
    }

    public static DBM createTrue(PTA pTA) {
        DBM dBM = new DBM(pTA);
        int n = pTA.numClocks;
        for (int i = 0; i < n + 1; ++i) {
            for (int j = 0; j < n + 1; ++j) {
                dBM.d[i][j] = i == j ? 1 : (i == 0 ? 1 : Integer.MAX_VALUE);
            }
        }
        return dBM;
    }

    public static DBM createFromConstraints(PTA pTA, Iterable<Constraint> iterable) {
        DBM dBM = DBM.createTrue(pTA);
        for (Constraint constraint : iterable) {
            dBM.addConstraint(constraint);
        }
        return dBM;
    }
}

