/*
 * Decompiled with CFR 0.152.
 */
package pta;

import explicit.IndexedSet;
import explicit.MDP;
import explicit.MDPModelChecker;
import explicit.ModelCheckerResult;
import explicit.Utils;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.List;
import prism.PrismComponent;
import prism.PrismException;
import prism.ProgressDisplay;
import pta.BackwardsReachabilityGraph;
import pta.DBM;
import pta.Edge;
import pta.LocZone;
import pta.PTA;
import pta.Transition;
import pta.Zone;

public class BackwardsReach
extends PrismComponent {
    public BackwardsReach(PrismComponent prismComponent) throws PrismException {
        super(prismComponent);
    }

    public double computeProbabilisticReachability(PTA pTA, BitSet bitSet, boolean bl) throws PrismException {
        if (bl) {
            throw new PrismException("Backwards reachability does not yet support minmum probabilities");
        }
        BackwardsReachabilityGraph backwardsReachabilityGraph = this.buildBackwardsGraph(pTA, bitSet);
        this.mainLog.print("Building MDP... ");
        this.mainLog.flush();
        MDP mDP = backwardsReachabilityGraph.buildMDP(pTA);
        this.mainLog.println(mDP.infoString());
        MDPModelChecker mDPModelChecker = new MDPModelChecker(this);
        mDPModelChecker.setExportAdv(true);
        mDPModelChecker.setPrecomp(false);
        ModelCheckerResult modelCheckerResult = mDPModelChecker.computeReachProbs(mDP, backwardsReachabilityGraph.getTarget(), false);
        return Math.max(0.0, Utils.minMaxOverArraySubset(modelCheckerResult.soln, backwardsReachabilityGraph.getInitialStates(), false));
    }

    public BackwardsReachabilityGraph buildBackwardsGraph(PTA pTA, BitSet bitSet) throws PrismException {
        Object object;
        this.mainLog.print("\nBuilding backwards reachability graph...");
        this.mainLog.flush();
        ProgressDisplay progressDisplay = new ProgressDisplay(this.mainLog);
        progressDisplay.start();
        long l = System.currentTimeMillis();
        BackwardsReachabilityGraph backwardsReachabilityGraph = new BackwardsReachabilityGraph();
        IndexedSet<LocZone> indexedSet = new IndexedSet<LocZone>();
        LinkedList<LocZone> linkedList = new LinkedList<LocZone>();
        ArrayList<LocZone> arrayList = new ArrayList<LocZone>();
        backwardsReachabilityGraph.states = arrayList;
        int n = 0;
        int n2 = bitSet.nextSetBit(0);
        while (n2 >= 0) {
            DBM dBM = DBM.createTrue(pTA);
            ((Zone)dBM).addConstraints(pTA.getInvariantConstraints(n2));
            object = new LocZone(n2, dBM);
            indexedSet.add((LocZone)object);
            linkedList.add((LocZone)object);
            arrayList.add((LocZone)object);
            backwardsReachabilityGraph.addState(pTA.getTransitions(n2));
            backwardsReachabilityGraph.addTargetState(n++);
            n2 = bitSet.nextSetBit(n2 + 1);
        }
        int n3 = -1;
        while (!linkedList.isEmpty()) {
            LocZone locZone = (LocZone)linkedList.removeFirst();
            ++n3;
            locZone = locZone.deepCopy();
            locZone.tPre(pTA);
            for (n2 = 0; n2 < pTA.getNumLocations(); ++n2) {
                if (bitSet.get(n2)) continue;
                int n4 = -1;
                for (Transition transition : pTA.getTransitions(n2)) {
                    ++n4;
                    int n5 = transition.getNumEdges();
                    for (int i = 0; i < n5; ++i) {
                        Edge edge = transition.getEdges().get(i);
                        if (edge.getDestination() != locZone.loc) continue;
                        LocZone locZone2 = locZone.deepCopy();
                        locZone2.dPre(edge);
                        if (locZone2.zone.isEmpty()) continue;
                        if (indexedSet.add(locZone2)) {
                            linkedList.add(locZone2);
                            arrayList.add(locZone2);
                            backwardsReachabilityGraph.addState(pTA.getTransitions(locZone2.loc));
                        }
                        int n6 = indexedSet.getIndexOfLastAdd();
                        backwardsReachabilityGraph.addTransition(n6, n4, i, n3);
                        int n7 = arrayList.size();
                        for (int j = 0; j < n7; ++j) {
                            LocZone locZone3 = (LocZone)arrayList.get(j);
                            if (j == n6 || locZone3.loc != locZone2.loc) continue;
                            Zone zone = locZone3.zone.deepCopy();
                            zone.intersect(locZone2.zone);
                            if (zone.isEmpty()) continue;
                            int n8 = backwardsReachabilityGraph.getList(j).size();
                            for (int k = 0; k < n8; ++k) {
                                List<List<Integer>> list = backwardsReachabilityGraph.getList(j).get(k);
                                int n9 = list.size();
                                if (n9 < 2) continue;
                                for (int i2 = 0; i2 < n9; ++i2) {
                                    List<Integer> list2 = list.get(i2);
                                    int n10 = list2.size();
                                    for (int i3 = 0; i3 < n10; ++i3) {
                                        int n11 = list2.get(i3);
                                        LocZone locZone4 = new LocZone(locZone2.loc, zone);
                                        if (indexedSet.add(locZone4)) {
                                            linkedList.add(locZone4);
                                            arrayList.add(locZone4);
                                            backwardsReachabilityGraph.addState(pTA.getTransitions(locZone4.loc));
                                        }
                                        int n12 = indexedSet.getIndexOfLastAdd();
                                        backwardsReachabilityGraph.addTransition(n12, n4, i, n3);
                                        backwardsReachabilityGraph.addTransition(n12, k, i2, n11);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (!progressDisplay.ready()) continue;
            progressDisplay.update(indexedSet.size());
        }
        progressDisplay.update(indexedSet.size());
        progressDisplay.end(" states");
        n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            if (((LocZone)arrayList.get((int)i)).loc != 0) continue;
            object = ((LocZone)arrayList.get((int)i)).zone.deepCopy();
            ((Zone)object).down();
            if (!((Zone)object).includes(DBM.createZero(pTA))) continue;
            backwardsReachabilityGraph.addInitialState(i);
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.println("Graph constructed in " + (double)l / 1000.0 + " secs.");
        this.mainLog.print("Graph: " + backwardsReachabilityGraph.states.size() + " symbolic states");
        this.mainLog.println(" (" + backwardsReachabilityGraph.getInitialStates().size() + " initial, " + backwardsReachabilityGraph.getTarget().cardinality() + " target)");
        return backwardsReachabilityGraph;
    }
}

