/*
 * Decompiled with CFR 0.152.
 */
package prism;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import parser.Values;
import parser.ast.ModulesFile;
import parser.ast.PropertiesFile;
import parser.ast.Property;
import parser.type.Type;
import prism.DefinedConstant;
import prism.PrismException;

public class UndefinedConstants {
    private ModulesFile modulesFile = null;
    private PropertiesFile propertiesFile = null;
    private List<Property> props = null;
    private boolean justLabels = false;
    private int mfNumConsts = 0;
    private List<DefinedConstant> mfConsts = null;
    private int pfNumConsts = 0;
    private List<DefinedConstant> pfConsts = null;
    private Values mfValues = null;
    private Values pfValues = null;
    private Vector<String> constSwitchNames;
    private Vector<String> constSwitchLows;
    private Vector<String> constSwitchHighs;
    private Vector<String> constSwitchSteps;

    public UndefinedConstants(ModulesFile modulesFile, PropertiesFile propertiesFile) {
        this(modulesFile, propertiesFile, false);
    }

    public UndefinedConstants(ModulesFile modulesFile, PropertiesFile propertiesFile, boolean bl) {
        this.setModulesFile(modulesFile);
        this.setPropertiesFile(propertiesFile);
        this.setJustLabels(bl);
        this.initialise();
    }

    public UndefinedConstants(ModulesFile modulesFile, PropertiesFile propertiesFile, Property property) {
        this.setModulesFile(modulesFile);
        this.setPropertiesFile(propertiesFile);
        this.addProperty(property);
        this.initialise();
    }

    public UndefinedConstants(ModulesFile modulesFile, PropertiesFile propertiesFile, List<Property> list) {
        this.setModulesFile(modulesFile);
        this.setPropertiesFile(propertiesFile);
        this.setProperties(list);
        this.initialise();
    }

    public void setModulesFile(ModulesFile modulesFile) {
        this.modulesFile = modulesFile;
    }

    public void setPropertiesFile(PropertiesFile propertiesFile) {
        this.propertiesFile = propertiesFile;
    }

    public void setProperties(List<Property> list) {
        this.props = list;
    }

    public void addProperty(Property property) {
        if (this.props == null) {
            this.props = new ArrayList<Property>();
        }
        this.props.add(property);
    }

    public void setJustLabels(boolean bl) {
        this.justLabels = bl;
    }

    public void initialise() {
        Vector<String> vector;
        Vector<String> vector2;
        Vector<Object> vector3 = vector2 = this.modulesFile == null ? new Vector() : this.modulesFile.getUndefinedConstants();
        if (this.propertiesFile == null) {
            vector = new Vector<String>();
        } else if (this.props == null) {
            if (this.justLabels) {
                vector = this.propertiesFile.getUndefinedConstantsUsedInLabels();
                vector = this.orderConstantsByPropertiesFile(vector, this.propertiesFile);
            } else {
                vector = this.propertiesFile.getUndefinedConstants();
            }
        } else {
            vector = this.propertiesFile.getUndefinedConstantsUsedInProperties(this.props);
            vector = this.orderConstantsByPropertiesFile(vector, this.propertiesFile);
        }
        this.setUpDataStructures(vector2, vector);
    }

    private Vector<String> orderConstantsByPropertiesFile(Vector<String> vector, PropertiesFile propertiesFile) {
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = propertiesFile.getUndefinedConstants();
        for (String string : vector3) {
            if (!vector.contains(string)) continue;
            vector2.add(string);
        }
        return vector2;
    }

    private void setUpDataStructures(Vector<String> vector, Vector<String> vector2) {
        String string;
        int n;
        this.mfNumConsts = vector.size();
        this.pfNumConsts = vector2.size();
        this.mfConsts = new ArrayList<DefinedConstant>(this.mfNumConsts);
        for (n = 0; n < this.mfNumConsts; ++n) {
            string = vector.elementAt(n);
            this.mfConsts.add(new DefinedConstant(string, this.modulesFile.getConstantList().getConstantType(this.modulesFile.getConstantList().getConstantIndex(string))));
        }
        this.pfConsts = new ArrayList<DefinedConstant>(this.pfNumConsts);
        for (n = 0; n < this.pfNumConsts; ++n) {
            string = vector2.elementAt(n);
            this.pfConsts.add(new DefinedConstant(string, this.propertiesFile.getConstantList().getConstantType(this.propertiesFile.getConstantList().getConstantIndex(string))));
        }
        this.clearAllDefinitions();
    }

    public boolean removeConstant(String string) {
        int n = this.getMFConstIndex(string);
        if (n != -1) {
            --this.mfNumConsts;
            this.mfConsts.remove(n);
            return true;
        }
        n = this.getPFConstIndex(string);
        if (n != -1) {
            --this.pfNumConsts;
            this.pfConsts.remove(n);
            return true;
        }
        return false;
    }

    public int removeConstants(String[] stringArray) {
        int n = 0;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            if (!this.removeConstant(stringArray[i])) continue;
            ++n;
        }
        return n;
    }

    public int getMFNumUndefined() {
        return this.mfNumConsts;
    }

    public int getPFNumUndefined() {
        return this.pfNumConsts;
    }

    public String getMFUndefinedName(int n) {
        return this.mfConsts.get(n).getName();
    }

    public String getPFUndefinedName(int n) {
        return this.pfConsts.get(n).getName();
    }

    public Type getMFUndefinedType(int n) {
        return this.mfConsts.get(n).getType();
    }

    public Type getPFUndefinedType(int n) {
        return this.pfConsts.get(n).getType();
    }

    public int getMFConstIndex(String string) {
        for (int i = 0; i < this.mfNumConsts; ++i) {
            if (!this.mfConsts.get(i).getName().equals(string)) continue;
            return i;
        }
        return -1;
    }

    public int getPFConstIndex(String string) {
        for (int i = 0; i < this.pfNumConsts; ++i) {
            if (!this.pfConsts.get(i).getName().equals(string)) continue;
            return i;
        }
        return -1;
    }

    public void clearAllDefinitions() {
        int n;
        for (n = 0; n < this.mfNumConsts; ++n) {
            this.mfConsts.get(n).clear();
        }
        for (n = 0; n < this.pfNumConsts; ++n) {
            this.pfConsts.get(n).clear();
        }
    }

    public void defineUsingConstSwitch(String string) throws PrismException {
        boolean bl = false;
        this.clearAllDefinitions();
        this.parseConstSwitch(string);
        if (bl && this.mfNumConsts + this.pfNumConsts == 0) {
            if (this.constSwitchNames.size() > 0) {
                throw new PrismException("There are no undefined constants to define");
            }
            return;
        }
        for (int i = 0; i < this.constSwitchNames.size(); ++i) {
            String string2 = this.constSwitchNames.elementAt(i);
            boolean bl2 = this.defineConstant(string2, this.constSwitchLows.elementAt(i), this.constSwitchHighs.elementAt(i), this.constSwitchSteps.elementAt(i), bl);
            if (!bl2) continue;
            throw new PrismException("Duplicate definitions for undefined constant \"" + string2 + "\"");
        }
        this.checkAllDefined();
        this.initialiseIterators();
    }

    private void parseConstSwitch(String string) throws PrismException {
        this.constSwitchNames = new Vector();
        this.constSwitchLows = new Vector();
        this.constSwitchHighs = new Vector();
        this.constSwitchSteps = new Vector();
        if (string == null) {
            return;
        }
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() == 0) continue;
            int n = stringArray[i].indexOf(61);
            if (n < 1 || n + 2 > stringArray[i].length()) {
                throw new PrismException("Invalid format in definition of undefined constants");
            }
            this.constSwitchNames.add(stringArray[i].substring(0, n));
            if (stringArray[i].charAt(stringArray[i].length() - 1) == ':') {
                throw new PrismException("Invalid format in definition of undefined constants");
            }
            String[] stringArray2 = stringArray[i].substring(n + 1).split(":");
            if (stringArray2.length == 1) {
                this.constSwitchLows.add(stringArray2[0]);
                this.constSwitchHighs.add(null);
                this.constSwitchSteps.add(null);
                continue;
            }
            if (stringArray2.length == 2) {
                this.constSwitchLows.add(stringArray2[0]);
                this.constSwitchHighs.add(stringArray2[1]);
                this.constSwitchSteps.add(null);
                continue;
            }
            if (stringArray2.length == 3) {
                this.constSwitchLows.add(stringArray2[0]);
                this.constSwitchHighs.add(stringArray2[2]);
                this.constSwitchSteps.add(stringArray2[1]);
                continue;
            }
            throw new PrismException("Invalid format in definition of undefined constants");
        }
    }

    public boolean defineConstant(String string, String string2) throws PrismException {
        return this.defineConstant(string, string2, null, null, false);
    }

    public boolean defineConstant(String string, String string2, String string3, String string4) throws PrismException {
        return this.defineConstant(string, string2, string3, string4, false);
    }

    public boolean defineConstant(String string, String string2, String string3, String string4, boolean bl) throws PrismException {
        int n = 0;
        boolean bl2 = false;
        n = this.getMFConstIndex(string);
        if (n != -1) {
            bl2 = this.mfConsts.get(n).isDefined();
            this.mfConsts.get(n).define(string2, string3, string4);
        } else {
            n = this.getPFConstIndex(string);
            if (n != -1) {
                bl2 = this.pfConsts.get(n).isDefined();
                this.pfConsts.get(n).define(string2, string3, string4);
            } else {
                if (bl) {
                    throw new PrismException("\"" + string + "\" is not an undefined constant");
                }
                if (this.modulesFile != null && this.modulesFile.isDefinedConstant(string)) {
                    throw new PrismException("Constant \"" + string + "\" has already been defined in the model");
                }
                if (this.propertiesFile != null && this.propertiesFile.isDefinedConstant(string)) {
                    throw new PrismException("Constant \"" + string + "\" has already been defined");
                }
            }
        }
        return bl2;
    }

    public void checkAllDefined() throws PrismException {
        int n;
        Vector<String> vector = new Vector<String>();
        for (n = 0; n < this.mfNumConsts; ++n) {
            if (this.mfConsts.get(n).getLow() != null) continue;
            vector.add(this.mfConsts.get(n).getName());
        }
        for (n = 0; n < this.pfNumConsts; ++n) {
            if (this.pfConsts.get(n).getLow() != null) continue;
            vector.add(this.pfConsts.get(n).getName());
        }
        int n2 = vector.size();
        if (n2 > 0) {
            String string;
            if (n2 == 1) {
                string = "Undefined constant \"" + (String)vector.get(0) + "\" must be defined";
            } else {
                string = "Undefined constants";
                for (n = 0; n < n2; ++n) {
                    if (n > 0 && n < n2 - 1) {
                        string = string + ",";
                    } else if (n == n2 - 1) {
                        string = string + " and";
                    }
                    string = string + " \"" + (String)vector.get(n) + "\"";
                }
                string = string + " must be defined";
            }
            throw new PrismException(string);
        }
    }

    public void initialiseIterators() {
        this.intialiseModelIterator();
        this.intialisePropertyIterator();
    }

    private void intialiseModelIterator() {
        int n;
        for (n = 0; n < this.mfNumConsts; ++n) {
            this.mfConsts.get(n).setValue(this.mfConsts.get(n).getLow());
        }
        this.mfValues = new Values();
        for (n = 0; n < this.mfNumConsts; ++n) {
            this.mfValues.addValue(this.mfConsts.get(n).getName(), this.mfConsts.get(n).getValue());
        }
    }

    private void intialisePropertyIterator() {
        int n;
        for (n = 0; n < this.pfNumConsts; ++n) {
            this.pfConsts.get(n).setValue(this.pfConsts.get(n).getLow());
        }
        this.pfValues = new Values();
        for (n = 0; n < this.pfNumConsts; ++n) {
            this.pfValues.addValue(this.pfConsts.get(n).getName(), this.pfConsts.get(n).getValue());
        }
    }

    public String getDefinedConstantsString() {
        int n;
        String string = "";
        for (n = 0; n < this.mfNumConsts; ++n) {
            string = string + this.mfConsts.get(n);
            if (n >= this.mfNumConsts - 1) continue;
            string = string + ",";
        }
        for (n = 0; n < this.pfNumConsts; ++n) {
            if (n == 0 && this.mfNumConsts > 0) {
                string = string + ",";
            }
            string = string + this.pfConsts.get(n);
            if (n >= this.pfNumConsts - 1) continue;
            string = string + ",";
        }
        return string;
    }

    public String getPFDefinedConstantsString() {
        String string = "";
        for (int i = 0; i < this.pfNumConsts; ++i) {
            string = string + this.pfConsts.get(i);
            if (i >= this.pfNumConsts - 1) continue;
            string = string + ",";
        }
        return string;
    }

    public int getNumModelIterations() {
        int n = 1;
        for (int i = 0; i < this.mfNumConsts; ++i) {
            n *= this.mfConsts.get(i).getNumSteps();
        }
        return n;
    }

    public int getNumModelRangingConstants() {
        int n = 0;
        for (int i = 0; i < this.mfNumConsts; ++i) {
            if (this.mfConsts.get(i).getNumSteps() <= 1) continue;
            ++n;
        }
        return n;
    }

    public int getNumPropertyIterations() {
        int n = 1;
        for (int i = 0; i < this.pfNumConsts; ++i) {
            n *= this.pfConsts.get(i).getNumSteps();
        }
        return n;
    }

    public int getNumPropertyRangingConstants() {
        int n = 0;
        for (int i = 0; i < this.pfNumConsts; ++i) {
            if (this.pfConsts.get(i).getNumSteps() <= 1) continue;
            ++n;
        }
        return n;
    }

    public int getNumIterations() {
        return this.getNumModelIterations() * this.getNumPropertyIterations();
    }

    public Vector<DefinedConstant> getRangingConstants() {
        int n;
        Vector<DefinedConstant> vector = new Vector<DefinedConstant>();
        for (n = 0; n < this.mfNumConsts; ++n) {
            if (this.mfConsts.get(n).getNumSteps() <= 1) continue;
            vector.addElement(this.mfConsts.get(n));
        }
        for (n = 0; n < this.pfNumConsts; ++n) {
            if (this.pfConsts.get(n).getNumSteps() <= 1) continue;
            vector.addElement(this.pfConsts.get(n));
        }
        return vector;
    }

    public void iterateModel() {
        int n;
        for (int i = this.mfNumConsts - 1; i >= -1; --i) {
            if (i >= 0) {
                if (!this.mfConsts.get(i).incr()) break;
                continue;
            }
            for (n = 0; n < this.mfNumConsts; ++n) {
                this.mfConsts.get(n).setValue(this.mfConsts.get(n).getLow());
            }
        }
        this.mfValues = new Values();
        for (n = 0; n < this.mfNumConsts; ++n) {
            this.mfValues.addValue(this.mfConsts.get(n).getName(), this.mfConsts.get(n).getValue());
        }
    }

    public void iterateProperty() {
        int n;
        for (int i = this.pfNumConsts - 1; i >= -1; --i) {
            if (i >= 0) {
                if (!this.pfConsts.get(i).incr()) break;
                continue;
            }
            for (n = 0; n < this.pfNumConsts; ++n) {
                this.pfConsts.get(n).setValue(this.pfConsts.get(n).getLow());
            }
        }
        this.pfValues = new Values();
        for (n = 0; n < this.pfNumConsts; ++n) {
            this.pfValues.addValue(this.pfConsts.get(n).getName(), this.pfConsts.get(n).getValue());
        }
    }

    public Values getMFConstantValues() {
        return this.mfValues;
    }

    public Values getPFConstantValues() {
        return this.pfValues;
    }

    public Values getNonRangingConstantValues() {
        int n;
        Values values = new Values();
        for (n = 0; n < this.mfNumConsts; ++n) {
            if (this.mfConsts.get(n).getNumSteps() != 1) continue;
            values.addValue(this.mfConsts.get(n).getName(), this.mfConsts.get(n).getValue());
        }
        for (n = 0; n < this.pfNumConsts; ++n) {
            if (this.pfConsts.get(n).getNumSteps() != 1) continue;
            values.addValue(this.pfConsts.get(n).getName(), this.pfConsts.get(n).getValue());
        }
        return values;
    }
}

