/*
 * Decompiled with CFR 0.152.
 */
package prism;

import java.util.ArrayList;
import java.util.List;
import prism.MultiObjUtils;
import prism.Point;
import prism.PrismException;

public class Tile {
    protected ArrayList<Point> cornerPoints;
    protected int dim;
    protected boolean upperBound;
    protected boolean[] projectionUpperBound;
    protected boolean hyperplaneSuggested;

    public Tile(ArrayList<Point> arrayList) {
        this.cornerPoints = arrayList;
        this.dim = this.cornerPoints.size();
        this.projectionUpperBound = new boolean[this.dim];
    }

    public ArrayList<Point> getCornerPoints() {
        return this.cornerPoints;
    }

    public boolean isUpperBound(int n) {
        if (n == this.dim) {
            return this.upperBound;
        }
        return this.projectionUpperBound[n];
    }

    protected boolean pointAboveHyperplane(Point point) throws PrismException {
        for (Point point2 : this.cornerPoints) {
            if (!point.isCloseTo(point2)) continue;
            return false;
        }
        Point point3 = Tile.getWeightsForTile(this);
        double d = 0.0;
        for (int i = 0; i < this.dim; ++i) {
            for (int j = 0; j < point.getDimension(); ++j) {
                d += point3.getCoord(j) * this.cornerPoints.get(i).getCoord(j);
            }
        }
        d /= (double)point.getDimension();
        double d2 = 0.0;
        for (int i = 0; i < point.getDimension(); ++i) {
            d2 += point3.getCoord(i) * point.getCoord(i);
        }
        return d2 >= d + 1.0E-5;
    }

    public boolean processNewPoint(Point point, boolean bl, int n) throws PrismException {
        boolean bl2 = this.pointAboveHyperplane(point);
        if (bl2) {
            this.hyperplaneSuggested = false;
            return true;
        }
        if (this.hyperplaneSuggested && bl) {
            this.hyperplaneSuggested = false;
            if (n == this.cornerPoints.size()) {
                this.upperBound = true;
            } else {
                this.projectionUpperBound[n] = true;
            }
        }
        return false;
    }

    public List<Tile> splitByPoint(Point point, List<Point> list, double d) throws PrismException {
        int n;
        Point point2 = Tile.getWeightsForTile(this);
        double d2 = 0.0;
        for (int i = 0; i < point.getDimension(); ++i) {
            d2 += point2.getCoord(i) * point.getCoord(i);
        }
        double d3 = 0.0;
        for (n = 0; n < point.getDimension(); ++n) {
            d3 += point2.getCoord(n) * this.getCornerPoints().get(0).getCoord(n);
        }
        n = d2 - d3 < d ? 1 : 0;
        ArrayList<Tile> arrayList = new ArrayList<Tile>();
        for (int i = 0; i < this.cornerPoints.size(); ++i) {
            int n2;
            ArrayList arrayList2 = (ArrayList)this.cornerPoints.clone();
            arrayList2.set(i, point);
            Tile tile = new Tile(arrayList2);
            boolean bl = true;
            for (n2 = 0; n2 < tile.cornerPoints.size(); ++n2) {
                bl = true;
                for (int j = 0; j < tile.cornerPoints.size(); ++j) {
                    if (tile.cornerPoints.get(j).getCoord(n2) == 0.0) continue;
                    bl = false;
                    break;
                }
                if (bl) break;
            }
            n2 = 0;
            for (Point point3 : list) {
                if (!tile.pointAboveHyperplane(point3)) continue;
                n2 = 1;
                break;
            }
            if (n != 0 || this.isUpperBound(this.dim)) {
                tile.upperBound = true;
            }
            if (bl || n2 != 0) continue;
            arrayList.add(tile);
        }
        return arrayList;
    }

    protected static Point getWeightsForTile(Tile tile) {
        int n;
        Object object;
        int n2 = tile.cornerPoints.size();
        int n3 = -1;
        for (int i = 0; i < n2; ++i) {
            if (tile.cornerPoints.get(i).isZero()) continue;
            n3 = i;
            break;
        }
        if (n3 == -1) {
            double[] dArray = new double[n2];
            dArray[0] = 1.0;
            return new Point(dArray);
        }
        double[][] dArray = new double[n2][n2];
        double[] dArray2 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            object = tile.cornerPoints.get(i);
            if (((Point)object).isZero()) {
                for (n = 0; n < n2; ++n) {
                    dArray[i][n] = tile.cornerPoints.get(n3).getCoord(n);
                }
            } else {
                for (n = 0; n < n2; ++n) {
                    dArray[i][n] = ((Point)object).getCoord(n);
                }
            }
            dArray2[i] = 1.0;
        }
        double[] dArray3 = MultiObjUtils.solveEqns(dArray, dArray2);
        object = new double[n2];
        for (n = 0; n < n2; ++n) {
            object[n] = dArray3[n];
        }
        return new Point((double[])object).normalize();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        for (int i = 0; i < this.cornerPoints.size() - 1; ++i) {
            stringBuffer.append(this.cornerPoints.get(i).toString());
            stringBuffer.append("; ");
        }
        stringBuffer.append(this.cornerPoints.get(this.cornerPoints.size() - 1).toString());
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public boolean liesOnBoundary(int n) {
        int n2 = 0;
        for (Point point : this.cornerPoints) {
            if (point.getCoord(n) != 0.0) continue;
            ++n2;
        }
        return n2 >= 2;
    }
}

