/*
 * Decompiled with CFR 0.152.
 */
package prism;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;
import odd.ODDNode;
import parser.VarList;
import parser.ast.RelOp;
import parser.type.TypeInt;
import prism.Model;
import prism.PrismException;
import prism.PrismLog;
import prism.StateValues;
import prism.StateValuesDV;

public class StateValuesMTBDD
implements StateValues {
    JDDNode values;
    Model model;
    JDDVars vars;
    JDDNode reach;
    int numDDRowVars;
    int numVars;
    ODDNode odd;
    VarList varList;
    int[] varSizes;
    int[] varValues;
    int currentVar;
    int currentVarLevel;
    PrismLog outputLog;

    public StateValuesMTBDD(JDDNode jDDNode, Model model) {
        this.values = jDDNode;
        this.model = model;
        this.vars = this.model.getAllDDRowVars();
        this.reach = this.model.getReach();
        this.numDDRowVars = this.model.getNumDDRowVars();
        this.numVars = this.vars.n();
        this.odd = this.model.getODD();
        this.varList = this.model.getVarList();
        this.varSizes = new int[this.varList.getNumVars()];
        for (int i = 0; i < this.varList.getNumVars(); ++i) {
            this.varSizes[i] = this.varList.getRangeLogTwo(i);
        }
        this.varValues = new int[this.varList.getNumVars()];
    }

    @Override
    public StateValuesDV convertToStateValuesDV() {
        StateValuesDV stateValuesDV = new StateValuesDV(this.values, this.model);
        this.clear();
        return stateValuesDV;
    }

    @Override
    public StateValuesMTBDD convertToStateValuesMTBDD() {
        return this;
    }

    public void setElement(int n, double d) {
        JDDNode jDDNode = JDD.Constant(1.0);
        ODDNode oDDNode = this.odd;
        int n2 = n;
        for (int i = 0; i < this.numVars; ++i) {
            JDD.Ref(this.vars.getVar(i));
            if ((long)n2 >= oDDNode.getEOff()) {
                n2 = (int)((long)n2 - oDDNode.getEOff());
                jDDNode = JDD.And(jDDNode, this.vars.getVar(i));
                oDDNode = oDDNode.getThen();
                continue;
            }
            jDDNode = JDD.And(jDDNode, JDD.Not(this.vars.getVar(i)));
            oDDNode = oDDNode.getElse();
        }
        this.values = JDD.ITE(jDDNode, JDD.Constant(d), this.values);
    }

    @Override
    public void readFromFile(File file) throws PrismException {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        long l = this.model.getNumStates();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string = bufferedReader.readLine();
            ++n;
            while (string != null) {
                if (!"".equals(string = string.trim())) {
                    if (string.contains("=")) {
                        bl = true;
                        String[] stringArray = string.split("=");
                        n2 = Integer.parseInt(stringArray[0]);
                        string = stringArray[1];
                    }
                    if ((long)(n2 + 1) > l) {
                        bufferedReader.close();
                        throw new PrismException("Too many values in file \"" + file + "\" (more than " + l + ")");
                    }
                    double d = Double.parseDouble(string);
                    this.setElement(n2, d);
                    ++n2;
                }
                string = bufferedReader.readLine();
                ++n;
            }
            bufferedReader.close();
            if (!bl && (long)n2 < l) {
                throw new PrismException("Too few values in file \"" + file + "\" (" + n2 + ", not " + l + ")");
            }
        }
        catch (IOException iOException) {
            throw new PrismException("File I/O error reading from \"" + file + "\"");
        }
        catch (NumberFormatException numberFormatException) {
            throw new PrismException("Error detected at line " + n + " of file \"" + file + "\"");
        }
    }

    @Override
    public void roundOff(int n) {
        this.values = JDD.RoundOff(this.values, n);
    }

    @Override
    public void subtractFromOne() {
        JDD.Ref(this.reach);
        this.values = JDD.Apply(2, this.reach, this.values);
    }

    @Override
    public void add(StateValues stateValues) {
        StateValuesMTBDD stateValuesMTBDD = (StateValuesMTBDD)stateValues;
        JDD.Ref(stateValuesMTBDD.values);
        this.values = JDD.Apply(1, this.values, stateValuesMTBDD.values);
    }

    @Override
    public void timesConstant(double d) {
        this.values = JDD.Apply(3, this.values, JDD.Constant(d));
    }

    @Override
    public double dotProduct(StateValues stateValues) {
        StateValuesMTBDD stateValuesMTBDD = (StateValuesMTBDD)stateValues;
        JDD.Ref(this.values);
        JDD.Ref(stateValuesMTBDD.values);
        JDDNode jDDNode = JDD.Apply(3, this.values, stateValuesMTBDD.values);
        jDDNode = JDD.SumAbstract(jDDNode, this.vars);
        double d = JDD.FindMax(jDDNode);
        JDD.Deref(jDDNode);
        return d;
    }

    @Override
    public void filter(JDDNode jDDNode) {
        JDD.Ref(jDDNode);
        this.values = JDD.Apply(3, this.values, jDDNode);
    }

    @Override
    public void maxMTBDD(JDDNode jDDNode) {
        JDD.Ref(jDDNode);
        this.values = JDD.Apply(6, this.values, jDDNode);
    }

    @Override
    public void clear() {
        JDD.Deref(this.values);
    }

    @Override
    public int getSize() {
        return (int)this.model.getNumStates();
    }

    @Override
    public Object getValue(int n) {
        JDDNode jDDNode = this.values;
        ODDNode oDDNode = this.odd;
        int n2 = 0;
        for (int i = 0; i < this.numVars; ++i) {
            if (oDDNode.getEOff() > (long)(n - n2)) {
                jDDNode = jDDNode.getIndex() > this.vars.getVarIndex(i) ? jDDNode : jDDNode.getElse();
                oDDNode = oDDNode.getElse();
                continue;
            }
            jDDNode = jDDNode.getIndex() > this.vars.getVarIndex(i) ? jDDNode : jDDNode.getThen();
            n2 = (int)((long)n2 + oDDNode.getEOff());
            oDDNode = oDDNode.getThen();
        }
        return jDDNode.getValue();
    }

    public JDDNode getJDDNode() {
        return this.values;
    }

    @Override
    public int getNNZ() {
        double d = JDD.GetNumMinterms(this.values, this.numDDRowVars);
        return d > 2.147483647E9 ? -1 : (int)Math.round(d);
    }

    @Override
    public String getNNZString() {
        return "" + this.getNNZ();
    }

    @Override
    public double firstFromBDD(JDDNode jDDNode) {
        JDD.Ref(jDDNode);
        JDD.Ref(this.reach);
        JDDNode jDDNode2 = JDD.And(jDDNode, this.reach);
        if (jDDNode2.equals(JDD.ZERO)) {
            return Double.NaN;
        }
        jDDNode2 = JDD.RestrictToFirst(jDDNode2, this.vars);
        JDD.Ref(this.values);
        jDDNode2 = JDD.Apply(3, this.values, jDDNode2);
        jDDNode2 = JDD.SumAbstract(jDDNode2, this.vars);
        double d = jDDNode2.getValue();
        JDD.Deref(jDDNode2);
        return d;
    }

    @Override
    public double minOverBDD(JDDNode jDDNode) {
        JDD.Ref(jDDNode);
        JDD.Ref(this.reach);
        JDDNode jDDNode2 = JDD.And(jDDNode, this.reach);
        if (jDDNode2.equals(JDD.ZERO)) {
            return Double.POSITIVE_INFINITY;
        }
        JDD.Ref(this.values);
        jDDNode2 = JDD.ITE(jDDNode2, this.values, JDD.PlusInfinity());
        double d = JDD.FindMin(jDDNode2);
        JDD.Deref(jDDNode2);
        return d;
    }

    @Override
    public double maxOverBDD(JDDNode jDDNode) {
        JDD.Ref(jDDNode);
        JDD.Ref(this.reach);
        JDDNode jDDNode2 = JDD.And(jDDNode, this.reach);
        if (jDDNode2.equals(JDD.ZERO)) {
            return Double.NEGATIVE_INFINITY;
        }
        JDD.Ref(this.values);
        jDDNode2 = JDD.ITE(jDDNode2, this.values, JDD.MinusInfinity());
        double d = JDD.FindMax(jDDNode2);
        JDD.Deref(jDDNode2);
        return d;
    }

    @Override
    public double sumOverBDD(JDDNode jDDNode) {
        JDD.Ref(this.values);
        JDD.Ref(jDDNode);
        JDDNode jDDNode2 = JDD.Apply(3, this.values, jDDNode);
        jDDNode2 = JDD.SumAbstract(jDDNode2, this.vars);
        double d = jDDNode2.getValue();
        JDD.Deref(jDDNode2);
        return d;
    }

    @Override
    public double sumOverMTBDD(JDDNode jDDNode) {
        JDD.Ref(this.values);
        JDD.Ref(jDDNode);
        JDDNode jDDNode2 = JDD.Apply(3, this.values, jDDNode);
        jDDNode2 = JDD.SumAbstract(jDDNode2, this.vars);
        double d = jDDNode2.getValue();
        JDD.Deref(jDDNode2);
        return d;
    }

    @Override
    public StateValues sumOverDDVars(JDDVars jDDVars, Model model) {
        JDD.Ref(this.values);
        JDDNode jDDNode = JDD.SumAbstract(this.values, jDDVars);
        return new StateValuesMTBDD(jDDNode, model);
    }

    @Override
    public JDDNode getBDDFromInterval(String string, double d) {
        return this.getBDDFromInterval(RelOp.parseSymbol(string), d);
    }

    @Override
    public JDDNode getBDDFromInterval(RelOp relOp, double d) {
        JDDNode jDDNode = null;
        JDD.Ref(this.values);
        switch (relOp) {
            case GEQ: {
                jDDNode = JDD.GreaterThanEquals(this.values, d);
                break;
            }
            case GT: {
                jDDNode = JDD.GreaterThan(this.values, d);
                break;
            }
            case LEQ: {
                jDDNode = JDD.LessThanEquals(this.values, d);
                break;
            }
            case LT: {
                jDDNode = JDD.LessThan(this.values, d);
            }
        }
        return jDDNode;
    }

    @Override
    public JDDNode getBDDFromInterval(double d, double d2) {
        JDD.Ref(this.values);
        JDDNode jDDNode = JDD.Interval(this.values, d, d2);
        return jDDNode;
    }

    @Override
    public JDDNode getBDDFromCloseValue(double d, double d2, boolean bl) {
        if (bl) {
            return this.getBDDFromCloseValueAbs(d, d2);
        }
        return this.getBDDFromCloseValueRel(d, d2);
    }

    @Override
    public JDDNode getBDDFromCloseValueAbs(double d, double d2) {
        JDD.Ref(this.values);
        JDDNode jDDNode = JDD.Interval(this.values, d - d2, d + d2);
        return jDDNode;
    }

    @Override
    public JDDNode getBDDFromCloseValueRel(double d, double d2) {
        JDD.Ref(this.values);
        JDDNode jDDNode = JDD.Interval(this.values, d - d2, d + d2);
        return jDDNode;
    }

    @Override
    public void print(PrismLog prismLog) throws PrismException {
        if (this.values.equals(JDD.ZERO)) {
            prismLog.println("(all zero)");
            return;
        }
        this.outputLog = prismLog;
        for (int i = 0; i < this.varList.getNumVars(); ++i) {
            this.varValues[i] = 0;
        }
        this.currentVar = 0;
        this.currentVarLevel = 0;
        this.printRec(this.values, 0, this.odd, 0L);
    }

    @Override
    public void print(PrismLog prismLog, boolean bl, boolean bl2, boolean bl3) throws PrismException {
        this.print(prismLog, bl, bl2, bl3, true);
    }

    @Override
    public void print(PrismLog prismLog, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws PrismException {
        if (!bl) {
            throw new PrismException("Not supported");
        }
        this.print(prismLog);
    }

    private void printRec(JDDNode jDDNode, int n, ODDNode oDDNode, long l) {
        JDDNode jDDNode2;
        JDDNode jDDNode3;
        if (jDDNode.equals(JDD.ZERO)) {
            return;
        }
        if (n == this.numVars) {
            this.outputLog.print(l + ":(");
            int n2 = this.varList.getNumVars();
            for (int i = 0; i < n2; ++i) {
                if (this.varList.getType(i) instanceof TypeInt) {
                    this.outputLog.print(this.varValues[i] + this.varList.getLow(i));
                } else {
                    this.outputLog.print(this.varValues[i] == 1);
                }
                if (i >= n2 - 1) continue;
                this.outputLog.print(",");
            }
            this.outputLog.print(")=" + jDDNode.getValue());
            this.outputLog.println();
            return;
        }
        if (jDDNode.getIndex() > this.vars.getVarIndex(n)) {
            jDDNode2 = jDDNode3 = jDDNode;
        } else {
            jDDNode2 = jDDNode.getElse();
            jDDNode3 = jDDNode.getThen();
        }
        ++this.currentVarLevel;
        if (this.currentVarLevel == this.varSizes[this.currentVar]) {
            ++this.currentVar;
            this.currentVarLevel = 0;
        }
        this.printRec(jDDNode2, n + 1, oDDNode.getElse(), l);
        --this.currentVarLevel;
        if (this.currentVarLevel == -1) {
            --this.currentVar;
            this.currentVarLevel = this.varSizes[this.currentVar] - 1;
        }
        int n3 = this.currentVar;
        this.varValues[n3] = this.varValues[n3] + (1 << this.varSizes[this.currentVar] - 1 - this.currentVarLevel);
        ++this.currentVarLevel;
        if (this.currentVarLevel == this.varSizes[this.currentVar]) {
            ++this.currentVar;
            this.currentVarLevel = 0;
        }
        this.printRec(jDDNode3, n + 1, oDDNode.getThen(), l + oDDNode.getEOff());
        --this.currentVarLevel;
        if (this.currentVarLevel == -1) {
            --this.currentVar;
            this.currentVarLevel = this.varSizes[this.currentVar] - 1;
        }
        int n4 = this.currentVar;
        this.varValues[n4] = this.varValues[n4] - (1 << this.varSizes[this.currentVar] - 1 - this.currentVarLevel);
    }

    @Override
    public void printFiltered(PrismLog prismLog, JDDNode jDDNode) throws PrismException {
        JDD.Ref(this.values);
        JDD.Ref(jDDNode);
        JDDNode jDDNode2 = JDD.Apply(3, this.values, jDDNode);
        if (jDDNode2.equals(JDD.ZERO)) {
            JDD.Deref(jDDNode2);
            prismLog.println("(all zero)");
            return;
        }
        this.outputLog = prismLog;
        for (int i = 0; i < this.varList.getNumVars(); ++i) {
            this.varValues[i] = 0;
        }
        this.currentVar = 0;
        this.currentVarLevel = 0;
        this.printRec(jDDNode2, 0, this.odd, 0L);
        JDD.Deref(jDDNode2);
    }

    @Override
    public void printFiltered(PrismLog prismLog, JDDNode jDDNode, boolean bl, boolean bl2, boolean bl3) throws PrismException {
        if (!bl) {
            throw new PrismException("Not supported");
        }
        this.printFiltered(prismLog, jDDNode);
    }

    @Override
    public StateValuesMTBDD deepCopy() throws PrismException {
        JDD.Ref(this.values);
        return new StateValuesMTBDD(this.values, this.model);
    }
}

