/*
 * Decompiled with CFR 0.152.
 */
package prism;

import dv.DoubleVector;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.constant.Constable;
import java.util.List;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;
import mtbdd.PrismMTBDD;
import odd.ODDNode;
import odd.ODDUtils;
import parser.Values;
import parser.VarList;
import parser.ast.Expression;
import parser.ast.ExpressionBinaryOp;
import parser.ast.ExpressionConstant;
import parser.ast.ExpressionFilter;
import parser.ast.ExpressionFormula;
import parser.ast.ExpressionFunc;
import parser.ast.ExpressionITE;
import parser.ast.ExpressionIdent;
import parser.ast.ExpressionLabel;
import parser.ast.ExpressionLiteral;
import parser.ast.ExpressionProp;
import parser.ast.ExpressionUnaryOp;
import parser.ast.ExpressionVar;
import parser.ast.LabelList;
import parser.ast.PropertiesFile;
import parser.ast.Property;
import parser.type.TypeBool;
import parser.type.TypeDouble;
import parser.type.TypeInt;
import parser.type.TypeVoid;
import prism.Filter;
import prism.Interval;
import prism.Model;
import prism.ModelChecker;
import prism.ModelType;
import prism.NonProbModelChecker;
import prism.NondetModelChecker;
import prism.Prism;
import prism.PrismException;
import prism.PrismLangException;
import prism.PrismLog;
import prism.PrismUtils;
import prism.ProbModel;
import prism.ProbModelChecker;
import prism.Result;
import prism.StateListMTBDD;
import prism.StateValues;
import prism.StateValuesDV;
import prism.StateValuesMTBDD;
import prism.StateValuesVoid;
import prism.StochModelChecker;

public class StateModelChecker
implements ModelChecker {
    protected Prism prism;
    protected PrismLog mainLog;
    protected PrismLog techLog;
    protected PropertiesFile propertiesFile;
    protected Values constantValues;
    protected Model model;
    protected VarList varList;
    protected JDDNode trans;
    protected JDDNode trans01;
    protected JDDNode transActions;
    protected JDDNode start;
    protected JDDNode reach;
    protected ODDNode odd;
    protected JDDVars allDDRowVars;
    protected JDDVars allDDColVars;
    protected JDDVars[] varDDRowVars;
    protected Filter currentFilter;
    protected Result result;
    protected int engine;
    protected double termCritParam;
    protected boolean verbose;
    protected boolean storeVector = false;
    protected boolean genStrat = false;

    public StateModelChecker(Prism prism, Model model, PropertiesFile propertiesFile) throws PrismException {
        this.prism = prism;
        this.mainLog = prism.getMainLog();
        this.techLog = prism.getTechLog();
        this.model = model;
        this.propertiesFile = propertiesFile;
        this.constantValues = new Values();
        this.constantValues.addValues(this.model.getConstantValues());
        if (propertiesFile != null) {
            this.constantValues.addValues(propertiesFile.getConstantValues());
        }
        this.varList = this.model.getVarList();
        this.trans = this.model.getTrans();
        this.trans01 = this.model.getTrans01();
        this.transActions = this.model.getTransActions();
        this.start = this.model.getStart();
        this.reach = this.model.getReach();
        this.odd = this.model.getODD();
        this.allDDRowVars = this.model.getAllDDRowVars();
        this.allDDColVars = this.model.getAllDDColVars();
        this.varDDRowVars = this.model.getVarDDRowVars();
        this.engine = prism.getEngine();
        this.termCritParam = prism.getTermCritParam();
        this.verbose = prism.getVerbose();
        this.storeVector = prism.getStoreVector();
        this.genStrat = prism.getGenStrat();
    }

    public StateModelChecker(Prism prism, VarList varList, JDDVars jDDVars, JDDVars[] jDDVarsArray, Values values) throws PrismException {
        this.prism = prism;
        this.mainLog = prism.getMainLog();
        this.techLog = prism.getTechLog();
        this.varList = varList;
        this.varDDRowVars = jDDVarsArray;
        this.constantValues = values;
        this.reach = null;
        jDDVars.refAll();
        this.model = new ProbModel(JDD.Constant(0.0), JDD.Constant(0.0), new JDDNode[0], new JDDNode[0], null, jDDVars, new JDDVars(), null, 0, null, null, null, 0, varList, jDDVarsArray, null, values);
    }

    public static StateModelChecker createModelChecker(ModelType modelType, Prism prism, Model model, PropertiesFile propertiesFile) throws PrismException {
        NonProbModelChecker nonProbModelChecker = null;
        switch (modelType) {
            case DTMC: {
                nonProbModelChecker = new ProbModelChecker(prism, model, propertiesFile);
                break;
            }
            case MDP: {
                nonProbModelChecker = new NondetModelChecker(prism, model, propertiesFile);
                break;
            }
            case CTMC: {
                nonProbModelChecker = new StochModelChecker(prism, model, propertiesFile);
                break;
            }
            default: {
                throw new PrismException("Cannot create model checker for model type " + (Object)((Object)modelType));
            }
        }
        return nonProbModelChecker;
    }

    public void clearDummyModel() {
        this.model.clear();
    }

    @Override
    public Result check(Expression expression) throws PrismException {
        long l = 0L;
        this.result = new Result();
        this.currentFilter = null;
        ExpressionFilter expressionFilter = ExpressionFilter.addDefaultFilterIfNeeded(expression, this.model.getNumStartStates() == 1L);
        if (this.storeVector) {
            expressionFilter.setStoreVector(true);
        }
        expression = expressionFilter;
        l = System.currentTimeMillis();
        StateValues stateValues = this.checkExpression(expression);
        l = System.currentTimeMillis() - l;
        this.mainLog.println("\nTime for model checking: " + (double)l / 1000.0 + " seconds.");
        String string = "Result";
        if (!"Result".equals(expression.getResultName())) {
            string = string + " (" + expression.getResultName().toLowerCase() + ")";
        }
        string = string + ": " + this.result.getResultString();
        this.mainLog.print("\n" + string + "\n");
        stateValues.clear();
        return this.result;
    }

    @Override
    public StateValues checkExpression(Expression expression) throws PrismException {
        StateValues stateValues;
        if (expression instanceof ExpressionITE) {
            stateValues = this.checkExpressionITE((ExpressionITE)expression);
        } else if (expression instanceof ExpressionBinaryOp) {
            stateValues = this.checkExpressionBinaryOp((ExpressionBinaryOp)expression);
        } else if (expression instanceof ExpressionUnaryOp) {
            stateValues = this.checkExpressionUnaryOp((ExpressionUnaryOp)expression);
        } else if (expression instanceof ExpressionFunc) {
            stateValues = this.checkExpressionFunc((ExpressionFunc)expression);
        } else {
            if (expression instanceof ExpressionIdent) {
                throw new PrismException("Unknown identifier \"" + ((ExpressionIdent)expression).getName() + "\"");
            }
            if (expression instanceof ExpressionLiteral) {
                stateValues = this.checkExpressionLiteral((ExpressionLiteral)expression);
            } else if (expression instanceof ExpressionConstant) {
                stateValues = this.checkExpressionConstant((ExpressionConstant)expression);
            } else {
                if (expression instanceof ExpressionFormula) {
                    if (((ExpressionFormula)expression).getDefinition() != null) {
                        return this.checkExpression(((ExpressionFormula)expression).getDefinition());
                    }
                    throw new PrismException("Unexpanded formula \"" + ((ExpressionFormula)expression).getName() + "\"");
                }
                if (expression instanceof ExpressionVar) {
                    stateValues = this.checkExpressionVar((ExpressionVar)expression);
                } else if (expression instanceof ExpressionLabel) {
                    stateValues = this.checkExpressionLabel((ExpressionLabel)expression);
                } else if (expression instanceof ExpressionProp) {
                    stateValues = this.checkExpressionProp((ExpressionProp)expression);
                } else if (expression instanceof ExpressionFilter) {
                    stateValues = this.checkExpressionFilter((ExpressionFilter)expression);
                } else {
                    throw new PrismException("Couldn't check " + expression.getClass());
                }
            }
        }
        if (stateValues instanceof StateValuesMTBDD && this.reach != null) {
            stateValues.filter(this.reach);
        }
        return stateValues;
    }

    @Override
    public JDDNode checkExpressionDD(Expression expression) throws PrismException {
        return this.checkExpression(expression).convertToStateValuesMTBDD().getJDDNode();
    }

    protected StateValues checkExpressionITE(ExpressionITE expressionITE) throws PrismException {
        StateValues stateValues = null;
        StateValues stateValues2 = null;
        StateValues stateValues3 = null;
        try {
            stateValues = this.checkExpression(expressionITE.getOperand1());
            stateValues2 = this.checkExpression(expressionITE.getOperand2());
            stateValues3 = this.checkExpression(expressionITE.getOperand3());
        }
        catch (PrismException prismException) {
            if (stateValues != null) {
                stateValues.clear();
            }
            if (stateValues2 != null) {
                stateValues2.clear();
            }
            throw prismException;
        }
        JDDNode jDDNode = stateValues.convertToStateValuesMTBDD().getJDDNode();
        if (stateValues2 instanceof StateValuesMTBDD && stateValues3 instanceof StateValuesMTBDD) {
            JDDNode jDDNode2 = ((StateValuesMTBDD)stateValues2).getJDDNode();
            JDDNode jDDNode3 = ((StateValuesMTBDD)stateValues3).getJDDNode();
            JDDNode jDDNode4 = JDD.ITE(jDDNode, jDDNode2, jDDNode3);
            return new StateValuesMTBDD(jDDNode4, this.model);
        }
        DoubleVector doubleVector = stateValues2.convertToStateValuesDV().getDoubleVector();
        doubleVector.filter(jDDNode, this.allDDRowVars, this.odd);
        DoubleVector doubleVector2 = stateValues3.convertToStateValuesDV().getDoubleVector();
        jDDNode = JDD.Not(jDDNode);
        doubleVector2.filter(jDDNode, this.allDDRowVars, this.odd);
        doubleVector.add(doubleVector2);
        doubleVector2.clear();
        JDD.Deref(jDDNode);
        return new StateValuesDV(doubleVector, this.model);
    }

    protected StateValues checkExpressionBinaryOp(ExpressionBinaryOp expressionBinaryOp) throws PrismException {
        StateValues stateValues = null;
        StateValues stateValues2 = null;
        int n = expressionBinaryOp.getOperator();
        if (n >= 5 && n <= 10) {
            return this.checkExpressionRelOp(n, expressionBinaryOp.getOperand1(), expressionBinaryOp.getOperand2());
        }
        try {
            stateValues = this.checkExpression(expressionBinaryOp.getOperand1());
            stateValues2 = this.checkExpression(expressionBinaryOp.getOperand2());
        }
        catch (PrismException prismException) {
            if (stateValues != null) {
                stateValues.clear();
            }
            throw prismException;
        }
        if (stateValues instanceof StateValuesMTBDD && stateValues2 instanceof StateValuesMTBDD) {
            JDDNode jDDNode;
            JDDNode jDDNode2 = ((StateValuesMTBDD)stateValues).getJDDNode();
            JDDNode jDDNode3 = ((StateValuesMTBDD)stateValues2).getJDDNode();
            switch (n) {
                case 1: {
                    jDDNode = JDD.Or(JDD.Not(jDDNode2), jDDNode3);
                    break;
                }
                case 2: {
                    jDDNode = JDD.Not(JDD.Xor(jDDNode2, jDDNode3));
                    break;
                }
                case 3: {
                    jDDNode = JDD.Or(jDDNode2, jDDNode3);
                    break;
                }
                case 4: {
                    jDDNode = JDD.And(jDDNode2, jDDNode3);
                    break;
                }
                case 11: {
                    jDDNode = JDD.Apply(1, jDDNode2, jDDNode3);
                    break;
                }
                case 12: {
                    jDDNode = JDD.Apply(2, jDDNode2, jDDNode3);
                    break;
                }
                case 13: {
                    jDDNode = JDD.Apply(3, jDDNode2, jDDNode3);
                    break;
                }
                case 14: {
                    jDDNode = JDD.Apply(4, jDDNode2, jDDNode3);
                    break;
                }
                default: {
                    throw new PrismException("Unknown binary operator");
                }
            }
            return new StateValuesMTBDD(jDDNode, this.model);
        }
        DoubleVector doubleVector = stateValues.convertToStateValuesDV().getDoubleVector();
        DoubleVector doubleVector2 = stateValues2.convertToStateValuesDV().getDoubleVector();
        int n2 = doubleVector.getSize();
        switch (n) {
            case 1: 
            case 3: 
            case 4: {
                throw new PrismException("Internal error: Explicit evaluation of Boolean");
            }
            case 11: {
                for (int i = 0; i < n2; ++i) {
                    doubleVector.setElement(i, doubleVector.getElement(i) + doubleVector2.getElement(i));
                }
                break;
            }
            case 12: {
                for (int i = 0; i < n2; ++i) {
                    doubleVector.setElement(i, doubleVector.getElement(i) - doubleVector2.getElement(i));
                }
                break;
            }
            case 13: {
                for (int i = 0; i < n2; ++i) {
                    doubleVector.setElement(i, doubleVector.getElement(i) * doubleVector2.getElement(i));
                }
                break;
            }
            case 14: {
                for (int i = 0; i < n2; ++i) {
                    doubleVector.setElement(i, doubleVector.getElement(i) / doubleVector2.getElement(i));
                }
                break;
            }
            default: {
                throw new PrismException("Unknown binary operator");
            }
        }
        doubleVector2.clear();
        return new StateValuesDV(doubleVector, this.model);
    }

    protected StateValues checkExpressionRelOp(int n, Expression expression, Expression expression2) throws PrismException {
        JDDNode jDDNode;
        StateValues stateValues = null;
        StateValues stateValues2 = null;
        if (expression instanceof ExpressionVar && expression2.isConstant() && expression2.getType() instanceof TypeInt) {
            ExpressionVar expressionVar = (ExpressionVar)expression;
            Expression expression3 = expression2;
            String string = expressionVar.getName();
            int n2 = this.varList.getIndex(string);
            if (n2 == -1) {
                throw new PrismException("Unknown variable \"" + string + "\"");
            }
            int n3 = this.varList.getLow(n2);
            int n4 = this.varList.getHigh(n2);
            JDDNode jDDNode2 = JDD.Constant(0.0);
            int n5 = expression3.evaluateInt(this.constantValues);
            switch (n) {
                case 5: {
                    if (n5 < n3 || n5 > n4) break;
                    jDDNode2 = JDD.SetVectorElement(jDDNode2, this.varDDRowVars[n2], n5 - n3, 1.0);
                    break;
                }
                case 6: {
                    if (n5 >= n3 && n5 <= n4) {
                        jDDNode2 = JDD.SetVectorElement(jDDNode2, this.varDDRowVars[n2], n5 - n3, 1.0);
                    }
                    jDDNode2 = JDD.Not(jDDNode2);
                    break;
                }
                case 7: {
                    for (int i = n5 + 1; i <= n4; ++i) {
                        jDDNode2 = JDD.SetVectorElement(jDDNode2, this.varDDRowVars[n2], i - n3, 1.0);
                    }
                    break;
                }
                case 8: {
                    for (int i = n5; i <= n4; ++i) {
                        jDDNode2 = JDD.SetVectorElement(jDDNode2, this.varDDRowVars[n2], i - n3, 1.0);
                    }
                    break;
                }
                case 9: {
                    for (int i = n5 - 1; i >= n3; --i) {
                        jDDNode2 = JDD.SetVectorElement(jDDNode2, this.varDDRowVars[n2], i - n3, 1.0);
                    }
                    break;
                }
                case 10: {
                    for (int i = n5; i >= n3; --i) {
                        jDDNode2 = JDD.SetVectorElement(jDDNode2, this.varDDRowVars[n2], i - n3, 1.0);
                    }
                    break;
                }
                default: {
                    throw new PrismException("Unknown relational operator");
                }
            }
            return new StateValuesMTBDD(jDDNode2, this.model);
        }
        if (expression.isConstant() && expression.getType() instanceof TypeInt && expression2 instanceof ExpressionVar) {
            Expression expression4 = expression;
            ExpressionVar expressionVar = (ExpressionVar)expression2;
            String string = expressionVar.getName();
            int n6 = this.varList.getIndex(string);
            if (n6 == -1) {
                throw new PrismException("Unknown variable \"" + string + "\"");
            }
            int n7 = this.varList.getLow(n6);
            int n8 = this.varList.getHigh(n6);
            JDDNode jDDNode3 = JDD.Constant(0.0);
            int n9 = expression4.evaluateInt(this.constantValues);
            switch (n) {
                case 5: {
                    if (n9 < n7 || n9 > n8) break;
                    jDDNode3 = JDD.SetVectorElement(jDDNode3, this.varDDRowVars[n6], n9 - n7, 1.0);
                    break;
                }
                case 6: {
                    if (n9 >= n7 && n9 <= n8) {
                        jDDNode3 = JDD.SetVectorElement(jDDNode3, this.varDDRowVars[n6], n9 - n7, 1.0);
                    }
                    jDDNode3 = JDD.Not(jDDNode3);
                    break;
                }
                case 7: {
                    for (int i = n9 - 1; i >= n7; --i) {
                        jDDNode3 = JDD.SetVectorElement(jDDNode3, this.varDDRowVars[n6], i - n7, 1.0);
                    }
                    break;
                }
                case 8: {
                    for (int i = n9; i >= n7; --i) {
                        jDDNode3 = JDD.SetVectorElement(jDDNode3, this.varDDRowVars[n6], i - n7, 1.0);
                    }
                    break;
                }
                case 9: {
                    for (int i = n9 + 1; i <= n8; ++i) {
                        jDDNode3 = JDD.SetVectorElement(jDDNode3, this.varDDRowVars[n6], i - n7, 1.0);
                    }
                    break;
                }
                case 10: {
                    for (int i = n9; i <= n8; ++i) {
                        jDDNode3 = JDD.SetVectorElement(jDDNode3, this.varDDRowVars[n6], i - n7, 1.0);
                    }
                    break;
                }
                default: {
                    throw new PrismException("Unknown relational operator");
                }
            }
            return new StateValuesMTBDD(jDDNode3, this.model);
        }
        try {
            stateValues = this.checkExpression(expression);
            stateValues2 = this.checkExpression(expression2);
        }
        catch (PrismException prismException) {
            if (stateValues != null) {
                stateValues.clear();
            }
            throw prismException;
        }
        JDDNode jDDNode4 = stateValues.convertToStateValuesMTBDD().getJDDNode();
        JDDNode jDDNode5 = stateValues2.convertToStateValuesMTBDD().getJDDNode();
        switch (n) {
            case 5: {
                jDDNode = JDD.Apply(7, jDDNode4, jDDNode5);
                break;
            }
            case 6: {
                jDDNode = JDD.Apply(8, jDDNode4, jDDNode5);
                break;
            }
            case 7: {
                jDDNode = JDD.Apply(9, jDDNode4, jDDNode5);
                break;
            }
            case 8: {
                jDDNode = JDD.Apply(10, jDDNode4, jDDNode5);
                break;
            }
            case 9: {
                jDDNode = JDD.Apply(11, jDDNode4, jDDNode5);
                break;
            }
            case 10: {
                jDDNode = JDD.Apply(12, jDDNode4, jDDNode5);
                break;
            }
            default: {
                throw new PrismException("Unknown relational operator");
            }
        }
        return new StateValuesMTBDD(jDDNode, this.model);
    }

    protected StateValues checkExpressionUnaryOp(ExpressionUnaryOp expressionUnaryOp) throws PrismException {
        StateValues stateValues = null;
        int n = expressionUnaryOp.getOperator();
        stateValues = this.checkExpression(expressionUnaryOp.getOperand());
        if (n == 3) {
            return stateValues;
        }
        if (stateValues instanceof StateValuesMTBDD) {
            JDDNode jDDNode;
            JDDNode jDDNode2 = ((StateValuesMTBDD)stateValues).getJDDNode();
            switch (n) {
                case 1: {
                    jDDNode = JDD.Not(jDDNode2);
                    break;
                }
                case 2: {
                    jDDNode = JDD.Apply(2, JDD.Constant(0.0), jDDNode2);
                    break;
                }
                default: {
                    throw new PrismException("Unknown unary operator");
                }
            }
            return new StateValuesMTBDD(jDDNode, this.model);
        }
        DoubleVector doubleVector = stateValues.convertToStateValuesDV().getDoubleVector();
        int n2 = doubleVector.getSize();
        switch (n) {
            case 1: {
                throw new PrismException("Internal error: Explicit evaluation of Boolean");
            }
            case 2: {
                for (int i = 0; i < n2; ++i) {
                    doubleVector.setElement(i, -doubleVector.getElement(i));
                }
                break;
            }
            default: {
                throw new PrismException("Unknown unary operator");
            }
        }
        return new StateValuesDV(doubleVector, this.model);
    }

    protected StateValues checkExpressionFunc(ExpressionFunc expressionFunc) throws PrismException {
        switch (expressionFunc.getNameCode()) {
            case 0: 
            case 1: {
                return this.checkExpressionFuncNary(expressionFunc);
            }
            case 2: 
            case 3: {
                return this.checkExpressionFuncUnary(expressionFunc);
            }
            case 4: 
            case 5: 
            case 6: {
                return this.checkExpressionFuncBinary(expressionFunc);
            }
            case 7: {
                throw new PrismException("Multi-objective model checking is not supported for " + (Object)((Object)this.model.getModelType()) + "s");
            }
        }
        throw new PrismException("Unrecognised function \"" + expressionFunc.getName() + "\"");
    }

    protected StateValues checkExpressionFuncUnary(ExpressionFunc expressionFunc) throws PrismException {
        StateValues stateValues = null;
        int n = expressionFunc.getNameCode();
        stateValues = this.checkExpression(expressionFunc.getOperand(0));
        if (stateValues instanceof StateValuesMTBDD) {
            JDDNode jDDNode = ((StateValuesMTBDD)stateValues).getJDDNode();
            switch (n) {
                case 2: {
                    jDDNode = JDD.MonadicApply(13, jDDNode);
                    break;
                }
                case 3: {
                    jDDNode = JDD.MonadicApply(14, jDDNode);
                }
            }
            return new StateValuesMTBDD(jDDNode, this.model);
        }
        DoubleVector doubleVector = stateValues.convertToStateValuesDV().getDoubleVector();
        int n2 = doubleVector.getSize();
        switch (n) {
            case 2: {
                for (int i = 0; i < n2; ++i) {
                    doubleVector.setElement(i, Math.floor(doubleVector.getElement(i)));
                }
                break;
            }
            case 3: {
                for (int i = 0; i < n2; ++i) {
                    doubleVector.setElement(i, Math.ceil(doubleVector.getElement(i)));
                }
                break;
            }
        }
        return new StateValuesDV(doubleVector, this.model);
    }

    protected StateValues checkExpressionFuncBinary(ExpressionFunc expressionFunc) throws PrismException {
        StateValues stateValues = null;
        StateValues stateValues2 = null;
        JDDNode jDDNode = null;
        int n = expressionFunc.getNameCode();
        double d = 0.0;
        try {
            stateValues = this.checkExpression(expressionFunc.getOperand(0));
            stateValues2 = this.checkExpression(expressionFunc.getOperand(1));
        }
        catch (PrismException prismException) {
            if (stateValues != null) {
                stateValues.clear();
            }
            throw prismException;
        }
        if (stateValues instanceof StateValuesMTBDD && stateValues2 instanceof StateValuesMTBDD) {
            JDDNode jDDNode2 = ((StateValuesMTBDD)stateValues).getJDDNode();
            JDDNode jDDNode3 = ((StateValuesMTBDD)stateValues2).getJDDNode();
            switch (n) {
                case 4: {
                    JDD.Ref(jDDNode2);
                    JDD.Ref(jDDNode3);
                    jDDNode = JDD.Apply(15, jDDNode2, jDDNode3);
                    if (expressionFunc.getType() instanceof TypeInt) {
                        JDD.Ref(jDDNode3);
                        jDDNode = JDD.ITE(JDD.LessThan(jDDNode3, 0.0), JDD.Constant(Double.NaN), jDDNode);
                        JDD.Ref(jDDNode);
                        jDDNode = JDD.ITE(JDD.GreaterThan(jDDNode, 2.147483647E9), JDD.Constant(Double.NaN), jDDNode);
                    }
                    JDD.Deref(jDDNode2);
                    JDD.Deref(jDDNode3);
                    break;
                }
                case 5: {
                    jDDNode = JDD.Apply(16, jDDNode2, jDDNode3);
                    break;
                }
                case 6: {
                    jDDNode = JDD.Apply(17, jDDNode2, jDDNode3);
                }
            }
            return new StateValuesMTBDD(jDDNode, this.model);
        }
        DoubleVector doubleVector = stateValues.convertToStateValuesDV().getDoubleVector();
        DoubleVector doubleVector2 = stateValues2.convertToStateValuesDV().getDoubleVector();
        int n2 = doubleVector.getSize();
        switch (n) {
            case 4: {
                if (expressionFunc.getType() instanceof TypeInt) {
                    for (int i = 0; i < n2; ++i) {
                        double d2 = doubleVector.getElement(i);
                        double d3 = doubleVector2.getElement(i);
                        double d4 = Math.pow(d2, d3);
                        doubleVector.setElement(i, d3 < 0.0 || d4 > 2.147483647E9 ? Double.NaN : d4);
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        doubleVector.setElement(i, Math.pow(doubleVector.getElement(i), doubleVector2.getElement(i)));
                    }
                }
                break;
            }
            case 5: {
                for (int i = 0; i < n2; ++i) {
                    double d5 = (int)doubleVector2.getElement(i);
                    d = d5 <= 0.0 ? Double.NaN : (double)((int)doubleVector.getElement(i) % (int)d5);
                    doubleVector.setElement(i, d < 0.0 ? d + d5 : d);
                }
                break;
            }
            case 6: {
                for (int i = 0; i < n2; ++i) {
                    doubleVector.setElement(i, PrismUtils.log(doubleVector.getElement(i), doubleVector2.getElement(i)));
                }
                break;
            }
        }
        doubleVector2.clear();
        return new StateValuesDV(doubleVector, this.model);
    }

    protected StateValues checkExpressionFuncNary(ExpressionFunc expressionFunc) throws PrismException {
        StateValues stateValues = null;
        StateValues stateValues2 = null;
        int n = expressionFunc.getNameCode();
        stateValues = this.checkExpression(expressionFunc.getOperand(0));
        int n2 = expressionFunc.getNumOperands();
        boolean bl = stateValues instanceof StateValuesMTBDD;
        for (int i = 1; i < n2; ++i) {
            try {
                stateValues2 = this.checkExpression(expressionFunc.getOperand(i));
            }
            catch (PrismException prismException) {
                if (stateValues2 != null) {
                    stateValues2.clear();
                }
                throw prismException;
            }
            if (!bl || !(stateValues2 instanceof StateValuesMTBDD)) {
                bl = false;
                DoubleVector doubleVector = stateValues.convertToStateValuesDV().getDoubleVector();
                DoubleVector doubleVector2 = stateValues2.convertToStateValuesDV().getDoubleVector();
                int n3 = doubleVector.getSize();
                switch (n) {
                    case 0: {
                        int n4;
                        for (n4 = 0; n4 < n3; ++n4) {
                            doubleVector.setElement(n4, Math.min(doubleVector.getElement(i), doubleVector2.getElement(i)));
                        }
                        break;
                    }
                    case 1: {
                        int n4;
                        for (n4 = 0; n4 < n3; ++n4) {
                            doubleVector.setElement(n4, Math.max(doubleVector.getElement(i), doubleVector2.getElement(i)));
                        }
                        break;
                    }
                }
                doubleVector2.clear();
                stateValues = new StateValuesDV(doubleVector, this.model);
                continue;
            }
            JDDNode jDDNode = ((StateValuesMTBDD)stateValues).getJDDNode();
            JDDNode jDDNode2 = ((StateValuesMTBDD)stateValues2).getJDDNode();
            switch (n) {
                case 0: {
                    jDDNode = JDD.Apply(5, jDDNode, jDDNode2);
                    break;
                }
                case 1: {
                    jDDNode = JDD.Apply(6, jDDNode, jDDNode2);
                }
            }
            stateValues = new StateValuesMTBDD(jDDNode, this.model);
        }
        return stateValues;
    }

    protected StateValues checkExpressionLiteral(ExpressionLiteral expressionLiteral) throws PrismException {
        JDDNode jDDNode;
        try {
            jDDNode = JDD.Constant(expressionLiteral.evaluateDouble());
        }
        catch (PrismLangException prismLangException) {
            throw new PrismException("Unknown literal type");
        }
        return new StateValuesMTBDD(jDDNode, this.model);
    }

    protected StateValues checkExpressionConstant(ExpressionConstant expressionConstant) throws PrismException {
        JDDNode jDDNode;
        int n = this.constantValues.getIndexOf(expressionConstant.getName());
        if (n == -1) {
            throw new PrismException("Couldn't evaluate constant \"" + expressionConstant.getName() + "\"");
        }
        try {
            jDDNode = JDD.Constant(this.constantValues.getDoubleValue(n));
        }
        catch (PrismLangException prismLangException) {
            throw new PrismException("Unknown type for constant \"" + expressionConstant.getName() + "\"");
        }
        return new StateValuesMTBDD(jDDNode, this.model);
    }

    protected StateValues checkExpressionVar(ExpressionVar expressionVar) throws PrismException {
        String string = expressionVar.getName();
        int n = this.varList.getIndex(string);
        if (n == -1) {
            throw new PrismException("Unknown variable \"" + string + "\"");
        }
        int n2 = this.varList.getLow(n);
        int n3 = this.varList.getHigh(n);
        JDDNode jDDNode = JDD.Constant(0.0);
        for (int i = n2; i <= n3; ++i) {
            jDDNode = JDD.SetVectorElement(jDDNode, this.varDDRowVars[n], i - n2, i);
        }
        return new StateValuesMTBDD(jDDNode, this.model);
    }

    protected StateValues checkExpressionLabel(ExpressionLabel expressionLabel) throws PrismException {
        if (expressionLabel.getName().equals("deadlock")) {
            JDDNode jDDNode = this.model.getDeadlocks();
            JDD.Ref(jDDNode);
            return new StateValuesMTBDD(jDDNode, this.model);
        }
        if (expressionLabel.getName().equals("init")) {
            JDDNode jDDNode = this.start;
            JDD.Ref(jDDNode);
            return new StateValuesMTBDD(jDDNode, this.model);
        }
        LabelList labelList = this.propertiesFile.getCombinedLabelList();
        int n = labelList.getLabelIndex(expressionLabel.getName());
        if (n == -1) {
            throw new PrismException("Unknown label \"" + expressionLabel.getName() + "\" in property");
        }
        return this.checkExpression(labelList.getLabel(n));
    }

    protected StateValues checkExpressionProp(ExpressionProp expressionProp) throws PrismException {
        Property property = this.propertiesFile.lookUpPropertyObjectByName(expressionProp.getName());
        if (property != null) {
            this.mainLog.println("\nModel checking : " + property);
            return this.checkExpression(property.getExpression());
        }
        throw new PrismException("Unknown property reference " + expressionProp);
    }

    protected StateValues checkExpressionFilter(ExpressionFilter expressionFilter) throws PrismException {
        StateListMTBDD stateListMTBDD;
        boolean bl;
        JDDNode jDDNode = null;
        StateValues stateValues = null;
        StateValues stateValues2 = null;
        JDDNode jDDNode2 = null;
        double d = 0.0;
        double d2 = 0.0;
        boolean bl2 = false;
        String string = null;
        Object object = null;
        Expression expression = expressionFilter.getFilter();
        if (expression == null) {
            expression = Expression.True();
        }
        String string2 = (bl = Expression.isTrue(expression)) ? "all states" : "states satisfying filter";
        jDDNode = this.checkExpressionDD(expression);
        StateListMTBDD stateListMTBDD2 = new StateListMTBDD(jDDNode, this.model);
        if (jDDNode.equals(JDD.ZERO)) {
            throw new PrismException("Filter satisfies no states");
        }
        boolean bl3 = expression instanceof ExpressionLabel && ((ExpressionLabel)expression).getName().equals("init");
        boolean bl4 = bl3 & this.model.getNumStartStates() == 1L;
        ExpressionFilter.FilterOperator filterOperator = expressionFilter.getOperatorType();
        this.currentFilter = filterOperator == ExpressionFilter.FilterOperator.STATE ? new Filter(Filter.FilterOperator.STATE, ODDUtils.GetIndexOfFirstFromDD(jDDNode, this.odd, this.allDDRowVars)) : (filterOperator == ExpressionFilter.FilterOperator.FORALL && bl3 && bl4 ? new Filter(Filter.FilterOperator.STATE, ODDUtils.GetIndexOfFirstFromDD(jDDNode, this.odd, this.allDDRowVars)) : (filterOperator == ExpressionFilter.FilterOperator.FIRST && bl3 && bl4 ? new Filter(Filter.FilterOperator.STATE, ODDUtils.GetIndexOfFirstFromDD(jDDNode, this.odd, this.allDDRowVars)) : null));
        stateValues = this.checkExpression(expressionFilter.getOperand());
        if (!bl3) {
            this.mainLog.println("\nStates satisfying filter " + expression + ": " + stateListMTBDD2.sizeString());
        }
        filterOperator = expressionFilter.getOperatorType();
        switch (filterOperator) {
            case PRINT: 
            case PRINTALL: {
                if (expressionFilter.getType() instanceof TypeBool) {
                    this.mainLog.print("\nSatisfying states");
                    this.mainLog.println(bl ? ":" : " that are also in filter " + expression + ":");
                    JDDNode jDDNode3 = stateValues.deepCopy().convertToStateValuesMTBDD().getJDDNode();
                    JDD.Ref(jDDNode);
                    jDDNode3 = JDD.And(jDDNode3, jDDNode);
                    new StateListMTBDD(jDDNode3, this.model).print(this.mainLog);
                    JDD.Deref(jDDNode3);
                } else if (filterOperator == ExpressionFilter.FilterOperator.PRINT) {
                    this.mainLog.println("\nResults (non-zero only) for filter " + expression + ":");
                    stateValues.printFiltered(this.mainLog, jDDNode);
                } else {
                    this.mainLog.println("\nResults (including zeros) for filter " + expression + ":");
                    stateValues.printFiltered(this.mainLog, jDDNode, false, false, true);
                }
                stateValues2 = stateValues;
                stateValues = null;
                break;
            }
            case MIN: {
                d = stateValues.minOverBDD(jDDNode);
                object = expressionFilter.getType() instanceof TypeInt ? (Number)new Integer((int)d) : (Number)new Double(d);
                stateValues2 = new StateValuesMTBDD(JDD.Constant(d), this.model);
                string = "Minimum value over " + string2;
                this.mainLog.println("\n" + string + ": " + object);
                jDDNode2 = stateValues.getBDDFromCloseValue(d, this.prism.getTermCritParam(), this.prism.getTermCrit() == 1);
                JDD.Ref(jDDNode);
                jDDNode2 = JDD.And(jDDNode2, jDDNode);
                break;
            }
            case MAX: {
                d = stateValues.maxOverBDD(jDDNode);
                object = expressionFilter.getType() instanceof TypeInt ? (Number)new Integer((int)d) : (Number)new Double(d);
                stateValues2 = new StateValuesMTBDD(JDD.Constant(d), this.model);
                string = "Maximum value over " + string2;
                this.mainLog.println("\n" + string + ": " + object);
                jDDNode2 = stateValues.getBDDFromCloseValue(d, this.prism.getTermCritParam(), this.prism.getTermCrit() == 1);
                JDD.Ref(jDDNode);
                jDDNode2 = JDD.And(jDDNode2, jDDNode);
                break;
            }
            case ARGMIN: {
                d = stateValues.minOverBDD(jDDNode);
                this.mainLog.print("\nMinimum value over " + string2 + ": ");
                this.mainLog.println(expressionFilter.getType() instanceof TypeInt ? (Number)new Integer((int)d) : (Number)new Double(d));
                jDDNode2 = stateValues.getBDDFromCloseValue(d, this.prism.getTermCritParam(), this.prism.getTermCrit() == 1);
                JDD.Ref(jDDNode);
                jDDNode2 = JDD.And(jDDNode2, jDDNode);
                stateValues2 = new StateValuesMTBDD(jDDNode2, this.model);
                this.mainLog.println("\nNumber of states with minimum value: " + stateValues2.getNNZString());
                jDDNode2 = null;
                break;
            }
            case ARGMAX: {
                d = stateValues.maxOverBDD(jDDNode);
                this.mainLog.print("\nMaximum value over " + string2 + ": ");
                this.mainLog.println(expressionFilter.getType() instanceof TypeInt ? (Number)new Integer((int)d) : (Number)new Double(d));
                jDDNode2 = stateValues.getBDDFromCloseValue(d, this.prism.getTermCritParam(), this.prism.getTermCrit() == 1);
                JDD.Ref(jDDNode);
                jDDNode2 = JDD.And(jDDNode2, jDDNode);
                stateValues2 = new StateValuesMTBDD(jDDNode2, this.model);
                this.mainLog.println("\nNumber of states with maximum value: " + stateValues2.getNNZString());
                jDDNode2 = null;
                break;
            }
            case COUNT: {
                stateValues.filter(jDDNode);
                d = stateValues.getNNZ();
                object = new Integer((int)d);
                stateValues2 = new StateValuesMTBDD(JDD.Constant(d), this.model);
                string = bl ? "Count of satisfying states" : "Count of satisfying states also in filter";
                this.mainLog.println("\n" + string + ": " + object);
                break;
            }
            case SUM: {
                d = stateValues.sumOverBDD(jDDNode);
                object = expressionFilter.getType() instanceof TypeInt ? (Number)new Integer((int)d) : (Number)new Double(d);
                stateValues2 = new StateValuesMTBDD(JDD.Constant(d), this.model);
                string = "Sum over " + string2;
                this.mainLog.println("\n" + string + ": " + object);
                break;
            }
            case AVG: {
                d = stateValues.sumOverBDD(jDDNode) / JDD.GetNumMinterms(jDDNode, this.allDDRowVars.n());
                object = new Double(d);
                stateValues2 = new StateValuesMTBDD(JDD.Constant(d), this.model);
                string = "Average over " + string2;
                this.mainLog.println("\n" + string + ": " + object);
                break;
            }
            case FIRST: {
                d = stateValues.firstFromBDD(jDDNode);
                object = expressionFilter.getType() instanceof TypeInt ? new Integer((int)d) : (expressionFilter.getType() instanceof TypeDouble ? (Constable)new Double(d) : (Constable)new Boolean(d > 0.0));
                stateValues2 = new StateValuesMTBDD(JDD.Constant(d), this.model);
                string = "Value in ";
                string = bl3 ? string + (bl4 ? "the initial state" : "first initial state") : string + (bl ? "the first state" : "first state satisfying filter");
                this.mainLog.println("\n" + string + ": " + object);
                break;
            }
            case RANGE: {
                d = stateValues.minOverBDD(jDDNode);
                d2 = stateValues.maxOverBDD(jDDNode);
                object = expressionFilter.getOperand().getType() instanceof TypeInt ? new Interval((int)d, (int)d2) : new Interval(d, d2);
                stateValues2 = stateValues;
                stateValues = null;
                string = "Range of values over ";
                string = string + (bl3 ? "initial states" : string2);
                this.mainLog.println("\n" + string + ": " + object);
                break;
            }
            case FORALL: {
                JDDNode jDDNode4 = stateValues.convertToStateValuesMTBDD().getJDDNode();
                this.mainLog.print("\nNumber of states satisfying " + expressionFilter.getOperand() + ": ");
                stateListMTBDD = new StateListMTBDD(jDDNode4, this.model);
                this.mainLog.print(stateListMTBDD.sizeString());
                this.mainLog.println(stateListMTBDD.includesAll(this.reach) ? " (all in model)" : "");
                JDD.Ref(jDDNode);
                jDDNode4 = JDD.And(jDDNode4, jDDNode);
                stateListMTBDD = new StateListMTBDD(jDDNode4, this.model);
                bl2 = jDDNode4.equals(jDDNode);
                object = new Boolean(bl2);
                stateValues2 = new StateValuesMTBDD(JDD.Constant(bl2 ? 1.0 : 0.0), this.model);
                stateValues = null;
                string = "Property " + (bl2 ? "" : "not ") + "satisfied in ";
                this.mainLog.print("\nProperty satisfied in " + stateListMTBDD.sizeString());
                if (bl3) {
                    string = bl4 ? string + "the initial state" : string + "all initial states";
                    this.mainLog.println(" of " + this.model.getNumStartStatesString() + " initial states.");
                } else if (bl) {
                    string = string + "all states";
                    this.mainLog.println(" of all " + this.model.getNumStatesString() + " states.");
                } else {
                    string = string + "all filter states";
                    this.mainLog.println(" of " + stateListMTBDD2.sizeString() + " filter states.");
                }
                JDD.Deref(jDDNode4);
                break;
            }
            case EXISTS: {
                JDDNode jDDNode5 = stateValues.convertToStateValuesMTBDD().getJDDNode();
                JDD.Ref(jDDNode);
                jDDNode5 = JDD.And(jDDNode5, jDDNode);
                bl2 = !jDDNode5.equals(JDD.ZERO);
                object = new Boolean(bl2);
                stateValues2 = new StateValuesMTBDD(JDD.Constant(bl2 ? 1.0 : 0.0), this.model);
                stateValues = null;
                string = "Property satisfied in ";
                string = bl ? string + (bl2 ? "at least one state" : "no states") : string + (bl2 ? "at least one filter state" : "no filter states");
                this.mainLog.println("\n" + string);
                JDD.Deref(jDDNode5);
                break;
            }
            case STATE: {
                if (stateListMTBDD2.size() != 1) {
                    String string3 = "Filter should be satisfied in exactly 1 state";
                    string3 = string3 + " (but \"" + expression + "\" is true in " + stateListMTBDD2.size() + " states)";
                    throw new PrismException(string3);
                }
                if (expressionFilter.getType() instanceof TypeVoid) {
                    object = ((StateValuesVoid)stateValues).getValue();
                    stateValues2 = stateValues;
                    stateValues = null;
                } else {
                    d = stateValues.firstFromBDD(jDDNode);
                    if (expressionFilter.getType() instanceof TypeInt) {
                        object = new Integer((int)d);
                    } else if (expressionFilter.getType() instanceof TypeDouble) {
                        object = new Double(d);
                    } else if (expressionFilter.getType() instanceof TypeBool) {
                        object = new Boolean(d > 0.0);
                    } else {
                        throw new PrismException("Don't know how to handle result of type " + expressionFilter.getType());
                    }
                    stateValues2 = new StateValuesMTBDD(JDD.Constant(d), this.model);
                }
                string = "Value in ";
                string = bl3 ? string + "the initial state" : string + "the filter state";
                this.mainLog.println("\n" + string + ": " + object);
                break;
            }
            default: {
                JDD.Deref(jDDNode);
                throw new PrismException("Unrecognised filter type \"" + expressionFilter.getOperatorName() + "\"");
            }
        }
        if (jDDNode2 != null) {
            stateListMTBDD = new StateListMTBDD(jDDNode2, this.model);
            this.mainLog.print("\nThere are " + stateListMTBDD.sizeString() + " states with ");
            this.mainLog.print((expressionFilter.getType() instanceof TypeDouble ? "(approximately) " : "") + "this value");
            if (!(this.verbose || stateListMTBDD.size() != -1 && stateListMTBDD.size() <= 10)) {
                this.mainLog.print(".\nThe first 10 states are displayed below. To view them all, enable verbose mode or use a print filter.\n");
                stateListMTBDD.print(this.mainLog, 10);
            } else {
                this.mainLog.print(":\n");
                stateListMTBDD.print(this.mainLog);
            }
            JDD.Deref(jDDNode2);
        }
        this.result.setResult(object);
        if (expressionFilter.getExplanationEnabled() && string != null) {
            this.result.setExplanation(string.toLowerCase());
        } else {
            this.result.setExplanation(null);
        }
        if (this.storeVector) {
            this.result.setVector(stateValues);
        } else if (stateValues != null) {
            stateValues.clear();
        }
        JDD.Deref(jDDNode);
        return stateValues2;
    }

    public JDDNode getStateRewardsByIndexObject(Object object, Model model, Values values) throws PrismException {
        JDDNode jDDNode = null;
        if (model.getNumRewardStructs() == 0) {
            throw new PrismException("Model has no rewards specified");
        }
        if (object == null) {
            jDDNode = model.getStateRewards(0);
        } else if (object instanceof Expression) {
            int n = ((Expression)object).evaluateInt(values);
            object = new Integer(n);
            jDDNode = model.getStateRewards(n - 1);
        } else if (object instanceof String) {
            jDDNode = model.getStateRewards((String)object);
        }
        if (jDDNode == null) {
            throw new PrismException("Invalid reward structure index \"" + object + "\"");
        }
        return jDDNode;
    }

    public JDDNode getTransitionRewardsByIndexObject(Object object, Model model, Values values) throws PrismException {
        JDDNode jDDNode = null;
        if (model.getNumRewardStructs() == 0) {
            throw new PrismException("Model has no rewards specified");
        }
        if (object == null) {
            jDDNode = model.getTransRewards(0);
        } else if (object instanceof Expression) {
            int n = ((Expression)object).evaluateInt(values);
            object = new Integer(n);
            jDDNode = model.getTransRewards(n - 1);
        } else if (object instanceof String) {
            jDDNode = model.getTransRewards((String)object);
        }
        if (jDDNode == null) {
            throw new PrismException("Invalid reward structure index \"" + object + "\"");
        }
        return jDDNode;
    }

    @Override
    public Values getConstantValues() {
        return this.constantValues;
    }

    public void exportLabels(List<String> list, int n, File file) throws PrismException, FileNotFoundException {
        int n2 = list.size();
        JDDNode[] jDDNodeArray = new JDDNode[n2];
        for (int i = 0; i < n2; ++i) {
            jDDNodeArray[i] = this.checkExpressionDD(new ExpressionLabel(list.get(i)));
        }
        String string = "l";
        String[] stringArray = list.toArray(new String[list.size()]);
        PrismMTBDD.ExportLabels(jDDNodeArray, stringArray, string, this.allDDRowVars, this.odd, n, file != null ? file.getPath() : null);
        for (int i = 0; i < n2; ++i) {
            JDD.Deref(jDDNodeArray[i]);
        }
    }
}

