/*
 * Decompiled with CFR 0.152.
 */
package prism;

import java.util.ArrayList;
import java.util.Vector;
import parser.Values;
import prism.DefinedConstant;
import prism.PrismException;
import prism.PrismLangException;
import prism.ResultListener;
import prism.ResultsExporter;
import prism.UndefinedConstants;

public class ResultsCollection {
    private Vector<DefinedConstant> rangingConstants;
    private int numMFRangingConstants;
    private int numPFRangingConstants;
    private Values nonRangingConstantValues;
    private TreeNode root;
    private int currentIteration = 0;
    private boolean anyErrors = false;
    private Vector<ResultListener> resultListeners = new Vector();
    private String resultName;

    public ResultsCollection(UndefinedConstants undefinedConstants) {
        this(undefinedConstants, null);
    }

    public ResultsCollection(UndefinedConstants undefinedConstants, String string) {
        this.rangingConstants = new Vector();
        Vector<DefinedConstant> vector = undefinedConstants.getRangingConstants();
        for (int i = 0; i < vector.size(); ++i) {
            this.rangingConstants.add(vector.get(i));
        }
        this.numMFRangingConstants = undefinedConstants.getNumModelRangingConstants();
        this.numPFRangingConstants = undefinedConstants.getNumPropertyRangingConstants();
        this.nonRangingConstantValues = undefinedConstants.getNonRangingConstantValues();
        this.root = this.rangingConstants.size() > 0 ? new TreeNode(0) : new TreeLeaf();
        this.resultName = string == null ? "Result" : string;
    }

    public Vector<DefinedConstant> getRangingConstants() {
        return this.rangingConstants;
    }

    public int getNumRangingConstants() {
        return this.rangingConstants.size();
    }

    public int getNumModelRangingConstants() {
        return this.numMFRangingConstants;
    }

    public int getNumPropertyRangingConstants() {
        return this.numPFRangingConstants;
    }

    public Values getNonRangingConstantValues() {
        return this.nonRangingConstantValues;
    }

    public boolean addResultListener(ResultListener resultListener) {
        return this.resultListeners.add(resultListener);
    }

    public boolean removeResultListener(ResultListener resultListener) {
        return this.resultListeners.removeElement(resultListener);
    }

    public int getCurrentIteration() {
        return this.currentIteration;
    }

    public String getResultName() {
        return this.resultName;
    }

    public int setResult(Values values, Object object) {
        int n = this.root.setResult(values, object);
        for (int i = 0; i < this.resultListeners.size(); ++i) {
            this.resultListeners.get(i).notifyResult(this, values, object);
        }
        this.currentIteration += n;
        if (object instanceof Exception) {
            this.anyErrors = true;
        }
        return n;
    }

    public int setResult(Values values, Values values2, Object object) {
        Values values3 = new Values();
        if (values != null) {
            values3.addValues(values);
        }
        if (values2 != null) {
            values3.addValues(values2);
        }
        return this.setResult(values3, object);
    }

    public int setMultipleErrors(Values values, Exception exception) {
        int n = this.root.setResult(values, exception);
        this.currentIteration += n;
        this.anyErrors = true;
        return n;
    }

    public int setMultipleErrors(Values values, Values values2, Exception exception) {
        Values values3 = new Values();
        if (values != null) {
            values3.addValues(values);
        }
        if (values2 != null) {
            values3.addValues(values2);
        }
        return this.setMultipleErrors(values3, exception);
    }

    public Object getResult(Values values) throws PrismException {
        return this.root.getResult(values);
    }

    public boolean containsErrors() {
        return this.anyErrors;
    }

    public String[] getHeadingsArray() {
        String[] stringArray = new String[this.rangingConstants.size() + 1];
        for (int i = 0; i < this.rangingConstants.size(); ++i) {
            stringArray[i] = this.rangingConstants.elementAt(i).getName();
        }
        stringArray[this.rangingConstants.size()] = "Result";
        return stringArray;
    }

    public ArrayList<String[]> toArrayList() {
        return this.root.toArrayList();
    }

    public String toString() {
        return this.toString(false, ",", ",", true);
    }

    public String toString(boolean bl, String string, String string2) {
        return this.toString(bl, string, string2, true);
    }

    public String toString(boolean bl, String string, String string2, boolean bl2) {
        String string3 = "";
        if (this.rangingConstants.size() == 0) {
            string2 = "";
        }
        if (bl2) {
            for (int i = 0; i < this.rangingConstants.size(); ++i) {
                if (i > 0) {
                    string3 = string3 + string;
                }
                string3 = string3 + this.rangingConstants.elementAt(i).getName();
            }
            string3 = string3 + string2 + "Result\n";
        }
        string3 = string3 + this.root.toString(bl, string, string2);
        return string3;
    }

    public ResultsExporter export(ResultsExporter resultsExporter) {
        resultsExporter.setRangingConstants(this.rangingConstants);
        resultsExporter.setNonRangingConstantValues(this.nonRangingConstantValues);
        resultsExporter.start();
        this.root.export(resultsExporter);
        resultsExporter.end();
        return resultsExporter;
    }

    public String toStringPartial(Values values, boolean bl, String string, String string2, boolean bl2) throws PrismException {
        int n;
        String string3 = "";
        if (values == null) {
            values = new Values();
        }
        boolean bl3 = true;
        for (n = 0; n < this.rangingConstants.size(); ++n) {
            if (values.contains(this.rangingConstants.elementAt(n).getName())) continue;
            bl3 = false;
            break;
        }
        if (bl3) {
            string2 = "";
        }
        if (bl2) {
            boolean bl4 = true;
            for (n = 0; n < this.rangingConstants.size(); ++n) {
                String string4 = this.rangingConstants.elementAt(n).getName();
                if (values.contains(string4)) continue;
                if (!bl4) {
                    string3 = string3 + string;
                }
                string3 = string3 + string4;
                bl4 = false;
            }
            string3 = string3 + string2 + "Result\n";
        }
        string3 = string3 + this.root.toStringPartial(values, bl, string, string2);
        return string3;
    }

    public String toStringMatrix(String string) {
        String string2 = "";
        string2 = string2 + this.root.toStringMatrix(string);
        return string2;
    }

    private class TreeLeaf
    extends TreeNode {
        private Object val;

        private TreeLeaf() {
            this.val = null;
        }

        @Override
        public int setResult(Values values, Object object) {
            int n = this.val == null ? 1 : 0;
            this.val = object;
            return n;
        }

        @Override
        public Object getResult(Values values) throws PrismException {
            return this.val;
        }

        @Override
        public String toStringMatrixRec(String string, String string2) {
            return this.val.toString();
        }

        @Override
        public String toStringRec(boolean bl, String string, String string2, String string3) {
            return string3 + string2 + this.val + "\n";
        }

        @Override
        public void exportRec(Values values, ResultsExporter resultsExporter) {
            resultsExporter.exportResult(values, this.val);
        }

        @Override
        public String toStringPartialRec(Values values, boolean bl, boolean bl2, String string, String string2, String string3) {
            return string3 + string2 + this.val + "\n";
        }

        @Override
        public void toArrayListRec(ArrayList<String[]> arrayList, String[] stringArray) {
            stringArray[((ResultsCollection)ResultsCollection.this).rangingConstants.size()] = "" + this.val;
            arrayList.add((String[])stringArray.clone());
        }
    }

    private class TreeNode {
        private int level;
        private DefinedConstant constant;
        private TreeNode[] kids;

        public TreeNode() {
        }

        public TreeNode(int n) {
            this.level = n;
            this.constant = (DefinedConstant)ResultsCollection.this.rangingConstants.get(this.level);
            int n2 = this.constant.getNumSteps();
            this.kids = new TreeNode[n2];
            for (int i = 0; i < n2; ++i) {
                this.kids[i] = this.level == ResultsCollection.this.rangingConstants.size() - 1 ? new TreeLeaf() : new TreeNode(n + 1);
            }
        }

        public int setResult(Values values, Object object) {
            Object object2 = null;
            if (values.contains(this.constant.getName())) {
                try {
                    object2 = values.getValueOf(this.constant.getName());
                }
                catch (PrismLangException prismLangException) {
                    // empty catch block
                }
                int n = this.constant.getValueIndex(object2);
                return this.kids[n].setResult(values, object);
            }
            int n = this.constant.getNumSteps();
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                n2 += this.kids[i].setResult(values, object);
            }
            return n2;
        }

        public Object getResult(Values values) throws PrismException {
            Object object = values.getValueOf(this.constant.getName());
            int n = this.constant.getValueIndex(object);
            return this.kids[n].getResult(values);
        }

        public ArrayList<String[]> toArrayList() {
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            String[] stringArray = new String[ResultsCollection.this.rangingConstants.size() + 1];
            this.toArrayListRec(arrayList, stringArray);
            return arrayList;
        }

        public void toArrayListRec(ArrayList<String[]> arrayList, String[] stringArray) {
            int n = this.constant.getNumSteps();
            for (int i = 0; i < n; ++i) {
                stringArray[this.level] = this.constant.getValue(i).toString();
                this.kids[i].toArrayListRec(arrayList, stringArray);
            }
        }

        public String toString() {
            return this.toString(false, ",", ",");
        }

        public String toString(boolean bl, String string, String string2) {
            String string3 = this.toStringRec(bl, string, string2, "");
            if (string3.charAt(string3.length() - 1) == '\n') {
                string3 = string3.substring(0, string3.length() - 1);
            }
            return string3;
        }

        public void export(ResultsExporter resultsExporter) {
            this.exportRec(new Values(), resultsExporter);
        }

        public String toStringRec(boolean bl, String string, String string2, String string3) {
            String string4 = "";
            int n = this.constant.getNumSteps();
            for (int i = 0; i < n; ++i) {
                String string5 = "";
                if (this.level > 0) {
                    string5 = string5 + string;
                }
                if (bl) {
                    string5 = string5 + this.constant.getName() + "=";
                }
                string5 = string5 + this.constant.getValue(i);
                string4 = string4 + this.kids[i].toStringRec(bl, string, string2, string3 + string5);
            }
            return string4;
        }

        public void exportRec(Values values, ResultsExporter resultsExporter) {
            int n = this.constant.getNumSteps();
            for (int i = 0; i < n; ++i) {
                values.setValue(this.constant.getName(), this.constant.getValue(i));
                this.kids[i].exportRec(values, resultsExporter);
            }
        }

        public String toStringPartial(Values values, boolean bl, String string, String string2) throws PrismException {
            return this.toStringPartialRec(values, true, bl, string, string2, "");
        }

        public String toStringPartialRec(Values values, boolean bl, boolean bl2, String string, String string2, String string3) throws PrismException {
            String string4 = "";
            if (values.contains(this.constant.getName())) {
                Object object = values.getValueOf(this.constant.getName());
                int n = this.constant.getValueIndex(object);
                string4 = string4 + this.kids[n].toStringPartialRec(values, bl, bl2, string, string2, string3);
            } else {
                int n = this.constant.getNumSteps();
                for (int i = 0; i < n; ++i) {
                    String string5 = "";
                    if (!bl) {
                        string5 = string5 + string;
                    }
                    if (bl2) {
                        string5 = string5 + this.constant.getName() + "=";
                    }
                    string5 = string5 + this.constant.getValue(i);
                    string4 = string4 + this.kids[i].toStringPartialRec(values, false, bl2, string, string2, string3 + string5);
                }
            }
            return string4;
        }

        public String toStringMatrix(String string) {
            return this.toStringMatrixRec(string, "");
        }

        public String toStringMatrixRec(String string, String string2) {
            int n;
            Object object;
            String string3 = "";
            int n2 = this.constant.getNumSteps();
            if (ResultsCollection.this.rangingConstants.size() == 1 || ResultsCollection.this.rangingConstants.size() - this.level == 2) {
                if (string.equals(", ")) {
                    string3 = string3 + "\"";
                }
                if (ResultsCollection.this.rangingConstants.size() > 2) {
                    string3 = string3 + string2 + ", ";
                }
                string3 = ResultsCollection.this.rangingConstants.size() == 1 ? string3 + this.constant.getName() : string3 + this.constant.getName() + "\\" + this.kids[0].constant.getName();
                if (!string.equals(", ")) {
                    string3 = string3 + ":";
                }
                if (string.equals(", ")) {
                    string3 = string3 + "\"";
                }
                string3 = string3 + "\n";
            }
            if (ResultsCollection.this.rangingConstants.size() == 1 || ResultsCollection.this.rangingConstants.size() - this.level == 2) {
                object = ResultsCollection.this.rangingConstants.size() == 1 ? this : this.kids[0];
                int n3 = ((TreeNode)object).constant.getNumSteps();
                for (n = 0; n < n3; ++n) {
                    if (ResultsCollection.this.rangingConstants.size() > 1 || n > 0) {
                        string3 = string3 + string;
                    }
                    string3 = string3 + ((TreeNode)object).constant.getValue(n);
                }
                string3 = string3 + "\n";
            }
            for (n = 0; n < n2; ++n) {
                if (ResultsCollection.this.rangingConstants.size() - this.level == 2) {
                    string3 = string3 + this.constant.getValue(n) + string;
                }
                if (ResultsCollection.this.rangingConstants.size() - this.level == 1 && n > 0) {
                    string3 = string3 + string;
                }
                if (ResultsCollection.this.rangingConstants.size() - this.level <= 2) {
                    string3 = string3 + this.kids[n].toStringMatrixRec(string, string2);
                } else {
                    object = string2;
                    if (!"".equals(string2)) {
                        object = (String)object + ",";
                    }
                    object = (String)object + this.constant.getName() + "=" + this.constant.getValue(n);
                    string3 = string3 + this.kids[n].toStringMatrixRec(string, (String)object);
                }
                if (ResultsCollection.this.rangingConstants.size() - this.level == 2 && n < n2 - 1) {
                    string3 = string3 + "\n";
                }
                if (ResultsCollection.this.rangingConstants.size() - this.level <= 2 || n >= n2 - 1) continue;
                string3 = string3 + "\n\n";
            }
            return string3;
        }
    }
}

