/*
 * Decompiled with CFR 0.152.
 */
package prism;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import prism.PrismException;

public class PrismStaTra {
    private File statesFile;
    private File transFile;
    private ArrayList<String> states;

    public PrismStaTra(File file, File file2) {
        this.statesFile = file;
        this.transFile = file2;
    }

    public void readStatesFromFile() throws PrismException {
        int n = 0;
        this.states = new ArrayList();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.statesFile));
            bufferedReader.readLine();
            n = 1;
            String string = bufferedReader.readLine();
            ++n;
            while (string != null) {
                string = string.trim();
                String[] stringArray = string.split(":");
                this.states.add(stringArray[1]);
                string = bufferedReader.readLine();
                ++n;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new PrismException("File I/O error reading from \"" + this.statesFile + "\"");
        }
        catch (NumberFormatException numberFormatException) {
            throw new PrismException("Error detected at line " + n + " of states file \"" + this.statesFile + "\"");
        }
    }

    private void readTransitionsFromFile() throws PrismException {
        int n = 0;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.transFile));
            String string = bufferedReader.readLine();
            System.out.println(string);
            n = 1;
            string = bufferedReader.readLine();
            ++n;
            while (string != null) {
                String[] stringArray = (string = string.trim()).split(" ");
                if (stringArray.length == 3) {
                    stringArray[0] = "" + this.states.get(Integer.parseInt(stringArray[0]));
                    stringArray[1] = "" + this.states.get(Integer.parseInt(stringArray[1]));
                } else if (stringArray.length == 4) {
                    if (stringArray[3].matches("[_a-zA-Z][_a-zA-Z0-9]*")) {
                        stringArray[0] = "" + this.states.get(Integer.parseInt(stringArray[0]));
                        stringArray[1] = "" + this.states.get(Integer.parseInt(stringArray[1]));
                    } else {
                        stringArray[0] = "" + this.states.get(Integer.parseInt(stringArray[0]));
                        stringArray[2] = "" + this.states.get(Integer.parseInt(stringArray[2]));
                    }
                } else {
                    stringArray[0] = "" + this.states.get(Integer.parseInt(stringArray[0]));
                    stringArray[2] = "" + this.states.get(Integer.parseInt(stringArray[2]));
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    if (i > 0) {
                        System.out.print(" ");
                    }
                    System.out.print(stringArray[i]);
                }
                System.out.println();
                string = bufferedReader.readLine();
                ++n;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new PrismException("File I/O error reading from \"" + this.transFile + "\"");
        }
        catch (NumberFormatException numberFormatException) {
            throw new PrismException("Error detected at line " + n + " of transition matrix file \"" + this.transFile + "\"");
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.out.println("Error: Need two arguments (states and transitions file)");
            System.exit(1);
        }
        try {
            PrismStaTra prismStaTra = new PrismStaTra(new File(stringArray[0]), new File(stringArray[1]));
            prismStaTra.readStatesFromFile();
            prismStaTra.readTransitionsFromFile();
        }
        catch (PrismException prismException) {
            System.out.println("Error: " + prismException.getMessage());
            System.exit(1);
        }
    }
}

