/*
 * Decompiled with CFR 0.152.
 */
package prism;

import dv.DoubleVector;
import explicit.CTMC;
import explicit.CTMCModelChecker;
import explicit.ConstructModel;
import explicit.DTMC;
import explicit.DTMCModelChecker;
import explicit.FastAdaptiveUniformisation;
import explicit.FastAdaptiveUniformisationModelChecker;
import explicit.ModelExplorer;
import hybrid.PrismHybrid;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;
import mtbdd.PrismMTBDD;
import odd.ODDUtils;
import param.BigRational;
import param.Function;
import param.ModelBuilder;
import param.ParamModelChecker;
import param.Point;
import param.RegionValues;
import parser.ExplicitFiles2ModulesFile;
import parser.PrismParser;
import parser.State;
import parser.Values;
import parser.ast.ConstantList;
import parser.ast.Expression;
import parser.ast.ForLoop;
import parser.ast.FormulaList;
import parser.ast.LabelList;
import parser.ast.ModulesFile;
import parser.ast.PropertiesFile;
import parser.ast.Property;
import pepa.compiler.InternalError;
import pepa.compiler.Main;
import prism.ECComputer;
import prism.ExplicitFiles2MTBDD;
import prism.ExplicitModel2MTBDD;
import prism.Model;
import prism.ModelType;
import prism.Modules2MTBDD;
import prism.NondetModel;
import prism.Preprocessor;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismFileLog;
import prism.PrismLangException;
import prism.PrismLog;
import prism.PrismModelListener;
import prism.PrismNative;
import prism.PrismNotSupportedException;
import prism.PrismSettings;
import prism.PrismSettingsListener;
import prism.PrismUtils;
import prism.ProbModelChecker;
import prism.Result;
import prism.ResultsCollection;
import prism.SCCComputer;
import prism.StateList;
import prism.StateListMTBDD;
import prism.StateModelChecker;
import prism.StateValues;
import prism.StochModelChecker;
import prism.UndefinedConstants;
import prism.Version;
import pta.DigitalClocks;
import pta.PTAModelChecker;
import simulator.GenerateSimulationPath;
import simulator.PrismModelExplorer;
import simulator.SimulatorEngine;
import simulator.method.SimulationMethod;
import sparse.PrismSparse;
import strat.Strategy;

public class Prism
extends PrismComponent
implements PrismSettingsListener {
    private static String version = Version.versionString;
    private static String versionSuffix = Version.versionSuffixString;
    private static String buildNumber = "";
    public static final int MTBDD = 1;
    public static final int SPARSE = 2;
    public static final int HYBRID = 3;
    public static final int EXPLICIT = 4;
    private static String[] engineStrings;
    public static final int POWER = 1;
    public static final int JACOBI = 2;
    public static final int GAUSSSEIDEL = 3;
    public static final int BGAUSSSEIDEL = 4;
    public static final int PGAUSSSEIDEL = 5;
    public static final int BPGAUSSSEIDEL = 6;
    public static final int JOR = 7;
    public static final int SOR = 8;
    public static final int BSOR = 9;
    public static final int PSOR = 10;
    public static final int BPSOR = 11;
    public static final int MDP_VALITER = 1;
    public static final int MDP_GAUSSSEIDEL = 2;
    public static final int MDP_POLITER = 3;
    public static final int MDP_MODPOLITER = 4;
    public static final int MDP_LP = 5;
    public static final int MDP_MULTI_VALITER = 1;
    public static final int MDP_MULTI_GAUSSSEIDEL = 2;
    public static final int MDP_MULTI_LP = 3;
    public static final int ABSOLUTE = 1;
    public static final int RELATIVE = 2;
    public static final int EXPORT_PLAIN = 1;
    public static final int EXPORT_MATLAB = 2;
    public static final int EXPORT_DOT = 3;
    public static final int EXPORT_MRMC = 4;
    public static final int EXPORT_ROWS = 5;
    public static final int EXPORT_DOT_STATES = 6;
    public static final int EXPORT_ADV_NONE = 1;
    public static final int EXPORT_ADV_DTMC = 2;
    public static final int EXPORT_ADV_MDP = 3;
    public static final int XIEBEEREL = 1;
    public static final int LOCKSTEP = 2;
    public static final int SCCFIND = 3;
    protected boolean exportPrism = false;
    protected File exportPrismFile = null;
    protected boolean exportPrismConst = false;
    protected File exportPrismConstFile = null;
    protected boolean exportDigital = false;
    protected File exportDigitalFile = null;
    protected boolean exportTarget = false;
    protected String exportTargetFilename = null;
    protected boolean exportProductTrans = false;
    protected String exportProductTransFilename = null;
    protected boolean exportProductStates = false;
    protected String exportProductStatesFilename = null;
    protected boolean storeVector = false;
    protected boolean genStrat = false;
    protected boolean doBisim = false;
    private boolean doReach = true;
    private boolean bsccComp = true;
    private boolean checkZeroLoops = false;
    private int construction = 3;
    private int ordering = 1;
    private int reachMethod = REACH_BFS;
    private PrismLog techLog;
    private static PrismParser thePrismParser;
    private static boolean prismParserInUse;
    private ExplicitFiles2MTBDD expf2mtbdd = null;
    private ExplicitModel2MTBDD expm2mtbdd = null;
    private SimulatorEngine theSimulator = null;
    private List<PrismModelListener> modelListeners;
    private ModelSource currentModelSource = ModelSource.PRISM_MODEL;
    private ModelType currentModelType = null;
    private ModulesFile currentModulesFile = null;
    private Values currentDefinedMFConstants = null;
    private Model currentModel = null;
    private explicit.Model currentModelExpl = null;
    boolean digital = false;
    private File explicitFilesStatesFile = null;
    private File explicitFilesTransFile = null;
    private File explicitFilesLabelsFile = null;
    private int explicitFilesNumStates = -1;
    private boolean cuddStarted = false;
    public static int REACH_BFS;
    public static int REACH_FRONTIER;

    public Prism(PrismLog prismLog) {
        this(prismLog, prismLog);
    }

    public Prism(PrismLog prismLog, PrismLog prismLog2) {
        this.mainLog = prismLog;
        this.techLog = prismLog2;
        this.settings = new PrismSettings();
        this.settings.addSettingsListener(this);
        this.modelListeners = new ArrayList<PrismModelListener>();
    }

    public void loadUserSettingsFile() {
        this.loadUserSettingsFile(null);
    }

    public void loadUserSettingsFile(File file) {
        try {
            if (file == null) {
                this.settings.loadSettingsFile();
            } else {
                this.settings.loadSettingsFile(file);
            }
        }
        catch (PrismException prismException) {
            try {
                if (file == null) {
                    this.settings.saveSettingsFile();
                } else {
                    this.settings.saveSettingsFile(file);
                }
            }
            catch (PrismException prismException2) {
                this.mainLog.printWarning("Failed to create new PRISM settings file.");
            }
        }
    }

    public void setMainLog(PrismLog prismLog) {
        this.mainLog = prismLog;
        PrismMTBDD.setMainLog(this.mainLog);
        PrismSparse.setMainLog(this.mainLog);
        PrismHybrid.setMainLog(this.mainLog);
    }

    public void setTechLog(PrismLog prismLog) {
        this.techLog = prismLog;
        JDD.SetOutputStream(this.techLog.getFilePointer());
        PrismMTBDD.setTechLog(this.techLog);
        PrismSparse.setTechLog(this.techLog);
        PrismHybrid.setTechLog(this.techLog);
    }

    public void setEngine(int n) throws PrismException {
        this.settings.setChoice("prism.engine", n);
    }

    public void setVerbose(boolean bl) throws PrismException {
        this.settings.set("prism.verbose", bl);
    }

    public void setFairness(boolean bl) throws PrismException {
        this.settings.set("prism.fairness", bl);
    }

    public void setPrecomp(boolean bl) throws PrismException {
        this.settings.set("prism.precomputation", bl);
    }

    public void setProb0(boolean bl) throws PrismException {
        this.settings.set("prism.prob0", bl);
    }

    public void setProb1(boolean bl) throws PrismException {
        this.settings.set("prism.prob1", bl);
    }

    public void setFixDeadlocks(boolean bl) throws PrismException {
        this.settings.set("prism.fixDeadlocks", bl);
    }

    public void setDoProbChecks(boolean bl) throws PrismException {
        this.settings.set("prism.doProbChecks", bl);
    }

    public void setSumRoundOff(double d) throws PrismException {
        this.settings.set("prism.sumRoundOff", d);
    }

    public void setCompact(boolean bl) throws PrismException {
        this.settings.set("prism.compact", bl);
    }

    public void setLinEqMethod(int n) throws PrismException {
        this.settings.setChoice("prism.linEqMethod", n);
    }

    public void setLinEqMethodParam(double d) throws PrismException {
        this.settings.set("prism.linEqMethodParam", d);
    }

    public void setMDPSolnMethod(int n) throws PrismException {
        this.settings.setChoice("prism.mdpSolnMethod", n);
    }

    public void setMDPMultiSolnMethod(int n) throws PrismException {
        this.settings.setChoice("prism.mdpMultiSolnMethod", n);
    }

    public void setTermCrit(int n) throws PrismException {
        this.settings.setChoice("prism.termCrit", n);
    }

    public void setTermCritParam(double d) throws PrismException {
        this.settings.set("prism.termCritParam", d);
    }

    public void setMaxIters(int n) throws PrismException {
        this.settings.set("prism.maxIters", n);
    }

    public void setCUDDMaxMem(String string) throws PrismException {
        this.settings.set("prism.cuddMaxMem", string);
    }

    public void setCUDDEpsilon(double d) throws PrismException {
        this.settings.set("prism.cuddEpsilon", d);
    }

    public void setNumSBLevels(int n) throws PrismException {
        this.settings.set("prism.numSBLevels", n);
    }

    public void setSBMaxMem(int n) throws PrismException {
        this.settings.set("prism.SBMaxMem", n);
    }

    public void setNumSORLevels(int n) throws PrismException {
        this.settings.set("prism.numSORLevels", n);
    }

    public void setSORMaxMem(int n) throws PrismException {
        this.settings.set("prism.SORMaxMem", n);
    }

    public void setDoSSDetect(boolean bl) throws PrismException {
        this.settings.set("prism.doSSDetect", bl);
    }

    public void setExtraDDInfo(boolean bl) throws PrismException {
        this.settings.set("prism.extraDDInfo", bl);
    }

    public void setExtraReachInfo(boolean bl) throws PrismException {
        this.settings.set("prism.extraReachInfo", bl);
    }

    public void setSCCMethod(int n) throws PrismException {
        this.settings.setChoice("prism.sccMethod", n);
    }

    public void setExportAdv(int n) throws PrismException {
        this.settings.setChoice("prism.exportAdv", n);
    }

    public void setExportAdvFilename(String string) throws PrismException {
        this.settings.set("prism.exportAdvFilename", string);
    }

    public void setExportPrism(boolean bl) throws PrismException {
        this.exportPrism = bl;
    }

    public void setExportPrismFile(File file) throws PrismException {
        this.exportPrismFile = file;
    }

    public void setExportPrismConst(boolean bl) throws PrismException {
        this.exportPrismConst = bl;
    }

    public void setExportPrismConstFile(File file) throws PrismException {
        this.exportPrismConstFile = file;
    }

    public void setExportDigital(boolean bl) throws PrismException {
        this.exportDigital = bl;
    }

    public void setExportDigitalFile(File file) throws PrismException {
        this.exportDigitalFile = file;
    }

    public void setExportTarget(boolean bl) throws PrismException {
        this.exportTarget = bl;
    }

    public void setExportTargetFilename(String string) throws PrismException {
        this.exportTargetFilename = string;
    }

    public void setExportProductTrans(boolean bl) throws PrismException {
        this.exportProductTrans = bl;
    }

    public void setExportProductTransFilename(String string) throws PrismException {
        this.exportProductTransFilename = string;
    }

    public void setExportProductStates(boolean bl) throws PrismException {
        this.exportProductStates = bl;
    }

    public void setExportProductStatesFilename(String string) throws PrismException {
        this.exportProductStatesFilename = string;
    }

    public void setStoreVector(boolean bl) {
        this.storeVector = bl;
    }

    public void setGenStrat(boolean bl) {
        this.genStrat = bl;
    }

    public void setDoBisim(boolean bl) {
        this.doBisim = bl;
    }

    public void setDoReach(boolean bl) throws PrismException {
        this.doReach = bl;
    }

    public void setBSCCComp(boolean bl) throws PrismException {
        this.bsccComp = bl;
    }

    public void setCheckZeroLoops(boolean bl) {
        this.checkZeroLoops = bl;
    }

    public void setConstruction(int n) throws PrismException {
        this.construction = n;
    }

    public void setOrdering(int n) throws PrismException {
        this.ordering = n;
    }

    public void setReachMethod(int n) {
        this.reachMethod = n;
    }

    public static String getVersion() {
        String string = version;
        if (versionSuffix.length() > 0) {
            string = string + "." + versionSuffix;
            if (buildNumber.length() > 0) {
                string = string + ".r" + buildNumber;
            }
        }
        return string;
    }

    public static String getBuildNumber() {
        return buildNumber;
    }

    public PrismLog getMainLog() {
        return this.mainLog;
    }

    public PrismLog getTechLog() {
        return this.techLog;
    }

    @Override
    public PrismSettings getSettings() {
        return this.settings;
    }

    public int getEngine() {
        return this.settings.getChoice("prism.engine");
    }

    public boolean getExplicit() {
        return this.getEngine() == 4;
    }

    public boolean getFixDeadlocks() {
        return this.settings.getBoolean("prism.fixDeadlocks");
    }

    public boolean getDoProbChecks() {
        return this.settings.getBoolean("prism.doProbChecks");
    }

    public double getSumRoundOff() {
        return this.settings.getDouble("prism.sumRoundOff");
    }

    public int getLinEqMethod() {
        return this.settings.getChoice("prism.linEqMethod");
    }

    public double getLinEqMethodParam() {
        return this.settings.getDouble("prism.linEqMethodParam");
    }

    public int getMDPSolnMethod() {
        return this.settings.getChoice("prism.mdpSolnMethod");
    }

    public int getMDPMultiSolnMethod() {
        return this.settings.getChoice("prism.mdpMultiSolnMethod");
    }

    public int getTermCrit() {
        return this.settings.getChoice("prism.termCrit");
    }

    public double getTermCritParam() {
        return this.settings.getDouble("prism.termCritParam");
    }

    public int getMaxIters() {
        return this.settings.getInteger("prism.maxIters");
    }

    public boolean getVerbose() {
        return this.settings.getBoolean("prism.verbose");
    }

    public boolean getPrecomp() {
        return this.settings.getBoolean("prism.precomputation");
    }

    public boolean getProb0() {
        return this.settings.getBoolean("prism.prob0");
    }

    public boolean getProb1() {
        return this.settings.getBoolean("prism.prob1");
    }

    public boolean getPreRel() {
        return this.settings.getBoolean("prism.preRel");
    }

    public boolean getFairness() {
        return this.settings.getBoolean("prism.fairness");
    }

    public int getSBMaxMem() {
        return this.settings.getInteger("prism.SBMaxMem");
    }

    public int getNumSBLevels() {
        return this.settings.getInteger("prism.numSBLevels");
    }

    public int getSORMaxMem() {
        return this.settings.getInteger("prism.SORMaxMem");
    }

    public boolean getDoSSDetect() {
        return this.settings.getBoolean("prism.doSSDetect");
    }

    public boolean getExtraDDInfo() {
        return this.settings.getBoolean("prism.extraDDInfo");
    }

    public boolean getExtraReachInfo() {
        return this.settings.getBoolean("prism.extraReachInfo");
    }

    public int getNumSORLevels() {
        return this.settings.getInteger("prism.numSORLevels");
    }

    public boolean getCompact() {
        return this.settings.getBoolean("prism.compact");
    }

    public String getCUDDMaxMem() {
        return this.settings.getString("prism.cuddMaxMem");
    }

    public double getCUDDEpsilon() {
        return this.settings.getDouble("prism.cuddEpsilon");
    }

    public int getSCCMethod() {
        return this.settings.getChoice("prism.sccMethod");
    }

    public int getExportAdv() {
        return this.settings.getChoice("prism.exportAdv");
    }

    public String getExportAdvFilename() {
        return this.settings.getString("prism.exportAdvFilename");
    }

    public boolean getExportPrism() {
        return this.exportPrism;
    }

    public File getExportPrismFile() {
        return this.exportPrismFile;
    }

    public boolean getExportPrismConst() {
        return this.exportPrismConst;
    }

    public File getExportPrismConstFile() {
        return this.exportPrismConstFile;
    }

    public boolean getExportTarget() {
        return this.exportTarget;
    }

    public String getExportTargetFilename() {
        return this.exportTargetFilename;
    }

    public boolean getExportProductTrans() {
        return this.exportProductTrans;
    }

    public String getExportProductTransFilename() {
        return this.exportProductTransFilename;
    }

    public boolean getExportProductStates() {
        return this.exportProductStates;
    }

    public String getExportProductStatesFilename() {
        return this.exportProductStatesFilename;
    }

    public boolean getStoreVector() {
        return this.storeVector;
    }

    public boolean getGenStrat() {
        return this.genStrat;
    }

    public boolean getDoBisim() {
        return this.doBisim;
    }

    public boolean getDoReach() {
        return this.doReach;
    }

    public boolean getBSCCComp() {
        return this.bsccComp;
    }

    public boolean getCheckZeroLoops() {
        return this.checkZeroLoops;
    }

    public int getConstruction() {
        return this.construction;
    }

    public int getOrdering() {
        return this.ordering;
    }

    public int getReachMethod() {
        return this.reachMethod;
    }

    public void addModelListener(PrismModelListener prismModelListener) {
        this.modelListeners.add(prismModelListener);
    }

    public static String getEngineString(int n) {
        return engineStrings[n];
    }

    @Override
    public void notifySettings(PrismSettings prismSettings) {
        if (this.cuddStarted) {
            JDD.SetCUDDEpsilon(prismSettings.getDouble("prism.cuddEpsilon"));
            try {
                long l = PrismUtils.convertMemoryStringtoKB(this.getCUDDMaxMem());
                JDD.SetCUDDMaxMem(l);
            }
            catch (PrismException prismException) {
                // empty catch block
            }
        }
    }

    public static PrismParser getPrismParser() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Class<Prism> clazz = Prism.class;
        synchronized (Prism.class) {
            try {
                while (prismParserInUse) {
                    Prism.class.wait();
                }
                prismParserInUse = true;
                if (thePrismParser == null) {
                    thePrismParser = new PrismParser();
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return thePrismParser;
            }
            catch (InterruptedException interruptedException) {
                Prism.class.notify();
                throw interruptedException;
            }
        }
    }

    public static synchronized void releasePrismParser() {
        prismParserInUse = false;
        Prism.class.notify();
    }

    public SimulatorEngine getSimulator() {
        if (this.theSimulator == null) {
            this.theSimulator = new SimulatorEngine(this);
        }
        return this.theSimulator;
    }

    public SCCComputer getSCCComputer(Model model) throws PrismException {
        return SCCComputer.createSCCComputer(this, model);
    }

    public SCCComputer getSCCComputer(JDDNode jDDNode, JDDNode jDDNode2, JDDVars jDDVars, JDDVars jDDVars2) throws PrismException {
        return SCCComputer.createSCCComputer(this, jDDNode, jDDNode2, jDDVars, jDDVars2);
    }

    public explicit.SCCComputer getExplicitSCCComputer(explicit.Model model) throws PrismException {
        return explicit.SCCComputer.createSCCComputer(this, model);
    }

    public ECComputer getECComputer(NondetModel nondetModel) throws PrismException {
        return ECComputer.createECComputer(this, nondetModel);
    }

    public ECComputer getECComputer(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, JDDVars jDDVars, JDDVars jDDVars2, JDDVars jDDVars3) throws PrismException {
        return ECComputer.createECComputer(this, jDDNode, jDDNode2, jDDNode3, jDDVars, jDDVars2, jDDVars3);
    }

    public explicit.ECComputer getExplicitECComputer(explicit.NondetModel nondetModel) throws PrismException {
        return explicit.ECComputer.createECComputer(this, nondetModel);
    }

    public static int compareVersions(String string, String string2) {
        int n;
        String[] stringArray;
        String[] stringArray2;
        int n2;
        double d = 0.0;
        double d2 = 0.0;
        if (string.equals(string2)) {
            return 0;
        }
        String[] stringArray3 = string.split("\\.");
        if (stringArray3.length < (n2 = Math.max(stringArray3.length, (stringArray2 = string2.split("\\.")).length))) {
            stringArray = new String[n2];
            for (n = 0; n < stringArray3.length; ++n) {
                stringArray[n] = stringArray3[n];
            }
            for (n = stringArray3.length; n < n2; ++n) {
                stringArray[n] = "";
            }
            stringArray3 = stringArray;
        }
        if (stringArray2.length < n2) {
            stringArray = new String[n2];
            for (n = 0; n < stringArray2.length; ++n) {
                stringArray[n] = stringArray2[n];
            }
            for (n = stringArray2.length; n < n2; ++n) {
                stringArray[n] = "";
            }
            stringArray2 = stringArray;
        }
        for (n = 0; n < n2; ++n) {
            boolean bl;
            boolean bl2;
            int n3;
            if (stringArray3[n].matches("alpha.*")) {
                try {
                    n3 = stringArray3[n].length() == 5 ? 0 : Integer.parseInt(stringArray3[n].substring(5));
                }
                catch (NumberFormatException numberFormatException) {
                    n3 = 0;
                }
                stringArray3[n] = "" + (-10000 + n3);
            }
            if (stringArray2[n].matches("alpha.*")) {
                try {
                    n3 = stringArray2[n].length() == 5 ? 0 : Integer.parseInt(stringArray2[n].substring(5));
                }
                catch (NumberFormatException numberFormatException) {
                    n3 = 0;
                }
                stringArray2[n] = "" + (-10000 + n3);
            }
            if (stringArray3[n].matches("beta.*")) {
                try {
                    n3 = stringArray3[n].length() == 4 ? 0 : Integer.parseInt(stringArray3[n].substring(4));
                }
                catch (NumberFormatException numberFormatException) {
                    n3 = 0;
                }
                stringArray3[n] = "" + (-100 + n3);
            }
            if (stringArray2[n].matches("beta.*")) {
                try {
                    n3 = stringArray2[n].length() == 4 ? 0 : Integer.parseInt(stringArray2[n].substring(4));
                }
                catch (NumberFormatException numberFormatException) {
                    n3 = 0;
                }
                stringArray2[n] = "" + (-100 + n3);
            }
            if (stringArray3[n].equals("")) {
                stringArray3[n] = "0";
            }
            if (stringArray2[n].equals("")) {
                stringArray2[n] = "0";
            }
            if (stringArray3[n].matches("dev.*")) {
                try {
                    n3 = stringArray3[n].length() == 3 ? 0 : Integer.parseInt(stringArray3[n].substring(3));
                }
                catch (NumberFormatException numberFormatException) {
                    n3 = 0;
                }
                stringArray3[n] = "" + (0.5 + (double)n3 / 1000.0);
            }
            if (stringArray2[n].matches("dev.*")) {
                try {
                    n3 = stringArray2[n].length() == 3 ? 0 : Integer.parseInt(stringArray2[n].substring(3));
                }
                catch (NumberFormatException numberFormatException) {
                    n3 = 0;
                }
                stringArray2[n] = "" + (0.5 + (double)n3 / 1000.0);
            }
            if (stringArray3[n].matches("r.*")) {
                try {
                    n3 = Integer.parseInt(stringArray3[n].substring(1));
                }
                catch (NumberFormatException numberFormatException) {
                    n3 = 0;
                }
                stringArray3[n] = "" + n3;
            }
            if (stringArray2[n].matches("r.*")) {
                try {
                    n3 = Integer.parseInt(stringArray2[n].substring(1));
                }
                catch (NumberFormatException numberFormatException) {
                    n3 = 0;
                }
                stringArray2[n] = "" + n3;
            }
            try {
                bl2 = true;
                d = Double.parseDouble(stringArray3[n]);
            }
            catch (NumberFormatException numberFormatException) {
                bl2 = false;
            }
            try {
                bl = true;
                d2 = Double.parseDouble(stringArray2[n]);
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
            if (!bl2 || !bl) continue;
            if (d < d2) {
                return -1;
            }
            if (d > d2) {
                return 1;
            }
            if (d != d2) continue;
        }
        return 0;
    }

    public static List<String> getListOfKeyords() {
        return PrismParser.getListOfKeywords();
    }

    public void initialise() throws PrismException {
        boolean bl = this.getSettings().getBoolean("PRISM_VERBOSE");
        this.mainLog.setVerbosityLevel(bl ? 2 : 0);
        this.mainLog.print("PRISM\n=====\n");
        this.mainLog.print("\nVersion: " + Prism.getVersion() + "\n");
        this.mainLog.print("Date: " + new Date() + "\n");
        try {
            String string = InetAddress.getLocalHost().getHostName();
            this.mainLog.print("Hostname: " + string + "\n");
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.mainLog.print("Memory limits: cudd=" + this.getCUDDMaxMem());
        this.mainLog.println(", java(heap)=" + PrismUtils.convertBytesToMemoryString(Runtime.getRuntime().maxMemory()));
        long l = PrismUtils.convertMemoryStringtoKB(this.getCUDDMaxMem());
        JDD.InitialiseCUDD(l, this.getCUDDEpsilon());
        this.cuddStarted = true;
        JDD.SetOutputStream(this.techLog.getFilePointer());
        PrismNative.initialise(this);
        PrismMTBDD.initialise(this.mainLog, this.techLog);
        PrismSparse.initialise(this.mainLog, this.techLog);
        PrismHybrid.initialise(this.mainLog, this.techLog);
        DoubleVector.setCUDDManager();
        ODDUtils.setCUDDManager();
    }

    public ModulesFile parseModelFile(File file) throws FileNotFoundException, PrismLangException {
        return this.parseModelFile(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModulesFile parseModelFile(File file, ModelType modelType) throws FileNotFoundException, PrismLangException {
        ModulesFile modulesFile = null;
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            PrismParser prismParser = Prism.getPrismParser();
            try {
                modulesFile = prismParser.parseModulesFile(fileInputStream, modelType);
            }
            finally {
                Prism.releasePrismParser();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new PrismLangException("Concurrency error in parser");
        }
        modulesFile.tidyUp();
        return modulesFile;
    }

    public ModulesFile parseModelString(String string) throws PrismLangException {
        return this.parseModelString(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModulesFile parseModelString(String string, ModelType modelType) throws PrismLangException {
        ModulesFile modulesFile = null;
        try {
            PrismParser prismParser = Prism.getPrismParser();
            try {
                modulesFile = prismParser.parseModulesFile(new ByteArrayInputStream(string.getBytes()), modelType);
            }
            finally {
                Prism.releasePrismParser();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new PrismLangException("Concurrency error in parser");
        }
        modulesFile.tidyUp();
        return modulesFile;
    }

    public ModulesFile importPepaFile(File file) throws PrismException, PrismLangException {
        String string;
        try {
            string = Main.compile("" + file);
        }
        catch (InternalError internalError) {
            throw new PrismException("Could not import PEPA file:\n" + internalError.getMessage());
        }
        return this.parseModelString(string);
    }

    public ModulesFile importPepaString(String string) throws PrismException, PrismLangException {
        String string2;
        File file = null;
        try {
            file = File.createTempFile("tempPepa" + System.currentTimeMillis(), ".pepa");
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(string);
            fileWriter.close();
        }
        catch (IOException iOException) {
            if (file != null) {
                file.delete();
            }
            throw new PrismException("Couldn't create temporary file for PEPA conversion");
        }
        try {
            string2 = Main.compile("" + file);
        }
        catch (InternalError internalError) {
            if (file != null) {
                file.delete();
            }
            throw new PrismException("Could not import PEPA file:\n" + internalError.getMessage());
        }
        return this.parseModelString(string2);
    }

    public ModulesFile importPrismPreprocFile(File file, String[] stringArray) throws PrismException {
        Preprocessor preprocessor = new Preprocessor(this, file);
        preprocessor.setParameters(stringArray);
        String string = preprocessor.preprocess();
        if (string == null) {
            throw new PrismException("No preprocessing information");
        }
        return this.parseModelString(string);
    }

    public PropertiesFile parsePropertiesFile(ModulesFile modulesFile, File file) throws FileNotFoundException, PrismLangException {
        return this.parsePropertiesFile(modulesFile, file, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertiesFile parsePropertiesFile(ModulesFile modulesFile, File file, boolean bl) throws FileNotFoundException, PrismLangException {
        PropertiesFile propertiesFile = null;
        FileInputStream fileInputStream = new FileInputStream(file);
        if (modulesFile == null) {
            modulesFile = new ModulesFile();
            modulesFile.setFormulaList(new FormulaList());
            modulesFile.setConstantList(new ConstantList());
        }
        try {
            PrismParser prismParser = Prism.getPrismParser();
            try {
                propertiesFile = prismParser.parsePropertiesFile(modulesFile, fileInputStream);
            }
            finally {
                Prism.releasePrismParser();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new PrismLangException("Concurrency error in parser");
        }
        if (bl) {
            propertiesFile.tidyUp();
        }
        return propertiesFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertiesFile parsePropertiesString(ModulesFile modulesFile, String string) throws PrismLangException {
        PropertiesFile propertiesFile = null;
        if (modulesFile == null) {
            modulesFile = new ModulesFile();
            modulesFile.setFormulaList(new FormulaList());
            modulesFile.setConstantList(new ConstantList());
        }
        try {
            PrismParser prismParser = Prism.getPrismParser();
            try {
                propertiesFile = prismParser.parsePropertiesFile(modulesFile, new ByteArrayInputStream(string.getBytes()));
            }
            finally {
                Prism.releasePrismParser();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new PrismLangException("Concurrency error in parser");
        }
        propertiesFile.tidyUp();
        return propertiesFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression parseSingleExpressionString(String string) throws PrismLangException {
        Expression expression;
        try {
            PrismParser prismParser = Prism.getPrismParser();
            try {
                expression = prismParser.parseSingleExpression(new ByteArrayInputStream(string.getBytes()));
            }
            finally {
                Prism.releasePrismParser();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new PrismLangException("Concurrency error in parser");
        }
        return expression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ForLoop parseForLoopString(String string) throws PrismLangException {
        ForLoop forLoop;
        try {
            PrismParser prismParser = Prism.getPrismParser();
            try {
                forLoop = prismParser.parseForLoop(new ByteArrayInputStream(string.getBytes()));
            }
            finally {
                Prism.releasePrismParser();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new PrismLangException("Concurrency error in parser");
        }
        return forLoop;
    }

    public void loadPRISMModel(ModulesFile modulesFile) {
        int n;
        this.currentModelSource = ModelSource.PRISM_MODEL;
        this.currentModulesFile = modulesFile;
        this.clearBuiltModel();
        this.currentModelType = this.currentModulesFile == null ? null : this.currentModulesFile.getModelType();
        this.currentDefinedMFConstants = null;
        this.currentModel = null;
        this.currentModelExpl = null;
        this.mainLog.println("\nType:        " + (Object)((Object)this.currentModulesFile.getModelType()));
        this.mainLog.print("Modules:     ");
        for (n = 0; n < this.currentModulesFile.getNumModules(); ++n) {
            this.mainLog.print(this.currentModulesFile.getModuleName(n) + " ");
        }
        this.mainLog.println();
        this.mainLog.print("Variables:   ");
        for (n = 0; n < this.currentModulesFile.getNumVars(); ++n) {
            this.mainLog.print(this.currentModulesFile.getVarName(n) + " ");
        }
        this.mainLog.println();
        if (this.exportPrism) {
            try {
                this.exportPRISMModel(this.exportPrismFile);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.mainLog.printWarning("PRISM code export failed: Couldn't open file \"" + this.exportPrismFile + "\" for output");
            }
            catch (PrismException prismException) {
                this.mainLog.printWarning("PRISM code export failed: " + prismException.getMessage());
            }
        }
    }

    public void setPRISMModelConstants(Values values) throws PrismLangException {
        if (this.currentDefinedMFConstants == null && values == null) {
            return;
        }
        if (this.currentDefinedMFConstants != null && this.currentDefinedMFConstants.equals(values)) {
            return;
        }
        this.clearBuiltModel();
        this.currentDefinedMFConstants = values;
        this.currentModulesFile.setSomeUndefinedConstants(values);
        this.currentModel = null;
        this.currentModelExpl = null;
        if (this.exportPrismConst) {
            try {
                this.exportPRISMModelWithExpandedConstants(this.exportPrismConstFile);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.mainLog.printWarning("PRISM code export failed: Couldn't open file \"" + this.exportPrismConstFile + "\" for output");
            }
            catch (PrismException prismException) {
                this.mainLog.printWarning("PRISM code export failed: " + prismException.getMessage());
            }
        }
    }

    public void loadPRISMModelAndBuiltModel(ModulesFile modulesFile, Model model) {
        this.currentModelSource = ModelSource.PRISM_MODEL;
        this.clearBuiltModel();
        this.currentModulesFile = modulesFile;
        this.currentModel = model;
        this.currentModelType = this.currentModulesFile == null ? null : this.currentModulesFile.getModelType();
        this.currentDefinedMFConstants = null;
        this.currentModelExpl = null;
    }

    public void loadBuiltModel(Model model) {
        this.currentModelSource = ModelSource.BUILT_MODEL;
        this.clearBuiltModel();
        this.currentModulesFile = null;
        this.currentModel = model;
        this.currentModelType = this.currentModel == null ? null : this.currentModel.getModelType();
        this.currentDefinedMFConstants = null;
        this.currentModelExpl = null;
    }

    public ModulesFile loadModelFromExplicitFiles(File file, File file2, File file3, ModelType modelType) throws PrismException {
        this.currentModelSource = ModelSource.EXPLICIT_FILES;
        this.clearBuiltModel();
        ExplicitFiles2ModulesFile explicitFiles2ModulesFile = new ExplicitFiles2ModulesFile(this);
        this.currentModulesFile = explicitFiles2ModulesFile.buildModulesFile(file, file2, modelType);
        this.explicitFilesStatesFile = file;
        this.explicitFilesTransFile = file2;
        this.explicitFilesLabelsFile = file3;
        this.explicitFilesNumStates = explicitFiles2ModulesFile.getNumStates();
        this.currentModelType = this.currentModulesFile == null ? null : this.currentModulesFile.getModelType();
        this.currentDefinedMFConstants = null;
        this.currentModel = null;
        this.currentModelExpl = null;
        return this.currentModulesFile;
    }

    public ModelType getModelType() {
        return this.currentModelType;
    }

    public ModulesFile getPRISMModel() {
        return this.currentModulesFile;
    }

    public Model getBuiltModel() {
        return this.currentModel;
    }

    public explicit.Model getBuiltModelExplicit() {
        return this.currentModelExpl;
    }

    public boolean modelCanBeBuilt() {
        return this.currentModelType != ModelType.PTA;
    }

    public boolean modelIsBuilt() {
        return this.getExplicit() ? this.currentModelExpl != null : this.currentModel != null;
    }

    public void buildModel() throws PrismException {
        this.mainLog.printSeparator();
        this.doBuildModel();
    }

    public void buildModelIfRequired() throws PrismException {
        if (!this.modelIsBuilt()) {
            this.doBuildModel();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doBuildModel() throws PrismException {
        this.clearBuiltModel();
        try {
            int n;
            Object object;
            if (this.currentModulesFile == null) {
                throw new PrismException("There is no currently loaded PRISM model to build");
            }
            if (this.currentModelType == ModelType.PTA) {
                throw new PrismException("You cannot build a PTA model explicitly, only perform model checking");
            }
            this.mainLog.print("\nBuilding model...\n");
            if (this.currentDefinedMFConstants != null && this.currentDefinedMFConstants.getNumValues() > 0) {
                this.mainLog.println("Model constants: " + this.currentDefinedMFConstants);
            }
            long l = System.currentTimeMillis();
            switch (this.currentModelSource) {
                case PRISM_MODEL: {
                    if (!this.getExplicit()) {
                        object = new Modules2MTBDD(this, this.currentModulesFile);
                        this.currentModel = ((Modules2MTBDD)object).translate();
                        this.currentModelExpl = null;
                        break;
                    }
                    object = new ConstructModel(this, this.getSimulator());
                    ((ConstructModel)object).setFixDeadlocks(this.getFixDeadlocks());
                    this.currentModelExpl = ((ConstructModel)object).constructModel(this.currentModulesFile, false, true);
                    this.currentModel = null;
                    break;
                }
                case EXPLICIT_FILES: {
                    if (this.getExplicit()) {
                        throw new PrismNotSupportedException("Explicit import not yet supported for explicit engine");
                    }
                    this.expf2mtbdd = new ExplicitFiles2MTBDD(this);
                    this.currentModel = this.expf2mtbdd.build(this.explicitFilesStatesFile, this.explicitFilesTransFile, this.explicitFilesLabelsFile, this.currentModulesFile, this.explicitFilesNumStates);
                    break;
                }
                default: {
                    throw new PrismException("Don't know how to build model from source " + (Object)((Object)this.currentModelSource));
                }
            }
            l = System.currentTimeMillis() - l;
            this.mainLog.println("\nTime for model construction: " + (double)l / 1000.0 + " seconds.");
            if (this.digital) {
                this.doBuildModelDigitalClocksChecks();
            }
            if (!this.getExplicit()) {
                object = this.currentModel.getDeadlockStates();
                n = object.size();
                if (n > 0) {
                    if (this.getFixDeadlocks()) {
                        this.mainLog.printWarning("Deadlocks detected and fixed in " + n + " states");
                    } else {
                        this.currentModel.printTransInfo(this.mainLog, this.getExtraDDInfo());
                        this.mainLog.print("\n" + n + " deadlock states found");
                        if (!this.getVerbose() && n > 10) {
                            this.mainLog.print(". The first 10 are below. Use verbose mode to view them all.\n");
                            object.print(this.mainLog, 10);
                        } else {
                            this.mainLog.print(":\n");
                            object.print(this.mainLog);
                        }
                        this.mainLog.print("\nTip: Use the \"fix deadlocks\" option to automatically add self-loops in deadlock states.\n");
                        throw new PrismException("Model contains " + n + " deadlock states");
                    }
                }
            } else {
                object = this.currentModelExpl.getDeadlockStatesList();
                n = this.currentModelExpl.getNumDeadlockStates();
                if (n > 0) {
                    if (this.getFixDeadlocks()) {
                        this.mainLog.printWarning("Deadlocks detected and fixed in " + n + " states");
                    } else {
                        this.mainLog.print(this.currentModelExpl.infoStringTable());
                        this.mainLog.print("\n" + n + " deadlock states found");
                        if (!this.getVerbose() && n > 10) {
                            this.mainLog.print(". The first 10 are below. Use verbose mode to view them all.\n");
                            ((explicit.StateValues)object).print(this.mainLog, 10);
                        } else {
                            this.mainLog.print(":\n");
                            ((explicit.StateValues)object).print(this.mainLog);
                        }
                        this.mainLog.print("\nTip: Use the \"fix deadlocks\" option to automatically add self-loops in deadlock states.\n");
                        throw new PrismException("Model contains " + n + " deadlock states");
                    }
                }
            }
            this.mainLog.println();
            if (!this.getExplicit()) {
                this.mainLog.println("Type:        " + (Object)((Object)this.currentModel.getModelType()));
                this.currentModel.printTransInfo(this.mainLog, this.getExtraDDInfo());
            } else {
                this.mainLog.println("Type:        " + (Object)((Object)this.currentModelExpl.getModelType()));
                this.mainLog.print(this.currentModelExpl.infoStringTable());
            }
            for (PrismModelListener prismModelListener : this.modelListeners) {
                if (prismModelListener == null) continue;
                prismModelListener.notifyModelBuildSuccessful();
            }
            return;
        }
        catch (PrismException prismException) {
            Iterator<PrismModelListener> iterator = this.modelListeners.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    throw prismException;
                }
                PrismModelListener prismModelListener = iterator.next();
                if (prismModelListener == null) continue;
                prismModelListener.notifyModelBuildFailed(prismException);
            }
        }
    }

    private void doBuildModelDigitalClocksChecks() throws PrismException {
        if (!this.getExplicit()) {
            StateList stateList = this.currentModel.getDeadlockStates();
            if (stateList.size() > 0) {
                throw new PrismException("Timelock in PTA, e.g. in state (" + stateList.getFirstAsValues() + ")");
            }
        } else if (this.currentModelExpl.getNumDeadlockStates() > 0) {
            int n = this.currentModelExpl.getFirstDeadlockState();
            String string = this.currentModelExpl.getStatesList().get(n).toString(this.currentModulesFile);
            throw new PrismException("Timelock in PTA, e.g. in state " + string);
        }
    }

    public Model buildModelExplicit(ModulesFile modulesFile) throws PrismException {
        if (modulesFile.getModelType() == ModelType.PTA) {
            throw new PrismException("You cannot build a PTA model explicitly, only perform model checking");
        }
        this.mainLog.print("\nBuilding model...\n");
        if (this.currentDefinedMFConstants != null && this.currentDefinedMFConstants.getNumValues() > 0) {
            this.mainLog.println("Model constants: " + this.currentDefinedMFConstants);
        }
        ConstructModel constructModel = new ConstructModel(this, this.getSimulator());
        explicit.Model model = constructModel.constructModel(modulesFile);
        List<State> list = constructModel.getStatesList();
        this.expm2mtbdd = new ExplicitModel2MTBDD(this);
        long l = System.currentTimeMillis();
        Model model2 = this.expm2mtbdd.buildModel(model, list, modulesFile, false);
        l = System.currentTimeMillis() - l;
        this.mainLog.println("\nTime for model construction: " + (double)l / 1000.0 + " seconds.");
        return model2;
    }

    public void exportPRISMModel(File file) throws FileNotFoundException, PrismException {
        this.mainLog.print("\nExporting parsed PRISM file ");
        this.mainLog.println(Prism.getDestinationStringForFile(file));
        PrismLog prismLog = this.getPrismLogForFile(file);
        prismLog.print(this.currentModulesFile.toString());
        if (file != null) {
            prismLog.close();
        }
    }

    public void exportPRISMModelWithExpandedConstants(File file) throws FileNotFoundException, PrismException {
        this.mainLog.print("\nExporting parsed PRISM file (with constant expansion) ");
        this.mainLog.println(Prism.getDestinationStringForFile(file));
        PrismLog prismLog = this.getPrismLogForFile(file);
        ModulesFile modulesFile = (ModulesFile)this.currentModulesFile.deepCopy();
        modulesFile = (ModulesFile)modulesFile.replaceConstants(this.currentModulesFile.getConstantValues());
        prismLog.print(modulesFile.toString());
        if (file != null) {
            prismLog.close();
        }
    }

    public void exportToSpyFile(File file) throws FileNotFoundException, PrismException {
        if (this.getExplicit()) {
            throw new PrismNotSupportedException("Export to Spy file not yet supported by explicit engine");
        }
        this.buildModelIfRequired();
        this.mainLog.println("\nExporting to spy file \"" + file + "\"...");
        int n = this.currentModel.getAllDDRowVars().n();
        if (n > 9) {
            n = 9;
        }
        JDDNode jDDNode = this.currentModel.getTrans();
        JDD.Ref(jDDNode);
        if (this.currentModelType == ModelType.MDP) {
            jDDNode = JDD.MaxAbstract(jDDNode, ((NondetModel)this.currentModel).getAllDDNondetVars());
        }
        JDD.ExportMatrixToSpyFile(jDDNode, this.currentModel.getAllDDRowVars(), this.currentModel.getAllDDColVars(), n, file.getPath());
        JDD.Deref(jDDNode);
    }

    public void exportToDotFile(File file) throws FileNotFoundException, PrismException {
        if (this.getExplicit()) {
            throw new PrismNotSupportedException("Export to Dot file not yet supported by explicit engine");
        }
        this.buildModelIfRequired();
        this.mainLog.println("\nExporting to dot file \"" + file + "\"...");
        JDD.ExportDDToDotFileLabelled(this.currentModel.getTrans(), file.getPath(), this.currentModel.getDDVarNames());
    }

    public void exportTransToFile(boolean bl, int n, File file) throws FileNotFoundException, PrismException {
        PrismLog prismLog;
        if (this.currentModelType == ModelType.MDP) {
            if (!bl) {
                this.mainLog.printWarning("Cannot export unordered transition matrix for MDPs; using ordered.");
            }
            bl = true;
        }
        if (n == 4) {
            if (!bl) {
                this.mainLog.printWarning("Cannot export unordered transition matrix in MRMC format; using ordered.");
            }
            bl = true;
        }
        if (n == 5) {
            if (!bl) {
                this.mainLog.printWarning("Cannot export unordered transition matrix in rows format; using ordered.");
            }
            bl = true;
        }
        this.buildModelIfRequired();
        this.mainLog.print("\nExporting transition matrix ");
        this.mainLog.print(Prism.getStringForExportType(n) + " ");
        this.mainLog.println(Prism.getDestinationStringForFile(file));
        if (!this.getExplicit()) {
            this.currentModel.exportToFile(n, bl, file);
        } else {
            prismLog = this.getPrismLogForFile(file);
            switch (n) {
                case 1: {
                    this.currentModelExpl.exportToPrismExplicitTra(prismLog);
                    break;
                }
                case 2: {
                    throw new PrismNotSupportedException("Export not yet supported");
                }
                case 3: {
                    this.currentModelExpl.exportToDotFile(prismLog);
                    break;
                }
                case 6: {
                    this.currentModelExpl.exportToDotFile(prismLog, null, true);
                    break;
                }
                case 4: 
                case 5: {
                    throw new PrismNotSupportedException("Export not yet supported");
                }
            }
            prismLog.close();
        }
        if (!this.getExplicit() && n == 6) {
            prismLog = this.getPrismLogForFile(file, true);
            this.currentModel.getReachableStates().printDot(prismLog);
            prismLog.println("}");
            if (file != null) {
                prismLog.close();
            }
        }
    }

    public void exportStateRewardsToFile(int n, File file) throws FileNotFoundException, PrismException {
        if (this.getExplicit()) {
            throw new PrismNotSupportedException("Export of state rewards not yet supported by explicit engine");
        }
        if (n == 5) {
            n = 1;
        }
        this.buildModelIfRequired();
        this.mainLog.print("\nExporting state rewards vector ");
        this.mainLog.print(Prism.getStringForExportType(n) + " ");
        this.mainLog.println(Prism.getDestinationStringForFile(file));
        String string = this.currentModel.exportStateRewardsToFile(n, file);
        if (string != null) {
            this.mainLog.println("Rewards exported to files: " + string);
        }
    }

    public void exportTransRewardsToFile(boolean bl, int n, File file) throws FileNotFoundException, PrismException {
        if (this.getExplicit()) {
            throw new PrismException("Export of transition rewards not yet supported by explicit engine");
        }
        if (this.currentModelType == ModelType.MDP) {
            if (!bl) {
                this.mainLog.printWarning("Cannot export unordered transition reward matrix for MDPs; using ordered.");
            }
            bl = true;
        }
        if (n == 4) {
            if (!bl) {
                this.mainLog.printWarning("Cannot export unordered transition reward matrix in MRMC format; using ordered.");
            }
            bl = true;
        }
        if (n == 5) {
            if (!bl) {
                this.mainLog.printWarning("Cannot export unordered transition matrix in rows format; using ordered.");
            }
            bl = true;
        }
        this.buildModelIfRequired();
        this.mainLog.print("\nExporting transition rewards matrix ");
        this.mainLog.print(Prism.getStringForExportType(n) + " ");
        this.mainLog.println(Prism.getDestinationStringForFile(file));
        String string = this.currentModel.exportTransRewardsToFile(n, bl, file);
        if (string != null) {
            this.mainLog.println("Rewards exported to files: " + string);
        }
    }

    public void exportBSCCsToFile(int n, File file) throws FileNotFoundException, PrismException {
        int n2;
        SCCComputer sCCComputer = null;
        explicit.SCCComputer sCCComputer2 = null;
        if (n == 4) {
            n = 1;
        }
        if (n == 5) {
            n = 1;
        }
        this.buildModelIfRequired();
        this.mainLog.println("\nComputing BSCCs...");
        long l = System.currentTimeMillis();
        if (!this.getExplicit()) {
            sCCComputer = this.getSCCComputer(this.currentModel);
            sCCComputer.computeBSCCs();
        } else {
            sCCComputer2 = this.getExplicitSCCComputer(this.currentModelExpl);
            sCCComputer2.computeBSCCs();
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.println("\nTime for BSCC computation: " + (double)l / 1000.0 + " seconds.");
        this.mainLog.print("\nExporting BSCCs ");
        this.mainLog.print(Prism.getStringForExportType(n) + " ");
        this.mainLog.println(Prism.getDestinationStringForFile(file));
        PrismLog prismLog = this.getPrismLogForFile(file);
        if (n == 2) {
            prismLog.print("% ");
        }
        prismLog.print("Variables: (");
        for (n2 = 0; n2 < this.currentModulesFile.getNumVars(); ++n2) {
            prismLog.print(this.currentModulesFile.getVarName(n2));
            if (n2 >= this.currentModulesFile.getNumVars() - 1) continue;
            prismLog.print(",");
        }
        prismLog.println(")");
        int n3 = !this.getExplicit() ? sCCComputer.getBSCCs().size() : sCCComputer2.getBSCCs().size();
        for (n2 = 0; n2 < n3; ++n2) {
            prismLog.println();
            if (n == 2) {
                prismLog.print("% ");
            }
            prismLog.println("BSCC " + (n2 + 1) + "/" + n3 + ":");
            if (n == 2) {
                prismLog.println("bscc" + (n2 + 1) + "=[");
            }
            if (!this.getExplicit()) {
                if (n != 2) {
                    new StateListMTBDD(sCCComputer.getBSCCs().get(n2), this.currentModel).print(prismLog);
                } else {
                    new StateListMTBDD(sCCComputer.getBSCCs().get(n2), this.currentModel).printMatlab(prismLog);
                }
                JDD.Deref(sCCComputer.getBSCCs().get(n2));
            } else {
                explicit.StateValues.createFromBitSet(sCCComputer2.getBSCCs().get(n2), this.currentModelExpl).print(prismLog, true, n == 2, true, true);
            }
            if (n != 2) continue;
            prismLog.println("];");
        }
        if (!this.getExplicit()) {
            JDD.Deref(sCCComputer.getNotInBSCCs());
        }
        if (file != null) {
            prismLog.close();
        }
    }

    public void exportMECsToFile(int n, File file) throws FileNotFoundException, PrismException {
        int n2;
        ECComputer eCComputer = null;
        explicit.ECComputer eCComputer2 = null;
        if (n == 4) {
            n = 1;
        }
        if (n == 5) {
            n = 1;
        }
        this.buildModelIfRequired();
        this.mainLog.println("\nComputing MECs...");
        long l = System.currentTimeMillis();
        if (!this.getExplicit()) {
            eCComputer = this.getECComputer((NondetModel)this.currentModel);
            eCComputer.computeMECStates();
        } else {
            eCComputer2 = this.getExplicitECComputer((explicit.NondetModel)this.currentModelExpl);
            eCComputer2.computeMECStates();
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.println("\nTime for MEC computation: " + (double)l / 1000.0 + " seconds.");
        this.mainLog.print("\nExporting MECs ");
        this.mainLog.print(Prism.getStringForExportType(n) + " ");
        this.mainLog.println(Prism.getDestinationStringForFile(file));
        PrismLog prismLog = this.getPrismLogForFile(file);
        if (n == 2) {
            prismLog.print("% ");
        }
        prismLog.print("Variables: (");
        for (n2 = 0; n2 < this.currentModulesFile.getNumVars(); ++n2) {
            prismLog.print(this.currentModulesFile.getVarName(n2));
            if (n2 >= this.currentModulesFile.getNumVars() - 1) continue;
            prismLog.print(",");
        }
        prismLog.println(")");
        int n3 = !this.getExplicit() ? eCComputer.getMECStates().size() : eCComputer2.getMECStates().size();
        for (n2 = 0; n2 < n3; ++n2) {
            prismLog.println();
            if (n == 2) {
                prismLog.print("% ");
            }
            prismLog.println("MEC " + (n2 + 1) + "/" + n3 + ":");
            if (n == 2) {
                prismLog.println("mec" + (n2 + 1) + "=[");
            }
            if (!this.getExplicit()) {
                if (n != 2) {
                    new StateListMTBDD(eCComputer.getMECStates().get(n2), this.currentModel).print(prismLog);
                } else {
                    new StateListMTBDD(eCComputer.getMECStates().get(n2), this.currentModel).printMatlab(prismLog);
                }
                JDD.Deref(eCComputer.getMECStates().get(n2));
            } else {
                explicit.StateValues.createFromBitSet(eCComputer2.getMECStates().get(n2), this.currentModelExpl).print(prismLog, true, n == 2, true, true);
            }
            if (n != 2) continue;
            prismLog.println("];");
        }
        if (file != null) {
            prismLog.close();
        }
    }

    public void exportSCCsToFile(int n, File file) throws FileNotFoundException, PrismException {
        int n2;
        SCCComputer sCCComputer = null;
        explicit.SCCComputer sCCComputer2 = null;
        if (n == 4) {
            n = 1;
        }
        if (n == 5) {
            n = 1;
        }
        this.buildModelIfRequired();
        this.mainLog.println("\nComputing SCCs...");
        long l = System.currentTimeMillis();
        if (!this.getExplicit()) {
            sCCComputer = this.getSCCComputer(this.currentModel);
            sCCComputer.computeSCCs();
        } else {
            sCCComputer2 = this.getExplicitSCCComputer(this.currentModelExpl);
            sCCComputer2.computeSCCs();
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.println("\nTime for SCC computation: " + (double)l / 1000.0 + " seconds.");
        this.mainLog.print("\nExporting SCCs ");
        this.mainLog.print(Prism.getStringForExportType(n) + " ");
        this.mainLog.println(Prism.getDestinationStringForFile(file));
        PrismLog prismLog = this.getPrismLogForFile(file);
        if (n == 2) {
            prismLog.print("% ");
        }
        prismLog.print("Variables: (");
        for (n2 = 0; n2 < this.currentModulesFile.getNumVars(); ++n2) {
            prismLog.print(this.currentModulesFile.getVarName(n2));
            if (n2 >= this.currentModulesFile.getNumVars() - 1) continue;
            prismLog.print(",");
        }
        prismLog.println(")");
        int n3 = !this.getExplicit() ? sCCComputer.getSCCs().size() : sCCComputer2.getSCCs().size();
        for (n2 = 0; n2 < n3; ++n2) {
            prismLog.println();
            if (n == 2) {
                prismLog.print("% ");
            }
            prismLog.println("SCC " + (n2 + 1) + "/" + n3 + ":");
            if (n == 2) {
                prismLog.println("scc" + (n2 + 1) + "=[");
            }
            if (!this.getExplicit()) {
                if (n != 2) {
                    new StateListMTBDD(sCCComputer.getSCCs().get(n2), this.currentModel).print(prismLog);
                } else {
                    new StateListMTBDD(sCCComputer.getSCCs().get(n2), this.currentModel).printMatlab(prismLog);
                }
                JDD.Deref(sCCComputer.getSCCs().get(n2));
            } else {
                explicit.StateValues.createFromBitSet(sCCComputer2.getSCCs().get(n2), this.currentModelExpl).print(prismLog, true, n == 2, true, true);
            }
            if (n != 2) continue;
            prismLog.println("];");
        }
        if (!this.getExplicit()) {
            JDD.Deref(sCCComputer.getNotInSCCs());
        }
        if (file != null) {
            prismLog.close();
        }
    }

    public void exportLabelsToFile(PropertiesFile propertiesFile, int n, File file) throws FileNotFoundException, PrismException {
        int n2;
        LabelList labelList;
        if (propertiesFile == null) {
            labelList = this.currentModulesFile.getLabelList();
            n2 = labelList.size();
        } else {
            labelList = propertiesFile.getCombinedLabelList();
            n2 = labelList.size();
        }
        this.buildModelIfRequired();
        this.mainLog.print("\nExporting labels and satisfying states ");
        this.mainLog.print(Prism.getStringForExportType(n) + " ");
        this.mainLog.println(Prism.getDestinationStringForFile(file));
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("init");
        arrayList.add("deadlock");
        for (int i = 0; i < n2; ++i) {
            arrayList.add(labelList.getLabelName(i));
        }
        if (this.getExplicit()) {
            PrismLog prismLog = this.getPrismLogForFile(file);
            explicit.StateModelChecker stateModelChecker = this.createModelCheckerExplicit(propertiesFile);
            stateModelChecker.exportLabels(this.currentModelExpl, arrayList, n, prismLog);
            prismLog.close();
        } else {
            StateModelChecker stateModelChecker = this.createModelChecker(propertiesFile);
            stateModelChecker.exportLabels(arrayList, n, file);
        }
    }

    public void exportStatesToFile(int n, File file) throws FileNotFoundException, PrismException {
        if (n == 4) {
            n = 1;
        }
        if (n == 5) {
            n = 1;
        }
        this.buildModelIfRequired();
        this.mainLog.print("\nExporting list of reachable states ");
        this.mainLog.print(Prism.getStringForExportType(n) + " ");
        this.mainLog.println(Prism.getDestinationStringForFile(file));
        PrismLog prismLog = this.getPrismLogForFile(file);
        if (!this.getExplicit()) {
            this.currentModel.exportStates(n, prismLog);
        } else {
            this.currentModelExpl.exportStates(n, this.currentModulesFile.createVarList(), prismLog);
        }
        if (file != null) {
            prismLog.close();
        }
    }

    public Result modelCheck(PropertiesFile propertiesFile, Expression expression) throws PrismException, PrismLangException {
        return this.modelCheck(propertiesFile, new Property(expression));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result modelCheck(PropertiesFile propertiesFile, Property property) throws PrismException, PrismLangException {
        Result result = null;
        Values values = propertiesFile.getConstantValues();
        boolean bl = false;
        int n = -1;
        if (!this.digital) {
            this.mainLog.printSeparator();
        }
        this.mainLog.println("\nModel checking: " + property);
        if (this.currentDefinedMFConstants != null && this.currentDefinedMFConstants.getNumValues() > 0) {
            this.mainLog.println("Model constants: " + this.currentDefinedMFConstants);
        }
        if (values != null && values.getNumValues() > 0) {
            this.mainLog.println("Property constants: " + values);
        }
        property.getExpression().checkValid(this.currentModelType);
        if (this.currentModelType == ModelType.PTA) {
            return this.modelCheckPTA(propertiesFile, property.getExpression(), values);
        }
        if (this.settings.getBoolean("prism.exact.enabled")) {
            return this.modelCheckExact(propertiesFile, property);
        }
        if (this.currentModelType == ModelType.CTMC && this.settings.getString("prism.transientMethod").equals("Fast adaptive uniformisation")) {
            FastAdaptiveUniformisationModelChecker fastAdaptiveUniformisationModelChecker = new FastAdaptiveUniformisationModelChecker(this, this.currentModulesFile, propertiesFile, this.getSimulator());
            return fastAdaptiveUniformisationModelChecker.check(property.getExpression());
        }
        if (this.currentModelType == ModelType.MDP && !Expression.containsMultiObjective(property.getExpression()) && this.getMDPSolnMethod() != 1 && !this.getExplicit()) {
            this.mainLog.printWarning("Switching to explicit engine to allow use of chosen MDP solution method.");
            bl = true;
            n = this.getEngine();
            this.setEngine(4);
        }
        try {
            this.buildModelIfRequired();
            if (this.genStrat && this.currentModelType.nondeterministic() && !this.getExplicit() && !((NondetModel)this.currentModel).areAllChoiceActionsUnique()) {
                throw new PrismException("Cannot generate strategies with the current engine because some state of the model do not have unique action labels for each choice. Either switch to the explicit engine or add more action labels to the model");
            }
            if (!this.getExplicit()) {
                StateModelChecker stateModelChecker = this.createModelChecker(propertiesFile);
                result = stateModelChecker.check(property.getExpression());
            } else {
                explicit.StateModelChecker stateModelChecker = this.createModelCheckerExplicit(propertiesFile);
                result = stateModelChecker.check(this.currentModelExpl, property.getExpression());
            }
        }
        finally {
            if (bl) {
                this.setEngine(n);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result modelCheckPTA(PropertiesFile propertiesFile, Expression expression, Values values) throws PrismException, PrismLangException {
        expression.checkValid(this.currentModelType);
        if (this.settings.getString("prism.ptaMethod").equals("Digital clocks")) {
            this.digital = true;
            ModulesFile modulesFile = this.currentModulesFile;
            try {
                DigitalClocks digitalClocks = new DigitalClocks(this);
                digitalClocks.translate(modulesFile, propertiesFile, expression);
                this.currentModulesFile = digitalClocks.getNewModulesFile();
                this.currentModulesFile.setUndefinedConstants(modulesFile.getConstantValues());
                this.currentModelType = ModelType.MDP;
                this.clearBuiltModel();
                this.currentModel = null;
                this.currentModelExpl = null;
                if (this.exportDigital) {
                    try {
                        this.exportPRISMModel(this.exportDigitalFile);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        this.mainLog.printWarning("PRISM code export failed: Couldn't open file \"" + this.exportDigitalFile + "\" for output");
                    }
                    catch (PrismException prismException) {
                        this.mainLog.printWarning("PRISM code export failed: " + prismException.getMessage());
                    }
                }
                Result result = this.modelCheck(propertiesFile, expression);
                return result;
            }
            finally {
                this.digital = false;
                this.currentModulesFile = modulesFile;
                this.currentModelType = ModelType.PTA;
                this.clearBuiltModel();
                this.currentModel = null;
                this.currentModelExpl = null;
            }
        }
        PTAModelChecker pTAModelChecker = new PTAModelChecker(this, this.currentModulesFile, propertiesFile);
        return pTAModelChecker.check(expression);
    }

    public boolean isPropertyOKForSimulation(Expression expression) {
        return this.getSimulator().isPropertyOKForSimulation(expression);
    }

    public void checkPropertyForSimulation(Expression expression) throws PrismException {
        this.getSimulator().checkPropertyForSimulation(expression);
    }

    public Result modelCheckSimulator(PropertiesFile propertiesFile, Expression expression, Values values, State state, long l, SimulationMethod simulationMethod) throws PrismException {
        Object object = null;
        this.mainLog.printSeparator();
        this.mainLog.println("\nSimulating: " + expression);
        if (this.currentDefinedMFConstants != null && this.currentDefinedMFConstants.getNumValues() > 0) {
            this.mainLog.println("Model constants: " + this.currentDefinedMFConstants);
        }
        if (values != null && values.getNumValues() > 0) {
            this.mainLog.println("Property constants: " + values);
        }
        expression.checkValid(this.currentModelType);
        object = this.getSimulator().modelCheckSingleProperty(this.currentModulesFile, propertiesFile, expression, state, l, simulationMethod);
        return new Result(object);
    }

    public Result[] modelCheckSimulatorSimultaneously(PropertiesFile propertiesFile, List<Expression> list, Values values, State state, long l, SimulationMethod simulationMethod) throws PrismException {
        Object[] objectArray = null;
        this.mainLog.printSeparator();
        this.mainLog.print("\nSimulating");
        if (list.size() == 1) {
            this.mainLog.println(": " + list.get(0));
        } else {
            this.mainLog.println(" " + list.size() + " properties:");
            for (int i = 0; i < list.size(); ++i) {
                this.mainLog.println(" " + list.get(i));
            }
        }
        if (this.currentDefinedMFConstants != null && this.currentDefinedMFConstants.getNumValues() > 0) {
            this.mainLog.println("Model constants: " + this.currentDefinedMFConstants);
        }
        if (values != null && values.getNumValues() > 0) {
            this.mainLog.println("Property constants: " + values);
        }
        for (Expression expression : list) {
            expression.checkValid(this.currentModelType);
        }
        objectArray = this.getSimulator().modelCheckMultipleProperties(this.currentModulesFile, propertiesFile, list, state, l, simulationMethod);
        Result[] resultArray = new Result[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            resultArray[i] = new Result(objectArray[i]);
        }
        return resultArray;
    }

    public void modelCheckSimulatorExperiment(PropertiesFile propertiesFile, UndefinedConstants undefinedConstants, ResultsCollection resultsCollection, Expression expression, State state, long l, SimulationMethod simulationMethod) throws PrismException, InterruptedException {
        this.mainLog.printSeparator();
        this.mainLog.println("\nSimulating: " + expression);
        if (this.currentDefinedMFConstants != null && this.currentDefinedMFConstants.getNumValues() > 0) {
            this.mainLog.println("Model constants: " + this.currentDefinedMFConstants);
        }
        this.mainLog.println("Property constants: " + undefinedConstants.getPFDefinedConstantsString());
        this.getSimulator().modelCheckExperiment(this.currentModulesFile, propertiesFile, undefinedConstants, resultsCollection, expression, state, l, simulationMethod);
    }

    public Result modelCheckExact(PropertiesFile propertiesFile, Property property) throws PrismException {
        if (this.currentModelType != ModelType.DTMC && this.currentModelType != ModelType.CTMC && this.currentModelType != ModelType.MDP) {
            throw new PrismException("Exact model checking is only supported for DTMCs, CTMCs and MDPs");
        }
        String[] stringArray = new String[]{"dummy"};
        String[] stringArray2 = new String[]{"0"};
        String[] stringArray3 = new String[]{"1"};
        ModelBuilder modelBuilder = new ModelBuilder(this);
        modelBuilder.setModulesFile(this.currentModulesFile);
        modelBuilder.setParameters(stringArray, stringArray2, stringArray3);
        modelBuilder.build();
        explicit.Model model = modelBuilder.getModel();
        ParamModelChecker paramModelChecker = new ParamModelChecker(this);
        paramModelChecker.setModelBuilder(modelBuilder);
        paramModelChecker.setParameters(stringArray, stringArray2, stringArray3);
        paramModelChecker.setModulesFileAndPropertiesFile(this.currentModulesFile, propertiesFile);
        Result result = paramModelChecker.check(model, property.getExpression());
        RegionValues regionValues = (RegionValues)result.getResult();
        if (regionValues.getNumRegions() != 1) {
            throw new PrismException("Unexpected result from paramteric model checker");
        }
        Function function = regionValues.getResult(0).getInitStateValueAsFunction();
        BigRational bigRational = function.evaluate(new Point(new BigRational[]{new BigRational(0L)}));
        result.setResult(bigRational);
        String string = "Result";
        if (!"Result".equals(property.getExpression().getResultName())) {
            string = string + " (" + property.getExpression().getResultName().toLowerCase() + ")";
        }
        string = string + ": " + result.getResultString();
        this.mainLog.print("\n" + string);
        return result;
    }

    public Result modelCheckParametric(PropertiesFile propertiesFile, Property property, String[] stringArray, String[] stringArray2, String[] stringArray3) throws PrismException {
        if (stringArray == null) {
            throw new PrismException("Must specify some parameters when using the parametric analysis");
        }
        if (this.currentModelType != ModelType.DTMC && this.currentModelType != ModelType.CTMC && this.currentModelType != ModelType.MDP) {
            throw new PrismException("Parametric model checking is only supported for DTMCs, CTMCs and MDPs");
        }
        Values values = propertiesFile.getConstantValues();
        Values values2 = this.currentModulesFile.getConstantValues();
        for (int i = 0; i < stringArray.length; ++i) {
            values2.removeValue(stringArray[i]);
        }
        this.mainLog.printSeparator();
        this.mainLog.println("\nParametric model checking: " + property);
        if (this.currentDefinedMFConstants != null && this.currentDefinedMFConstants.getNumValues() > 0) {
            this.mainLog.println("Model constants: " + this.currentDefinedMFConstants);
        }
        if (values != null && values.getNumValues() > 0) {
            this.mainLog.println("Property constants: " + values);
        }
        ModelBuilder modelBuilder = new ModelBuilder(this);
        modelBuilder.setModulesFile(this.currentModulesFile);
        modelBuilder.setParameters(stringArray, stringArray2, stringArray3);
        modelBuilder.build();
        explicit.Model model = modelBuilder.getModel();
        ParamModelChecker paramModelChecker = new ParamModelChecker(this);
        paramModelChecker.setModelBuilder(modelBuilder);
        paramModelChecker.setParameters(stringArray, stringArray2, stringArray3);
        paramModelChecker.setModulesFileAndPropertiesFile(this.currentModulesFile, propertiesFile);
        Result result = paramModelChecker.check(model, property.getExpression());
        String string = "Result";
        if (!"Result".equals(property.getExpression().getResultName())) {
            string = string + " (" + property.getExpression().getResultName().toLowerCase() + ")";
        }
        string = string + ": " + result.getResultString();
        this.mainLog.print("\n" + string);
        return result;
    }

    public void exportStrategy(Strategy strategy, StrategyExportType strategyExportType, File file) throws FileNotFoundException, PrismException {
        this.mainLog.print("\nExporting strategy " + strategyExportType.description() + " ");
        this.mainLog.println(Prism.getDestinationStringForFile(file));
        PrismLog prismLog = this.getPrismLogForFile(file);
        switch (strategyExportType) {
            case ACTIONS: {
                strategy.exportActions(prismLog);
                break;
            }
            case INDICES: {
                strategy.exportIndices(prismLog);
                break;
            }
            case INDUCED_MODEL: {
                strategy.exportInducedModel(prismLog);
                break;
            }
            case DOT_FILE: {
                strategy.exportDotFile(prismLog);
            }
        }
        if (file != null) {
            prismLog.close();
        }
    }

    public void generateSimulationPath(ModulesFile modulesFile, String string, long l, File file) throws PrismException, PrismLangException {
        GenerateSimulationPath generateSimulationPath = new GenerateSimulationPath(this.getSimulator(), this.mainLog);
        generateSimulationPath.generateSimulationPath(modulesFile, null, string, l, file);
    }

    public void doSteadyState() throws PrismException {
        this.doSteadyState(1, null, null);
    }

    public void doSteadyState(int n, File file, File file2) throws PrismException {
        long l = 0L;
        StateValues stateValues = null;
        explicit.StateValues stateValues2 = null;
        if (this.currentModelType != ModelType.CTMC && this.currentModelType != ModelType.DTMC) {
            throw new PrismException("Steady-state probabilities only computed for DTMCs/CTMCs");
        }
        if (file != null && this.getEngine() == 1) {
            throw new PrismException("Steady-state probability export not supported for MTBDD engine");
        }
        if (n == 4) {
            n = 1;
        }
        if (n == 5) {
            n = 1;
        }
        this.mainLog.printSeparator();
        this.mainLog.println("\nComputing steady-state probabilities...");
        this.buildModelIfRequired();
        l = System.currentTimeMillis();
        if (!this.getExplicit()) {
            stateValues = this.computeSteadyStateProbabilities(this.currentModel, file2);
        } else {
            stateValues2 = this.computeSteadyStateProbabilitiesExplicit(this.currentModelExpl, file2);
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.print("\nPrinting steady-state probabilities ");
        this.mainLog.print(Prism.getStringForExportType(n) + " ");
        this.mainLog.println(Prism.getDestinationStringForFile(file));
        PrismLog prismLog = this.getPrismLogForFile(file);
        if (!this.getExplicit()) {
            stateValues.print(prismLog, file == null, n == 2, file == null, file == null);
        } else {
            stateValues2.print(prismLog, file == null, n == 2, file == null, file == null);
        }
        this.mainLog.println("\nTime for steady-state probability computation: " + (double)l / 1000.0 + " seconds.");
        if (!this.getExplicit()) {
            stateValues.clear();
        } else {
            stateValues2.clear();
        }
        if (file != null) {
            prismLog.close();
        }
    }

    protected StateValues computeSteadyStateProbabilities(Model model, File file) throws PrismException {
        ProbModelChecker probModelChecker;
        if (model.getModelType() == ModelType.DTMC) {
            probModelChecker = new ProbModelChecker(this, model, null);
        } else if (model.getModelType() == ModelType.CTMC) {
            probModelChecker = new StochModelChecker(this, model, null);
        } else {
            throw new PrismException("Steady-state probabilities only computed for DTMCs/CTMCs");
        }
        return probModelChecker.doSteadyState(file);
    }

    protected explicit.StateValues computeSteadyStateProbabilitiesExplicit(explicit.Model model, File file) throws PrismException {
        if (model.getModelType() != ModelType.DTMC) {
            if (model.getModelType() == ModelType.CTMC) {
                throw new PrismException("Not implemented yet");
            }
            throw new PrismException("Steady-state probabilities only computed for DTMCs/CTMCs");
        }
        DTMCModelChecker dTMCModelChecker = new DTMCModelChecker(this);
        explicit.StateValues stateValues = dTMCModelChecker.doSteadyState((DTMC)model, (File)null);
        return stateValues;
    }

    public void doTransient(double d) throws PrismException {
        this.doTransient(d, 1, null, null);
    }

    public void doTransient(double d, int n, File file, File file2) throws PrismException {
        long l = 0L;
        ProbModelChecker probModelChecker = null;
        StateValues stateValues = null;
        explicit.StateValues stateValues2 = null;
        if (this.currentModelType != ModelType.CTMC && this.currentModelType != ModelType.DTMC) {
            throw new PrismException("Steady-state probabilities only computed for DTMCs/CTMCs");
        }
        if (d < 0.0) {
            throw new PrismException("Cannot compute transient probabilities for negative time value");
        }
        if (file != null && this.getEngine() == 1) {
            throw new PrismException("Transient probability export only supported for sparse/hybrid engines");
        }
        if (n == 4) {
            n = 1;
        }
        if (n == 5) {
            n = 1;
        }
        this.mainLog.printSeparator();
        String string = this.currentModelType.continuousTime() ? Double.toString(d) : Integer.toString((int)d);
        this.mainLog.println("\nComputing transient probabilities (time = " + string + ")...");
        l = System.currentTimeMillis();
        if (this.currentModelType == ModelType.CTMC && this.settings.getString("prism.transientMethod").equals("Fast adaptive uniformisation")) {
            PrismModelExplorer prismModelExplorer = new PrismModelExplorer(this.getSimulator(), this.currentModulesFile);
            FastAdaptiveUniformisation fastAdaptiveUniformisation = new FastAdaptiveUniformisation(this, prismModelExplorer);
            fastAdaptiveUniformisation.setConstantValues(this.currentModulesFile.getConstantValues());
            stateValues2 = fastAdaptiveUniformisation.doTransient(d, file2, this.currentModel);
        } else if (!this.getExplicit()) {
            this.buildModelIfRequired();
            if (this.currentModelType == ModelType.DTMC) {
                probModelChecker = new ProbModelChecker(this, this.currentModel, null);
                stateValues = probModelChecker.doTransient((int)d, file2);
            } else {
                probModelChecker = new StochModelChecker(this, this.currentModel, null);
                stateValues = ((StochModelChecker)probModelChecker).doTransient(d, file2);
            }
        } else {
            this.buildModelIfRequired();
            if (this.currentModelType == ModelType.DTMC) {
                throw new PrismException("Not implemented yet");
            }
            if (this.currentModelType == ModelType.CTMC) {
                CTMCModelChecker cTMCModelChecker = new CTMCModelChecker(this);
                stateValues2 = cTMCModelChecker.doTransient((CTMC)this.currentModelExpl, d, file2);
            } else {
                throw new PrismException("Transient probabilities only computed for DTMCs/CTMCs");
            }
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.print("\nPrinting transient probabilities ");
        this.mainLog.print(Prism.getStringForExportType(n) + " ");
        this.mainLog.println(Prism.getDestinationStringForFile(file));
        PrismLog prismLog = this.getPrismLogForFile(file);
        if (stateValues != null) {
            stateValues.print(prismLog, file == null, n == 2, file == null, file == null);
        } else {
            stateValues2.print(prismLog, file == null, n == 2, file == null, file == null);
        }
        this.mainLog.println("\nTime for transient probability computation: " + (double)l / 1000.0 + " seconds.");
        if (stateValues != null) {
            stateValues.clear();
        }
        if (stateValues2 != null) {
            stateValues2.clear();
        }
        if (file != null) {
            prismLog.close();
        }
    }

    public void doTransient(UndefinedConstants undefinedConstants, int n, File file, File file2) throws PrismException {
        int n2 = 0;
        int n3 = 0;
        double d = 0.0;
        double d2 = 0.0;
        long l = 0L;
        StateValues stateValues = null;
        StateValues stateValues2 = null;
        explicit.StateValues stateValues3 = null;
        explicit.StateValues stateValues4 = null;
        PrismLog prismLog = null;
        File file3 = null;
        if (this.currentModelType != ModelType.CTMC && this.currentModelType != ModelType.DTMC) {
            throw new PrismException("Steady-state probabilities only computed for DTMCs/CTMCs");
        }
        if (file != null && this.getEngine() == 1) {
            throw new PrismException("Transient probability export only supported for sparse/hybrid engines");
        }
        if (n == 4) {
            n = 1;
        }
        if (n == 5) {
            n = 1;
        }
        for (int i = 0; i < undefinedConstants.getNumPropertyIterations(); ++i) {
            Object object;
            Object object2 = undefinedConstants.getPFConstantValues().getValue(0);
            if (this.currentModelType.continuousTime()) {
                d = (Double)object2;
            } else {
                n2 = (Integer)object2;
            }
            if (this.currentModelType.continuousTime() ? (Double)object2 < 0.0 : (Integer)object2 < 0) {
                throw new PrismException("Cannot compute transient probabilities for negative time value");
            }
            this.mainLog.printSeparator();
            this.mainLog.println("\nComputing transient probabilities (time = " + object2 + ")...");
            l = System.currentTimeMillis();
            if (this.currentModelType == ModelType.CTMC && this.settings.getString("prism.transientMethod").equals("Fast adaptive uniformisation")) {
                object = new PrismModelExplorer(this.getSimulator(), this.currentModulesFile);
                FastAdaptiveUniformisation fastAdaptiveUniformisation = new FastAdaptiveUniformisation(this, (ModelExplorer)object);
                fastAdaptiveUniformisation.setConstantValues(this.currentModulesFile.getConstantValues());
                if (i == 0) {
                    stateValues3 = fastAdaptiveUniformisation.doTransient(d, file2, this.currentModel);
                    d2 = 0.0;
                } else {
                    stateValues3 = fastAdaptiveUniformisation.doTransient(d - d2, stateValues3);
                }
            } else if (!this.getExplicit()) {
                this.buildModelIfRequired();
                if (this.currentModelType.continuousTime()) {
                    object = new StochModelChecker(this, this.currentModel, null);
                    if (i == 0) {
                        stateValues2 = ((ProbModelChecker)object).readDistributionFromFile(file2);
                        d2 = 0.0;
                    }
                    stateValues = ((StochModelChecker)object).doTransient(d - d2, stateValues2);
                } else {
                    object = new ProbModelChecker(this, this.currentModel, null);
                    if (i == 0) {
                        stateValues2 = ((ProbModelChecker)object).readDistributionFromFile(file2);
                        n3 = 0;
                    }
                    stateValues = ((ProbModelChecker)object).doTransient(n2 - n3, stateValues2);
                }
            } else {
                this.buildModelIfRequired();
                if (this.currentModelType.continuousTime()) {
                    object = new CTMCModelChecker(this);
                    if (i == 0) {
                        stateValues4 = ((DTMCModelChecker)object).readDistributionFromFile(file2, this.currentModelExpl);
                        d2 = 0.0;
                    }
                    stateValues3 = ((CTMCModelChecker)object).doTransient((CTMC)this.currentModelExpl, d - d2, stateValues4);
                } else {
                    throw new PrismException("Not implemented yet");
                }
            }
            l = System.currentTimeMillis() - l;
            file3 = file != null && undefinedConstants.getNumPropertyIterations() > 1 ? new File(PrismUtils.addSuffixToFilename(file.getPath(), object2.toString())) : file;
            this.mainLog.print("\nPrinting transient probabilities ");
            this.mainLog.print(Prism.getStringForExportType(n) + " ");
            this.mainLog.println(Prism.getDestinationStringForFile(file3));
            prismLog = this.getPrismLogForFile(file3);
            if (stateValues != null) {
                stateValues.print(prismLog, file == null, n == 2, file == null);
            } else if (!this.settings.getString("prism.transientMethod").equals("Fast adaptive uniformisation")) {
                stateValues3.print(prismLog, file == null, n == 2, file == null, true);
            } else {
                stateValues3.print(prismLog, file == null, n == 2, true, false);
            }
            this.mainLog.println("\nTime for transient probability computation: " + (double)l / 1000.0 + " seconds.");
            stateValues2 = stateValues;
            stateValues4 = stateValues3;
            n3 = n2;
            d2 = d;
            undefinedConstants.iterateProperty();
        }
        if (stateValues != null) {
            stateValues.clear();
        }
        if (stateValues3 != null) {
            stateValues3.clear();
        }
        if (file != null) {
            prismLog.close();
        }
    }

    public void explicitBuildTest() throws PrismException {
    }

    private void clearBuiltModel() {
        if (this.currentModel != null) {
            this.currentModel.clear();
        }
    }

    public void closeDown() {
        this.closeDown(true);
    }

    public void closeDown(boolean bl) {
        this.clearBuiltModel();
        PrismNative.closeDown();
        PrismMTBDD.closeDown();
        PrismSparse.closeDown();
        PrismHybrid.closeDown();
        ParamModelChecker.closeDown();
        if (this.cuddStarted) {
            JDD.CloseDownCUDD(bl);
        }
    }

    private StateModelChecker createModelChecker(PropertiesFile propertiesFile) throws PrismException {
        if (propertiesFile == null) {
            propertiesFile = this.parsePropertiesString(this.currentModulesFile, "");
        }
        StateModelChecker stateModelChecker = StateModelChecker.createModelChecker(this.currentModelType, this, this.currentModel, propertiesFile);
        return stateModelChecker;
    }

    private explicit.StateModelChecker createModelCheckerExplicit(PropertiesFile propertiesFile) throws PrismException {
        explicit.StateModelChecker stateModelChecker = explicit.StateModelChecker.createModelChecker(this.currentModelType, this);
        stateModelChecker.setModulesFileAndPropertiesFile(this.currentModulesFile, propertiesFile);
        stateModelChecker.setExportTarget(this.exportTarget);
        stateModelChecker.setExportTargetFilename(this.exportTargetFilename);
        stateModelChecker.setExportProductTrans(this.exportProductTrans);
        stateModelChecker.setExportProductTransFilename(this.exportProductTransFilename);
        stateModelChecker.setExportProductStates(this.exportProductStates);
        stateModelChecker.setExportProductStatesFilename(this.exportProductStatesFilename);
        stateModelChecker.setStoreVector(this.storeVector);
        stateModelChecker.setGenStrat(this.genStrat);
        stateModelChecker.setDoBisim(this.doBisim);
        return stateModelChecker;
    }

    private PrismLog getPrismLogForFile(File file) throws PrismException {
        return this.getPrismLogForFile(file, false);
    }

    private PrismLog getPrismLogForFile(File file, boolean bl) throws PrismException {
        PrismLog prismLog = file != null ? PrismFileLog.create(file.getPath(), bl) : this.mainLog;
        return prismLog;
    }

    private static String getStringForExportType(int n) {
        switch (n) {
            case 1: {
                return "in plain text format";
            }
            case 2: {
                return "in Matlab format";
            }
            case 3: {
                return "in Dot format";
            }
            case 4: {
                return "in MRMC format";
            }
            case 5: {
                return "in rows format";
            }
            case 6: {
                return "in Dot format (with states)";
            }
        }
        return "in ? format";
    }

    private static String getDestinationStringForFile(File file) {
        return file == null ? "below:" : "to file \"" + file + "\"...";
    }

    public Model buildModel(ModulesFile modulesFile) throws PrismException {
        this.loadPRISMModel(modulesFile);
        this.buildModel();
        return this.getBuiltModel();
    }

    public void exportToSpyFile(Model model, File file) throws FileNotFoundException, PrismException {
        this.loadBuiltModel(model);
        this.exportToSpyFile(file);
    }

    public void exportToDotFile(Model model, File file) throws FileNotFoundException, PrismException {
        this.loadBuiltModel(model);
        this.exportToDotFile(file);
    }

    public void exportToFile(Model model, boolean bl, int n, File file) throws FileNotFoundException, PrismException {
        this.exportTransToFile(model, bl, n, file);
    }

    public void exportTransToFile(Model model, boolean bl, int n, File file) throws FileNotFoundException, PrismException {
        this.loadBuiltModel(model);
        this.exportTransToFile(bl, n, file);
    }

    public void exportStateRewardsToFile(Model model, int n, File file) throws FileNotFoundException, PrismException {
        this.loadBuiltModel(model);
        this.exportStateRewardsToFile(n, file);
    }

    public void exportTransRewardsToFile(Model model, boolean bl, int n, File file) throws FileNotFoundException, PrismException {
        this.loadBuiltModel(model);
        this.exportTransRewardsToFile(bl, n, file);
    }

    public void exportBSCCsToFile(Model model, int n, File file) throws FileNotFoundException, PrismException {
        this.loadBuiltModel(model);
        this.exportBSCCsToFile(n, file);
    }

    public void exportLabelsToFile(Model model, ModulesFile modulesFile, PropertiesFile propertiesFile, int n, File file) throws FileNotFoundException, PrismException {
        this.loadPRISMModelAndBuiltModel(modulesFile, model);
        this.exportLabelsToFile(propertiesFile, n, file);
    }

    public void exportStatesToFile(Model model, int n, File file) throws FileNotFoundException, PrismException {
        this.loadBuiltModel(model);
        this.exportStateRewardsToFile(n, file);
    }

    public Result modelCheck(Model model, PropertiesFile propertiesFile, Expression expression) throws PrismException, PrismLangException {
        this.loadBuiltModel(model);
        return this.modelCheck(propertiesFile, expression);
    }

    public Result modelCheckPTA(ModulesFile modulesFile, PropertiesFile propertiesFile, Expression expression) throws PrismException, PrismLangException {
        this.loadPRISMModel(modulesFile);
        return this.modelCheckPTA(propertiesFile, expression, null);
    }

    public Result modelCheckSimulator(ModulesFile modulesFile, PropertiesFile propertiesFile, Expression expression, State state, long l, SimulationMethod simulationMethod) throws PrismException {
        this.loadPRISMModel(modulesFile);
        return this.modelCheckSimulator(propertiesFile, expression, null, state, l, simulationMethod);
    }

    public Result[] modelCheckSimulatorSimultaneously(ModulesFile modulesFile, PropertiesFile propertiesFile, List<Expression> list, State state, long l, SimulationMethod simulationMethod) throws PrismException {
        this.loadPRISMModel(modulesFile);
        return this.modelCheckSimulatorSimultaneously(propertiesFile, list, null, state, l, simulationMethod);
    }

    public void modelCheckSimulatorExperiment(ModulesFile modulesFile, PropertiesFile propertiesFile, UndefinedConstants undefinedConstants, ResultsCollection resultsCollection, Expression expression, State state, long l, SimulationMethod simulationMethod) throws PrismException, InterruptedException {
        this.loadPRISMModel(modulesFile);
        this.modelCheckSimulatorExperiment(propertiesFile, undefinedConstants, resultsCollection, expression, state, l, simulationMethod);
    }

    public void doSteadyState(Model model) throws PrismException {
        this.doSteadyState(model, 1, null);
    }

    public void doSteadyState(Model model, int n, File file) throws PrismException {
        this.loadBuiltModel(model);
        this.doSteadyState(n, file, null);
    }

    public void doTransient(Model model, double d) throws PrismException {
        this.doTransient(model, d, 1, null, null);
    }

    public void doTransient(Model model, double d, int n, File file, File file2) throws PrismException {
        this.loadBuiltModel(model);
        this.doTransient(d, n, file, file2);
    }

    static {
        try {
            buildNumber = Prism.class.getClassLoader().loadClass("prism.Revision").getField("svnRevision").get(null).toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        engineStrings = new String[]{"?", "MTBDD", "Sparse", "Hybrid", "Explicit"};
        thePrismParser = null;
        prismParserInUse = false;
        REACH_BFS = 1;
        REACH_FRONTIER = 2;
    }

    private static enum ModelSource {
        PRISM_MODEL,
        EXPLICIT_FILES,
        BUILT_MODEL;

    }

    public static enum StrategyExportType {
        ACTIONS,
        INDICES,
        INDUCED_MODEL,
        DOT_FILE;


        public String description() {
            switch (this) {
                case ACTIONS: {
                    return "as actions";
                }
                case INDICES: {
                    return "as indices";
                }
                case INDUCED_MODEL: {
                    return "as an induced model";
                }
                case DOT_FILE: {
                    return "as a dot file";
                }
            }
            return this.toString();
        }
    }
}

