/*
 * Decompiled with CFR 0.152.
 */
package prism;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import prism.Operator;
import prism.OpsAndBoundsList;

public class Point {
    protected static final double SMALL_NUMBER = 1.0E-5;
    private double[] coords;

    public Point(int n) {
        this.coords = new double[n];
    }

    public Point(double[] dArray) {
        this.coords = dArray;
    }

    public double getCoord(int n) {
        return this.coords[n];
    }

    public void setCoord(int n, double d) {
        this.coords[n] = d;
    }

    public int getDimension() {
        return this.coords.length;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Point)) {
            return false;
        }
        Point point = (Point)object;
        if (point.getDimension() != this.getDimension()) {
            return false;
        }
        for (int i = 0; i < this.getDimension(); ++i) {
            if (point.getCoord(i) == this.getCoord(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return (int)(this.coords[0] * 100.0);
    }

    public boolean isCloseTo(Point point) {
        if (point.getDimension() != this.getDimension()) {
            return false;
        }
        for (int i = 0; i < this.getDimension(); ++i) {
            if (!(Math.abs(point.getCoord(i) - this.getCoord(i)) >= 1.0E-5)) continue;
            return false;
        }
        return true;
    }

    public Point normalize() {
        double[] dArray = new double[this.coords.length];
        double d = 0.0;
        double[] dArray2 = this.coords;
        int n = dArray2.length;
        for (int i = 0; i < n; ++i) {
            Double d2 = dArray2[i];
            d += Math.abs(d2);
        }
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Math.abs(this.coords[i]) / d;
            if (!(dArray[i] < 1.0E-10)) continue;
            dArray[i] = 0.0;
        }
        return new Point(dArray);
    }

    public double distanceTo(Point point) throws IllegalArgumentException {
        if (point.getDimension() != this.getDimension()) {
            throw new IllegalArgumentException("The method Point.distanceTo(Point) can be only applied to points of equal dimensions");
        }
        double d = 0.0;
        for (int i = 0; i < this.getDimension(); ++i) {
            d += Math.pow(this.getCoord(i) - point.getCoord(i), 2.0);
        }
        return Math.sqrt(d);
    }

    public double euclideanNorm() {
        return this.distanceTo(new Point(this.getDimension()));
    }

    public String toString() {
        return Arrays.toString(this.coords).replace('[', '(').replace(']', ')');
    }

    public Point clone() {
        return new Point((double[])this.coords.clone());
    }

    public double[] getCoords() {
        return (double[])this.coords.clone();
    }

    public Point project(BitSet bitSet) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (int i = 0; i < this.getDimension(); ++i) {
            if (!bitSet.get(i)) continue;
            arrayList.add(this.getCoord(i));
        }
        double[] dArray = new double[arrayList.size()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = (Double)arrayList.get(i);
        }
        return new Point(dArray);
    }

    public Point toRealProperties(OpsAndBoundsList opsAndBoundsList) {
        int n;
        double[] dArray = (double[])this.coords.clone();
        for (n = 0; n < opsAndBoundsList.probSize(); ++n) {
            if (!opsAndBoundsList.isProbNegated(n)) continue;
            dArray[n] = 1.0 - dArray[n];
        }
        for (n = 0; n < opsAndBoundsList.rewardSize(); ++n) {
            if (opsAndBoundsList.getRewardOperator(n) != Operator.R_MIN && opsAndBoundsList.getRewardOperator(n) != Operator.R_LE) continue;
            dArray[n + opsAndBoundsList.probSize()] = -dArray[n + opsAndBoundsList.probSize()];
        }
        return new Point(dArray);
    }

    public boolean isZero() {
        for (int i = 0; i < this.getDimension(); ++i) {
            if (this.getCoord(i) == 0.0) continue;
            return false;
        }
        return true;
    }
}

