/*
 * Decompiled with CFR 0.152.
 */
package prism;

import acceptance.AcceptanceOmega;
import acceptance.AcceptanceOmegaDD;
import acceptance.AcceptanceRabin;
import acceptance.AcceptanceReachDD;
import acceptance.AcceptanceType;
import automata.DA;
import automata.LTL2DA;
import dv.DoubleVector;
import dv.IntegerVector;
import explicit.MinMax;
import hybrid.PrismHybrid;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Vector;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;
import mtbdd.PrismMTBDD;
import odd.ODDUtils;
import parser.ast.Expression;
import parser.ast.ExpressionFunc;
import parser.ast.ExpressionProb;
import parser.ast.ExpressionQuant;
import parser.ast.ExpressionReward;
import parser.ast.ExpressionTemporal;
import parser.ast.ExpressionUnaryOp;
import parser.ast.PropertiesFile;
import parser.ast.RelOp;
import prism.ECComputer;
import prism.ECComputerDefault;
import prism.Filter;
import prism.IntegerBound;
import prism.LTLModelChecker;
import prism.Model;
import prism.MultiObjModelChecker;
import prism.NonProbModelChecker;
import prism.NondetModel;
import prism.OpRelOpBound;
import prism.Operator;
import prism.OpsAndBoundsList;
import prism.Prism;
import prism.PrismException;
import prism.PrismFileLog;
import prism.PrismLog;
import prism.PrismNative;
import prism.StateValues;
import prism.StateValuesDV;
import prism.StateValuesMTBDD;
import prism.StateValuesVoid;
import prism.TileList;
import sparse.PrismSparse;
import strat.MDStrategyIV;

public class NondetModelChecker
extends NonProbModelChecker {
    protected NondetModel model;
    protected JDDNode nondetMask;
    protected JDDVars allDDNondetVars;
    protected boolean precomp;
    protected boolean prob0;
    protected boolean prob1;
    protected boolean fairness;

    public NondetModelChecker(Prism prism, Model model, PropertiesFile propertiesFile) throws PrismException {
        super(prism, model, propertiesFile);
        boolean bl;
        if (!(model instanceof NondetModel)) {
            throw new PrismException("Wrong model type passed to NondetModelChecker.");
        }
        this.model = (NondetModel)model;
        this.nondetMask = this.model.getNondetMask();
        this.allDDNondetVars = this.model.getAllDDNondetVars();
        this.precomp = prism.getPrecomp();
        this.prob0 = prism.getProb0();
        this.prob1 = prism.getProb1();
        this.fairness = prism.getFairness();
        boolean bl2 = bl = this.genStrat || prism.getExportAdv() != 1;
        if (bl) {
            if (this.engine != 2) {
                this.mainLog.println("Switching engine since only sparse engine currently supports this computation...");
                this.engine = 2;
            }
            if (this.precomp && this.prob1) {
                this.mainLog.printWarning("Disabling Prob1 since this is needed for adversary generation");
                this.prob1 = false;
            }
        }
        PrismNative.setCompact(prism.getCompact());
        PrismNative.setTermCrit(prism.getTermCrit());
        PrismNative.setTermCritParam(prism.getTermCritParam());
        PrismNative.setMaxIters(prism.getMaxIters());
        PrismNative.setSBMaxMem(prism.getSBMaxMem());
        PrismNative.setNumSBLevels(prism.getNumSBLevels());
        PrismNative.setExportAdv(prism.getExportAdv());
        PrismNative.setExportAdvFilename(prism.getExportAdvFilename());
    }

    @Override
    public StateValues checkExpression(Expression expression) throws PrismException {
        StateValues stateValues = expression instanceof ExpressionProb ? this.checkExpressionProb((ExpressionProb)expression) : (expression instanceof ExpressionReward ? this.checkExpressionReward((ExpressionReward)expression) : (expression instanceof ExpressionFunc ? (((ExpressionFunc)expression).getName().equals("multi") ? this.checkExpressionMultiObjective((ExpressionFunc)expression) : super.checkExpression(expression)) : super.checkExpression(expression)));
        if (stateValues instanceof StateValuesMTBDD) {
            stateValues.filter(this.reach);
        }
        return stateValues;
    }

    protected StateValues checkExpressionProb(ExpressionProb expressionProb) throws PrismException {
        OpRelOpBound opRelOpBound = expressionProb.getRelopBoundInfo(this.constantValues);
        MinMax minMax = opRelOpBound.getMinMax(this.model.getModelType());
        if (opRelOpBound.isTriviallyTrue()) {
            this.mainLog.printWarning("Checking for probability " + opRelOpBound.relOpBoundString() + " - formula trivially satisfies all states");
            JDD.Ref(this.reach);
            return new StateValuesMTBDD(this.reach, this.model);
        }
        if (opRelOpBound.isTriviallyFalse()) {
            this.mainLog.printWarning("Checking for probability " + opRelOpBound.relOpBoundString() + " - formula trivially satisfies no states");
            return new StateValuesMTBDD(JDD.Constant(0.0), this.model);
        }
        boolean bl = opRelOpBound.isQualitative() && this.precomp && this.prob0 && this.prob1;
        StateValues stateValues = this.checkProbPathFormula(expressionProb.getExpression(), bl, minMax.isMin());
        if (this.verbose) {
            this.mainLog.print("\n" + (minMax.isMin() ? "Minimum" : "Maximum") + " probabilities (non-zero only) for all states:\n");
            stateValues.print(this.mainLog);
        }
        if (opRelOpBound.isNumeric()) {
            return stateValues;
        }
        JDDNode jDDNode = stateValues.getBDDFromInterval(opRelOpBound.getRelOp(), opRelOpBound.getBound());
        JDD.Ref(this.reach);
        jDDNode = JDD.And(jDDNode, this.reach);
        stateValues.clear();
        return new StateValuesMTBDD(jDDNode, this.model);
    }

    protected StateValues checkExpressionReward(ExpressionReward expressionReward) throws PrismException {
        Object object;
        OpRelOpBound opRelOpBound = expressionReward.getRelopBoundInfo(this.constantValues);
        MinMax minMax = opRelOpBound.getMinMax(this.model.getModelType());
        Object object2 = expressionReward.getRewardStructIndex();
        JDDNode jDDNode = this.getStateRewardsByIndexObject(object2, this.model, this.constantValues);
        JDDNode jDDNode2 = this.getTransitionRewardsByIndexObject(object2, this.model, this.constantValues);
        StateValues stateValues = null;
        Expression expression = expressionReward.getExpression();
        if (expression instanceof ExpressionTemporal) {
            object = (ExpressionTemporal)expression;
            switch (((ExpressionTemporal)object).getOperator()) {
                case 11: {
                    if (((ExpressionTemporal)object).hasBounds()) {
                        stateValues = this.checkRewardCumul((ExpressionTemporal)object, jDDNode, jDDNode2, minMax.isMin());
                        break;
                    }
                    stateValues = this.checkRewardTotal((ExpressionTemporal)object, jDDNode, jDDNode2, minMax.isMin());
                    break;
                }
                case 12: {
                    stateValues = this.checkRewardInst((ExpressionTemporal)object, jDDNode, jDDNode2, minMax.isMin());
                    break;
                }
                case 13: {
                    stateValues = this.checkRewardReach((ExpressionTemporal)object, jDDNode, jDDNode2, minMax.isMin());
                }
            }
        }
        if (stateValues == null) {
            throw new PrismException("Unrecognised operator in R operator");
        }
        if (this.verbose) {
            this.mainLog.print("\n" + (minMax.isMin() ? "Minimum" : "Maximum") + " rewards (non-zero only) for all states:\n");
            stateValues.print(this.mainLog);
        }
        if (opRelOpBound.isNumeric()) {
            return stateValues;
        }
        object = stateValues.getBDDFromInterval(opRelOpBound.getRelOp(), opRelOpBound.getBound());
        JDD.Ref(this.reach);
        object = JDD.And((JDDNode)object, this.reach);
        stateValues.clear();
        return new StateValuesMTBDD((JDDNode)object, this.model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StateValues checkExpressionMultiObjective(ExpressionFunc expressionFunc) throws PrismException {
        ArrayList<JDDNode> arrayList;
        JDDNode jDDNode3;
        int n;
        ArrayList<JDDNode> arrayList2 = null;
        ArrayList<Integer> arrayList3 = null;
        boolean bl = false;
        int n2 = 0;
        boolean bl2 = false;
        JDDNode jDDNode2 = null;
        if (this.currentFilter == null || this.currentFilter.getOperator() != Filter.FilterOperator.STATE) {
            throw new PrismException("Multi-objective model checking can only compute values from a single state");
        }
        int n3 = this.currentFilter.getStateIndex();
        jDDNode2 = ODDUtils.SingleIndexToDD(n3, this.odd, this.allDDRowVars);
        n3 = expressionFunc.getNumOperands();
        OpsAndBoundsList opsAndBoundsList = new OpsAndBoundsList();
        ArrayList<JDDNode> arrayList4 = new ArrayList<JDDNode>(n3);
        ArrayList<JDDNode> arrayList5 = new ArrayList<JDDNode>(n3);
        ArrayList<String> arrayList6 = new ArrayList<String>();
        ArrayList<Expression> arrayList7 = new ArrayList<Expression>(n3);
        for (n = 0; n < n3; ++n) {
            this.extractInfoFromMultiObjectiveOperand((ExpressionQuant)expressionFunc.getOperand(n), opsAndBoundsList, arrayList5, arrayList6, arrayList7);
        }
        if (opsAndBoundsList.numberOfNumerical() > 1 && opsAndBoundsList.numberOfNumerical() < opsAndBoundsList.probSize() + opsAndBoundsList.rewardSize()) {
            throw new PrismException("Multiple min/max queries cannot be combined with boolean queries.");
        }
        bl = opsAndBoundsList.contains(Operator.P_MIN);
        bl2 = opsAndBoundsList.contains(Operator.R_GE) || opsAndBoundsList.contains(Operator.R_MAX);
        Expression[] expressionArray = new Expression[n3];
        DA[] dAArray = new DA[n3];
        JDDVars[] jDDVarsArray = new JDDVars[n3];
        JDDVars[] jDDVarsArray2 = new JDDVars[n3];
        LTLModelChecker lTLModelChecker = new LTLModelChecker(this.prism);
        MultiObjModelChecker multiObjModelChecker = new MultiObjModelChecker(this.prism, this.prism);
        NondetModel nondetModel = this.model;
        n = 1;
        for (int i = 0; i < n3; ++i) {
            if (!opsAndBoundsList.isProbabilityObjective(i)) continue;
            jDDVarsArray[i] = new JDDVars();
            jDDVarsArray2[i] = new JDDVars();
            NondetModel nondetModel2 = multiObjModelChecker.constructDRAandProductMulti(nondetModel, lTLModelChecker, this, expressionArray[i], i, dAArray, opsAndBoundsList.getOperator(i), (Expression)arrayList7.get(i), jDDVarsArray[i], jDDVarsArray2[i], jDDNode2);
            if (i > 0 & n == 0) {
                nondetModel.clear();
            }
            nondetModel = nondetModel2;
            n = 0;
        }
        opsAndBoundsList.makeAllProbUp();
        this.outputProductMulti(nondetModel);
        for (JDDNode jDDNode3 : arrayList5) {
            JDD.Ref(jDDNode3);
            JDD.Ref(nondetModel.getTrans01());
            arrayList4.add(JDD.Apply(3, jDDNode3, nondetModel.getTrans01()));
        }
        if (bl2) {
            multiObjModelChecker.removeNonZeroMecsForMax(nondetModel, lTLModelChecker, arrayList5, opsAndBoundsList, n3, dAArray, jDDVarsArray, jDDVarsArray2);
        }
        JDDNode jDDNode4 = nondetModel.getTrans();
        jDDNode3 = nondetModel.getTrans01();
        boolean bl3 = multiObjModelChecker.removeNonZeroRewardTrans(nondetModel, arrayList5, opsAndBoundsList);
        ArrayList<ArrayList<JDDNode>> arrayList8 = new ArrayList<ArrayList<JDDNode>>(n3);
        ArrayList<ArrayList<JDDNode>> arrayList9 = new ArrayList<ArrayList<JDDNode>>(n3);
        JDDNode jDDNode5 = JDD.Constant(0.0);
        JDDNode jDDNode6 = JDD.Constant(0.0);
        for (int i = 0; i < n3; ++i) {
            if (opsAndBoundsList.isProbabilityObjective(i)) {
                arrayList = new ArrayList<JDDNode>();
                ArrayList<JDDNode> arrayList10 = new ArrayList<JDDNode>();
                for (int j = 0; j < ((AcceptanceRabin)dAArray[i].getAcceptance()).size(); ++j) {
                    JDDNode jDDNode7 = JDD.Constant(0.0);
                    JDDNode jDDNode8 = JDD.Constant(0.0);
                    for (int k = 0; k < dAArray[i].size(); ++k) {
                        if (!((AcceptanceRabin.RabinPair)((AcceptanceRabin)dAArray[i].getAcceptance()).get(j)).getL().get(k)) {
                            jDDNode7 = JDD.SetVectorElement(jDDNode7, jDDVarsArray[i], k, 1.0);
                        }
                        if (!((AcceptanceRabin.RabinPair)((AcceptanceRabin)dAArray[i].getAcceptance()).get(j)).getK().get(k)) continue;
                        jDDNode8 = JDD.SetVectorElement(jDDNode8, jDDVarsArray[i], k, 1.0);
                    }
                    arrayList.add(jDDNode7);
                    JDD.Ref(jDDNode7);
                    jDDNode5 = JDD.Or(jDDNode5, jDDNode7);
                    arrayList10.add(jDDNode8);
                    JDD.Ref(jDDNode8);
                    jDDNode6 = JDD.Or(jDDNode6, jDDNode8);
                }
                arrayList8.add(i, arrayList);
                arrayList9.add(i, arrayList10);
                continue;
            }
            arrayList8.add(i, null);
            arrayList9.add(i, null);
        }
        List<JDDNode> list = multiObjModelChecker.computeAllEcs(nondetModel, lTLModelChecker, arrayList8, arrayList9, jDDNode5, jDDNode6, jDDVarsArray, jDDVarsArray2, opsAndBoundsList, n3);
        arrayList = new ArrayList(n3);
        for (int i = 0; i < n3; ++i) {
            if (opsAndBoundsList.isProbabilityObjective(i)) {
                arrayList.add(multiObjModelChecker.computeAcceptingEndComponent(dAArray[i], nondetModel, jDDVarsArray[i], jDDVarsArray2[i], list, (List<JDDNode>)arrayList8.get(i), (List<JDDNode>)arrayList9.get(i), lTLModelChecker, n2 > 1, arrayList6.get(i)));
                continue;
            }
            if (arrayList7.get(i) == null) continue;
            JDDNode jDDNode9 = this.checkExpressionDD((Expression)arrayList7.get(i));
            JDD.Ref(nondetModel.getReach());
            jDDNode9 = JDD.And(jDDNode9, nondetModel.getReach());
            arrayList.add(jDDNode9);
        }
        if (n2 > 1) {
            arrayList2 = new ArrayList<JDDNode>();
            arrayList3 = new ArrayList<Integer>();
            multiObjModelChecker.checkConflictsInObjectives(nondetModel, lTLModelChecker, n2, n3, opsAndBoundsList, dAArray, jDDVarsArray, jDDVarsArray2, arrayList, arrayList8, arrayList9, arrayList2, arrayList3);
        }
        for (JDDNode jDDNode10 : list) {
            JDD.Deref(jDDNode10);
        }
        if (arrayList.isEmpty() && this.prism.getMDPSolnMethod() == 3) {
            this.addDummyFormula(nondetModel, lTLModelChecker, arrayList, opsAndBoundsList);
        }
        if (bl3) {
            JDD.Deref(nondetModel.getTrans());
            JDD.Deref(nondetModel.getTrans01());
            nondetModel.trans = jDDNode4;
            nondetModel.trans01 = jDDNode3;
        }
        Object object = multiObjModelChecker.computeMultiReachProbs(nondetModel, lTLModelChecker, arrayList4, nondetModel.getStart(), arrayList, arrayList2, arrayList3, opsAndBoundsList, n2 > 1);
        if (jDDNode2 != null) {
            JDD.Deref(jDDNode2);
        }
        if (nondetModel != null && nondetModel != this.model) {
            nondetModel.clear();
        }
        for (int i = 0; i < n3; ++i) {
            if (!opsAndBoundsList.isProbabilityObjective(i)) continue;
            jDDVarsArray[i].derefAll();
            jDDVarsArray2[i].derefAll();
        }
        for (JDDNode jDDNode7 : arrayList) {
            JDD.Deref(jDDNode7);
        }
        if (arrayList2 != null) {
            for (JDDNode jDDNode7 : arrayList2) {
                JDD.Deref(jDDNode7);
            }
        }
        if (object instanceof TileList) {
            if (opsAndBoundsList.numberOfNumerical() == 2) {
                List<TileList> list2 = TileList.getStoredTileLists();
                synchronized (list2) {
                    if (expressionFunc.getOperand(0) instanceof ExpressionReward && expressionFunc.getOperand(1) instanceof ExpressionProb) {
                        TileList.storedFormulasX.add(expressionFunc.getOperand(1));
                        TileList.storedFormulasY.add(expressionFunc.getOperand(0));
                    } else {
                        TileList.storedFormulasX.add(expressionFunc.getOperand(0));
                        TileList.storedFormulasY.add(expressionFunc.getOperand(1));
                    }
                    TileList.storedFormulas.add(expressionFunc);
                    TileList.storedTileLists.add((TileList)object);
                }
            }
            return new StateValuesVoid(object);
        }
        if (object instanceof Double) {
            if (bl) {
                object = 1.0 - (Double)object;
            }
            return new StateValuesMTBDD(JDD.Constant((Double)object), this.model);
        }
        throw new PrismException("Do not know how to treat the returned value " + object);
    }

    protected void extractInfoFromMultiObjectiveOperand(ExpressionQuant expressionQuant, OpsAndBoundsList opsAndBoundsList, List<JDDNode> list, List<String> list2, List<Expression> list3) throws PrismException {
        double d;
        ExpressionTemporal expressionTemporal;
        Object object;
        Object object2;
        RelOp relOp;
        int n = 0;
        ExpressionProb expressionProb = null;
        ExpressionReward expressionReward = null;
        if (expressionQuant instanceof ExpressionProb) {
            expressionProb = (ExpressionProb)expressionQuant;
            expressionReward = null;
            relOp = expressionProb.getRelOp();
        } else if (expressionQuant instanceof ExpressionReward) {
            expressionReward = (ExpressionReward)expressionQuant;
            expressionProb = null;
            relOp = expressionReward.getRelOp();
            object2 = expressionReward.getRewardStructIndex();
            object = this.getStateRewardsByIndexObject(object2, this.model, this.constantValues);
            JDDNode jDDNode = this.getTransitionRewardsByIndexObject(object2, this.model, this.constantValues);
            if (object != null && !object.equals(JDD.ZERO)) {
                throw new PrismException("Multi-objective model checking does not support state rewards; please convert to transition rewards");
            }
            list.add(jDDNode);
        } else {
            throw new PrismException("Multi-objective properties can only contain P and R operators");
        }
        if (expressionReward != null) {
            expressionTemporal = (ExpressionTemporal)expressionReward.getExpression();
            if (expressionTemporal.getOperator() != 11) {
                throw new PrismException("Reward operators in multi-objective properties must be C or C<=k (" + expressionTemporal.getOperatorSymbol() + " is not yet supported)");
            }
            n = expressionTemporal.getUpperBound() != null ? expressionTemporal.getUpperBound().evaluateInt(this.constantValues) : -1;
        }
        if (expressionProb != null && expressionProb.getExpression() instanceof ExpressionTemporal) {
            expressionTemporal = (ExpressionTemporal)expressionProb.getExpression();
            n = expressionTemporal.getUpperBound() != null ? expressionTemporal.getUpperBound().evaluateInt(this.constantValues) : -1;
        }
        if (((OpRelOpBound)(object2 = expressionQuant.getRelopBoundInfo(this.constantValues))).getRelOp().isStrict()) {
            throw new PrismException("Multi-objective properties can not use strict inequalities on P/R operators");
        }
        if (relOp == RelOp.MAX) {
            object = expressionProb != null ? Operator.P_MAX : Operator.R_MAX;
        } else if (relOp == RelOp.GEQ) {
            object = expressionProb != null ? Operator.P_GE : Operator.R_GE;
        } else if (relOp == RelOp.MIN) {
            object = expressionProb != null ? Operator.P_MIN : Operator.R_MIN;
        } else if (relOp == RelOp.LEQ) {
            object = expressionProb != null ? Operator.P_LE : Operator.R_LE;
        } else {
            throw new PrismException("Multi-objective properties can only contain P/R operators with max/min=? or lower/upper probability bounds");
        }
        double d2 = d = ((OpRelOpBound)object2).isNumeric() ? -1.0 : ((OpRelOpBound)object2).getBound();
        if (((OpRelOpBound)object2).isProbabilistic() && ((OpRelOpBound)object2).getRelOp().isUpperBound()) {
            d = 1.0 - d;
        }
        opsAndBoundsList.add((OpRelOpBound)object2, (Operator)((Object)object), d, n);
        if (expressionProb != null) {
            list3.add(expressionProb.getExpression());
            list2.add(expressionProb.getExpression().toString());
        } else {
            list3.add(null);
            list2.add("");
        }
    }

    protected void addDummyFormula(NondetModel nondetModel, LTLModelChecker lTLModelChecker, List<JDDNode> list, OpsAndBoundsList opsAndBoundsList) throws PrismException {
        List<JDDNode> list2 = lTLModelChecker.findMECStates(nondetModel, nondetModel.getReach());
        JDDNode jDDNode = JDD.Constant(0.0);
        for (JDDNode jDDNode2 : list2) {
            jDDNode = JDD.Or(jDDNode, jDDNode2);
        }
        list.add(jDDNode);
        OpRelOpBound opRelOpBound = new OpRelOpBound("P", RelOp.GEQ, 0.0);
        opsAndBoundsList.add(opRelOpBound, Operator.P_GE, 0.0, -1);
    }

    protected void outputProductMulti(NondetModel nondetModel) throws PrismException {
        this.mainLog.println();
        nondetModel.printTransInfo(this.mainLog, this.prism.getExtraDDInfo());
        if (this.prism.getExportProductTrans()) {
            try {
                this.mainLog.println("\nExporting product transition matrix to file \"" + this.prism.getExportProductTransFilename() + "\"...");
                nondetModel.exportToFile(1, true, new File(this.prism.getExportProductTransFilename()));
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.mainLog.printWarning("Could not export product transition matrix to file \"" + this.prism.getExportProductTransFilename() + "\"");
            }
        }
        if (this.prism.getExportProductStates()) {
            this.mainLog.println("\nExporting product state space to file \"" + this.prism.getExportProductStatesFilename() + "\"...");
            PrismFileLog prismFileLog = new PrismFileLog(this.prism.getExportProductStatesFilename());
            nondetModel.exportStates(1, prismFileLog);
            prismFileLog.close();
        }
    }

    protected StateValues checkProbPathFormula(Expression expression, boolean bl, boolean bl2) throws PrismException {
        boolean bl3 = expression.isSimplePathFormula();
        if (bl3 && this.prism.getSettings().getBoolean("prism.pathViaAutomata") && LTLModelChecker.isSupportedLTLFormula(this.model.getModelType(), expression)) {
            bl3 = false;
        }
        if (bl3) {
            return this.checkProbPathFormulaSimple(expression, bl, bl2);
        }
        return this.checkProbPathFormulaLTL(expression, bl, bl2);
    }

    protected StateValues checkProbPathFormulaSimple(Expression expression, boolean bl, boolean bl2) throws PrismException {
        boolean bl3 = false;
        StateValues stateValues = null;
        if ((expression = Expression.convertSimplePathFormulaToCanonicalForm(expression)) instanceof ExpressionUnaryOp && ((ExpressionUnaryOp)expression).getOperator() == 1) {
            bl3 = true;
            bl2 = !bl2;
            expression = ((ExpressionUnaryOp)expression).getOperand();
        }
        if (expression instanceof ExpressionTemporal) {
            ExpressionTemporal expressionTemporal = (ExpressionTemporal)expression;
            if (expressionTemporal.getOperator() == 1) {
                stateValues = this.checkProbNext(expressionTemporal, bl2);
            } else if (expressionTemporal.getOperator() == 2) {
                stateValues = expressionTemporal.hasBounds() ? this.checkProbBoundedUntil(expressionTemporal, bl2) : this.checkProbUntil(expressionTemporal, bl, bl2);
            }
        }
        if (stateValues == null) {
            throw new PrismException("Unrecognised path operator in P operator");
        }
        if (bl3) {
            stateValues.subtractFromOne();
        }
        return stateValues;
    }

    protected StateValues checkProbNext(ExpressionTemporal expressionTemporal, boolean bl) throws PrismException {
        StateValues stateValues = null;
        JDDNode jDDNode = this.checkExpressionDD(expressionTemporal.getOperand2());
        stateValues = this.computeNextProbs(this.trans, jDDNode, bl);
        JDD.Deref(jDDNode);
        return stateValues;
    }

    protected StateValues checkProbBoundedUntil(ExpressionTemporal expressionTemporal, boolean bl) throws PrismException {
        JDDNode jDDNode;
        StateValues stateValues = null;
        IntegerBound integerBound = IntegerBound.fromExpressionTemporal(expressionTemporal, this.constantValues, true);
        JDDNode jDDNode2 = this.checkExpressionDD(expressionTemporal.getOperand1());
        try {
            jDDNode = this.checkExpressionDD(expressionTemporal.getOperand2());
        }
        catch (PrismException prismException) {
            JDD.Deref(jDDNode2);
            throw prismException;
        }
        Integer n = integerBound.hasLowerBound() ? integerBound.getLowestInteger() : Integer.valueOf(0);
        Integer n2 = null;
        if (integerBound.hasUpperBound()) {
            n2 = integerBound.getHighestInteger() - n;
        }
        if (n2 == null) {
            try {
                stateValues = this.checkProbUntil(jDDNode2, jDDNode, false, bl);
            }
            catch (PrismException prismException) {
                JDD.Deref(jDDNode2);
                JDD.Deref(jDDNode);
                throw prismException;
            }
        }
        if (n2 == 0) {
            JDD.Ref(jDDNode);
            stateValues = new StateValuesMTBDD(jDDNode, this.model);
        } else {
            try {
                stateValues = this.computeBoundedUntilProbs(this.trans, this.trans01, jDDNode2, jDDNode, n2, bl);
            }
            catch (PrismException prismException) {
                JDD.Deref(jDDNode2);
                JDD.Deref(jDDNode);
                throw prismException;
            }
        }
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                stateValues = this.computeRestrictedNext(this.trans, jDDNode2, stateValues, bl);
            }
        }
        JDD.Deref(jDDNode2);
        JDD.Deref(jDDNode);
        return stateValues;
    }

    protected StateValues checkProbUntil(ExpressionTemporal expressionTemporal, boolean bl, boolean bl2) throws PrismException {
        JDDNode jDDNode;
        StateValues stateValues = null;
        JDDNode jDDNode2 = this.checkExpressionDD(expressionTemporal.getOperand1());
        try {
            jDDNode = this.checkExpressionDD(expressionTemporal.getOperand2());
        }
        catch (PrismException prismException) {
            JDD.Deref(jDDNode2);
            throw prismException;
        }
        try {
            stateValues = this.checkProbUntil(jDDNode2, jDDNode, bl, bl2);
        }
        catch (PrismException prismException) {
            JDD.Deref(jDDNode2);
            JDD.Deref(jDDNode);
            throw prismException;
        }
        JDD.Deref(jDDNode2);
        JDD.Deref(jDDNode);
        return stateValues;
    }

    protected StateValues checkProbUntil(JDDNode jDDNode, JDDNode jDDNode2, boolean bl, boolean bl2) throws PrismException {
        JDDNode jDDNode3;
        JDDNode jDDNode4;
        StateValues stateValues = null;
        if (bl2 && this.fairness) {
            this.mainLog.print("\nDoing conversion for fairness...\n");
            long l = System.currentTimeMillis();
            jDDNode4 = PrismMTBDD.Prob0A(this.trans01, this.reach, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, jDDNode, jDDNode2);
            JDD.Ref(jDDNode4);
            JDDNode jDDNode5 = JDD.Not(jDDNode4);
            JDD.Ref(jDDNode5);
            JDD.Ref(jDDNode2);
            jDDNode3 = JDD.And(jDDNode5, JDD.Not(jDDNode2));
            JDD.Deref(jDDNode5);
            JDD.Ref(this.reach);
            jDDNode3 = JDD.And(this.reach, jDDNode3);
            JDD.Ref(this.reach);
            jDDNode4 = JDD.And(this.reach, jDDNode4);
            l = System.currentTimeMillis() - l;
            this.mainLog.print("\nTime for fairness conversion: " + (double)l / 1000.0 + " seconds.\n");
        } else {
            JDD.Ref(jDDNode);
            jDDNode3 = jDDNode;
            JDD.Ref(jDDNode2);
            jDDNode4 = jDDNode2;
        }
        if (bl) {
            this.mainLog.print("\nProbability bound in formula is 0/1 so not computing exact probabilities...\n");
            stateValues = this.computeUntilProbsQual(this.trans01, jDDNode3, jDDNode4, bl2 && !this.fairness);
        } else {
            try {
                stateValues = this.computeUntilProbs(this.trans, this.transActions, this.trans01, jDDNode3, jDDNode4, bl2 && !this.fairness);
            }
            catch (PrismException prismException) {
                JDD.Deref(jDDNode3);
                JDD.Deref(jDDNode4);
                throw prismException;
            }
        }
        if (bl2 && this.fairness) {
            stateValues.subtractFromOne();
        }
        JDD.Deref(jDDNode3);
        JDD.Deref(jDDNode4);
        return stateValues;
    }

    protected StateValues checkProbPathFormulaLTL(Expression expression, boolean bl, boolean bl2) throws PrismException {
        JDDNode jDDNode;
        Object object;
        StateValues stateValues = null;
        StateValues stateValues2 = null;
        if (bl2 && !this.fairness) {
            expression = Expression.Not(Expression.Parenth(expression));
        }
        if (Expression.containsTemporalTimeBounds(expression)) {
            if (this.model.getModelType().continuousTime()) {
                throw new PrismException("DA construction for time-bounded operators not supported for " + (Object)((Object)this.model.getModelType()) + ".");
            }
            if (expression.isSimplePathFormula()) {
                expression = Expression.convertSimplePathFormulaToCanonicalForm(expression);
            } else {
                throw new PrismException("Time-bounded operators not supported in LTL: " + expression);
            }
        }
        if (expression instanceof ExpressionFunc && ((ExpressionFunc)expression).getName().equals("dfa")) {
            throw new PrismException("Model checking for \"dfa\" specifications not supported yet");
        }
        LTLModelChecker lTLModelChecker = new LTLModelChecker(this.prism);
        Vector<JDDNode> vector = new Vector<JDDNode>();
        Expression expression2 = lTLModelChecker.checkMaximalStateFormulas(this, this.model, expression.deepCopy(), vector);
        this.mainLog.println("\nBuilding deterministic automaton (for " + expression2 + ")...");
        long l = System.currentTimeMillis();
        LTL2DA lTL2DA = new LTL2DA(this.prism);
        AcceptanceType[] acceptanceTypeArray = new AcceptanceType[]{AcceptanceType.RABIN, AcceptanceType.GENERALIZED_RABIN, AcceptanceType.REACH};
        DA<BitSet, ? extends AcceptanceOmega> dA = lTL2DA.convertLTLFormulaToDA(expression2, this.constantValues, acceptanceTypeArray);
        dA.checkForCanonicalAPs(vector.size());
        this.mainLog.println(dA.getAutomataType() + " has " + dA.size() + " states, " + dA.getAcceptance().getSizeStatistics() + ".");
        l = System.currentTimeMillis() - l;
        this.mainLog.println("Time for deterministic automaton translation: " + (double)l / 1000.0 + " seconds.");
        if (this.prism.getSettings().getExportPropAut()) {
            this.mainLog.println("Exporting DA to file \"" + this.prism.getSettings().getExportPropAutFilename() + "\"...");
            object = new PrismFileLog(this.prism.getSettings().getExportPropAutFilename());
            dA.print((PrismLog)object, this.prism.getSettings().getExportPropAutType());
            ((PrismLog)object).close();
        }
        this.mainLog.println("\nConstructing MDP-" + dA.getAutomataType() + " product...");
        JDDVars jDDVars = new JDDVars();
        JDDVars jDDVars2 = new JDDVars();
        NondetModel nondetModel = lTLModelChecker.constructProductMDP(dA, this.model, vector, jDDVars, jDDVars2);
        this.mainLog.println();
        nondetModel.printTransInfo(this.mainLog, this.prism.getExtraDDInfo());
        if (this.prism.getExportProductTrans()) {
            try {
                this.mainLog.println("\nExporting product transition matrix to file \"" + this.prism.getExportProductTransFilename() + "\"...");
                nondetModel.exportToFile(1, true, new File(this.prism.getExportProductTransFilename()));
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.mainLog.printWarning("Could not export product transition matrix to file \"" + this.prism.getExportProductTransFilename() + "\"");
            }
        }
        if (this.prism.getExportProductStates()) {
            this.mainLog.println("\nExporting product state space to file \"" + this.prism.getExportProductStatesFilename() + "\"...");
            object = new PrismFileLog(this.prism.getExportProductStatesFilename());
            nondetModel.exportStates(1, (PrismLog)object);
            ((PrismFileLog)object).close();
        }
        if ((object = dA.getAcceptance().toAcceptanceDD(jDDVars)) instanceof AcceptanceReachDD) {
            this.mainLog.println("\nSkipping accepting MEC computation since acceptance is defined via goal states...");
            jDDNode = ((AcceptanceReachDD)object).getGoalStates();
            JDD.Ref(nondetModel.getReach());
            jDDNode = JDD.And(jDDNode, nondetModel.getReach());
        } else {
            this.mainLog.println("\nFinding accepting end components...");
            jDDNode = lTLModelChecker.findAcceptingECStates((AcceptanceOmegaDD)object, nondetModel, jDDVars, jDDVars2, this.fairness);
        }
        object.clear();
        this.mainLog.println("\nComputing reachability probabilities...");
        NondetModelChecker nondetModelChecker = new NondetModelChecker(this.prism, nondetModel, null);
        stateValues = nondetModelChecker.checkProbUntil(nondetModel.getReach(), jDDNode, bl, bl2 && this.fairness);
        if (bl2 && !this.fairness) {
            stateValues.subtractFromOne();
        }
        JDDNode jDDNode2 = lTLModelChecker.buildStartMask(dA, vector, jDDVars);
        JDD.Ref(this.model.getReach());
        jDDNode2 = JDD.And(this.model.getReach(), jDDNode2);
        stateValues.filter(jDDNode2);
        stateValues2 = stateValues.sumOverDDVars(jDDVars, this.model);
        stateValues.clear();
        nondetModel.clear();
        for (int i = 0; i < vector.size(); ++i) {
            JDD.Deref(vector.get(i));
        }
        JDD.Deref(jDDNode);
        JDD.Deref(jDDNode2);
        jDDVars.derefAll();
        jDDVars2.derefAll();
        return stateValues2;
    }

    protected StateValues checkRewardCumul(ExpressionTemporal expressionTemporal, JDDNode jDDNode, JDDNode jDDNode2, boolean bl) throws PrismException {
        StateValues stateValues = null;
        if (expressionTemporal.getUpperBound() == null) {
            throw new PrismException("Cumulative reward operator without time bound (C) is only allowed for multi-objective queries");
        }
        int n = expressionTemporal.getUpperBound().evaluateInt(this.constantValues);
        if (n < 0) {
            throw new PrismException("Invalid time bound " + n + " in cumulative reward formula");
        }
        if (n == 0) {
            stateValues = new StateValuesMTBDD(JDD.Constant(0.0), this.model);
        } else {
            stateValues = this.computeCumulRewards(this.trans, jDDNode, jDDNode2, n, bl);
        }
        return stateValues;
    }

    protected StateValues checkRewardTotal(ExpressionTemporal expressionTemporal, JDDNode jDDNode, JDDNode jDDNode2, boolean bl) throws PrismException {
        StateValues stateValues = this.computeTotalRewards(this.trans, this.trans01, jDDNode, jDDNode2, bl);
        return stateValues;
    }

    protected StateValues checkRewardInst(ExpressionTemporal expressionTemporal, JDDNode jDDNode, JDDNode jDDNode2, boolean bl) throws PrismException {
        StateValues stateValues = null;
        int n = expressionTemporal.getUpperBound().evaluateInt(this.constantValues);
        if (n < 0) {
            throw new PrismException("Invalid bound " + n + " in instantaneous reward property");
        }
        stateValues = this.computeInstRewards(this.trans, jDDNode, n, bl);
        return stateValues;
    }

    protected StateValues checkRewardReach(ExpressionTemporal expressionTemporal, JDDNode jDDNode, JDDNode jDDNode2, boolean bl) throws PrismException {
        StateValues stateValues = null;
        JDDNode jDDNode3 = this.checkExpressionDD(expressionTemporal.getOperand2());
        try {
            stateValues = this.computeReachRewards(this.trans, this.transActions, this.trans01, jDDNode, jDDNode2, jDDNode3, bl);
        }
        catch (PrismException prismException) {
            JDD.Deref(jDDNode3);
            throw prismException;
        }
        JDD.Deref(jDDNode3);
        return stateValues;
    }

    protected StateValues computeNextProbs(JDDNode jDDNode, JDDNode jDDNode2, boolean bl) {
        StateValuesMTBDD stateValuesMTBDD = null;
        JDD.Ref(jDDNode2);
        JDDNode jDDNode3 = JDD.PermuteVariables(jDDNode2, this.allDDRowVars, this.allDDColVars);
        JDD.Ref(jDDNode);
        jDDNode3 = JDD.MatrixMultiply(jDDNode, jDDNode3, this.allDDColVars, 2);
        if (bl) {
            JDD.Ref(this.nondetMask);
            jDDNode3 = JDD.Apply(6, jDDNode3, this.nondetMask);
            jDDNode3 = JDD.MinAbstract(jDDNode3, this.allDDNondetVars);
        } else {
            jDDNode3 = JDD.MaxAbstract(jDDNode3, this.allDDNondetVars);
        }
        stateValuesMTBDD = new StateValuesMTBDD(jDDNode3, this.model);
        return stateValuesMTBDD;
    }

    protected StateValues computeRestrictedNext(JDDNode jDDNode, JDDNode jDDNode2, StateValues stateValues, boolean bl) {
        StateValuesMTBDD stateValuesMTBDD = null;
        StateValuesMTBDD stateValuesMTBDD2 = stateValues.convertToStateValuesMTBDD();
        JDDNode jDDNode3 = stateValuesMTBDD2.getJDDNode();
        JDD.Ref(jDDNode3);
        jDDNode3 = JDD.PermuteVariables(jDDNode3, this.allDDRowVars, this.allDDColVars);
        JDD.Ref(jDDNode);
        jDDNode3 = JDD.MatrixMultiply(jDDNode, jDDNode3, this.allDDColVars, 2);
        if (bl) {
            JDD.Ref(this.nondetMask);
            jDDNode3 = JDD.Apply(6, jDDNode3, this.nondetMask);
            jDDNode3 = JDD.MinAbstract(jDDNode3, this.allDDNondetVars);
        } else {
            jDDNode3 = JDD.MaxAbstract(jDDNode3, this.allDDNondetVars);
        }
        JDD.Ref(jDDNode2);
        jDDNode3 = JDD.Apply(5, jDDNode3, jDDNode2);
        stateValuesMTBDD = new StateValuesMTBDD(jDDNode3, this.model);
        stateValuesMTBDD2.clear();
        return stateValuesMTBDD;
    }

    protected StateValues computeBoundedUntilProbs(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, JDDNode jDDNode4, int n, boolean bl) throws PrismException {
        JDDNode jDDNode5;
        JDDNode jDDNode6;
        JDDNode jDDNode7;
        StateValues stateValues = null;
        if (jDDNode4.equals(JDD.ZERO)) {
            jDDNode7 = JDD.Constant(0.0);
            JDD.Ref(this.reach);
            jDDNode6 = this.reach;
            jDDNode5 = JDD.Constant(0.0);
        } else if (jDDNode3.equals(JDD.ZERO)) {
            JDD.Ref(jDDNode4);
            jDDNode7 = jDDNode4;
            JDD.Ref(this.reach);
            JDD.Ref(jDDNode4);
            jDDNode6 = JDD.And(this.reach, JDD.Not(jDDNode4));
            jDDNode5 = JDD.Constant(0.0);
        } else {
            JDD.Ref(jDDNode4);
            jDDNode7 = jDDNode4;
            if (jDDNode7.equals(this.reach)) {
                jDDNode6 = JDD.Constant(0.0);
            } else if (this.precomp && this.prob0) {
                jDDNode6 = bl ? PrismMTBDD.Prob0E(jDDNode2, this.reach, this.nondetMask, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, jDDNode3, jDDNode7) : PrismMTBDD.Prob0A(jDDNode2, this.reach, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, jDDNode3, jDDNode7);
            } else {
                JDD.Ref(this.reach);
                JDD.Ref(jDDNode3);
                JDD.Ref(jDDNode4);
                jDDNode6 = JDD.And(this.reach, JDD.Not(JDD.Or(jDDNode3, jDDNode4)));
            }
            JDD.Ref(this.reach);
            JDD.Ref(jDDNode7);
            JDD.Ref(jDDNode6);
            jDDNode5 = JDD.And(this.reach, JDD.Not(JDD.Or(jDDNode7, jDDNode6)));
        }
        this.mainLog.print("\nyes = " + JDD.GetNumMintermsString(jDDNode7, this.allDDRowVars.n()));
        this.mainLog.print(", no = " + JDD.GetNumMintermsString(jDDNode6, this.allDDRowVars.n()));
        this.mainLog.print(", maybe = " + JDD.GetNumMintermsString(jDDNode5, this.allDDRowVars.n()) + "\n");
        if (jDDNode5.equals(JDD.ZERO)) {
            JDD.Ref(jDDNode7);
            stateValues = new StateValuesMTBDD(jDDNode7, this.model);
        } else {
            this.mainLog.println("\nComputing probabilities...");
            this.mainLog.println("Engine: " + Prism.getEngineString(this.engine));
            try {
                switch (this.engine) {
                    case 1: {
                        JDDNode jDDNode8 = PrismMTBDD.NondetBoundedUntil(jDDNode, this.odd, this.nondetMask, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, jDDNode7, jDDNode5, n, bl);
                        stateValues = new StateValuesMTBDD(jDDNode8, this.model);
                        break;
                    }
                    case 2: {
                        DoubleVector doubleVector = PrismSparse.NondetBoundedUntil(jDDNode, this.odd, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, jDDNode7, jDDNode5, n, bl);
                        stateValues = new StateValuesDV(doubleVector, (Model)this.model);
                        break;
                    }
                    case 3: {
                        DoubleVector doubleVector = PrismHybrid.NondetBoundedUntil(jDDNode, this.odd, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, jDDNode7, jDDNode5, n, bl);
                        stateValues = new StateValuesDV(doubleVector, (Model)this.model);
                        break;
                    }
                    default: {
                        throw new PrismException("Unknown engine");
                    }
                }
            }
            catch (PrismException prismException) {
                JDD.Deref(jDDNode7);
                JDD.Deref(jDDNode6);
                JDD.Deref(jDDNode5);
                throw prismException;
            }
        }
        JDD.Deref(jDDNode7);
        JDD.Deref(jDDNode6);
        JDD.Deref(jDDNode5);
        return stateValues;
    }

    protected StateValues computeUntilProbsQual(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, boolean bl) {
        JDDNode jDDNode4;
        JDDNode jDDNode5 = null;
        JDDNode jDDNode6 = null;
        StateValuesMTBDD stateValuesMTBDD = null;
        if (jDDNode3.equals(JDD.ZERO)) {
            jDDNode5 = JDD.Constant(0.0);
            JDD.Ref(this.reach);
            jDDNode6 = this.reach;
            jDDNode4 = JDD.Constant(0.0);
        } else if (jDDNode2.equals(JDD.ZERO)) {
            JDD.Ref(jDDNode3);
            jDDNode5 = jDDNode3;
            JDD.Ref(this.reach);
            JDD.Ref(jDDNode3);
            jDDNode6 = JDD.And(this.reach, JDD.Not(jDDNode3));
            jDDNode4 = JDD.Constant(0.0);
        } else {
            if (bl) {
                jDDNode6 = PrismMTBDD.Prob0E(jDDNode, this.reach, this.nondetMask, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, jDDNode2, jDDNode3);
                jDDNode5 = PrismMTBDD.Prob1A(jDDNode, this.reach, this.nondetMask, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, jDDNode6, jDDNode3);
            } else {
                jDDNode6 = PrismMTBDD.Prob0A(jDDNode, this.reach, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, jDDNode2, jDDNode3);
                jDDNode5 = PrismMTBDD.Prob1E(jDDNode, this.reach, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, jDDNode2, jDDNode3, jDDNode6);
            }
            JDD.Ref(this.reach);
            JDD.Ref(jDDNode5);
            JDD.Ref(jDDNode6);
            jDDNode4 = JDD.And(this.reach, JDD.Not(JDD.Or(jDDNode5, jDDNode6)));
        }
        this.mainLog.print("\nyes = " + JDD.GetNumMintermsString(jDDNode5, this.allDDRowVars.n()));
        this.mainLog.print(", no = " + JDD.GetNumMintermsString(jDDNode6, this.allDDRowVars.n()));
        this.mainLog.print(", maybe = " + JDD.GetNumMintermsString(jDDNode4, this.allDDRowVars.n()) + "\n");
        if (jDDNode4.equals(JDD.ZERO)) {
            JDD.Ref(jDDNode5);
            stateValuesMTBDD = new StateValuesMTBDD(jDDNode5, this.model);
        } else {
            JDD.Ref(jDDNode5);
            JDD.Ref(jDDNode4);
            stateValuesMTBDD = new StateValuesMTBDD(JDD.Apply(1, jDDNode5, JDD.Apply(3, jDDNode4, JDD.Constant(0.5))), this.model);
        }
        JDD.Deref(jDDNode5);
        JDD.Deref(jDDNode6);
        JDD.Deref(jDDNode4);
        return stateValuesMTBDD;
    }

    protected StateValues computeUntilProbs(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, JDDNode jDDNode4, JDDNode jDDNode5, boolean bl) throws PrismException {
        JDDNode jDDNode6;
        JDDNode jDDNode7;
        JDDNode jDDNode8;
        Object object;
        Object object2;
        StateValues stateValues = null;
        if (this.prism.getExportTarget()) {
            object2 = new JDDNode[]{this.model.getStart(), jDDNode5};
            object = new String[]{"init", "target"};
            try {
                this.mainLog.println("\nExporting target states info to file \"" + this.prism.getExportTargetFilename() + "\"...");
                PrismMTBDD.ExportLabels(object2, object, "l", this.model.getAllDDRowVars(), this.model.getODD(), 1, this.prism.getExportTargetFilename());
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.mainLog.printWarning("Could not export target to file \"" + this.prism.getExportTargetFilename() + "\"");
            }
        }
        if (jDDNode5.equals(JDD.ZERO)) {
            jDDNode8 = JDD.Constant(0.0);
            JDD.Ref(this.reach);
            jDDNode7 = this.reach;
            jDDNode6 = JDD.Constant(0.0);
        } else if (jDDNode4.equals(JDD.ZERO)) {
            JDD.Ref(jDDNode5);
            jDDNode8 = jDDNode5;
            JDD.Ref(this.reach);
            JDD.Ref(jDDNode5);
            jDDNode7 = JDD.And(this.reach, JDD.Not(jDDNode5));
            jDDNode6 = JDD.Constant(0.0);
        } else {
            if (this.precomp && (this.prob0 || this.prob1)) {
                jDDNode7 = bl ? PrismMTBDD.Prob0E(jDDNode3, this.reach, this.nondetMask, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, jDDNode4, jDDNode5) : PrismMTBDD.Prob0A(jDDNode3, this.reach, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, jDDNode4, jDDNode5);
            } else {
                JDD.Ref(this.reach);
                JDD.Ref(jDDNode4);
                JDD.Ref(jDDNode5);
                jDDNode7 = JDD.And(this.reach, JDD.Not(JDD.Or(jDDNode4, jDDNode5)));
            }
            if (this.precomp && this.prob1) {
                jDDNode8 = bl ? PrismMTBDD.Prob1A(jDDNode3, this.reach, this.nondetMask, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, jDDNode7, jDDNode5) : PrismMTBDD.Prob1E(jDDNode3, this.reach, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, jDDNode4, jDDNode5, jDDNode7);
            } else {
                JDD.Ref(jDDNode5);
                jDDNode8 = jDDNode5;
            }
            JDD.Ref(this.reach);
            JDD.Ref(jDDNode8);
            JDD.Ref(jDDNode7);
            jDDNode6 = JDD.And(this.reach, JDD.Not(JDD.Or(jDDNode8, jDDNode7)));
        }
        this.mainLog.print("\nyes = " + JDD.GetNumMintermsString(jDDNode8, this.allDDRowVars.n()));
        this.mainLog.print(", no = " + JDD.GetNumMintermsString(jDDNode7, this.allDDRowVars.n()));
        this.mainLog.print(", maybe = " + JDD.GetNumMintermsString(jDDNode6, this.allDDRowVars.n()) + "\n");
        if (jDDNode6.equals(JDD.ZERO)) {
            JDD.Ref(jDDNode8);
            stateValues = new StateValuesMTBDD(jDDNode8, this.model);
        } else {
            this.mainLog.println("\nComputing remaining probabilities...");
            this.mainLog.println("Engine: " + Prism.getEngineString(this.engine));
            try {
                switch (this.engine) {
                    case 1: {
                        JDDNode jDDNode9 = PrismMTBDD.NondetUntil(jDDNode, this.odd, this.nondetMask, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, jDDNode8, jDDNode6, bl);
                        stateValues = new StateValuesMTBDD(jDDNode9, this.model);
                        break;
                    }
                    case 2: {
                        object2 = null;
                        if (this.genStrat) {
                            object = JDD.ITE(jDDNode8, JDD.Constant(-2.0), JDD.Constant(-1.0));
                            object2 = new IntegerVector((JDDNode)object, this.allDDRowVars, this.odd);
                            JDD.Deref((JDDNode)object);
                        }
                        DoubleVector doubleVector = PrismSparse.NondetUntil(jDDNode, jDDNode2, this.model.getSynchs(), this.odd, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, jDDNode8, jDDNode6, bl, (IntegerVector)object2);
                        if (this.genStrat) {
                            this.result.setStrategy(new MDStrategyIV(this.model, (IntegerVector)object2));
                        }
                        stateValues = new StateValuesDV(doubleVector, (Model)this.model);
                        break;
                    }
                    case 3: {
                        DoubleVector doubleVector = PrismHybrid.NondetUntil(jDDNode, this.odd, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, jDDNode8, jDDNode6, bl);
                        stateValues = new StateValuesDV(doubleVector, (Model)this.model);
                        break;
                    }
                    default: {
                        throw new PrismException("Unknown engine");
                    }
                }
            }
            catch (PrismException prismException) {
                JDD.Deref(jDDNode8);
                JDD.Deref(jDDNode7);
                JDD.Deref(jDDNode6);
                throw prismException;
            }
        }
        JDD.Deref(jDDNode8);
        JDD.Deref(jDDNode7);
        JDD.Deref(jDDNode6);
        return stateValues;
    }

    protected StateValues computeCumulRewards(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, int n, boolean bl) throws PrismException {
        StateValuesDV stateValuesDV = null;
        this.mainLog.println("\nComputing rewards...");
        this.mainLog.println("Engine: " + Prism.getEngineString(this.engine));
        switch (this.engine) {
            case 1: {
                throw new PrismException("MTBDD engine does not yet support this type of property (use the sparse engine instead)");
            }
            case 2: {
                DoubleVector doubleVector = PrismSparse.NondetCumulReward(jDDNode, jDDNode2, jDDNode3, this.odd, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, n, bl);
                stateValuesDV = new StateValuesDV(doubleVector, (Model)this.model);
                break;
            }
            case 3: {
                throw new PrismException("Hybrid engine does not yet support this type of property (use the sparse engine instead)");
            }
            default: {
                throw new PrismException("Unknown engine");
            }
        }
        return stateValuesDV;
    }

    protected StateValues computeTotalRewards(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, JDDNode jDDNode4, boolean bl) throws PrismException {
        throw new PrismException("Expected total reward (C) is not yet supported for MDPs.");
    }

    protected StateValues computeInstRewards(JDDNode jDDNode, JDDNode jDDNode2, int n, boolean bl) throws PrismException {
        StateValues stateValues = null;
        int n2 = this.engine;
        if (n == 0) {
            JDD.Ref(jDDNode2);
            stateValues = new StateValuesMTBDD(jDDNode2, this.model);
        } else {
            this.mainLog.println("\nComputing rewards...");
            if (n2 == 3) {
                this.mainLog.println("Switching engine since hybrid engine does yet support this computation...");
                n2 = 2;
            }
            this.mainLog.println("Engine: " + Prism.getEngineString(n2));
            switch (n2) {
                case 1: {
                    JDDNode jDDNode3 = PrismMTBDD.NondetInstReward(jDDNode, jDDNode2, this.odd, this.nondetMask, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, n, bl, this.start);
                    stateValues = new StateValuesMTBDD(jDDNode3, this.model);
                    break;
                }
                case 2: {
                    DoubleVector doubleVector = PrismSparse.NondetInstReward(jDDNode, jDDNode2, this.odd, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, n, bl, this.start);
                    stateValues = new StateValuesDV(doubleVector, (Model)this.model);
                    break;
                }
                case 3: {
                    throw new PrismException("Hybrid engine does not yet support this type of property (use sparse or MTBDD engine instead)");
                }
                default: {
                    throw new PrismException("Unknown engine");
                }
            }
        }
        return stateValues;
    }

    protected StateValues computeReachRewards(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, JDDNode jDDNode4, JDDNode jDDNode5, JDDNode jDDNode6, boolean bl) throws PrismException {
        JDDNode jDDNode7;
        JDDNode jDDNode8;
        StateValues stateValues = null;
        int n = this.engine;
        List<JDDNode> list = null;
        if (jDDNode6.equals(JDD.ZERO)) {
            JDD.Ref(this.reach);
            jDDNode8 = this.reach;
            jDDNode7 = JDD.Constant(0.0);
        } else if (jDDNode6.equals(this.reach)) {
            jDDNode8 = JDD.Constant(0.0);
            jDDNode7 = JDD.Constant(0.0);
        } else {
            JDDNode jDDNode9;
            JDDNode jDDNode10;
            if (!bl) {
                jDDNode10 = PrismMTBDD.Prob0E(jDDNode3, this.reach, this.nondetMask, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, this.reach, jDDNode6);
                jDDNode9 = PrismMTBDD.Prob1A(jDDNode3, this.reach, this.nondetMask, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, jDDNode10, jDDNode6);
                JDD.Deref(jDDNode10);
                JDD.Ref(this.reach);
                jDDNode8 = JDD.And(this.reach, JDD.Not(jDDNode9));
            } else {
                if (this.prism.getCheckZeroLoops()) {
                    JDD.Ref(jDDNode4);
                    JDD.Ref(this.reach);
                    Object object = JDD.And(this.reach, JDD.Apply(7, jDDNode4, JDD.Constant(0.0)));
                    JDD.Ref(jDDNode6);
                    object = JDD.And((JDDNode)object, JDD.Not(jDDNode6));
                    JDD.Ref(jDDNode5);
                    JDDNode jDDNode11 = JDD.Apply(7, jDDNode5, JDD.Constant(0.0));
                    JDD.Ref(this.trans);
                    JDD.Ref(jDDNode11);
                    JDDNode jDDNode12 = JDD.And(this.trans, jDDNode11);
                    JDD.Ref(this.trans01);
                    JDDNode jDDNode13 = JDD.And(this.trans01, jDDNode11);
                    ECComputerDefault eCComputerDefault = new ECComputerDefault(this.prism, (JDDNode)object, jDDNode12, jDDNode13, this.model.getAllDDRowVars(), this.model.getAllDDColVars(), this.model.getAllDDNondetVars());
                    ((ECComputer)eCComputerDefault).computeMECStates();
                    list = eCComputerDefault.getMECStates();
                    JDD.Deref((JDDNode)object);
                    JDD.Deref(jDDNode12);
                    JDD.Deref(jDDNode13);
                }
                jDDNode10 = PrismMTBDD.Prob0A(jDDNode3, this.reach, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, this.reach, jDDNode6);
                jDDNode9 = PrismMTBDD.Prob1E(jDDNode3, this.reach, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, this.reach, jDDNode6, jDDNode10);
                JDD.Deref(jDDNode10);
                JDD.Ref(this.reach);
                jDDNode8 = JDD.And(this.reach, JDD.Not(jDDNode9));
            }
            JDD.Ref(this.reach);
            JDD.Ref(jDDNode8);
            JDD.Ref(jDDNode6);
            jDDNode7 = JDD.And(this.reach, JDD.Not(JDD.Or(jDDNode8, jDDNode6)));
        }
        if (this.prism.getCheckZeroLoops()) {
            if (bl && list != null && list.size() > 0) {
                this.mainLog.printWarning("PRISM detected your model contains " + list.size() + " zero-reward " + (list.size() == 1 ? "loop." : "loops.\n") + "Your minimum rewards may be too low...");
            }
        } else if (bl) {
            this.mainLog.printWarning("PRISM hasn't checked for zero-reward loops.\nYour minimum rewards may be too low...");
        }
        this.mainLog.print("\ngoal = " + JDD.GetNumMintermsString(jDDNode6, this.allDDRowVars.n()));
        this.mainLog.print(", inf = " + JDD.GetNumMintermsString(jDDNode8, this.allDDRowVars.n()));
        this.mainLog.print(", maybe = " + JDD.GetNumMintermsString(jDDNode7, this.allDDRowVars.n()) + "\n");
        if (jDDNode7.equals(JDD.ZERO)) {
            JDD.Ref(jDDNode8);
            stateValues = new StateValuesMTBDD(JDD.ITE(jDDNode8, JDD.PlusInfinity(), JDD.Constant(0.0)), this.model);
        } else {
            this.mainLog.println("\nComputing remaining rewards...");
            if (n == 3) {
                this.mainLog.println("Switching engine since hybrid engine does yet support this computation...");
                n = 2;
            }
            this.mainLog.println("Engine: " + Prism.getEngineString(n));
            try {
                switch (n) {
                    case 1: {
                        JDDNode jDDNode14 = PrismMTBDD.NondetReachReward(jDDNode, jDDNode4, jDDNode5, this.odd, this.nondetMask, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, jDDNode6, jDDNode8, jDDNode7, bl);
                        stateValues = new StateValuesMTBDD(jDDNode14, this.model);
                        break;
                    }
                    case 2: {
                        DoubleVector doubleVector = PrismSparse.NondetReachReward(jDDNode, jDDNode2, this.model.getSynchs(), jDDNode4, jDDNode5, this.odd, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, jDDNode6, jDDNode8, jDDNode7, bl);
                        stateValues = new StateValuesDV(doubleVector, (Model)this.model);
                        break;
                    }
                    case 3: {
                        throw new PrismException("Hybrid engine does not yet support this type of property (use sparse or MTBDD engine instead)");
                    }
                    default: {
                        throw new PrismException("Unknown engine");
                    }
                }
            }
            catch (PrismException prismException) {
                JDD.Deref(jDDNode8);
                JDD.Deref(jDDNode7);
                throw prismException;
            }
        }
        if (list != null) {
            for (JDDNode jDDNode11 : list) {
                JDD.Deref(jDDNode11);
            }
        }
        JDD.Deref(jDDNode8);
        JDD.Deref(jDDNode7);
        return stateValues;
    }

    private boolean checkWeakAbsorbing(JDDNode jDDNode, NondetModel nondetModel) {
        JDD.Ref(nondetModel.getTrans01());
        JDD.Ref(jDDNode);
        JDDNode jDDNode2 = JDD.And(nondetModel.getTrans01(), jDDNode);
        jDDNode2 = JDD.SwapVariables(jDDNode2, nondetModel.getAllDDRowVars(), nondetModel.getAllDDColVars());
        jDDNode2 = JDD.ThereExists(jDDNode2, nondetModel.getAllDDNondetVars());
        jDDNode2 = JDD.ThereExists(jDDNode2, nondetModel.getAllDDColVars());
        JDD.Ref(nondetModel.getReach());
        jDDNode2 = JDD.And(nondetModel.getReach(), jDDNode2);
        JDD.Ref(jDDNode);
        jDDNode2 = JDD.And(jDDNode2, JDD.Not(jDDNode));
        boolean bl = jDDNode2.equals(JDD.ZERO);
        JDD.Deref(jDDNode2);
        return bl;
    }
}

