/*
 * Decompiled with CFR 0.152.
 */
package prism;

import cex.CexPathStates;
import java.util.ArrayList;
import java.util.List;
import jdd.JDD;
import jdd.JDDNode;
import parser.ast.Expression;
import parser.ast.ExpressionExists;
import parser.ast.ExpressionForAll;
import parser.ast.ExpressionTemporal;
import parser.ast.ExpressionUnaryOp;
import parser.ast.PropertiesFile;
import prism.Model;
import prism.ModelType;
import prism.NondetModel;
import prism.Prism;
import prism.PrismException;
import prism.SCCComputer;
import prism.StateModelChecker;
import prism.StateValues;
import prism.StateValuesMTBDD;

public class NonProbModelChecker
extends StateModelChecker {
    private boolean doGenCex = true;

    public NonProbModelChecker(Prism prism, Model model, PropertiesFile propertiesFile) throws PrismException {
        super(prism, model, propertiesFile);
    }

    @Override
    public StateValues checkExpression(Expression expression) throws PrismException {
        StateValues stateValues = expression instanceof ExpressionExists ? this.checkExpressionExists(((ExpressionExists)expression).getExpression()) : (expression instanceof ExpressionForAll ? this.checkExpressionForAll(((ExpressionForAll)expression).getExpression()) : super.checkExpression(expression));
        if (stateValues instanceof StateValuesMTBDD) {
            stateValues.filter(this.reach);
        }
        return stateValues;
    }

    protected StateValues checkExpressionExists(Expression expression) throws PrismException {
        StateValues stateValues = null;
        if (!expression.isSimplePathFormula()) {
            throw new PrismException("(Non-probabilistic) LTL model checking is not supported");
        }
        if (expression instanceof ExpressionUnaryOp) {
            ExpressionUnaryOp expressionUnaryOp = (ExpressionUnaryOp)expression;
            if (expressionUnaryOp.getOperator() == 3) {
                stateValues = this.checkExpressionExists(expressionUnaryOp.getOperand());
            } else if (expressionUnaryOp.getOperator() == 1) {
                stateValues = this.checkExpressionForAll(expressionUnaryOp.getOperand());
                stateValues.subtractFromOne();
            }
        } else if (expression instanceof ExpressionTemporal) {
            ExpressionTemporal expressionTemporal = (ExpressionTemporal)expression;
            if (expressionTemporal.hasBounds()) {
                throw new PrismException("Model checking of bounded CTL operators is not supported");
            }
            if (expressionTemporal.getOperator() == 1) {
                throw new PrismException("CTL model checking of the E X operator is not yet supported");
            }
            stateValues = expressionTemporal.getOperator() == 2 ? this.checkExistsUntil(expressionTemporal) : (expressionTemporal.getOperator() == 4 ? this.checkExistsGlobally(expressionTemporal) : this.checkExpressionExists(expressionTemporal.convertToUntilForm()));
        }
        if (stateValues == null) {
            throw new PrismException("Unrecognised path operator in E operator");
        }
        return stateValues;
    }

    protected StateValues checkExpressionForAll(Expression expression) throws PrismException {
        StateValues stateValues = null;
        if (!expression.isSimplePathFormula()) {
            throw new PrismException("(Non-probabilistic) LTL model checking is not supported");
        }
        if (expression instanceof ExpressionUnaryOp) {
            ExpressionUnaryOp expressionUnaryOp = (ExpressionUnaryOp)expression;
            if (expressionUnaryOp.getOperator() == 3) {
                stateValues = this.checkExpressionForAll(expressionUnaryOp.getOperand());
            } else if (expressionUnaryOp.getOperator() == 1) {
                stateValues = this.checkExpressionExists(expressionUnaryOp.getOperand());
                stateValues.subtractFromOne();
            }
        } else if (expression instanceof ExpressionTemporal) {
            ExpressionTemporal expressionTemporal = (ExpressionTemporal)expression;
            if (expressionTemporal.hasBounds()) {
                throw new PrismException("Model checking of bounded CTL operators is not supported");
            }
            if (expressionTemporal.getOperator() == 1) {
                throw new PrismException("CTL model checking of the A X operator is not yet supported");
            }
            if (expressionTemporal.getOperator() == 2) {
                throw new PrismException("CTL model checking of the A U operator is not yet supported");
            }
            if (expressionTemporal.getOperator() == 3) {
                ExpressionTemporal expressionTemporal2 = (ExpressionTemporal)expressionTemporal.deepCopy();
                expressionTemporal2.setOperator(4);
                expressionTemporal2.setOperand2(Expression.Not(expressionTemporal2.getOperand2()));
                stateValues = this.checkExpressionExists(expressionTemporal2);
                stateValues.subtractFromOne();
            } else {
                stateValues = this.checkExpressionForAll(expressionTemporal.convertToUntilForm());
            }
        }
        if (stateValues == null) {
            throw new PrismException("Unrecognised path operator in E operator");
        }
        return stateValues;
    }

    protected StateValues checkExistsUntil(ExpressionTemporal expressionTemporal) throws PrismException {
        JDDNode jDDNode;
        JDDNode jDDNode2;
        JDDNode jDDNode3 = null;
        ArrayList<JDDNode> arrayList = null;
        JDDNode jDDNode4 = null;
        boolean bl = false;
        JDDNode jDDNode5 = this.checkExpressionDD(expressionTemporal.getOperand1());
        try {
            jDDNode2 = this.checkExpressionDD(expressionTemporal.getOperand2());
        }
        catch (PrismException prismException) {
            JDD.Deref(jDDNode5);
            throw prismException;
        }
        long l = System.currentTimeMillis();
        if (this.doGenCex) {
            arrayList = new ArrayList<JDDNode>();
            bl = false;
            jDDNode3 = this.model.getStart();
        }
        if (this.model.getModelType() == ModelType.MDP) {
            JDD.Ref(this.trans01);
            jDDNode = JDD.ThereExists(this.trans01, ((NondetModel)this.model).getAllDDNondetVars());
        } else {
            JDD.Ref(this.trans01);
            jDDNode = this.trans01;
        }
        boolean bl2 = false;
        int n = 0;
        JDDNode jDDNode6 = JDD.Constant(0.0);
        while (!bl2) {
            ++n;
            JDD.Ref(jDDNode6);
            JDDNode jDDNode7 = JDD.PermuteVariables(jDDNode6, this.allDDRowVars, this.allDDColVars);
            JDD.Ref(jDDNode);
            jDDNode7 = JDD.And(jDDNode7, jDDNode);
            jDDNode7 = JDD.ThereExists(jDDNode7, this.allDDColVars);
            JDD.Ref(jDDNode5);
            jDDNode7 = JDD.And(jDDNode5, jDDNode7);
            JDD.Ref(jDDNode2);
            jDDNode7 = JDD.Or(jDDNode2, jDDNode7);
            if (jDDNode7.equals(jDDNode6)) {
                bl2 = true;
            }
            if (this.doGenCex && !bl) {
                JDD.Ref(jDDNode6);
                JDD.Ref(jDDNode7);
                arrayList.add(JDD.And(jDDNode7, JDD.Not(jDDNode6)));
                if (JDD.AreIntersecting(jDDNode7, jDDNode3)) {
                    bl = true;
                    JDD.Ref(jDDNode7);
                    JDD.Ref(jDDNode3);
                    jDDNode4 = JDD.And(jDDNode7, jDDNode3);
                    jDDNode4 = JDD.RestrictToFirst(jDDNode4, this.allDDRowVars);
                }
            }
            JDD.Deref(jDDNode6);
            jDDNode6 = jDDNode7;
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.println("\nCTL EU fixpoint: " + n + " iterations in " + (double)l / 1000.0 + " seconds");
        if (this.doGenCex) {
            if (!bl) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    JDD.Deref((JDDNode)arrayList.get(i));
                }
            } else {
                int n2;
                this.mainLog.println("Processing counterexample trace (" + arrayList.size() + " states long)...");
                JDD.Deref((JDDNode)arrayList.get(arrayList.size() - 1));
                arrayList.set(arrayList.size() - 1, jDDNode4);
                for (n2 = arrayList.size() - 2; n2 >= 0; --n2) {
                    JDD.Ref((JDDNode)arrayList.get(n2 + 1));
                    JDD.Ref(jDDNode);
                    JDDNode jDDNode8 = JDD.And((JDDNode)arrayList.get(n2 + 1), jDDNode);
                    jDDNode8 = JDD.ThereExists(jDDNode8, this.allDDRowVars);
                    jDDNode8 = JDD.PermuteVariables(jDDNode8, this.allDDColVars, this.allDDRowVars);
                    JDD.Ref((JDDNode)arrayList.get(n2));
                    jDDNode8 = JDD.And(jDDNode8, (JDDNode)arrayList.get(n2));
                    jDDNode8 = JDD.PermuteVariables(JDD.RestrictToFirst(jDDNode8, this.allDDColVars), this.allDDColVars, this.allDDRowVars);
                    JDD.Deref((JDDNode)arrayList.get(n2));
                    arrayList.set(n2, jDDNode8);
                }
                CexPathStates cexPathStates = new CexPathStates(this.model);
                for (n2 = arrayList.size() - 1; n2 >= 0; --n2) {
                    cexPathStates.addState(this.model.convertBddToState((JDDNode)arrayList.get(n2)));
                    JDD.Deref((JDDNode)arrayList.get(n2));
                }
                this.result.setCounterexample(cexPathStates);
            }
        }
        JDD.Deref(jDDNode5);
        JDD.Deref(jDDNode2);
        JDD.Deref(jDDNode);
        return new StateValuesMTBDD(jDDNode6, this.model);
    }

    protected StateValues checkExistsGlobally(ExpressionTemporal expressionTemporal) throws PrismException {
        int n;
        JDDNode jDDNode;
        List<JDDNode> list = null;
        JDDNode jDDNode2 = null;
        int n2 = 0;
        JDDNode jDDNode3 = this.checkExpressionDD(expressionTemporal.getOperand2());
        long l = System.currentTimeMillis();
        if (this.model.getModelType() == ModelType.MDP) {
            JDD.Ref(this.trans01);
            jDDNode = JDD.ThereExists(this.trans01, ((NondetModel)this.model).getAllDDNondetVars());
        } else {
            JDD.Ref(this.trans01);
            jDDNode = this.trans01;
        }
        JDD.Ref(jDDNode3);
        jDDNode = JDD.And(jDDNode, jDDNode3);
        JDD.Ref(jDDNode3);
        jDDNode = JDD.And(jDDNode, JDD.PermuteVariables(jDDNode3, this.allDDRowVars, this.allDDColVars));
        SCCComputer sCCComputer = this.prism.getSCCComputer(this.reach, jDDNode, this.allDDRowVars, this.allDDColVars);
        sCCComputer.computeSCCs();
        list = sCCComputer.getSCCs();
        jDDNode2 = sCCComputer.getNotInSCCs();
        n2 = list.size();
        JDDNode jDDNode4 = JDD.Create();
        for (n = 0; n < n2; ++n) {
            JDDNode jDDNode5 = list.get(n);
            if (jDDNode5 == null || !JDD.AreIntersecting(jDDNode5, jDDNode)) continue;
            JDD.Ref(jDDNode5);
            jDDNode4 = JDD.Or(jDDNode4, jDDNode5);
        }
        this.mainLog.println("\nCTL EG non-trivial SCC states: " + JDD.GetNumMintermsString(jDDNode4, this.allDDRowVars.n()));
        boolean bl = false;
        int n3 = 0;
        JDDNode jDDNode6 = JDD.Constant(0.0);
        while (!bl) {
            ++n3;
            JDD.Ref(jDDNode6);
            JDDNode jDDNode7 = JDD.PermuteVariables(jDDNode6, this.allDDRowVars, this.allDDColVars);
            JDD.Ref(jDDNode);
            jDDNode7 = JDD.And(jDDNode7, jDDNode);
            jDDNode7 = JDD.ThereExists(jDDNode7, this.allDDColVars);
            JDD.Ref(jDDNode4);
            jDDNode7 = JDD.Or(jDDNode4, jDDNode7);
            if (jDDNode7.equals(jDDNode6)) {
                bl = true;
            }
            JDD.Deref(jDDNode6);
            jDDNode6 = jDDNode7;
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.println("CTL EG reachability fixpoint: " + n3 + " iterations in " + (double)l / 1000.0 + " seconds");
        JDD.Deref(jDDNode3);
        JDD.Deref(jDDNode4);
        JDD.Deref(jDDNode);
        for (n = 0; n < n2; ++n) {
            if (list.get(n) == null) continue;
            JDD.Deref(list.get(n));
        }
        if (jDDNode2 != null) {
            JDD.Deref(jDDNode2);
        }
        return new StateValuesMTBDD(jDDNode6, this.model);
    }
}

