/*
 * Decompiled with CFR 0.152.
 */
package prism;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;
import parser.Values;
import parser.VarList;
import parser.ast.Command;
import parser.ast.Expression;
import parser.ast.Module;
import parser.ast.ModulesFile;
import parser.ast.RewardStruct;
import parser.ast.SystemBrackets;
import parser.ast.SystemDefn;
import parser.ast.SystemFullParallel;
import parser.ast.SystemHide;
import parser.ast.SystemInterleaved;
import parser.ast.SystemModule;
import parser.ast.SystemParallel;
import parser.ast.SystemReference;
import parser.ast.SystemRename;
import parser.ast.Update;
import parser.ast.Updates;
import prism.Model;
import prism.ModelType;
import prism.NondetModel;
import prism.Prism;
import prism.PrismException;
import prism.PrismLangException;
import prism.PrismLog;
import prism.PrismNotSupportedException;
import prism.PrismUtils;
import prism.ProbModel;
import prism.StateModelChecker;
import prism.StochModel;

public class Modules2MTBDD {
    private Prism prism;
    private StateModelChecker expr2mtbdd;
    private PrismLog mainLog;
    private PrismLog techLog;
    private ModulesFile modulesFile;
    private ModelType modelType;
    private int numModules;
    private String[] moduleNames;
    private int numVars;
    private VarList varList;
    private Values constantValues;
    private int numSynchs;
    private Vector<String> synchs;
    private int numRewardStructs;
    private String[] rewardStructNames;
    private JDDNode trans;
    private JDDNode range;
    private JDDNode start;
    private JDDNode[] stateRewards;
    private JDDNode[] transRewards;
    private JDDNode transActions;
    private JDDNode[] transPerAction;
    private JDDNode transInd;
    private JDDNode[] transSynch;
    private JDDVars allDDRowVars;
    private JDDVars allDDColVars;
    private JDDVars allDDSynchVars;
    private JDDVars allDDSchedVars;
    private JDDVars allDDChoiceVars;
    private JDDVars allDDNondetVars;
    private JDDVars globalDDRowVars;
    private JDDVars globalDDColVars;
    private JDDVars[] moduleDDRowVars;
    private JDDVars[] moduleDDColVars;
    private JDDNode[] moduleRangeDDs;
    private JDDNode[] moduleIdentities;
    private JDDVars[] varDDRowVars;
    private JDDVars[] varDDColVars;
    private JDDNode[] varRangeDDs;
    private JDDNode[] varColRangeDDs;
    private JDDNode[] varIdentities;
    private JDDNode[] ddSynchVars;
    private JDDNode[] ddSchedVars;
    private JDDNode[] ddChoiceVars;
    private Vector<String> ddVarNames;
    private boolean[] varsUsed;
    private boolean doSymmetry;
    private JDDNode symm;
    private JDDNode[] nonSymms;
    private int numModulesBeforeSymm;
    private int numModulesAfterSymm;
    private int numSymmModules;
    private boolean storeTransParts = false;
    private boolean storeTransActions = true;

    public Modules2MTBDD(Prism prism, ModulesFile modulesFile) {
        this.prism = prism;
        this.mainLog = prism.getMainLog();
        this.techLog = prism.getTechLog();
        this.modulesFile = modulesFile;
        String string = this.prism.getSettings().getString("prism.symmRedParams");
        this.doSymmetry = string != null && string != "";
    }

    public Model translate() throws PrismException {
        int n;
        Model model = null;
        this.varList = this.modulesFile.createVarList();
        if (this.varList.containsUnboundedVariables()) {
            throw new PrismNotSupportedException("Cannot build a model that contains a variable with unbounded range (try the explicit engine instead)");
        }
        this.numVars = this.varList.getNumVars();
        this.constantValues = this.modulesFile.getConstantValues();
        this.modelType = this.modulesFile.getModelType();
        this.moduleNames = this.modulesFile.getModuleNames();
        this.numModules = this.modulesFile.getNumModules();
        this.synchs = this.modulesFile.getSynchs();
        this.numSynchs = this.synchs.size();
        this.allocateDDVars();
        this.sortDDVars();
        this.sortIdentities();
        this.sortRanges();
        this.expr2mtbdd = new StateModelChecker(this.prism, this.varList, this.allDDRowVars, this.varDDRowVars, this.constantValues);
        this.translateModules();
        if (this.modelType == ModelType.MDP) {
            JDDNode jDDNode = JDD.GetSupport(this.trans);
            jDDNode = JDD.ThereExists(jDDNode, this.allDDRowVars);
            JDDNode jDDNode2 = jDDNode = JDD.ThereExists(jDDNode, this.allDDColVars);
            JDDVars jDDVars = new JDDVars();
            while (!jDDNode2.equals(JDD.ONE)) {
                jDDVars.addVar(JDD.Var(jDDNode2.getIndex()));
                jDDNode2 = jDDNode2.getThen();
            }
            JDD.Deref(jDDNode);
            this.allDDNondetVars.derefAll();
            this.allDDNondetVars = jDDVars;
        }
        if (this.prism.getExtraDDInfo()) {
            this.mainLog.print("Transition matrix (pre-reachability): ");
            this.mainLog.print(JDD.GetNumNodes(this.trans) + " nodes (");
            this.mainLog.print(JDD.GetNumTerminals(this.trans) + " terminal)\n");
        }
        this.buildInitialStates();
        this.rewardStructNames = new String[this.numRewardStructs];
        for (n = 0; n < this.numRewardStructs; ++n) {
            this.rewardStructNames[n] = this.modulesFile.getRewardStruct(n).getName();
        }
        if (this.modelType == ModelType.DTMC) {
            model = new ProbModel(this.trans, this.start, this.stateRewards, this.transRewards, this.rewardStructNames, this.allDDRowVars, this.allDDColVars, this.ddVarNames, this.numModules, this.moduleNames, this.moduleDDRowVars, this.moduleDDColVars, this.numVars, this.varList, this.varDDRowVars, this.varDDColVars, this.constantValues);
        } else if (this.modelType == ModelType.MDP) {
            model = new NondetModel(this.trans, this.start, this.stateRewards, this.transRewards, this.rewardStructNames, this.allDDRowVars, this.allDDColVars, this.allDDSynchVars, this.allDDSchedVars, this.allDDChoiceVars, this.allDDNondetVars, this.ddVarNames, this.numModules, this.moduleNames, this.moduleDDRowVars, this.moduleDDColVars, this.numVars, this.varList, this.varDDRowVars, this.varDDColVars, this.constantValues);
        } else if (this.modelType == ModelType.CTMC) {
            model = new StochModel(this.trans, this.start, this.stateRewards, this.transRewards, this.rewardStructNames, this.allDDRowVars, this.allDDColVars, this.ddVarNames, this.numModules, this.moduleNames, this.moduleDDRowVars, this.moduleDDColVars, this.numVars, this.varList, this.varDDRowVars, this.varDDColVars, this.constantValues);
        }
        model.setSynchs((Vector)this.synchs.clone());
        if (this.modelType == ModelType.MDP && this.storeTransParts) {
            ((NondetModel)model).setTransInd(this.transInd);
            ((NondetModel)model).setTransSynch(this.transSynch);
        }
        if (this.storeTransActions) {
            model.setTransActions(this.transActions);
            model.setTransPerAction(this.transPerAction);
        }
        if (this.prism.getDoReach()) {
            this.mainLog.print("\nComputing reachable states...\n");
            model.doReachability();
            model.filterReachableStates();
        } else {
            this.mainLog.print("\nSkipping reachable state computation.\n");
            model.skipReachability();
            model.filterReachableStates();
        }
        if (this.prism.getExtraDDInfo()) {
            this.mainLog.print("Reach: " + JDD.GetNumNodes(model.getReach()) + " nodes\n");
        }
        if (this.doSymmetry) {
            this.doSymmetry(model);
        }
        model.findDeadlocks(this.prism.getFixDeadlocks());
        this.globalDDRowVars.derefAll();
        this.globalDDColVars.derefAll();
        for (n = 0; n < this.numModules; ++n) {
            JDD.Deref(this.moduleIdentities[n]);
            JDD.Deref(this.moduleRangeDDs[n]);
        }
        for (n = 0; n < this.numVars; ++n) {
            JDD.Deref(this.varIdentities[n]);
            JDD.Deref(this.varRangeDDs[n]);
            JDD.Deref(this.varColRangeDDs[n]);
        }
        JDD.Deref(this.range);
        if (this.modelType == ModelType.MDP) {
            for (n = 0; n < this.ddSynchVars.length; ++n) {
                JDD.Deref(this.ddSynchVars[n]);
            }
            for (n = 0; n < this.ddSchedVars.length; ++n) {
                JDD.Deref(this.ddSchedVars[n]);
            }
            for (n = 0; n < this.ddChoiceVars.length; ++n) {
                JDD.Deref(this.ddChoiceVars[n]);
            }
        }
        if (this.doSymmetry) {
            JDD.Deref(this.symm);
            for (n = 0; n < this.numSymmModules - 1; ++n) {
                JDD.Deref(this.nonSymms[n]);
            }
        }
        this.expr2mtbdd.clearDummyModel();
        return model;
    }

    private void allocateDDVars() {
        int n = 0;
        this.ddVarNames = new Vector();
        switch (this.prism.getOrdering()) {
            case 1: {
                JDDNode jDDNode;
                int n2;
                int n3;
                if (this.modelType == ModelType.MDP) {
                    this.ddSynchVars = new JDDNode[this.numSynchs];
                    this.ddSchedVars = new JDDNode[this.numModules];
                    n3 = this.numModules;
                    for (n2 = 0; n2 < this.numModules; ++n2) {
                        n3 += this.modulesFile.getModule(n2).getNumCommands();
                    }
                    this.ddChoiceVars = new JDDNode[n3];
                }
                this.varDDRowVars = new JDDVars[this.numVars];
                this.varDDColVars = new JDDVars[this.numVars];
                for (n2 = 0; n2 < this.numVars; ++n2) {
                    this.varDDRowVars[n2] = new JDDVars();
                    this.varDDColVars[n2] = new JDDVars();
                }
                if (this.modelType == ModelType.MDP) {
                    for (n2 = 0; n2 < this.numSynchs; ++n2) {
                        this.ddSynchVars[n2] = jDDNode = JDD.Var(n++);
                        this.ddVarNames.add(this.synchs.elementAt(n2) + ".a");
                    }
                }
                if (this.modelType == ModelType.MDP) {
                    for (n2 = 0; n2 < this.numModules; ++n2) {
                        this.ddSchedVars[n2] = jDDNode = JDD.Var(n++);
                        this.ddVarNames.add(this.moduleNames[n2] + ".s");
                    }
                }
                if (this.modelType == ModelType.MDP) {
                    n3 = this.ddChoiceVars.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        this.ddChoiceVars[n2] = jDDNode = JDD.Var(n++);
                        this.ddVarNames.add("l" + n2);
                    }
                }
                for (n2 = 0; n2 < 20; ++n2) {
                    ++n;
                    this.ddVarNames.add("");
                }
                for (n2 = 0; n2 < this.numVars; ++n2) {
                    int n4 = this.varList.getRangeLogTwo(n2);
                    for (int i = 0; i < n4; ++i) {
                        JDDNode jDDNode2 = JDD.Var(n++);
                        JDDNode jDDNode3 = JDD.Var(n++);
                        this.varDDRowVars[n2].addVar(jDDNode2);
                        this.varDDColVars[n2].addVar(jDDNode3);
                        this.ddVarNames.add(this.varList.getName(n2) + "." + i);
                        this.ddVarNames.add(this.varList.getName(n2) + "'." + i);
                    }
                }
                break;
            }
            case 2: {
                int n5;
                JDDNode jDDNode;
                int n6;
                int n7;
                if (this.modelType == ModelType.MDP) {
                    this.ddSynchVars = new JDDNode[this.numSynchs];
                    this.ddSchedVars = new JDDNode[this.numModules];
                    n7 = this.numModules;
                    for (n6 = 0; n6 < this.numModules; ++n6) {
                        n7 += this.modulesFile.getModule(n6).getNumCommands();
                    }
                    this.ddChoiceVars = new JDDNode[n7];
                }
                this.varDDRowVars = new JDDVars[this.numVars];
                this.varDDColVars = new JDDVars[this.numVars];
                for (n6 = 0; n6 < this.numVars; ++n6) {
                    this.varDDRowVars[n6] = new JDDVars();
                    this.varDDColVars[n6] = new JDDVars();
                }
                if (this.modelType == ModelType.MDP) {
                    for (n6 = 0; n6 < this.numSynchs; ++n6) {
                        this.ddSynchVars[n6] = jDDNode = JDD.Var(n++);
                        this.ddVarNames.add(this.synchs.elementAt(n6) + ".a");
                    }
                }
                if (this.modelType == ModelType.MDP) {
                    n7 = this.ddChoiceVars.length;
                    for (n6 = 0; n6 < n7; ++n6) {
                        this.ddChoiceVars[n6] = jDDNode = JDD.Var(n++);
                        this.ddVarNames.add("l" + n6);
                    }
                }
                int n8 = -1;
                for (n6 = 0; n6 < this.numVars; ++n6) {
                    if (this.modelType == ModelType.MDP && n8 != this.varList.getModule(n6)) {
                        for (n5 = n8 + 1; n5 <= this.varList.getModule(n6); ++n5) {
                            this.ddSchedVars[n5] = jDDNode = JDD.Var(n++);
                            this.ddVarNames.add(this.moduleNames[n5] + ".s");
                        }
                        n8 = this.varList.getModule(n6);
                    }
                    int n9 = this.varList.getRangeLogTwo(n6);
                    for (n5 = 0; n5 < n9; ++n5) {
                        JDDNode jDDNode4 = JDD.Var(n++);
                        JDDNode jDDNode5 = JDD.Var(n++);
                        this.varDDRowVars[n6].addVar(jDDNode4);
                        this.varDDColVars[n6].addVar(jDDNode5);
                        this.ddVarNames.add(this.varList.getName(n6) + "." + n5);
                        this.ddVarNames.add(this.varList.getName(n6) + "'." + n5);
                    }
                }
                if (this.modelType != ModelType.MDP) break;
                for (n5 = n8 + 1; n5 < this.numModules; ++n5) {
                    this.ddSchedVars[n5] = jDDNode = JDD.Var(n++);
                    this.ddVarNames.add(this.moduleNames[n5] + ".s");
                }
                break;
            }
            default: {
                this.mainLog.printWarning("Invalid MTBDD ordering selected - it's all going to go wrong.");
            }
        }
    }

    private void sortDDVars() {
        int n;
        this.globalDDRowVars = new JDDVars();
        this.globalDDColVars = new JDDVars();
        this.moduleDDRowVars = new JDDVars[this.numModules];
        this.moduleDDColVars = new JDDVars[this.numModules];
        for (n = 0; n < this.numModules; ++n) {
            this.moduleDDRowVars[n] = new JDDVars();
            this.moduleDDColVars[n] = new JDDVars();
        }
        for (n = 0; n < this.numVars; ++n) {
            this.varDDRowVars[n].refAll();
            this.varDDColVars[n].refAll();
            int n2 = this.varList.getModule(n);
            if (n2 == -1) {
                this.globalDDRowVars.addVars(this.varDDRowVars[n]);
                this.globalDDColVars.addVars(this.varDDColVars[n]);
                continue;
            }
            this.moduleDDRowVars[n2].addVars(this.varDDRowVars[n]);
            this.moduleDDColVars[n2].addVars(this.varDDColVars[n]);
        }
        this.allDDRowVars = new JDDVars();
        this.allDDColVars = new JDDVars();
        if (this.modelType == ModelType.MDP) {
            this.allDDSynchVars = new JDDVars();
            this.allDDSchedVars = new JDDVars();
            this.allDDChoiceVars = new JDDVars();
            this.allDDNondetVars = new JDDVars();
        }
        for (n = 0; n < this.numVars; ++n) {
            this.varDDRowVars[n].refAll();
            this.varDDColVars[n].refAll();
            this.allDDRowVars.addVars(this.varDDRowVars[n]);
            this.allDDColVars.addVars(this.varDDColVars[n]);
        }
        if (this.modelType == ModelType.MDP) {
            for (n = 0; n < this.ddSynchVars.length; ++n) {
                JDD.Ref(this.ddSynchVars[n]);
                JDD.Ref(this.ddSynchVars[n]);
                this.allDDSynchVars.addVar(this.ddSynchVars[n]);
                this.allDDNondetVars.addVar(this.ddSynchVars[n]);
            }
            for (n = 0; n < this.ddSchedVars.length; ++n) {
                JDD.Ref(this.ddSchedVars[n]);
                JDD.Ref(this.ddSchedVars[n]);
                this.allDDSchedVars.addVar(this.ddSchedVars[n]);
                this.allDDNondetVars.addVar(this.ddSchedVars[n]);
            }
            for (n = 0; n < this.ddChoiceVars.length; ++n) {
                JDD.Ref(this.ddChoiceVars[n]);
                JDD.Ref(this.ddChoiceVars[n]);
                this.allDDChoiceVars.addVar(this.ddChoiceVars[n]);
                this.allDDNondetVars.addVar(this.ddChoiceVars[n]);
            }
        }
    }

    private void sortIdentities() {
        int n;
        JDDNode jDDNode;
        int n2;
        this.varIdentities = new JDDNode[this.numVars];
        for (n2 = 0; n2 < this.numVars; ++n2) {
            jDDNode = JDD.Constant(0.0);
            for (n = 0; n < this.varList.getRange(n2); ++n) {
                jDDNode = JDD.SetMatrixElement(jDDNode, this.varDDRowVars[n2], this.varDDColVars[n2], n, n, 1.0);
            }
            this.varIdentities[n2] = jDDNode;
        }
        this.moduleIdentities = new JDDNode[this.numModules];
        for (n2 = 0; n2 < this.numModules; ++n2) {
            jDDNode = JDD.Constant(1.0);
            for (n = 0; n < this.numVars; ++n) {
                if (this.varList.getModule(n) != n2) continue;
                JDD.Ref(this.varIdentities[n]);
                jDDNode = JDD.Apply(3, jDDNode, this.varIdentities[n]);
            }
            this.moduleIdentities[n2] = jDDNode;
        }
    }

    private void sortRanges() {
        int n;
        this.range = JDD.Constant(1.0);
        this.varRangeDDs = new JDDNode[this.numVars];
        this.varColRangeDDs = new JDDNode[this.numVars];
        for (n = 0; n < this.numVars; ++n) {
            JDD.Ref(this.varIdentities[n]);
            this.varRangeDDs[n] = JDD.SumAbstract(this.varIdentities[n], this.varDDColVars[n]);
            JDD.Ref(this.varIdentities[n]);
            this.varColRangeDDs[n] = JDD.SumAbstract(this.varIdentities[n], this.varDDRowVars[n]);
            JDD.Ref(this.varRangeDDs[n]);
            this.range = JDD.Apply(3, this.range, this.varRangeDDs[n]);
        }
        this.moduleRangeDDs = new JDDNode[this.numModules];
        for (n = 0; n < this.numModules; ++n) {
            JDD.Ref(this.moduleIdentities[n]);
            this.moduleRangeDDs[n] = JDD.SumAbstract(this.moduleIdentities[n], this.moduleDDColVars[n]);
        }
    }

    private void translateModules() throws PrismException {
        this.varsUsed = new boolean[this.numVars];
        if (this.modulesFile.getSystemDefn() == null) {
            SystemFullParallel systemFullParallel = new SystemFullParallel();
            for (int i = 0; i < this.numModules; ++i) {
                systemFullParallel.addOperand(new SystemModule(this.moduleNames[i]));
            }
            this.translateSystemDefn(systemFullParallel);
        } else {
            this.translateSystemDefn(this.modulesFile.getSystemDefn());
        }
        if (this.modelType == ModelType.DTMC) {
            JDD.Ref(this.trans);
            JDDNode jDDNode = JDD.SumAbstract(this.trans, this.allDDColVars);
            this.trans = JDD.Apply(4, this.trans, jDDNode);
        }
    }

    private void translateSystemDefn(SystemDefn systemDefn) throws PrismException {
        int n;
        JDDNode jDDNode;
        int n2;
        int[] nArray = new int[this.numSynchs];
        for (n2 = 0; n2 < this.numSynchs; ++n2) {
            nArray[n2] = 0;
        }
        SystemDDs systemDDs = this.translateSystemDefnRec(systemDefn, nArray);
        if (this.modelType == ModelType.MDP) {
            JDDNode jDDNode2;
            int n3 = systemDDs.ind.max;
            for (n2 = 0; n2 < this.numSynchs; ++n2) {
                if (systemDDs.synchs[n2].max <= n3) continue;
                n3 = systemDDs.synchs[n2].max;
            }
            if (n3 > systemDDs.ind.max) {
                jDDNode = JDD.Constant(1.0);
                for (n2 = systemDDs.ind.max; n2 < n3; ++n2) {
                    jDDNode2 = this.ddChoiceVars[this.ddChoiceVars.length - n2 - 1];
                    JDD.Ref(jDDNode2);
                    jDDNode = JDD.And(jDDNode, JDD.Not(jDDNode2));
                }
                systemDDs.ind.trans = JDD.Apply(3, systemDDs.ind.trans, jDDNode);
                systemDDs.ind.max = n3;
            }
            for (n2 = 0; n2 < this.numSynchs; ++n2) {
                if (n3 <= systemDDs.synchs[n2].max) continue;
                jDDNode = JDD.Constant(1.0);
                for (n = systemDDs.synchs[n2].max; n < n3; ++n) {
                    jDDNode2 = this.ddChoiceVars[this.ddChoiceVars.length - n - 1];
                    JDD.Ref(jDDNode2);
                    jDDNode = JDD.And(jDDNode, JDD.Not(jDDNode2));
                }
                systemDDs.synchs[n2].trans = JDD.Apply(3, systemDDs.synchs[n2].trans, jDDNode);
                systemDDs.synchs[n2].max = n3;
            }
            jDDNode = JDD.Constant(1.0);
            for (n2 = 0; n2 < this.numSynchs; ++n2) {
                JDD.Ref(this.ddSynchVars[n2]);
                jDDNode = JDD.And(jDDNode, JDD.Not(this.ddSynchVars[n2]));
            }
            systemDDs.ind.trans = JDD.Apply(3, jDDNode, systemDDs.ind.trans);
            for (n2 = 0; n2 < this.numSynchs; ++n2) {
                jDDNode = JDD.Constant(1.0);
                for (n = 0; n < this.numSynchs; ++n) {
                    JDD.Ref(this.ddSynchVars[n]);
                    jDDNode = n == n2 ? JDD.And(jDDNode, this.ddSynchVars[n]) : JDD.And(jDDNode, JDD.Not(this.ddSynchVars[n]));
                }
                systemDDs.synchs[n2].trans = JDD.Apply(3, jDDNode, systemDDs.synchs[n2].trans);
            }
        }
        this.computeRewards(systemDDs);
        int n4 = this.modulesFile.getNumRewardStructs();
        JDD.Ref(systemDDs.ind.trans);
        this.trans = systemDDs.ind.trans;
        for (n = 0; n < n4; ++n) {
            this.transRewards[n] = systemDDs.ind.rewards[n];
        }
        for (n2 = 0; n2 < this.numSynchs; ++n2) {
            JDD.Ref(systemDDs.synchs[n2].trans);
            this.trans = JDD.Apply(1, this.trans, systemDDs.synchs[n2].trans);
            for (n = 0; n < n4; ++n) {
                this.transRewards[n] = JDD.Apply(1, this.transRewards[n], systemDDs.synchs[n2].rewards[n]);
            }
        }
        if (this.modelType != ModelType.MDP) {
            n4 = this.modulesFile.getNumRewardStructs();
            for (n = 0; n < n4; ++n) {
                JDD.Ref(this.trans);
                this.transRewards[n] = JDD.Apply(4, this.transRewards[n], this.trans);
            }
        }
        if (this.modelType == ModelType.MDP && this.storeTransParts) {
            JDD.Ref(systemDDs.ind.trans);
            this.transInd = JDD.ThereExists(JDD.GreaterThan(systemDDs.ind.trans, 0.0), this.allDDColVars);
            this.transSynch = new JDDNode[this.numSynchs];
            for (n2 = 0; n2 < this.numSynchs; ++n2) {
                JDD.Ref(systemDDs.synchs[n2].trans);
                this.transSynch[n2] = JDD.ThereExists(JDD.GreaterThan(systemDDs.synchs[n2].trans, 0.0), this.allDDColVars);
            }
        }
        if (this.storeTransActions) {
            this.transActions = null;
            this.transPerAction = null;
            switch (this.modelType) {
                case MDP: {
                    this.transActions = JDD.Constant(0.0);
                    for (n2 = 0; n2 < this.numSynchs; ++n2) {
                        JDD.Ref(systemDDs.synchs[n2].trans);
                        jDDNode = JDD.ThereExists(JDD.GreaterThan(systemDDs.synchs[n2].trans, 0.0), this.allDDColVars);
                        this.transActions = JDD.Apply(1, this.transActions, JDD.Apply(3, jDDNode, JDD.Constant(1 + n2)));
                    }
                    break;
                }
                case DTMC: 
                case CTMC: {
                    this.transPerAction = new JDDNode[this.numSynchs + 1];
                    JDD.Ref(systemDDs.ind.trans);
                    this.transPerAction[0] = systemDDs.ind.trans;
                    for (n2 = 0; n2 < this.numSynchs; ++n2) {
                        JDD.Ref(systemDDs.synchs[n2].trans);
                        this.transPerAction[n2 + 1] = systemDDs.synchs[n2].trans;
                    }
                    break;
                }
            }
        }
        JDD.Deref(systemDDs.ind.guards);
        JDD.Deref(systemDDs.ind.trans);
        for (n2 = 0; n2 < this.numSynchs; ++n2) {
            JDD.Deref(systemDDs.synchs[n2].guards);
            JDD.Deref(systemDDs.synchs[n2].trans);
        }
        JDD.Deref(systemDDs.id);
    }

    private SystemDDs translateSystemDefnRec(SystemDefn systemDefn, int[] nArray) throws PrismException {
        SystemDDs systemDDs;
        if (systemDefn instanceof SystemModule) {
            systemDDs = this.translateSystemModule((SystemModule)systemDefn, nArray);
        } else if (systemDefn instanceof SystemBrackets) {
            systemDDs = this.translateSystemDefnRec(((SystemBrackets)systemDefn).getOperand(), nArray);
        } else if (systemDefn instanceof SystemFullParallel) {
            systemDDs = this.translateSystemFullParallel((SystemFullParallel)systemDefn, nArray);
        } else if (systemDefn instanceof SystemInterleaved) {
            systemDDs = this.translateSystemInterleaved((SystemInterleaved)systemDefn, nArray);
        } else if (systemDefn instanceof SystemParallel) {
            systemDDs = this.translateSystemParallel((SystemParallel)systemDefn, nArray);
        } else if (systemDefn instanceof SystemHide) {
            systemDDs = this.translateSystemHide((SystemHide)systemDefn, nArray);
        } else if (systemDefn instanceof SystemRename) {
            systemDDs = this.translateSystemRename((SystemRename)systemDefn, nArray);
        } else if (systemDefn instanceof SystemReference) {
            String string = ((SystemReference)systemDefn).getName();
            SystemDefn systemDefn2 = this.modulesFile.getSystemDefnByName(string);
            if (systemDefn2 == null) {
                throw new PrismLangException("Reference to system " + systemDefn + " which does not exist", systemDefn);
            }
            systemDDs = this.translateSystemDefnRec(systemDefn2, nArray);
        } else {
            throw new PrismLangException("Unknown operator in model construction", systemDefn);
        }
        return systemDDs;
    }

    private SystemDDs translateSystemModule(SystemModule systemModule, int[] nArray) throws PrismException {
        SystemDDs systemDDs = new SystemDDs(this.numSynchs);
        int n = this.modulesFile.getModuleIndex(systemModule.getName());
        Module module = this.modulesFile.getModule(n);
        systemDDs.ind = this.translateModule(n, module, "", 0);
        for (int i = 0; i < this.numSynchs; ++i) {
            String string = this.synchs.elementAt(i);
            systemDDs.synchs[i] = this.translateModule(n, module, string, nArray[i]);
        }
        JDD.Ref(this.moduleIdentities[n]);
        systemDDs.id = this.moduleIdentities[n];
        systemDDs.allSynchs.addAll(module.getAllSynchs());
        return systemDDs;
    }

    private SystemDDs translateSystemFullParallel(SystemFullParallel systemFullParallel, int[] nArray) throws PrismException {
        SystemDDs systemDDs = this.translateSystemDefnRec(systemFullParallel.getOperand(0), nArray);
        for (int i = 1; i < systemFullParallel.getNumOperands(); ++i) {
            int n;
            int[] nArray2 = new int[this.numSynchs];
            for (n = 0; n < this.numSynchs; ++n) {
                nArray2[n] = systemDDs.allSynchs.contains(this.synchs.get(n)) ? systemDDs.synchs[n].max : nArray[n];
            }
            SystemDDs systemDDs2 = this.translateSystemDefnRec(systemFullParallel.getOperand(i), nArray2);
            SystemDDs systemDDs3 = systemDDs;
            systemDDs = new SystemDDs(this.numSynchs);
            systemDDs.ind = this.translateNonSynchronising(systemDDs3.ind, systemDDs2.ind, systemDDs3.id, systemDDs2.id);
            for (n = 0; n < this.numSynchs; ++n) {
                systemDDs.synchs[n] = (systemDDs3.allSynchs.contains(this.synchs.get(n)) ? 1 : 0) + (systemDDs2.allSynchs.contains(this.synchs.get(n)) ? 1 : 0) == 1 ? this.translateNonSynchronising(systemDDs3.synchs[n], systemDDs2.synchs[n], systemDDs3.id, systemDDs2.id) : this.translateSynchronising(systemDDs3.synchs[n], systemDDs2.synchs[n]);
            }
            systemDDs.id = JDD.Apply(3, systemDDs3.id, systemDDs2.id);
            systemDDs.allSynchs.addAll(systemDDs3.allSynchs);
            systemDDs.allSynchs.addAll(systemDDs2.allSynchs);
        }
        return systemDDs;
    }

    private SystemDDs translateSystemInterleaved(SystemInterleaved systemInterleaved, int[] nArray) throws PrismException {
        SystemDDs systemDDs = this.translateSystemDefnRec(systemInterleaved.getOperand(0), nArray);
        for (int i = 1; i < systemInterleaved.getNumOperands(); ++i) {
            SystemDDs systemDDs2 = this.translateSystemDefnRec(systemInterleaved.getOperand(i), nArray);
            SystemDDs systemDDs3 = systemDDs;
            systemDDs = new SystemDDs(this.numSynchs);
            systemDDs.ind = this.translateNonSynchronising(systemDDs3.ind, systemDDs2.ind, systemDDs3.id, systemDDs2.id);
            for (int j = 0; j < this.numSynchs; ++j) {
                systemDDs.synchs[j] = this.translateNonSynchronising(systemDDs3.synchs[j], systemDDs2.synchs[j], systemDDs3.id, systemDDs2.id);
            }
            systemDDs.id = JDD.Apply(3, systemDDs3.id, systemDDs2.id);
            systemDDs.allSynchs.addAll(systemDDs3.allSynchs);
            systemDDs.allSynchs.addAll(systemDDs2.allSynchs);
        }
        return systemDDs;
    }

    private SystemDDs translateSystemParallel(SystemParallel systemParallel, int[] nArray) throws PrismException {
        int n;
        boolean[] blArray = new boolean[this.numSynchs];
        for (n = 0; n < this.numSynchs; ++n) {
            blArray[n] = systemParallel.containsAction(this.synchs.elementAt(n));
        }
        SystemDDs systemDDs = this.translateSystemDefnRec(systemParallel.getOperand1(), nArray);
        int[] nArray2 = new int[this.numSynchs];
        for (n = 0; n < this.numSynchs; ++n) {
            nArray2[n] = blArray[n] ? systemDDs.synchs[n].max : nArray[n];
        }
        SystemDDs systemDDs2 = this.translateSystemDefnRec(systemParallel.getOperand2(), nArray2);
        SystemDDs systemDDs3 = new SystemDDs(this.numSynchs);
        systemDDs3.ind = this.translateNonSynchronising(systemDDs.ind, systemDDs2.ind, systemDDs.id, systemDDs2.id);
        for (n = 0; n < this.numSynchs; ++n) {
            systemDDs3.synchs[n] = blArray[n] ? this.translateSynchronising(systemDDs.synchs[n], systemDDs2.synchs[n]) : this.translateNonSynchronising(systemDDs.synchs[n], systemDDs2.synchs[n], systemDDs.id, systemDDs2.id);
        }
        systemDDs3.id = JDD.Apply(3, systemDDs.id, systemDDs2.id);
        systemDDs3.allSynchs.addAll(systemDDs.allSynchs);
        systemDDs3.allSynchs.addAll(systemDDs2.allSynchs);
        return systemDDs3;
    }

    private SystemDDs translateSystemHide(SystemHide systemHide, int[] nArray) throws PrismException {
        int n;
        int[] nArray2 = new int[this.numSynchs];
        for (n = 0; n < this.numSynchs; ++n) {
            nArray2[n] = systemHide.containsAction(this.synchs.elementAt(n)) ? 0 : nArray[n];
        }
        SystemDDs systemDDs = this.translateSystemDefnRec(systemHide.getOperand(), nArray2);
        SystemDDs systemDDs2 = new SystemDDs(this.numSynchs);
        systemDDs2.ind = systemDDs.ind;
        for (n = 0; n < this.numSynchs; ++n) {
            if (systemHide.containsAction(this.synchs.elementAt(n))) {
                systemDDs2.ind = this.combineComponentDDs(systemDDs2.ind, systemDDs.synchs[n]);
                systemDDs2.synchs[n] = new ComponentDDs();
                systemDDs2.synchs[n].guards = JDD.Constant(0.0);
                systemDDs2.synchs[n].trans = JDD.Constant(0.0);
                systemDDs2.synchs[n].min = 0;
                systemDDs2.synchs[n].max = 0;
                continue;
            }
            systemDDs2.synchs[n] = systemDDs.synchs[n];
        }
        systemDDs2.id = systemDDs.id;
        systemDDs2.allSynchs.addAll(systemDDs.allSynchs);
        for (n = 0; n < systemHide.getNumActions(); ++n) {
            systemDDs2.allSynchs.remove(systemHide.getAction(n));
        }
        return systemDDs2;
    }

    private SystemDDs translateSystemRename(SystemRename systemRename, int[] nArray) throws PrismException {
        int n;
        String string;
        int n2;
        int[] nArray2 = new int[this.numSynchs];
        for (n2 = 0; n2 < this.numSynchs; ++n2) {
            string = systemRename.getNewName(this.synchs.elementAt(n2));
            n = this.synchs.indexOf(string);
            if (n == -1) {
                throw new PrismLangException("Invalid action name \"" + string + "\" in renaming", systemRename);
            }
            nArray2[n2] = nArray[n];
        }
        SystemDDs systemDDs = this.translateSystemDefnRec(systemRename.getOperand(), nArray2);
        SystemDDs systemDDs2 = new SystemDDs(this.numSynchs);
        systemDDs2.ind = systemDDs.ind;
        for (n2 = 0; n2 < this.numSynchs; ++n2) {
            systemDDs2.synchs[n2] = new ComponentDDs();
            systemDDs2.synchs[n2].guards = JDD.Constant(0.0);
            systemDDs2.synchs[n2].trans = JDD.Constant(0.0);
            systemDDs2.synchs[n2].min = 0;
            systemDDs2.synchs[n2].max = 0;
        }
        for (n2 = 0; n2 < this.numSynchs; ++n2) {
            string = systemRename.getNewName(this.synchs.elementAt(n2));
            n = this.synchs.indexOf(string);
            if (n == -1) {
                throw new PrismLangException("Invalid action name \"" + string + "\" in renaming", systemRename);
            }
            systemDDs2.synchs[n] = this.combineComponentDDs(systemDDs2.synchs[n], systemDDs.synchs[n2]);
        }
        systemDDs2.id = systemDDs.id;
        Iterator<String> iterator = systemDDs.allSynchs.iterator();
        while (iterator.hasNext()) {
            systemDDs2.allSynchs.add(systemRename.getNewName(iterator.next()));
        }
        return systemDDs2;
    }

    private ComponentDDs translateSynchronising(ComponentDDs componentDDs, ComponentDDs componentDDs2) throws PrismException {
        ComponentDDs componentDDs3 = new ComponentDDs();
        JDD.Ref(componentDDs.guards);
        JDD.Ref(componentDDs2.guards);
        componentDDs3.guards = JDD.And(componentDDs.guards, componentDDs2.guards);
        JDD.Ref(componentDDs.trans);
        JDD.Ref(componentDDs2.trans);
        componentDDs3.trans = JDD.Apply(3, componentDDs.trans, componentDDs2.trans);
        componentDDs3.min = componentDDs.min < componentDDs2.min ? componentDDs.min : componentDDs2.min;
        componentDDs3.max = componentDDs.max > componentDDs2.max ? componentDDs.max : componentDDs2.max;
        JDD.Deref(componentDDs.guards);
        JDD.Deref(componentDDs2.guards);
        JDD.Deref(componentDDs.trans);
        JDD.Deref(componentDDs2.trans);
        return componentDDs3;
    }

    private ComponentDDs translateNonSynchronising(ComponentDDs componentDDs, ComponentDDs componentDDs2, JDDNode jDDNode, JDDNode jDDNode2) throws PrismException {
        JDD.Ref(jDDNode2);
        componentDDs.trans = JDD.Apply(3, componentDDs.trans, jDDNode2);
        JDD.Ref(jDDNode);
        componentDDs2.trans = JDD.Apply(3, componentDDs2.trans, jDDNode);
        ComponentDDs componentDDs3 = this.combineComponentDDs(componentDDs, componentDDs2);
        return componentDDs3;
    }

    private ComponentDDs combineComponentDDs(ComponentDDs componentDDs, ComponentDDs componentDDs2) throws PrismException {
        ComponentDDs componentDDs3 = new ComponentDDs();
        if (this.modelType != ModelType.MDP) {
            componentDDs3.guards = JDD.Or(componentDDs.guards, componentDDs2.guards);
            componentDDs3.trans = JDD.Apply(1, componentDDs.trans, componentDDs2.trans);
            componentDDs3.min = 0;
            componentDDs3.max = 0;
        } else if (componentDDs.trans.equals(JDD.ZERO)) {
            JDD.Deref(componentDDs.guards);
            componentDDs3.guards = componentDDs2.guards;
            JDD.Deref(componentDDs.trans);
            componentDDs3.trans = componentDDs2.trans;
            componentDDs3.min = componentDDs2.min;
            componentDDs3.max = componentDDs2.max;
        } else if (componentDDs2.trans.equals(JDD.ZERO)) {
            JDD.Deref(componentDDs2.guards);
            componentDDs3.guards = componentDDs.guards;
            JDD.Deref(componentDDs2.trans);
            componentDDs3.trans = componentDDs.trans;
            componentDDs3.min = componentDDs.min;
            componentDDs3.max = componentDDs.max;
        } else {
            JDDNode jDDNode;
            if (componentDDs.max > componentDDs2.max) {
                JDDNode jDDNode2 = JDD.Constant(1.0);
                for (int i = componentDDs2.max; i < componentDDs.max; ++i) {
                    jDDNode = this.ddChoiceVars[this.ddChoiceVars.length - i - 1];
                    JDD.Ref(jDDNode);
                    jDDNode2 = JDD.And(jDDNode2, JDD.Not(jDDNode));
                }
                componentDDs2.trans = JDD.Apply(3, componentDDs2.trans, jDDNode2);
                componentDDs2.max = componentDDs.max;
            } else if (componentDDs2.max > componentDDs.max) {
                JDDNode jDDNode3 = JDD.Constant(1.0);
                for (int i = componentDDs.max; i < componentDDs2.max; ++i) {
                    jDDNode = this.ddChoiceVars[this.ddChoiceVars.length - i - 1];
                    JDD.Ref(jDDNode);
                    jDDNode3 = JDD.And(jDDNode3, JDD.Not(jDDNode));
                }
                componentDDs.trans = JDD.Apply(3, componentDDs.trans, jDDNode3);
                componentDDs.max = componentDDs2.max;
            }
            if (this.ddChoiceVars.length - componentDDs.max - 1 < 0) {
                throw new PrismException("Insufficient BDD variables allocated for nondeterminism - please report this as a bug. Thank you");
            }
            jDDNode = this.ddChoiceVars[this.ddChoiceVars.length - componentDDs.max - 1];
            componentDDs3.guards = JDD.Or(componentDDs.guards, componentDDs2.guards);
            JDD.Ref(jDDNode);
            componentDDs3.trans = JDD.ITE(jDDNode, componentDDs2.trans, componentDDs.trans);
            componentDDs3.min = componentDDs.min;
            componentDDs3.max = componentDDs.max + 1;
        }
        return componentDDs3;
    }

    private ComponentDDs translateModule(int n, Module module, String string, int n2) throws PrismException {
        ComponentDDs componentDDs;
        int n3;
        double d = 0.0;
        double d2 = 0.0;
        int n4 = module.getNumCommands();
        JDDNode[] jDDNodeArray = new JDDNode[n4];
        JDDNode[] jDDNodeArray2 = new JDDNode[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            Command command = module.getCommand(n3);
            boolean bl = false;
            if (string == "") {
                if (command.getSynch() == "") {
                    bl = true;
                }
            } else if (command.getSynch().equals(string)) {
                bl = true;
            }
            if (bl) {
                String string2;
                jDDNodeArray[n3] = this.translateExpression(command.getGuard());
                JDD.Ref(this.range);
                jDDNodeArray[n3] = JDD.Apply(3, jDDNodeArray[n3], this.range);
                if (jDDNodeArray[n3].equals(JDD.ZERO)) {
                    if (!Expression.isFalse(command.getGuard())) {
                        string2 = "Guard for command " + (n3 + 1) + " of module \"" + module.getName() + "\" is never satisfied.";
                        this.mainLog.printWarning(string2);
                    }
                    jDDNodeArray2[n3] = JDD.Constant(0.0);
                    continue;
                }
                jDDNodeArray2[n3] = this.translateUpdates(n, n3, command.getUpdates(), command.getSynch() != "", jDDNodeArray[n3]);
                JDD.Ref(jDDNodeArray[n3]);
                jDDNodeArray2[n3] = JDD.Apply(3, jDDNodeArray2[n3], jDDNodeArray[n3]);
                d = JDD.FindMin(jDDNodeArray2[n3]);
                if (d < 0.0) {
                    string2 = this.modelType == ModelType.CTMC ? "Rates" : "Probabilities";
                    string2 = string2 + " in command " + (n3 + 1) + " of module \"" + module.getName() + "\" are negative";
                    string2 = string2 + " (" + d + ") for some states.\n";
                    string2 = string2 + "Perhaps the guard needs to be strengthened";
                    throw new PrismLangException(string2, command);
                }
                if (!this.prism.getDoProbChecks()) continue;
                JDD.Ref(jDDNodeArray2[n3]);
                JDDNode jDDNode = JDD.SumAbstract(jDDNodeArray2[n3], this.moduleDDColVars[n]);
                jDDNode = JDD.SumAbstract(jDDNode, this.globalDDColVars);
                JDD.Ref(jDDNodeArray[n3]);
                jDDNode = JDD.ITE(jDDNodeArray[n3], jDDNode, JDD.Constant(1.0));
                d = JDD.FindMin(jDDNode);
                d2 = JDD.FindMax(jDDNode);
                if (d != d || d2 != d2) {
                    JDD.Deref(jDDNode);
                    string2 = this.modelType == ModelType.CTMC ? "Rates" : "Probabilities";
                    string2 = string2 + " in command " + (n3 + 1) + " of module \"" + module.getName() + "\" have errors (NaN) for some states. ";
                    string2 = string2 + "Check for zeros in divide or modulo operations. ";
                    string2 = string2 + "Perhaps the guard needs to be strengthened";
                    throw new PrismLangException(string2, command);
                }
                if (this.modelType != ModelType.CTMC && d < 1.0 - this.prism.getSumRoundOff()) {
                    JDD.Deref(jDDNode);
                    string2 = "Probabilities in command " + (n3 + 1) + " of module \"" + module.getName() + "\" sum to less than one";
                    string2 = string2 + " (e.g. " + d + ") for some states. ";
                    string2 = string2 + "Perhaps some of the updates give out-of-range values. ";
                    string2 = string2 + "One possible solution is to strengthen the guard";
                    throw new PrismLangException(string2, command);
                }
                if (this.modelType == ModelType.CTMC && d <= 0.0) {
                    JDD.Deref(jDDNode);
                    string2 = "Rates in command " + (n3 + 1) + " of module \"" + module.getName() + "\" sum to zero for some states. ";
                    string2 = string2 + "Perhaps some of the updates give out-of-range values. ";
                    string2 = string2 + "One possible solution is to strengthen the guard";
                    throw new PrismLangException(string2, command);
                }
                if (this.modelType != ModelType.CTMC && d2 > 1.0 + this.prism.getSumRoundOff()) {
                    JDD.Deref(jDDNode);
                    string2 = "Probabilities in command " + (n3 + 1) + " of module \"" + module.getName() + "\" sum to more than one";
                    string2 = string2 + " (e.g. " + d2 + ") for some states. ";
                    string2 = string2 + "Perhaps the guard needs to be strengthened";
                    throw new PrismLangException(string2, command);
                }
                if (this.modelType == ModelType.CTMC && d2 == Double.POSITIVE_INFINITY) {
                    JDD.Deref(jDDNode);
                    string2 = "Rates in command " + (n3 + 1) + " of module \"" + module.getName() + "\" sum to infinity for some states. ";
                    string2 = string2 + "Perhaps the guard needs to be strengthened";
                    throw new PrismLangException(string2, command);
                }
                JDD.Deref(jDDNode);
                continue;
            }
            jDDNodeArray[n3] = JDD.Constant(0.0);
            jDDNodeArray2[n3] = JDD.Constant(0.0);
        }
        if (this.modelType == ModelType.DTMC) {
            componentDDs = this.combineCommandsProb(n, n4, jDDNodeArray, jDDNodeArray2);
        } else if (this.modelType == ModelType.MDP) {
            componentDDs = this.combineCommandsNondet(n, n4, jDDNodeArray, jDDNodeArray2, n2);
        } else if (this.modelType == ModelType.CTMC) {
            componentDDs = this.combineCommandsStoch(n, n4, jDDNodeArray, jDDNodeArray2);
        } else {
            throw new PrismException("Unknown model type");
        }
        for (n3 = 0; n3 < n4; ++n3) {
            JDD.Deref(jDDNodeArray[n3]);
            JDD.Deref(jDDNodeArray2[n3]);
        }
        return componentDDs;
    }

    private ComponentDDs combineCommandsProb(int n, int n2, JDDNode[] jDDNodeArray, JDDNode[] jDDNodeArray2) {
        ComponentDDs componentDDs = new ComponentDDs();
        JDDNode jDDNode = JDD.Constant(0.0);
        JDDNode jDDNode2 = JDD.Constant(0.0);
        for (int i = 0; i < n2; ++i) {
            if (jDDNodeArray[i].equals(JDD.ZERO)) continue;
            JDD.Ref(jDDNodeArray[i]);
            JDD.Ref(jDDNode2);
            JDDNode jDDNode3 = JDD.And(jDDNodeArray[i], jDDNode2);
            if (!jDDNode3.equals(JDD.ZERO)) {
                this.mainLog.printWarning("Guard for command " + (i + 1) + " of module \"" + this.moduleNames[n] + "\" overlaps with previous commands.");
            }
            JDD.Deref(jDDNode3);
            JDD.Ref(jDDNodeArray[i]);
            jDDNode2 = JDD.Or(jDDNode2, jDDNodeArray[i]);
            JDD.Ref(jDDNodeArray[i]);
            JDD.Ref(jDDNodeArray2[i]);
            jDDNode = JDD.Apply(1, jDDNode, JDD.Apply(3, jDDNodeArray[i], jDDNodeArray2[i]));
        }
        componentDDs.guards = jDDNode2;
        componentDDs.trans = jDDNode;
        componentDDs.min = 0;
        componentDDs.max = 0;
        return componentDDs;
    }

    private ComponentDDs combineCommandsStoch(int n, int n2, JDDNode[] jDDNodeArray, JDDNode[] jDDNodeArray2) {
        ComponentDDs componentDDs = new ComponentDDs();
        JDDNode jDDNode = JDD.Constant(0.0);
        JDDNode jDDNode2 = JDD.Constant(0.0);
        for (int i = 0; i < n2; ++i) {
            if (jDDNodeArray[i].equals(JDD.ZERO)) continue;
            JDD.Ref(jDDNodeArray[i]);
            jDDNode2 = JDD.Or(jDDNode2, jDDNodeArray[i]);
            JDD.Ref(jDDNodeArray[i]);
            JDD.Ref(jDDNodeArray2[i]);
            jDDNode = JDD.Apply(1, jDDNode, JDD.Apply(3, jDDNodeArray[i], jDDNodeArray2[i]));
        }
        componentDDs.guards = jDDNode2;
        componentDDs.trans = jDDNode;
        componentDDs.min = 0;
        componentDDs.max = 0;
        return componentDDs;
    }

    private ComponentDDs combineCommandsNondet(int n, int n2, JDDNode[] jDDNodeArray, JDDNode[] jDDNodeArray2, int n3) throws PrismException {
        int n4;
        ComponentDDs componentDDs = new ComponentDDs();
        JDDNode jDDNode = JDD.Constant(0.0);
        JDDNode jDDNode2 = JDD.Constant(0.0);
        JDDNode jDDNode3 = JDD.Constant(0.0);
        for (n4 = 0; n4 < n2; ++n4) {
            JDD.Ref(jDDNodeArray[n4]);
            jDDNode3 = JDD.Apply(1, jDDNode3, jDDNodeArray[n4]);
            JDD.Ref(jDDNodeArray[n4]);
            jDDNode2 = JDD.Or(jDDNode2, jDDNodeArray[n4]);
        }
        int n5 = (int)Math.round(JDD.FindMax(jDDNode3));
        if (n5 == 0) {
            componentDDs.guards = jDDNode2;
            componentDDs.trans = jDDNode;
            componentDDs.min = n3;
            componentDDs.max = n3;
            JDD.Deref(jDDNode3);
            return componentDDs;
        }
        if (n5 == 1) {
            for (n4 = 0; n4 < n2; ++n4) {
                JDD.Ref(jDDNodeArray[n4]);
                JDD.Ref(jDDNodeArray2[n4]);
                jDDNode = JDD.Apply(1, jDDNode, JDD.Apply(3, jDDNodeArray[n4], jDDNodeArray2[n4]));
            }
            componentDDs.guards = jDDNode2;
            componentDDs.trans = jDDNode;
            componentDDs.min = n3;
            componentDDs.max = n3;
            JDD.Deref(jDDNode3);
            return componentDDs;
        }
        int n6 = (int)Math.ceil(PrismUtils.log2(n5));
        JDDVars jDDVars = new JDDVars();
        for (n4 = 0; n4 < n6; ++n4) {
            if (this.ddChoiceVars.length - n3 - n6 + n4 < 0) {
                throw new PrismException("Insufficient BDD variables allocated for nondeterminism - please report this as a bug. Thank you.");
            }
            jDDVars.addVar(this.ddChoiceVars[this.ddChoiceVars.length - n3 - n6 + n4]);
        }
        for (n4 = 1; n4 <= n5; ++n4) {
            JDDNode jDDNode4;
            int n7;
            JDD.Ref(jDDNode3);
            JDDNode jDDNode5 = JDD.Equals(jDDNode3, n4);
            if (jDDNode5.equals(JDD.ZERO)) {
                JDD.Deref(jDDNode5);
                continue;
            }
            JDDNode[] jDDNodeArray3 = new JDDNode[n4];
            JDDNode[] jDDNodeArray4 = new JDDNode[n4];
            for (n7 = 0; n7 < n4; ++n7) {
                jDDNodeArray3[n7] = JDD.Constant(0.0);
                jDDNodeArray4[n7] = jDDNode5;
                JDD.Ref(jDDNode5);
            }
            for (n7 = 0; n7 < n2; ++n7) {
                JDD.Ref(jDDNodeArray[n7]);
                JDD.Ref(jDDNode5);
                jDDNode4 = JDD.And(jDDNodeArray[n7], jDDNode5);
                if (!jDDNode4.equals(JDD.ZERO)) {
                    JDD.Ref(jDDNode4);
                    JDDNode jDDNode6 = jDDNode4;
                    for (int i = 0; i < n4; ++i) {
                        JDD.Ref(jDDNode6);
                        JDD.Ref(jDDNodeArray4[i]);
                        JDDNode jDDNode7 = JDD.And(jDDNode6, jDDNodeArray4[i]);
                        if (!jDDNode7.equals(JDD.ZERO)) {
                            JDD.Ref(jDDNode7);
                            jDDNodeArray4[i] = JDD.And(jDDNodeArray4[i], JDD.Not(jDDNode7));
                            JDD.Ref(jDDNode7);
                            JDD.Ref(jDDNodeArray2[n7]);
                            jDDNodeArray3[i] = JDD.Apply(1, jDDNodeArray3[i], JDD.Apply(3, jDDNode7, jDDNodeArray2[n7]));
                        }
                        if ((jDDNode6 = JDD.And(jDDNode6, JDD.Not(jDDNode7))).equals(JDD.ZERO)) break;
                    }
                    JDD.Deref(jDDNode6);
                }
                JDD.Deref(jDDNode4);
            }
            for (n7 = 0; n7 < n4; ++n7) {
                jDDNode4 = JDD.SetVectorElement(JDD.Constant(0.0), jDDVars, n7, 1.0);
                jDDNode = JDD.Apply(1, jDDNode, JDD.Apply(3, jDDNode4, jDDNodeArray3[n7]));
                JDD.Deref(jDDNodeArray4[n7]);
            }
            jDDNode3 = JDD.Apply(3, jDDNode3, JDD.Not(jDDNode5));
        }
        JDD.Deref(jDDNode3);
        componentDDs.guards = jDDNode2;
        componentDDs.trans = jDDNode;
        componentDDs.min = n3;
        componentDDs.max = n3 + n6;
        return componentDDs;
    }

    private JDDNode translateUpdates(int n, int n2, Updates updates, boolean bl, JDDNode jDDNode) throws PrismException {
        JDDNode jDDNode2 = JDD.Constant(0.0);
        int n3 = updates.getNumUpdates();
        for (int i = 0; i < n3; ++i) {
            Expression expression;
            String string;
            JDDNode jDDNode3 = this.translateUpdate(n, updates.getUpdate(i), bl, jDDNode);
            boolean bl2 = false;
            if (jDDNode3.equals(JDD.ZERO)) {
                bl2 = true;
                string = "Update " + (i + 1) + " of command " + (n2 + 1);
                string = string + " of module \"" + this.moduleNames[n] + "\" doesn't do anything";
                this.mainLog.printWarning(new PrismLangException(string, updates.getUpdate(i)).getMessage());
            }
            if ((expression = updates.getProbability(i)) == null) {
                expression = Expression.Double(1.0);
            }
            JDDNode jDDNode4 = this.translateExpression(expression);
            jDDNode3 = JDD.Apply(3, jDDNode3, jDDNode4);
            if (!bl2 && jDDNode3.equals(JDD.ZERO)) {
                string = "Update " + (i + 1) + " of command " + (n2 + 1);
                string = string + " of module \"" + this.moduleNames[n] + "\" doesn't do anything";
                this.mainLog.printWarning(new PrismLangException(string, updates.getUpdate(i)).getMessage());
            }
            jDDNode2 = JDD.Apply(1, jDDNode2, jDDNode3);
        }
        return jDDNode2;
    }

    private JDDNode translateUpdate(int n, Update update, boolean bl, JDDNode jDDNode) throws PrismException {
        int n2;
        for (n2 = 0; n2 < this.numVars; ++n2) {
            this.varsUsed[n2] = false;
        }
        JDDNode jDDNode2 = JDD.Constant(1.0);
        int n3 = update.getNumElements();
        for (n2 = 0; n2 < n3; ++n2) {
            String string = update.getVar(n2);
            int n4 = this.varList.getIndex(string);
            if (n4 == -1) {
                throw new PrismLangException("Unknown variable \"" + string + "\" in update", update.getVarIdent(n2));
            }
            this.varsUsed[n4] = true;
            if (this.varList.getModule(n4) != -1 && this.varList.getModule(n4) != n) {
                throw new PrismLangException("Cannot modify variable \"" + string + "\" from module \"" + this.moduleNames[n] + "\"", update.getVarIdent(n2));
            }
            if (this.varList.getModule(n4) == -1 && bl) {
                throw new PrismLangException("Synchronous command cannot modify global variable", update.getVarIdent(n2));
            }
            int n5 = this.varList.getLow(n4);
            int n6 = this.varList.getHigh(n4);
            JDDNode jDDNode3 = JDD.Constant(0.0);
            for (int i = n5; i <= n6; ++i) {
                jDDNode3 = JDD.SetVectorElement(jDDNode3, this.varDDColVars[n4], i - n5, i);
            }
            JDDNode jDDNode4 = this.translateExpression(update.getExpression(n2));
            JDD.Ref(jDDNode);
            jDDNode4 = JDD.Apply(3, jDDNode4, jDDNode);
            JDDNode jDDNode5 = JDD.Apply(7, jDDNode3, jDDNode4);
            JDD.Ref(jDDNode);
            jDDNode5 = JDD.Apply(3, jDDNode5, jDDNode);
            JDD.Ref(this.varColRangeDDs[n4]);
            jDDNode5 = JDD.Apply(3, jDDNode5, this.varColRangeDDs[n4]);
            JDD.Ref(this.range);
            jDDNode5 = JDD.Apply(3, jDDNode5, this.range);
            jDDNode2 = JDD.Apply(3, jDDNode2, jDDNode5);
        }
        for (n2 = 0; n2 < this.numVars; ++n2) {
            if (this.varList.getModule(n2) != n && this.varList.getModule(n2) != -1 || this.varsUsed[n2]) continue;
            JDD.Ref(this.varIdentities[n2]);
            jDDNode2 = JDD.Apply(3, jDDNode2, this.varIdentities[n2]);
        }
        return jDDNode2;
    }

    private JDDNode translateExpression(Expression expression) throws PrismException {
        return this.expr2mtbdd.checkExpressionDD(expression);
    }

    private void computeRewards(SystemDDs systemDDs) throws PrismException {
        int n;
        int n2;
        this.numRewardStructs = this.modulesFile.getNumRewardStructs();
        this.stateRewards = new JDDNode[this.numRewardStructs];
        this.transRewards = new JDDNode[this.numRewardStructs];
        for (n2 = 0; n2 < this.numRewardStructs; ++n2) {
            this.stateRewards[n2] = JDD.Constant(0.0);
            systemDDs.ind.rewards[n2] = JDD.Constant(0.0);
            for (n = 0; n < this.numSynchs; ++n) {
                systemDDs.synchs[n].rewards[n2] = JDD.Constant(0.0);
            }
        }
        for (n2 = 0; n2 < this.numRewardStructs; ++n2) {
            RewardStruct rewardStruct = this.modulesFile.getRewardStruct(n2);
            int n3 = rewardStruct.getNumItems();
            for (n = 0; n < n3; ++n) {
                double d;
                ComponentDDs componentDDs;
                double d2;
                JDDNode jDDNode;
                JDDNode jDDNode2 = this.translateExpression(rewardStruct.getStates(n));
                JDDNode jDDNode3 = this.translateExpression(rewardStruct.getReward(n));
                String string = rewardStruct.getSynch(n);
                if (string == null) {
                    double d3;
                    jDDNode = JDD.Apply(3, jDDNode2, jDDNode3);
                    d2 = JDD.FindMin(jDDNode);
                    if (d3 < 0.0) {
                        String string2 = "Reward structure item contains negative rewards (" + d2 + ").";
                        string2 = string2 + "\nNote that these may correspond to states which are unreachable.";
                        string2 = string2 + "\nIf this is the case, try strengthening the predicate.";
                        throw new PrismLangException(string2, rewardStruct.getRewardStructItem(n));
                    }
                    this.stateRewards[n2] = JDD.Apply(1, this.stateRewards[n2], jDDNode);
                    continue;
                }
                if ("".equals(string)) {
                    componentDDs = systemDDs.ind;
                } else {
                    int n4 = this.synchs.indexOf(string);
                    if (n4 != -1) {
                        componentDDs = systemDDs.synchs[n4];
                    } else {
                        throw new PrismLangException("Invalid action name \"" + string + "\" in reward structure item", rewardStruct.getRewardStructItem(n));
                    }
                }
                JDD.Ref(componentDDs.trans);
                jDDNode = this.modelType == ModelType.MDP ? JDD.GreaterThan(componentDDs.trans, 0.0) : componentDDs.trans;
                jDDNode = JDD.Apply(3, jDDNode, jDDNode2);
                jDDNode = JDD.Apply(3, jDDNode, jDDNode3);
                d2 = JDD.FindMin(jDDNode);
                if (d < 0.0) {
                    String string3 = "Reward structure item contains negative rewards (" + d2 + ").";
                    string3 = string3 + "\nNote that these may correspond to states which are unreachable.";
                    string3 = string3 + "\nIf this is the case, try strengthening the predicate.";
                    throw new PrismLangException(string3, rewardStruct.getRewardStructItem(n));
                }
                componentDDs.rewards[n2] = JDD.Apply(1, componentDDs.rewards[n2], jDDNode);
            }
        }
    }

    private void buildInitialStates() throws PrismException {
        if (this.modulesFile.getInitialStates() != null) {
            this.start = this.translateExpression(this.modulesFile.getInitialStates());
            JDD.Ref(this.range);
            this.start = JDD.And(this.start, this.range);
            if (this.start.equals(JDD.ZERO)) {
                throw new PrismLangException("No initial states: \"init\" construct evaluates to false", this.modulesFile.getInitialStates());
            }
        } else {
            this.start = JDD.Constant(1.0);
            for (int i = 0; i < this.numVars; ++i) {
                JDDNode jDDNode = JDD.SetVectorElement(JDD.Constant(0.0), this.varDDRowVars[i], this.varList.getStart(i) - this.varList.getLow(i), 1.0);
                this.start = JDD.And(this.start, jDDNode);
            }
        }
    }

    private void doSymmetry(Model model) throws PrismException {
        int n;
        int n2;
        String[] stringArray = this.prism.getSettings().getString("prism.symmRedParams").split(" ");
        if (stringArray.length != 2) {
            throw new PrismException("Invalid parameters for symmetry reduction");
        }
        try {
            this.numModulesBeforeSymm = Integer.parseInt(stringArray[0].trim());
            this.numModulesAfterSymm = Integer.parseInt(stringArray[1].trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new PrismException("Invalid parameters for symmetry reduction");
        }
        long l = System.currentTimeMillis();
        JDDNode jDDNode = model.getReach();
        JDD.Ref(jDDNode);
        JDDNode jDDNode2 = model.getTrans();
        JDD.Ref(jDDNode2);
        JDDNode[] jDDNodeArray = new JDDNode[this.numRewardStructs];
        for (n2 = 0; n2 < this.numRewardStructs; ++n2) {
            jDDNodeArray[n2] = model.getTransRewards(n2);
            JDD.Ref(jDDNodeArray[n2]);
        }
        this.mainLog.print("\nApplying symmetry reduction...\n");
        this.numSymmModules = this.numModules - (this.numModulesBeforeSymm + this.numModulesAfterSymm);
        this.computeSymmetryFilters(jDDNode);
        this.mainLog.println("\nNumber of states before before symmetry reduction: " + model.getNumStatesString());
        this.mainLog.println("DD sizes before symmetry reduction:");
        this.mainLog.print("trans: ");
        this.mainLog.println(JDD.GetInfoString(jDDNode2, this.modelType == ModelType.MDP ? this.allDDRowVars.n() * 2 + this.allDDNondetVars.n() : this.allDDRowVars.n() * 2));
        JDD.Ref(this.symm);
        jDDNode2 = JDD.Apply(3, jDDNode2, this.symm);
        for (n = 0; n < this.numRewardStructs; ++n) {
            this.mainLog.print("transrew[" + n + "]: ");
            this.mainLog.println(JDD.GetInfoString(jDDNodeArray[n], this.modelType == ModelType.MDP ? this.allDDRowVars.n() * 2 + this.allDDNondetVars.n() : this.allDDRowVars.n() * 2));
            JDD.Ref(this.symm);
            jDDNodeArray[n] = JDD.Apply(3, jDDNodeArray[n], this.symm);
        }
        this.mainLog.println("Starting quicksort...");
        boolean bl = false;
        int n3 = 0;
        for (n2 = this.numSymmModules; n2 > 1 && !bl; --n2) {
            JDD.Ref(jDDNode2);
            JDDNode jDDNode3 = jDDNode2;
            for (int i = 0; i < n2 - 1; ++i) {
                if (this.nonSymms[i].equals(JDD.ZERO)) continue;
                JDD.Ref(jDDNode3);
                JDD.Ref(this.nonSymms[i]);
                JDDNode jDDNode4 = JDD.Apply(3, jDDNode3, JDD.PermuteVariables(this.nonSymms[i], this.allDDRowVars, this.allDDColVars));
                if (jDDNode4.equals(JDD.ZERO)) {
                    JDD.Deref(jDDNode4);
                    continue;
                }
                ++n3;
                this.mainLog.println("Iteration " + (this.numSymmModules - n2 + 1) + "." + (i + 1));
                jDDNode4 = JDD.SwapVariables(jDDNode4, this.moduleDDColVars[this.numModulesBeforeSymm + i], this.moduleDDColVars[this.numModulesBeforeSymm + i + 1]);
                JDD.Ref(this.nonSymms[i]);
                JDD.Ref(jDDNode4);
                jDDNode3 = JDD.ITE(JDD.PermuteVariables(this.nonSymms[i], this.allDDRowVars, this.allDDColVars), JDD.Constant(0.0), JDD.Apply(1, jDDNode3, jDDNode4));
                JDD.Deref(jDDNode4);
                for (n = 0; n < this.numRewardStructs; ++n) {
                    JDD.Ref(jDDNodeArray[n]);
                    JDD.Ref(this.nonSymms[i]);
                    jDDNode4 = JDD.Apply(3, jDDNodeArray[n], JDD.PermuteVariables(this.nonSymms[i], this.allDDRowVars, this.allDDColVars));
                    jDDNode4 = JDD.SwapVariables(jDDNode4, this.moduleDDColVars[this.numModulesBeforeSymm + i], this.moduleDDColVars[this.numModulesBeforeSymm + i + 1]);
                    JDD.Ref(this.nonSymms[i]);
                    JDD.Ref(jDDNode4);
                    jDDNodeArray[n] = JDD.ITE(JDD.PermuteVariables(this.nonSymms[i], this.allDDRowVars, this.allDDColVars), JDD.Constant(0.0), JDD.Apply(1, jDDNodeArray[n], jDDNode4));
                    JDD.Deref(jDDNode4);
                }
            }
            if (jDDNode3.equals(jDDNode2)) {
                bl = true;
            }
            JDD.Deref(jDDNode2);
            jDDNode2 = jDDNode3;
        }
        model.resetTrans(jDDNode2);
        for (n2 = 0; n2 < this.numRewardStructs; ++n2) {
            model.resetTransRewards(n2, jDDNodeArray[n2]);
        }
        JDD.Ref(this.symm);
        jDDNode = JDD.And(jDDNode, this.symm);
        model.setReach(jDDNode);
        model.filterReachableStates();
        l = System.currentTimeMillis() - l;
        this.mainLog.println("Symmetry complete: " + (this.numSymmModules - n2) + " iterations, " + n3 + " swaps, " + (double)l / 1000.0 + " seconds");
    }

    private void computeSymmetryFilters(JDDNode jDDNode) throws PrismException {
        this.nonSymms = new JDDNode[this.numSymmModules - 1];
        JDD.Ref(jDDNode);
        this.symm = jDDNode;
        for (int i = 0; i < this.numSymmModules - 1; ++i) {
            JDDNode jDDNode2 = JDD.VariablesLessThanEquals(this.moduleDDRowVars[this.numModulesBeforeSymm + i], this.moduleDDRowVars[this.numModulesBeforeSymm + i + 1]);
            JDD.Ref(jDDNode2);
            JDD.Ref(jDDNode);
            this.nonSymms[i] = JDD.And(JDD.Not(jDDNode2), jDDNode);
            this.symm = JDD.And(this.symm, jDDNode2);
        }
    }

    private class SystemDDs {
        public ComponentDDs ind;
        public ComponentDDs[] synchs;
        public JDDNode id;
        public HashSet<String> allSynchs;

        public SystemDDs(int n) {
            this.synchs = new ComponentDDs[n];
            this.allSynchs = new HashSet();
        }
    }

    private class ComponentDDs {
        public JDDNode guards;
        public JDDNode trans;
        public JDDNode[] rewards;
        public int min;
        public int max;

        public ComponentDDs() {
            this.rewards = new JDDNode[Modules2MTBDD.this.modulesFile.getNumRewardStructs()];
        }
    }
}

