/*
 * Decompiled with CFR 0.152.
 */
package prism;

public enum ModelType {
    CTMC,
    CTMDP,
    DTMC,
    LTS,
    MDP,
    PTA,
    STPG,
    SMG;


    public String fullName() {
        switch (this) {
            case CTMC: {
                return "continuous-time Markov chain";
            }
            case CTMDP: {
                return "continuous-time Markov decision process";
            }
            case DTMC: {
                return "discrete-time Markov chain";
            }
            case LTS: {
                return "labelled transition system";
            }
            case MDP: {
                return "Markov decision process";
            }
            case PTA: {
                return "probabilistic timed automaton";
            }
            case STPG: {
                return "stochastic two-player game";
            }
            case SMG: {
                return "stochastic multi-player game";
            }
        }
        return "";
    }

    public String keyword() {
        switch (this) {
            case CTMC: {
                return "ctmc";
            }
            case CTMDP: {
                return "ctmdp";
            }
            case DTMC: {
                return "dtmc";
            }
            case LTS: {
                return "lts";
            }
            case MDP: {
                return "mdp";
            }
            case PTA: {
                return "pta";
            }
            case STPG: {
                return "stpg";
            }
            case SMG: {
                return "smg";
            }
        }
        return "";
    }

    public boolean choicesSumToOne() {
        switch (this) {
            case DTMC: 
            case LTS: 
            case MDP: 
            case PTA: 
            case STPG: 
            case SMG: {
                return true;
            }
            case CTMC: 
            case CTMDP: {
                return false;
            }
        }
        return true;
    }

    public boolean continuousTime() {
        switch (this) {
            case DTMC: 
            case LTS: 
            case MDP: 
            case STPG: 
            case SMG: {
                return false;
            }
            case CTMC: 
            case CTMDP: 
            case PTA: {
                return true;
            }
        }
        return true;
    }

    public boolean nondeterministic() {
        switch (this) {
            case CTMC: 
            case DTMC: {
                return false;
            }
            case CTMDP: 
            case LTS: 
            case MDP: 
            case PTA: 
            case STPG: 
            case SMG: {
                return true;
            }
        }
        return true;
    }

    public boolean multiplePlayers() {
        switch (this) {
            case CTMC: 
            case CTMDP: 
            case DTMC: 
            case LTS: 
            case MDP: 
            case PTA: {
                return false;
            }
            case STPG: 
            case SMG: {
                return true;
            }
        }
        return true;
    }

    public boolean isProbabilistic() {
        switch (this) {
            case LTS: {
                return false;
            }
        }
        return true;
    }

    public String probabilityOrRate() {
        switch (this) {
            case CTMC: 
            case CTMDP: {
                return "Rate";
            }
            case LTS: {
                return "";
            }
        }
        return "Probability";
    }

    public static ModelType parseName(String string) {
        if ("ctmc".equals(string)) {
            return CTMC;
        }
        if ("ctmdp".equals(string)) {
            return CTMDP;
        }
        if ("dtmc".equals(string)) {
            return DTMC;
        }
        if ("mdp".equals(string)) {
            return MDP;
        }
        if ("lts".equals(string)) {
            return LTS;
        }
        if ("pta".equals(string)) {
            return PTA;
        }
        if ("stpg".equals(string)) {
            return STPG;
        }
        if ("smg".equals(string)) {
            return SMG;
        }
        return null;
    }
}

