/*
 * Decompiled with CFR 0.152.
 */
package prism;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import prism.PrismException;

public class MathML2Prism {
    public static String convert(Node node) throws PrismException {
        return MathML2Prism.convert(node, null, null);
    }

    public static String convert(Node node, ArrayList<String> arrayList, ArrayList<String> arrayList2) throws PrismException {
        short s = node.getNodeType();
        switch (s) {
            case 1: {
                String string = node.getNodeName();
                if (string.equals("math")) {
                    NodeList nodeList = node.getChildNodes();
                    int n = nodeList.getLength();
                    ArrayList<Node> arrayList3 = new ArrayList<Node>();
                    for (int i = 0; i < n; ++i) {
                        if (nodeList.item(i).getNodeType() == 3) continue;
                        arrayList3.add(nodeList.item(i));
                    }
                    if (arrayList3.size() == 0) {
                        throw new PrismException("Empty MathML expression");
                    }
                    if (arrayList3.size() > 1) {
                        throw new PrismException("Too many top-level nodes in MathML expression");
                    }
                    return MathML2Prism.convert((Node)arrayList3.get(0), arrayList, arrayList2);
                }
                if (string.equals("cn")) {
                    String string2 = node.getFirstChild().getNodeValue().trim();
                    return string2;
                }
                if (string.equals("ci")) {
                    String string3 = node.getFirstChild().getNodeValue().trim();
                    if (arrayList != null && arrayList.contains(string3)) {
                        string3 = arrayList2.get(arrayList.indexOf(string3));
                    }
                    return string3;
                }
                if (string.equals("apply")) {
                    int n;
                    NodeList nodeList = node.getChildNodes();
                    int n2 = nodeList.getLength();
                    ArrayList<Node> arrayList4 = new ArrayList<Node>();
                    for (n = 0; n < n2; ++n) {
                        if (nodeList.item(n).getNodeType() == 3) continue;
                        arrayList4.add(nodeList.item(n));
                    }
                    n2 = arrayList4.size();
                    if (n2 == 0) {
                        throw new PrismException("Empty apply node in MathML expression");
                    }
                    String string4 = ((Node)arrayList4.get(0)).getNodeName();
                    ArrayList<String> arrayList5 = new ArrayList<String>();
                    n2 = arrayList4.size() - 1;
                    for (n = 0; n < n2; ++n) {
                        arrayList5.add(MathML2Prism.convert((Node)arrayList4.get(n + 1), arrayList, arrayList2));
                    }
                    if (string4.equals("plus")) {
                        String string5 = "(";
                        for (n = 0; n < n2; ++n) {
                            if (n > 0) {
                                string5 = string5 + "+";
                            }
                            string5 = string5 + (String)arrayList5.get(n);
                        }
                        string5 = string5 + ")";
                        return string5;
                    }
                    if (string4.equals("minus")) {
                        if (n2 != 2) {
                            throw new PrismException("MathML apply minus operations has " + n2 + " operands");
                        }
                        String string6 = "(" + (String)arrayList5.get(0) + "-" + (String)arrayList5.get(1) + ")";
                        return string6;
                    }
                    if (string4.equals("times")) {
                        String string7 = "(";
                        for (n = 0; n < n2; ++n) {
                            if (n > 0) {
                                string7 = string7 + "*";
                            }
                            string7 = string7 + (String)arrayList5.get(n);
                        }
                        string7 = string7 + ")";
                        return string7;
                    }
                    if (string4.equals("divide")) {
                        if (n2 != 2) {
                            throw new PrismException("MathML apply divide operations has " + n2 + " operands");
                        }
                        String string8 = "(" + (String)arrayList5.get(0) + "/" + (String)arrayList5.get(1) + ")";
                        return string8;
                    }
                    if (string4.equals("power")) {
                        if (n2 != 2) {
                            throw new PrismException("MathML apply power operations has " + n2 + " operands");
                        }
                        String string9 = "(func(pow," + (String)arrayList5.get(0) + "," + (String)arrayList5.get(1) + "))";
                        return string9;
                    }
                    throw new PrismException("Unknown MathML apply operator \"" + string4 + "\"");
                }
                throw new PrismException("Unknown MathML element \"" + string + "\"");
            }
            case 4: 
            case 5: {
                return "";
            }
            case 3: {
                return "";
            }
            case 7: {
                return "";
            }
        }
        return "";
    }

    public static String parseAndConvert(InputStream inputStream) throws PrismException {
        DocumentBuilder documentBuilder;
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(new ErrorHandler(){

                @Override
                public void fatalError(SAXParseException sAXParseException) throws SAXException {
                    throw sAXParseException;
                }

                @Override
                public void error(SAXParseException sAXParseException) throws SAXException {
                    throw sAXParseException;
                }

                @Override
                public void warning(SAXParseException sAXParseException) {
                }
            });
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new PrismException("Couldn't create XML parser");
        }
        try {
            document = documentBuilder.parse(inputStream);
            return MathML2Prism.convert(document.getDocumentElement());
        }
        catch (IOException iOException) {
            throw new PrismException("I/O error: " + iOException.getMessage());
        }
        catch (SAXException sAXException) {
            throw new PrismException("Invalid XML file:\n" + sAXException.getMessage());
        }
    }

    public static void main(String[] stringArray) {
        try {
            String string = MathML2Prism.parseAndConvert(System.in);
            System.out.println(string);
        }
        catch (PrismException prismException) {
            System.err.println("Error: " + prismException.getMessage());
        }
    }
}

