/*
 * Decompiled with CFR 0.152.
 */
package prism;

import acceptance.AcceptanceGenRabinDD;
import acceptance.AcceptanceOmega;
import acceptance.AcceptanceOmegaDD;
import acceptance.AcceptanceRabin;
import acceptance.AcceptanceRabinDD;
import automata.DA;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;
import parser.VarList;
import parser.ast.Declaration;
import parser.ast.DeclarationInt;
import parser.ast.Expression;
import parser.ast.ExpressionBinaryOp;
import parser.ast.ExpressionLabel;
import parser.ast.ExpressionTemporal;
import parser.ast.ExpressionUnaryOp;
import parser.type.TypeBool;
import parser.type.TypePathBool;
import prism.ECComputer;
import prism.Model;
import prism.ModelChecker;
import prism.ModelType;
import prism.NondetModel;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismLangException;
import prism.PrismNotSupportedException;
import prism.PrismUtils;
import prism.ProbModel;
import prism.SCCComputer;
import prism.queueElement;

public class LTLModelChecker
extends PrismComponent {
    public LTLModelChecker(PrismComponent prismComponent) throws PrismException {
        super(prismComponent);
    }

    public static boolean isSupportedLTLFormula(ModelType modelType, Expression expression) throws PrismLangException {
        if (!expression.isPathFormula(true)) {
            return false;
        }
        if (Expression.containsTemporalTimeBounds(expression)) {
            if (modelType.continuousTime()) {
                return false;
            }
            if (!expression.isSimplePathFormula()) {
                return false;
            }
        }
        return true;
    }

    public Expression checkMaximalStateFormulas(ModelChecker modelChecker, Model model, Expression expression, Vector<JDDNode> vector) throws PrismException {
        if (expression.getType() instanceof TypeBool) {
            JDDNode jDDNode = modelChecker.checkExpressionDD(expression);
            if (jDDNode.equals(JDD.ZERO)) {
                JDD.Deref(jDDNode);
                return Expression.False();
            }
            if (jDDNode.equals(model.getReach())) {
                JDD.Deref(jDDNode);
                return Expression.True();
            }
            int n = vector.indexOf(jDDNode);
            if (n != -1) {
                JDD.Deref(jDDNode);
                return new ExpressionLabel("L" + n);
            }
            JDD.Ref(jDDNode);
            JDD.Ref(model.getReach());
            JDDNode jDDNode2 = JDD.And(JDD.Not(jDDNode), model.getReach());
            n = vector.indexOf(jDDNode2);
            JDD.Deref(jDDNode2);
            if (n != -1) {
                JDD.Deref(jDDNode);
                return Expression.Not(new ExpressionLabel("L" + n));
            }
            vector.add(jDDNode);
            return new ExpressionLabel("L" + (vector.size() - 1));
        }
        if (expression.getType() instanceof TypePathBool) {
            if (expression instanceof ExpressionBinaryOp) {
                ExpressionBinaryOp expressionBinaryOp = (ExpressionBinaryOp)expression;
                expressionBinaryOp.setOperand1(this.checkMaximalStateFormulas(modelChecker, model, expressionBinaryOp.getOperand1(), vector));
                expressionBinaryOp.setOperand2(this.checkMaximalStateFormulas(modelChecker, model, expressionBinaryOp.getOperand2(), vector));
            } else if (expression instanceof ExpressionUnaryOp) {
                ExpressionUnaryOp expressionUnaryOp = (ExpressionUnaryOp)expression;
                expressionUnaryOp.setOperand(this.checkMaximalStateFormulas(modelChecker, model, expressionUnaryOp.getOperand(), vector));
            } else if (expression instanceof ExpressionTemporal) {
                ExpressionTemporal expressionTemporal = (ExpressionTemporal)expression;
                if (expressionTemporal.getOperand1() != null) {
                    expressionTemporal.setOperand1(this.checkMaximalStateFormulas(modelChecker, model, expressionTemporal.getOperand1(), vector));
                }
                if (expressionTemporal.getOperand2() != null) {
                    expressionTemporal.setOperand2(this.checkMaximalStateFormulas(modelChecker, model, expressionTemporal.getOperand2(), vector));
                }
            }
        }
        return expression;
    }

    public ProbModel constructProductMC(DA<BitSet, ? extends AcceptanceOmega> dA, ProbModel probModel, Vector<JDDNode> vector) throws PrismException {
        return this.constructProductMC(dA, probModel, vector, null, null, true);
    }

    public ProbModel constructProductMC(DA<BitSet, ? extends AcceptanceOmega> dA, ProbModel probModel, Vector<JDDNode> vector, JDDVars jDDVars, JDDVars jDDVars2) throws PrismException {
        return this.constructProductMC(dA, probModel, vector, jDDVars, jDDVars2, true);
    }

    public ProbModel constructProductMC(DA<BitSet, ? extends AcceptanceOmega> dA, ProbModel probModel, Vector<JDDNode> vector, JDDVars jDDVars, JDDVars jDDVars2, boolean bl) throws PrismException {
        int n;
        JDDVars[] jDDVarsArray = probModel.getVarDDRowVars();
        JDDVars[] jDDVarsArray2 = probModel.getVarDDColVars();
        JDDVars jDDVars3 = probModel.getAllDDRowVars();
        JDDVars jDDVars4 = probModel.getAllDDColVars();
        Vector<String> vector2 = probModel.getDDVarNames();
        VarList varList = probModel.getVarList();
        String string = "_da";
        while (varList.getIndex(string) != -1) {
            string = "_" + string;
        }
        int n2 = (int)Math.ceil(PrismUtils.log2(dA.size()));
        n2 = Math.max(n2, 1);
        boolean bl2 = true;
        if (jDDVars3.getMinVarIndex() - 1 < 2 * n2) {
            bl2 = false;
        }
        JDDVars jDDVars5 = jDDVars == null ? new JDDVars() : jDDVars;
        JDDVars jDDVars6 = jDDVars2 == null ? new JDDVars() : jDDVars2;
        Vector<String> vector3 = new Vector<String>();
        vector3.addAll(vector2);
        int n3 = bl2 ? jDDVars3.getMinVarIndex() - 2 * n2 : probModel.getAllDDColVars().getMaxVarIndex() + 1;
        for (n = 0; n < n2; ++n) {
            jDDVars5.addVar(JDD.Var(n3++));
            jDDVars6.addVar(JDD.Var(n3++));
            if (!bl2) {
                vector3.add("");
                vector3.add("");
            }
            vector3.set(n3 - 2, string + "." + n);
            vector3.set(n3 - 1, string + "'." + n);
        }
        JDDVars[] jDDVarsArray3 = new JDDVars[jDDVarsArray.length + 1];
        JDDVars[] jDDVarsArray4 = new JDDVars[jDDVarsArray.length + 1];
        jDDVarsArray3[bl2 ? 0 : jDDVarsArray.length] = jDDVars5;
        jDDVarsArray4[bl2 ? 0 : jDDVarsArray2.length] = jDDVars6;
        for (n = 0; n < jDDVarsArray.length; ++n) {
            jDDVarsArray3[bl2 ? n + 1 : n] = new JDDVars();
            jDDVarsArray4[bl2 ? n + 1 : n] = new JDDVars();
            jDDVarsArray3[bl2 ? n + 1 : n].addVars(jDDVarsArray[n]);
            jDDVarsArray4[bl2 ? n + 1 : n].addVars(jDDVarsArray2[n]);
        }
        JDDVars jDDVars7 = new JDDVars();
        JDDVars jDDVars8 = new JDDVars();
        if (bl2) {
            jDDVars7.addVars(jDDVars5);
            jDDVars8.addVars(jDDVars6);
            jDDVars7.addVars(jDDVars3);
            jDDVars8.addVars(jDDVars4);
        } else {
            jDDVars7.addVars(jDDVars3);
            jDDVars8.addVars(jDDVars4);
            jDDVars7.addVars(jDDVars5);
            jDDVars8.addVars(jDDVars6);
        }
        VarList varList2 = (VarList)varList.clone();
        Declaration declaration = new Declaration(string, new DeclarationInt(Expression.Int(0), Expression.Int(Math.max(dA.size() - 1, 1))));
        varList2.addVar(bl2 ? 0 : varList.getNumVars(), declaration, 1, probModel.getConstantValues());
        jDDVars3.refAll();
        jDDVars3.refAll();
        jDDVars4.refAll();
        jDDVars4.refAll();
        for (n = 0; n < probModel.getNumModules(); ++n) {
            probModel.getModuleDDRowVars(n).refAll();
            probModel.getModuleDDColVars(n).refAll();
        }
        jDDVars5.refAll();
        jDDVars6.refAll();
        JDDNode jDDNode = this.buildTransMask(dA, vector, jDDVars3, jDDVars4, jDDVars5, jDDVars6);
        JDD.Ref(probModel.getTrans());
        jDDNode = JDD.Apply(3, probModel.getTrans(), jDDNode);
        JDDNode jDDNode2 = this.buildStartMask(dA, vector, jDDVars5);
        JDD.Ref(bl ? probModel.getReach() : probModel.getStart());
        jDDNode2 = JDD.And(bl ? probModel.getReach() : probModel.getStart(), jDDNode2);
        ProbModel probModel2 = new ProbModel(jDDNode, jDDNode2, new JDDNode[0], new JDDNode[0], new String[0], jDDVars7, jDDVars8, vector3, probModel.getNumModules(), probModel.getModuleNames(), probModel.getModuleDDRowVars(), probModel.getModuleDDColVars(), probModel.getNumVars() + 1, varList2, jDDVarsArray3, jDDVarsArray4, probModel.getConstantValues());
        probModel2.doReachability();
        probModel2.filterReachableStates();
        probModel2.findDeadlocks(false);
        if (probModel2.getDeadlockStates().size() > 0) {
            throw new PrismException("Model-" + dA.getAutomataType() + " product has deadlock states");
        }
        jDDNode2 = this.buildStartMask(dA, vector, jDDVars5);
        JDD.Ref(probModel.getStart());
        jDDNode2 = JDD.And(probModel.getStart(), jDDNode2);
        probModel2.setStart(jDDNode2);
        if (jDDVars != null) {
            jDDVars.refAll();
        }
        if (jDDVars2 != null) {
            jDDVars2.refAll();
        }
        return probModel2;
    }

    public NondetModel constructProductMDP(DA<BitSet, ? extends AcceptanceOmega> dA, NondetModel nondetModel, Vector<JDDNode> vector) throws PrismException {
        return this.constructProductMDP(dA, nondetModel, vector, null, null, true, null);
    }

    public NondetModel constructProductMDP(DA<BitSet, ? extends AcceptanceOmega> dA, NondetModel nondetModel, Vector<JDDNode> vector, JDDVars jDDVars, JDDVars jDDVars2) throws PrismException {
        return this.constructProductMDP(dA, nondetModel, vector, jDDVars, jDDVars2, true, null);
    }

    public NondetModel constructProductMDP(DA<BitSet, ? extends AcceptanceOmega> dA, NondetModel nondetModel, Vector<JDDNode> vector, JDDVars jDDVars, JDDVars jDDVars2, boolean bl, JDDNode jDDNode) throws PrismException {
        int n;
        JDDVars[] jDDVarsArray = nondetModel.getVarDDRowVars();
        JDDVars[] jDDVarsArray2 = nondetModel.getVarDDColVars();
        JDDVars jDDVars3 = nondetModel.getAllDDRowVars();
        JDDVars jDDVars4 = nondetModel.getAllDDColVars();
        Vector<String> vector2 = nondetModel.getDDVarNames();
        VarList varList = nondetModel.getVarList();
        String string = "_da";
        while (varList.getIndex(string) != -1) {
            string = "_" + string;
        }
        int n2 = (int)Math.ceil(PrismUtils.log2(dA.size()));
        n2 = Math.max(n2, 1);
        boolean bl2 = true;
        if (jDDVars3.getMinVarIndex() - nondetModel.getAllDDNondetVars().getMaxVarIndex() - 1 < 2 * n2) {
            bl2 = false;
        }
        JDDVars jDDVars5 = jDDVars == null ? new JDDVars() : jDDVars;
        JDDVars jDDVars6 = jDDVars2 == null ? new JDDVars() : jDDVars2;
        Vector<String> vector3 = new Vector<String>();
        vector3.addAll(vector2);
        int n3 = bl2 ? jDDVars3.getMinVarIndex() - 2 * n2 : nondetModel.getAllDDColVars().getMaxVarIndex() + 1;
        for (n = 0; n < n2; ++n) {
            jDDVars5.addVar(JDD.Var(n3++));
            jDDVars6.addVar(JDD.Var(n3++));
            if (!bl2) {
                vector3.add("");
                vector3.add("");
            }
            vector3.set(n3 - 2, string + "." + n);
            vector3.set(n3 - 1, string + "'." + n);
        }
        JDDVars[] jDDVarsArray3 = new JDDVars[jDDVarsArray.length + 1];
        JDDVars[] jDDVarsArray4 = new JDDVars[jDDVarsArray.length + 1];
        jDDVarsArray3[bl2 ? 0 : jDDVarsArray.length] = jDDVars5;
        jDDVarsArray4[bl2 ? 0 : jDDVarsArray2.length] = jDDVars6;
        for (n = 0; n < jDDVarsArray.length; ++n) {
            jDDVarsArray3[bl2 ? n + 1 : n] = new JDDVars();
            jDDVarsArray4[bl2 ? n + 1 : n] = new JDDVars();
            jDDVarsArray3[bl2 ? n + 1 : n].addVars(jDDVarsArray[n]);
            jDDVarsArray4[bl2 ? n + 1 : n].addVars(jDDVarsArray2[n]);
        }
        JDDVars jDDVars7 = new JDDVars();
        JDDVars jDDVars8 = new JDDVars();
        if (bl2) {
            jDDVars7.addVars(jDDVars5);
            jDDVars8.addVars(jDDVars6);
            jDDVars7.addVars(jDDVars3);
            jDDVars8.addVars(jDDVars4);
        } else {
            jDDVars7.addVars(jDDVars3);
            jDDVars8.addVars(jDDVars4);
            jDDVars7.addVars(jDDVars5);
            jDDVars8.addVars(jDDVars6);
        }
        VarList varList2 = (VarList)varList.clone();
        Declaration declaration = new Declaration(string, new DeclarationInt(Expression.Int(0), Expression.Int(Math.max(dA.size() - 1, 1))));
        varList2.addVar(bl2 ? 0 : varList.getNumVars(), declaration, 1, nondetModel.getConstantValues());
        jDDVars3.refAll();
        jDDVars3.refAll();
        jDDVars4.refAll();
        jDDVars4.refAll();
        for (n = 0; n < nondetModel.getNumModules(); ++n) {
            nondetModel.getModuleDDRowVars(n).refAll();
            nondetModel.getModuleDDColVars(n).refAll();
        }
        jDDVars5.refAll();
        jDDVars6.refAll();
        nondetModel.getAllDDSchedVars().refAll();
        nondetModel.getAllDDSynchVars().refAll();
        nondetModel.getAllDDChoiceVars().refAll();
        nondetModel.getAllDDNondetVars().refAll();
        JDDNode jDDNode2 = this.buildTransMask(dA, vector, jDDVars3, jDDVars4, jDDVars5, jDDVars6);
        JDD.Ref(nondetModel.getTrans());
        jDDNode2 = JDD.Apply(3, nondetModel.getTrans(), jDDNode2);
        JDDNode jDDNode3 = this.buildStartMask(dA, vector, jDDVars5);
        JDD.Ref(bl ? nondetModel.getReach() : (jDDNode != null ? jDDNode : nondetModel.getStart()));
        jDDNode3 = JDD.And(bl ? nondetModel.getReach() : (jDDNode != null ? jDDNode : nondetModel.getStart()), jDDNode3);
        NondetModel nondetModel2 = new NondetModel(jDDNode2, jDDNode3, new JDDNode[0], new JDDNode[0], new String[0], jDDVars7, jDDVars8, nondetModel.getAllDDSchedVars(), nondetModel.getAllDDSynchVars(), nondetModel.getAllDDChoiceVars(), nondetModel.getAllDDNondetVars(), vector3, nondetModel.getNumModules(), nondetModel.getModuleNames(), nondetModel.getModuleDDRowVars(), nondetModel.getModuleDDColVars(), nondetModel.getNumVars() + 1, varList2, jDDVarsArray3, jDDVarsArray4, nondetModel.getConstantValues());
        if (nondetModel.getTransActions() != null) {
            JDD.Ref(nondetModel.getTransActions());
            nondetModel2.setTransActions(nondetModel.getTransActions());
        }
        nondetModel2.setSynchs(new Vector<String>(nondetModel.getSynchs()));
        nondetModel2.doReachability();
        nondetModel2.filterReachableStates();
        nondetModel2.findDeadlocks(false);
        if (nondetModel2.getDeadlockStates().size() > 0) {
            throw new PrismException("Model-DA product has deadlock states");
        }
        jDDNode3 = this.buildStartMask(dA, vector, jDDVars5);
        JDD.Ref(jDDNode != null ? jDDNode : nondetModel.getStart());
        jDDNode3 = JDD.And(jDDNode != null ? jDDNode : nondetModel.getStart(), jDDNode3);
        nondetModel2.setStart(jDDNode3);
        if (jDDVars != null) {
            jDDVars.refAll();
        }
        if (jDDVars2 != null) {
            jDDVars2.refAll();
        }
        return nondetModel2;
    }

    public JDDNode buildTransMask(DA<BitSet, ? extends AcceptanceOmega> dA, Vector<JDDNode> vector, JDDVars jDDVars, JDDVars jDDVars2, JDDVars jDDVars3, JDDVars jDDVars4) {
        int n = dA.getAPList().size();
        JDDNode jDDNode = JDD.Constant(0.0);
        int n2 = dA.size();
        for (int i = 0; i < n2; ++i) {
            int n3 = dA.getNumEdges(i);
            for (int j = 0; j < n3; ++j) {
                JDDNode jDDNode2 = JDD.Constant(1.0);
                for (int k = 0; k < n; ++k) {
                    JDDNode jDDNode3 = vector.get(Integer.parseInt(dA.getAPList().get(k).substring(1)));
                    JDD.Ref(jDDNode3);
                    if (!dA.getEdgeLabel(i, j).get(k)) {
                        jDDNode3 = JDD.Not(jDDNode3);
                    }
                    jDDNode2 = JDD.And(jDDNode2, jDDNode3);
                }
                jDDNode2 = JDD.PermuteVariables(jDDNode2, jDDVars, jDDVars2);
                JDDNode jDDNode4 = JDD.SetMatrixElement(JDD.Constant(0.0), jDDVars3, jDDVars4, i, dA.getEdgeDest(i, j), 1.0);
                jDDNode4 = JDD.And(jDDNode4, jDDNode2);
                jDDNode = JDD.Or(jDDNode, jDDNode4);
            }
        }
        return jDDNode;
    }

    public JDDNode buildStartMask(DA<BitSet, ? extends AcceptanceOmega> dA, Vector<JDDNode> vector, JDDVars jDDVars) {
        int n = dA.getAPList().size();
        JDDNode jDDNode = JDD.Constant(0.0);
        int n2 = dA.getStartState();
        int n3 = dA.getNumEdges(n2);
        for (int i = 0; i < n3; ++i) {
            JDDNode jDDNode2 = JDD.Constant(1.0);
            for (int j = 0; j < n; ++j) {
                JDDNode jDDNode3 = vector.get(Integer.parseInt(dA.getAPList().get(j).substring(1)));
                JDD.Ref(jDDNode3);
                if (!dA.getEdgeLabel(n2, i).get(j)) {
                    jDDNode3 = JDD.Not(jDDNode3);
                }
                jDDNode2 = JDD.And(jDDNode2, jDDNode3);
            }
            JDDNode jDDNode4 = JDD.Constant(0.0);
            jDDNode4 = JDD.SetVectorElement(jDDNode4, jDDVars, dA.getEdgeDest(n2, i), 1.0);
            JDDNode jDDNode5 = JDD.And(jDDNode4, jDDNode2);
            jDDNode = JDD.Or(jDDNode, jDDNode5);
        }
        return jDDNode;
    }

    public JDDNode findAcceptingBSCCs(AcceptanceOmegaDD acceptanceOmegaDD, ProbModel probModel) throws PrismException {
        JDDNode jDDNode = JDD.Constant(0.0);
        SCCComputer sCCComputer = SCCComputer.createSCCComputer(this, probModel);
        sCCComputer.computeBSCCs();
        List<JDDNode> list = sCCComputer.getBSCCs();
        JDD.Deref(sCCComputer.getNotInBSCCs());
        for (JDDNode jDDNode2 : list) {
            if (acceptanceOmegaDD.isBSCCAccepting(jDDNode2)) {
                JDD.Ref(jDDNode2);
                jDDNode = JDD.Or(jDDNode, jDDNode2);
            }
            JDD.Deref(jDDNode2);
        }
        return jDDNode;
    }

    public JDDNode findAcceptingECStates(AcceptanceOmegaDD acceptanceOmegaDD, NondetModel nondetModel, JDDVars jDDVars, JDDVars jDDVars2, boolean bl) throws PrismException {
        switch (acceptanceOmegaDD.getType()) {
            case RABIN: {
                return this.findAcceptingECStatesForRabin((AcceptanceRabinDD)acceptanceOmegaDD, nondetModel, jDDVars, jDDVars2, bl);
            }
            case GENERALIZED_RABIN: {
                return this.findAcceptingECStatesForGeneralizedRabin((AcceptanceGenRabinDD)acceptanceOmegaDD, nondetModel, jDDVars, jDDVars2, bl);
            }
        }
        throw new PrismNotSupportedException("Computing the accepting EC states for " + acceptanceOmegaDD.getTypeName() + " acceptance is not yet implemented (symbolic engine)");
    }

    public JDDNode findAcceptingECStatesForRabin(AcceptanceRabinDD acceptanceRabinDD, NondetModel nondetModel, JDDVars jDDVars, JDDVars jDDVars2, boolean bl) throws PrismException {
        JDDNode jDDNode = null;
        JDDNode jDDNode2 = JDD.Constant(0.0);
        if (acceptanceRabinDD.size() > 1) {
            JDDNode jDDNode3;
            Iterator iterator;
            Object object;
            int n;
            JDDNode jDDNode4 = JDD.Constant(0.0);
            JDDNode jDDNode5 = JDD.Constant(0.0);
            ArrayList<JDDNode> arrayList = new ArrayList<JDDNode>();
            ArrayList<JDDNode> arrayList2 = new ArrayList<JDDNode>();
            for (n = 0; n < acceptanceRabinDD.size(); ++n) {
                object = JDD.Not(((AcceptanceRabinDD.RabinPairDD)acceptanceRabinDD.get(n)).getL());
                iterator = ((AcceptanceRabinDD.RabinPairDD)acceptanceRabinDD.get(n)).getK();
                arrayList.add((JDDNode)object);
                JDD.Ref((JDDNode)object);
                jDDNode4 = JDD.Or(jDDNode4, (JDDNode)object);
                arrayList2.add((JDDNode)((Object)iterator));
                JDD.Ref((JDDNode)((Object)iterator));
                jDDNode5 = JDD.Or(jDDNode5, (JDDNode)((Object)iterator));
            }
            JDD.Ref(nondetModel.getTrans01());
            JDD.Ref(jDDNode4);
            JDDNode jDDNode6 = JDD.Apply(3, nondetModel.getTrans01(), jDDNode4);
            jDDNode4 = JDD.PermuteVariables(jDDNode4, jDDVars, jDDVars2);
            jDDNode6 = JDD.Apply(3, jDDNode6, jDDNode4);
            jDDNode6 = JDD.ThereExists(jDDNode6, nondetModel.getAllDDColVars());
            jDDNode6 = JDD.ThereExists(jDDNode6, nondetModel.getAllDDNondetVars());
            object = this.findMECStates(nondetModel, jDDNode6, jDDNode5);
            JDD.Deref(jDDNode5);
            JDD.Deref(jDDNode6);
            for (n = 0; n < acceptanceRabinDD.size(); ++n) {
                jDDNode4 = (JDDNode)arrayList.get(n);
                jDDNode5 = (JDDNode)arrayList2.get(n);
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    List<JDDNode> list;
                    jDDNode3 = (JDDNode)iterator.next();
                    JDD.Ref(jDDNode3);
                    JDD.Ref(jDDNode4);
                    jDDNode6 = JDD.And(jDDNode3, jDDNode4);
                    if (jDDNode6.equals(jDDNode3)) {
                        list = new Vector<JDDNode>();
                        JDD.Ref(jDDNode3);
                        list.add(jDDNode3);
                    } else {
                        if (jDDNode6.equals(JDD.ZERO)) {
                            JDD.Deref(jDDNode6);
                            continue;
                        }
                        JDD.Ref(nondetModel.getTrans01());
                        JDD.Ref(jDDNode6);
                        Object object2 = JDD.Apply(3, nondetModel.getTrans01(), jDDNode6);
                        jDDNode6 = JDD.PermuteVariables(jDDNode6, jDDVars, jDDVars2);
                        object2 = JDD.Apply(3, jDDNode6, (JDDNode)object2);
                        object2 = JDD.ThereExists((JDDNode)object2, nondetModel.getAllDDColVars());
                        jDDNode6 = JDD.ThereExists((JDDNode)object2, nondetModel.getAllDDNondetVars());
                        list = this.findMECStates(nondetModel, jDDNode6, jDDNode5);
                    }
                    JDD.Deref(jDDNode6);
                    jDDNode = JDD.Constant(0.0);
                    for (JDDNode jDDNode7 : list) {
                        if (JDD.AreIntersecting(jDDNode7, jDDNode5)) {
                            jDDNode = JDD.Or(jDDNode, jDDNode7);
                            continue;
                        }
                        JDD.Deref(jDDNode7);
                    }
                    jDDNode2 = JDD.Or(jDDNode2, jDDNode);
                }
                JDD.Deref(jDDNode5);
                JDD.Deref(jDDNode4);
            }
            iterator = object.iterator();
            while (iterator.hasNext()) {
                jDDNode3 = (JDDNode)iterator.next();
                JDD.Deref(jDDNode3);
            }
        } else {
            for (int i = 0; i < acceptanceRabinDD.size(); ++i) {
                Object object;
                JDDNode jDDNode8 = JDD.Not(((AcceptanceRabinDD.RabinPairDD)acceptanceRabinDD.get(i)).getL());
                JDDNode jDDNode9 = ((AcceptanceRabinDD.RabinPairDD)acceptanceRabinDD.get(i)).getK();
                JDD.Ref(nondetModel.getTrans01());
                JDD.Ref(jDDNode8);
                JDDNode jDDNode10 = JDD.Apply(3, nondetModel.getTrans01(), jDDNode8);
                jDDNode8 = JDD.PermuteVariables(jDDNode8, jDDVars, jDDVars2);
                jDDNode10 = JDD.Apply(3, jDDNode10, jDDNode8);
                jDDNode10 = JDD.ThereExists(jDDNode10, nondetModel.getAllDDColVars());
                jDDNode10 = JDD.ThereExists(jDDNode10, nondetModel.getAllDDNondetVars());
                if (!bl) {
                    object = this.findMECStates(nondetModel, jDDNode10);
                    JDD.Deref(jDDNode10);
                    jDDNode = this.filteredUnion((List<JDDNode>)object, jDDNode9);
                } else {
                    JDD.Ref(jDDNode10);
                    object = JDD.And(jDDNode10, jDDNode9);
                    JDD.Ref(nondetModel.getTrans01());
                    JDDNode jDDNode11 = JDD.ThereExists(nondetModel.getTrans01(), nondetModel.getAllDDNondetVars());
                    JDDNode jDDNode12 = this.backwardSet(nondetModel, (JDDNode)object, jDDNode11);
                    jDDNode10 = JDD.And(jDDNode10, jDDNode12);
                    jDDNode = this.findFairECs(nondetModel, jDDNode10);
                }
                jDDNode2 = JDD.Or(jDDNode2, jDDNode);
            }
        }
        return jDDNode2;
    }

    public JDDNode findAcceptingECStatesForGeneralizedRabin(AcceptanceGenRabinDD acceptanceGenRabinDD, NondetModel nondetModel, JDDVars jDDVars, JDDVars jDDVars2, boolean bl) throws PrismException {
        if (bl) {
            throw new PrismException("Accepting end-component computation for generalized Rabin is currently not supported with fairness");
        }
        JDDNode jDDNode = JDD.Constant(0.0);
        for (int i = 0; i < acceptanceGenRabinDD.size(); ++i) {
            JDDNode jDDNode2 = JDD.Not(((AcceptanceGenRabinDD.GenRabinPairDD)acceptanceGenRabinDD.get(i)).getL());
            JDD.Ref(nondetModel.getTrans01());
            JDD.Ref(jDDNode2);
            JDDNode jDDNode3 = JDD.Apply(3, nondetModel.getTrans01(), jDDNode2);
            jDDNode2 = JDD.PermuteVariables(jDDNode2, jDDVars, jDDVars2);
            jDDNode3 = JDD.Apply(3, jDDNode3, jDDNode2);
            jDDNode3 = JDD.ThereExists(jDDNode3, nondetModel.getAllDDColVars());
            jDDNode3 = JDD.ThereExists(jDDNode3, nondetModel.getAllDDNondetVars());
            List<JDDNode> list = this.findMECStates(nondetModel, jDDNode3);
            JDD.Deref(jDDNode3);
            JDDNode jDDNode4 = JDD.Constant(0.0);
            for (int j = 0; j < list.size(); ++j) {
                if (((AcceptanceGenRabinDD.GenRabinPairDD)acceptanceGenRabinDD.get(i)).isBSCCAccepting(list.get(j))) {
                    jDDNode4 = JDD.Or(jDDNode4, list.get(j));
                    continue;
                }
                JDD.Deref(list.get(j));
            }
            jDDNode = JDD.Or(jDDNode, jDDNode4);
        }
        return jDDNode;
    }

    public JDDNode findMultiAcceptingStates(DA<BitSet, AcceptanceRabin> dA, NondetModel nondetModel, JDDVars jDDVars, JDDVars jDDVars2, boolean bl, List<JDDNode> list, List<JDDNode> list2, List<JDDNode> list3) throws PrismException {
        JDDNode jDDNode = null;
        JDDNode jDDNode2 = JDD.Constant(0.0);
        for (int i = 0; i < dA.getAcceptance().size(); ++i) {
            JDDNode jDDNode3 = list2.get(i);
            JDDNode jDDNode4 = list3.get(i);
            for (JDDNode jDDNode5 : list) {
                List<JDDNode> list4 = null;
                JDD.Ref(jDDNode5);
                JDD.Ref(jDDNode3);
                JDDNode jDDNode6 = JDD.And(jDDNode5, jDDNode3);
                if (jDDNode6.equals(jDDNode5)) {
                    list4 = new Vector<JDDNode>();
                    list4.add(jDDNode5);
                } else {
                    if (jDDNode6.equals(JDD.ZERO)) {
                        JDD.Deref(jDDNode6);
                        continue;
                    }
                    JDD.Ref(nondetModel.getTrans01());
                    JDD.Ref(jDDNode6);
                    Object object = JDD.Apply(3, nondetModel.getTrans01(), jDDNode6);
                    jDDNode6 = JDD.PermuteVariables(jDDNode6, jDDVars, jDDVars2);
                    object = JDD.Apply(3, jDDNode6, (JDDNode)object);
                    object = JDD.ThereExists((JDDNode)object, nondetModel.getAllDDColVars());
                    jDDNode6 = JDD.ThereExists((JDDNode)object, nondetModel.getAllDDNondetVars());
                    list4 = this.findMECStates(nondetModel, jDDNode6, jDDNode4);
                    JDD.Deref(jDDNode6);
                }
                jDDNode = JDD.Constant(0.0);
                for (JDDNode jDDNode7 : list4) {
                    if (JDD.AreIntersecting(jDDNode7, jDDNode4)) {
                        jDDNode = JDD.Or(jDDNode, jDDNode7);
                        continue;
                    }
                    JDD.Deref(jDDNode7);
                }
                jDDNode2 = JDD.Or(jDDNode2, jDDNode);
            }
            JDD.Deref(jDDNode4);
            JDD.Deref(jDDNode3);
        }
        return jDDNode2;
    }

    public void findMultiConflictAcceptingStates(DA<BitSet, AcceptanceRabin>[] dAArray, NondetModel nondetModel, JDDVars[] jDDVarsArray, JDDVars[] jDDVarsArray2, List<JDDNode> list, List<List<JDDNode>> list2, List<List<JDDNode>> list3, List<JDDNode> list4, List<List<Integer>> list5) throws PrismException {
        int n;
        Object object;
        ArrayList<queueElement> arrayList = new ArrayList<queueElement>();
        int n2 = 0;
        for (int i = 0; i < dAArray.length; ++i) {
            ArrayList<Integer> object2 = new ArrayList<Integer>();
            object2.add(i);
            object = new queueElement(list2.get(i), list3.get(i), list.get(i), object2, i + 1);
            arrayList.add((queueElement)object);
        }
        while (n2 < arrayList.size()) {
            this.computeCombinations(dAArray, nondetModel, jDDVarsArray, jDDVarsArray2, list, list2, list3, arrayList, n2);
            ++n2;
        }
        for (queueElement queueElement2 : arrayList) {
            if (queueElement2.children == null) continue;
            object = queueElement2.targetDD;
            for (queueElement queueElement3 : queueElement2.children) {
                JDD.Ref(queueElement3.targetDD);
                object = JDD.And((JDDNode)object, JDD.Not(queueElement3.targetDD));
            }
            queueElement2.targetDD = object;
        }
        list.clear();
        for (n = 0; n < dAArray.length; ++n) {
            list.add(((queueElement)arrayList.get((int)n)).targetDD);
        }
        for (n = dAArray.length; n < arrayList.size(); ++n) {
            list4.add(((queueElement)arrayList.get((int)n)).targetDD);
            list5.add(((queueElement)arrayList.get((int)n)).draIDs);
        }
    }

    private void computeCombinations(DA<BitSet, AcceptanceRabin>[] dAArray, NondetModel nondetModel, JDDVars[] jDDVarsArray, JDDVars[] jDDVarsArray2, List<JDDNode> list, List<List<JDDNode>> list2, List<List<JDDNode>> list3, List<queueElement> list4, int n) throws PrismException {
        Object object;
        int n2;
        queueElement queueElement2 = list4.get(n);
        int n3 = list4.size();
        for (n2 = queueElement2.next; n2 < dAArray.length; ++n2) {
            Object object2;
            object = new ArrayList();
            ArrayList<JDDNode> arrayList = new ArrayList<JDDNode>();
            JDDNode jDDNode = JDD.Constant(0.0);
            List<JDDNode> list5 = list2.get(n2);
            List<JDDNode> list6 = list3.get(n2);
            JDD.Ref(queueElement2.targetDD);
            JDD.Ref(list.get(n2));
            JDDNode jDDNode2 = JDD.And(queueElement2.targetDD, list.get(n2));
            for (int i = 0; i < queueElement2.statesH.size(); ++i) {
                JDD.Ref(jDDNode2);
                JDD.Ref(queueElement2.statesH.get(i));
                object2 = JDD.And(jDDNode2, queueElement2.statesH.get(i));
                for (int j = 0; j < list5.size(); ++j) {
                    JDD.Ref((JDDNode)object2);
                    JDD.Ref(list5.get(j));
                    JDDNode jDDNode3 = JDD.And((JDDNode)object2, list5.get(j));
                    JDD.Ref(nondetModel.getTrans01());
                    JDD.Ref(jDDNode3);
                    JDDNode jDDNode4 = JDD.Apply(3, nondetModel.getTrans01(), jDDNode3);
                    jDDNode3 = JDD.PermuteVariables(jDDNode3, nondetModel.getAllDDRowVars(), nondetModel.getAllDDColVars());
                    jDDNode4 = JDD.Apply(3, jDDNode3, jDDNode4);
                    jDDNode4 = JDD.ThereExists(jDDNode4, nondetModel.getAllDDColVars());
                    jDDNode3 = JDD.ThereExists(jDDNode4, nondetModel.getAllDDNondetVars());
                    JDD.Ref(queueElement2.statesL.get(i));
                    JDD.Ref(list6.get(j));
                    JDDNode jDDNode5 = JDD.And(queueElement2.statesL.get(i), list6.get(j));
                    List<JDDNode> list7 = null;
                    list7 = this.findMECStates(nondetModel, jDDNode3, jDDNode5);
                    JDD.Deref(jDDNode3);
                    if (list7 != null) {
                        boolean bl = false;
                        for (JDDNode jDDNode6 : list7) {
                            if (JDD.AreIntersecting(jDDNode6, jDDNode5)) {
                                jDDNode = JDD.Or(jDDNode, jDDNode6);
                                bl = true;
                                continue;
                            }
                            JDD.Deref(jDDNode6);
                        }
                        if (bl) {
                            JDD.Ref(queueElement2.statesH.get(i));
                            JDD.Ref(list5.get(j));
                            JDDNode jDDNode7 = JDD.And(queueElement2.statesH.get(i), list5.get(j));
                            object.add(jDDNode7);
                            JDD.Ref(jDDNode5);
                            arrayList.add(jDDNode5);
                        }
                    }
                    JDD.Deref(jDDNode5);
                }
                JDD.Deref((JDDNode)object2);
            }
            JDD.Deref(jDDNode2);
            if (!object.isEmpty()) {
                ArrayList<Integer> arrayList2 = new ArrayList<Integer>(queueElement2.draIDs);
                arrayList2.add(n2);
                object2 = new queueElement((List<JDDNode>)object, arrayList, jDDNode, arrayList2, n2 + 1);
                list4.add((queueElement)object2);
                queueElement2.addChildren((queueElement)object2);
                continue;
            }
            JDD.Deref(jDDNode);
        }
        for (n2 = n3 - 1; n2 > n; --n2) {
            object = list4.get(n2);
            if (((queueElement)object).draIDs.size() <= queueElement2.draIDs.size()) break;
            if (!((queueElement)object).draIDs.containsAll(queueElement2.draIDs)) continue;
            queueElement2.addChildren((queueElement)object);
        }
        if (queueElement2.draIDs.size() > 1) {
            for (n2 = 0; n2 < queueElement2.statesH.size(); ++n2) {
                JDD.Deref(queueElement2.statesH.get(n2));
                JDD.Deref(queueElement2.statesL.get(n2));
            }
        }
    }

    private JDDNode findFairECs(NondetModel nondetModel, JDDNode jDDNode) {
        JDDNode jDDNode2 = JDD.Constant(0.0);
        JDDNode jDDNode3 = jDDNode;
        while (!jDDNode3.equals(jDDNode2)) {
            JDD.Deref(jDDNode2);
            JDD.Ref(jDDNode3);
            jDDNode2 = jDDNode3;
            JDD.Ref(jDDNode3);
            JDD.Ref(nondetModel.getTrans01());
            JDDNode jDDNode4 = JDD.And(nondetModel.getTrans01(), jDDNode3);
            JDD.Ref(jDDNode3);
            JDDNode jDDNode5 = JDD.Not(JDD.PermuteVariables(jDDNode3, nondetModel.getAllDDRowVars(), nondetModel.getAllDDColVars()));
            jDDNode5 = JDD.And(jDDNode4, jDDNode5);
            jDDNode5 = JDD.ThereExists(jDDNode5, nondetModel.getAllDDColVars());
            jDDNode5 = JDD.ThereExists(jDDNode5, nondetModel.getAllDDNondetVars());
            jDDNode3 = JDD.And(jDDNode3, JDD.Not(jDDNode5));
        }
        JDD.Deref(jDDNode2);
        return jDDNode3;
    }

    private JDDNode backwardSet(NondetModel nondetModel, JDDNode jDDNode, JDDNode jDDNode2) {
        JDDNode jDDNode3 = JDD.Constant(0.0);
        JDDNode jDDNode4 = jDDNode;
        while (!jDDNode4.equals(jDDNode3)) {
            JDD.Deref(jDDNode3);
            JDD.Ref(jDDNode4);
            jDDNode3 = jDDNode4;
            JDD.Ref(jDDNode4);
            JDD.Ref(jDDNode2);
            jDDNode4 = JDD.Or(jDDNode4, this.preimage(nondetModel, jDDNode4, jDDNode2));
        }
        JDD.Deref(jDDNode2);
        JDD.Deref(jDDNode3);
        return jDDNode4;
    }

    private JDDNode preimage(NondetModel nondetModel, JDDNode jDDNode, JDDNode jDDNode2) {
        JDDNode jDDNode3 = JDD.PermuteVariables(jDDNode, nondetModel.getAllDDRowVars(), nondetModel.getAllDDColVars());
        jDDNode3 = JDD.And(jDDNode2, jDDNode3);
        jDDNode3 = JDD.ThereExists(jDDNode3, nondetModel.getAllDDColVars());
        return jDDNode3;
    }

    public List<JDDNode> findMECStates(NondetModel nondetModel, JDDNode jDDNode) throws PrismException {
        ECComputer eCComputer = ECComputer.createECComputer(this, nondetModel);
        eCComputer.computeMECStates(jDDNode, null);
        return eCComputer.getMECStates();
    }

    public List<JDDNode> findMECStates(NondetModel nondetModel, JDDNode jDDNode, JDDNode jDDNode2) throws PrismException {
        ECComputer eCComputer = ECComputer.createECComputer(this, nondetModel);
        eCComputer.computeMECStates(jDDNode, jDDNode2);
        return eCComputer.getMECStates();
    }

    public List<JDDNode> findBottomEndComponents(NondetModel nondetModel, JDDNode jDDNode) throws PrismException {
        List<JDDNode> list = this.findMECStates(nondetModel, jDDNode);
        Vector<JDDNode> vector = new Vector<JDDNode>();
        for (JDDNode jDDNode2 : list) {
            JDD.Ref(nondetModel.getTrans01());
            JDD.Ref(jDDNode2);
            JDDNode jDDNode3 = JDD.And(nondetModel.getTrans01(), jDDNode2);
            JDD.Ref(jDDNode2);
            jDDNode3 = JDD.And(jDDNode3, JDD.Not(JDD.PermuteVariables(jDDNode2, nondetModel.getAllDDRowVars(), nondetModel.getAllDDColVars())));
            if (jDDNode3.equals(JDD.ZERO)) {
                vector.add(jDDNode2);
            } else {
                JDD.Deref(jDDNode2);
            }
            JDD.Deref(jDDNode3);
        }
        return vector;
    }

    public JDDNode maxStableSetTrans1(NondetModel nondetModel, JDDNode jDDNode) {
        JDD.Ref(jDDNode);
        JDD.Ref(nondetModel.getTrans());
        JDDNode jDDNode2 = JDD.Apply(3, nondetModel.getTrans(), jDDNode);
        JDDNode jDDNode3 = JDD.PermuteVariables(jDDNode, nondetModel.getAllDDRowVars(), nondetModel.getAllDDColVars());
        jDDNode3 = JDD.Apply(3, jDDNode2, jDDNode3);
        jDDNode3 = JDD.SumAbstract(jDDNode3, nondetModel.getAllDDColVars());
        jDDNode3 = JDD.GreaterThan(jDDNode3, 1.0 - this.settings.getDouble("prism.sumRoundOff"));
        JDD.Ref(nondetModel.getTrans01());
        JDDNode jDDNode4 = JDD.And(nondetModel.getTrans01(), jDDNode3);
        return jDDNode4;
    }

    private JDDNode filteredUnion(List<JDDNode> list, JDDNode jDDNode) {
        JDDNode jDDNode2 = JDD.Constant(0.0);
        for (JDDNode jDDNode3 : list) {
            if (JDD.AreIntersecting(jDDNode3, jDDNode)) {
                jDDNode2 = JDD.Or(jDDNode2, jDDNode3);
                continue;
            }
            JDD.Deref(jDDNode3);
        }
        JDD.Deref(jDDNode);
        return jDDNode2;
    }
}

