/*
 * Decompiled with CFR 0.152.
 */
package prism;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;
import parser.Values;
import parser.VarList;
import parser.ast.ModulesFile;
import prism.Model;
import prism.ModelType;
import prism.NondetModel;
import prism.Prism;
import prism.PrismException;
import prism.PrismLog;
import prism.ProbModel;
import prism.StochModel;

public class ExplicitFiles2MTBDD {
    private Prism prism;
    private PrismLog mainLog;
    private File statesFile;
    private File transFile;
    private File labelsFile;
    private ModulesFile modulesFile;
    private ModelType modelType;
    private VarList varList;
    private int numVars;
    private int numStates;
    private int[][] statesArray = null;
    private JDDNode trans;
    private JDDNode range;
    private JDDNode start;
    private JDDNode stateRewards;
    private JDDNode transRewards;
    private JDDVars allDDRowVars;
    private JDDVars allDDColVars;
    private JDDVars allDDSynchVars;
    private JDDVars allDDSchedVars;
    private JDDVars allDDChoiceVars;
    private JDDVars allDDNondetVars;
    private JDDVars[] moduleDDRowVars;
    private JDDVars[] moduleDDColVars;
    private JDDNode[] moduleRangeDDs;
    private JDDNode[] moduleIdentities;
    private JDDVars[] varDDRowVars;
    private JDDVars[] varDDColVars;
    private JDDNode[] varRangeDDs;
    private JDDNode[] varColRangeDDs;
    private JDDNode[] varIdentities;
    private JDDNode[] ddSynchVars;
    private JDDNode[] ddSchedVars;
    private JDDNode[] ddChoiceVars;
    private Vector<String> ddVarNames;
    private Vector<String> synchs;
    private JDDNode transActions;
    private Vector<JDDNode> transPerAction;
    private int maxNumChoices = 0;

    public ExplicitFiles2MTBDD(Prism prism) {
        this.prism = prism;
        this.mainLog = prism.getMainLog();
    }

    public Model build(File file, File file2, File file3, ModulesFile modulesFile, int n) throws PrismException {
        this.statesFile = file;
        this.transFile = file2;
        this.labelsFile = file3;
        this.modulesFile = modulesFile;
        this.modelType = modulesFile.getModelType();
        this.varList = modulesFile.createVarList();
        this.numVars = this.varList.getNumVars();
        this.numStates = n;
        if (file != null) {
            this.readStatesFromFile();
        }
        return this.buildModel();
    }

    private void readStatesFromFile() throws PrismException {
        int n = 0;
        this.statesArray = new int[this.numStates][];
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.statesFile));
            bufferedReader.readLine();
            n = 1;
            String string = bufferedReader.readLine();
            ++n;
            while (string != null) {
                if ((string = string.trim()).length() > 0) {
                    String[] stringArray = string.split(":");
                    int n2 = Integer.parseInt(stringArray[0]);
                    if ((stringArray = stringArray[1].substring(stringArray[1].indexOf(40) + 1, stringArray[1].indexOf(41)).split(",")).length != this.numVars) {
                        throw new PrismException("(wrong number of variable values) ");
                    }
                    if (this.statesArray[n2] != null) {
                        throw new PrismException("(duplicated state) ");
                    }
                    this.statesArray[n2] = new int[this.numVars];
                    for (int i = 0; i < this.numVars; ++i) {
                        this.statesArray[n2][i] = this.varList.encodeToIntFromString(i, stringArray[i]);
                    }
                }
                string = bufferedReader.readLine();
                ++n;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new PrismException("File I/O error reading from \"" + this.statesFile + "\"");
        }
        catch (PrismException prismException) {
            throw new PrismException("Error detected " + prismException.getMessage() + "at line " + n + " of states file \"" + this.statesFile + "\"");
        }
    }

    private Model buildModel() throws PrismException {
        int n;
        Model model = null;
        if (this.modelType == ModelType.MDP) {
            this.computeMaxChoicesFromFile();
        }
        this.allocateDDVars();
        this.sortDDVars();
        this.sortIdentities();
        this.sortRanges();
        this.buildTrans();
        if (this.modelType == ModelType.MDP) {
            JDDNode jDDNode = JDD.GetSupport(this.trans);
            jDDNode = JDD.ThereExists(jDDNode, this.allDDRowVars);
            JDDNode jDDNode2 = jDDNode = JDD.ThereExists(jDDNode, this.allDDColVars);
            JDDVars jDDVars = new JDDVars();
            while (!jDDNode2.equals(JDD.ONE)) {
                jDDVars.addVar(JDD.Var(jDDNode2.getIndex()));
                jDDNode2 = jDDNode2.getThen();
            }
            JDD.Deref(jDDNode);
            this.allDDNondetVars.derefAll();
            this.allDDNondetVars = jDDVars;
        }
        this.buildInit();
        this.computeStateRewards();
        int n2 = 1;
        String[] stringArray = this.modulesFile.getModuleNames();
        Values values = new Values();
        JDDNode[] jDDNodeArray = new JDDNode[]{this.stateRewards};
        JDDNode[] jDDNodeArray2 = new JDDNode[]{this.transRewards};
        String[] stringArray2 = new String[]{""};
        if (this.modelType == ModelType.DTMC) {
            model = new ProbModel(this.trans, this.start, jDDNodeArray, jDDNodeArray2, stringArray2, this.allDDRowVars, this.allDDColVars, this.ddVarNames, n2, stringArray, this.moduleDDRowVars, this.moduleDDColVars, this.numVars, this.varList, this.varDDRowVars, this.varDDColVars, values);
        } else if (this.modelType == ModelType.MDP) {
            model = new NondetModel(this.trans, this.start, jDDNodeArray, jDDNodeArray2, stringArray2, this.allDDRowVars, this.allDDColVars, this.allDDSynchVars, this.allDDSchedVars, this.allDDChoiceVars, this.allDDNondetVars, this.ddVarNames, n2, stringArray, this.moduleDDRowVars, this.moduleDDColVars, this.numVars, this.varList, this.varDDRowVars, this.varDDColVars, values);
        } else if (this.modelType == ModelType.CTMC) {
            model = new StochModel(this.trans, this.start, jDDNodeArray, jDDNodeArray2, stringArray2, this.allDDRowVars, this.allDDColVars, this.ddVarNames, n2, stringArray, this.moduleDDRowVars, this.moduleDDColVars, this.numVars, this.varList, this.varDDRowVars, this.varDDColVars, values);
        }
        model.setSynchs(this.synchs);
        if (this.modelType != ModelType.MDP) {
            model.setTransPerAction(this.transPerAction.toArray(new JDDNode[0]));
        } else {
            model.setTransActions(this.transActions);
        }
        if (this.prism.getDoReach()) {
            this.mainLog.print("\nComputing reachable states...\n");
            model.doReachability();
            model.filterReachableStates();
        } else {
            this.mainLog.print("\nSkipping reachable state computation.\n");
            model.skipReachability();
            model.filterReachableStates();
        }
        if (this.prism.getExtraDDInfo()) {
            this.mainLog.print("Reach: " + JDD.GetNumNodes(model.getReach()) + " nodes\n");
        }
        model.findDeadlocks(this.prism.getFixDeadlocks());
        JDD.Deref(this.moduleIdentities[0]);
        JDD.Deref(this.moduleRangeDDs[0]);
        for (n = 0; n < this.numVars; ++n) {
            JDD.Deref(this.varIdentities[n]);
            JDD.Deref(this.varRangeDDs[n]);
            JDD.Deref(this.varColRangeDDs[n]);
        }
        JDD.Deref(this.range);
        if (this.modelType == ModelType.MDP) {
            for (n = 0; n < this.ddSynchVars.length; ++n) {
                JDD.Deref(this.ddSynchVars[n]);
            }
            for (n = 0; n < this.ddSchedVars.length; ++n) {
                JDD.Deref(this.ddSchedVars[n]);
            }
            for (n = 0; n < this.ddChoiceVars.length; ++n) {
                JDD.Deref(this.ddChoiceVars[n]);
            }
        }
        return model;
    }

    private void computeMaxChoicesFromFile() throws PrismException {
        int n = 0;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.transFile));
            bufferedReader.readLine();
            n = 1;
            String string = bufferedReader.readLine();
            ++n;
            this.maxNumChoices = 0;
            while (string != null) {
                if ((string = string.trim()).length() > 0) {
                    String[] stringArray = string.split(" ");
                    if (stringArray.length < 4 || stringArray.length > 5) {
                        throw new PrismException("");
                    }
                    int n2 = Integer.parseInt(stringArray[1]);
                    if (n2 + 1 > this.maxNumChoices) {
                        this.maxNumChoices = n2 + 1;
                    }
                }
                string = bufferedReader.readLine();
                ++n;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new PrismException("File I/O error reading from \"" + this.transFile + "\"");
        }
        catch (NumberFormatException numberFormatException) {
            throw new PrismException("Error detected at line " + n + " of transition matrix file \"" + this.transFile + "\"");
        }
        catch (PrismException prismException) {
            throw new PrismException("Error detected " + prismException.getMessage() + "at line " + n + " of transition matrix file \"" + this.transFile + "\"");
        }
    }

    private void allocateDDVars() {
        int n;
        int n2 = 0;
        this.ddVarNames = new Vector();
        if (this.modelType == ModelType.MDP) {
            this.ddSynchVars = new JDDNode[0];
            this.ddSchedVars = new JDDNode[0];
            this.ddChoiceVars = new JDDNode[this.maxNumChoices];
        }
        this.varDDRowVars = new JDDVars[this.numVars];
        this.varDDColVars = new JDDVars[this.numVars];
        for (n = 0; n < this.numVars; ++n) {
            this.varDDRowVars[n] = new JDDVars();
            this.varDDColVars[n] = new JDDVars();
        }
        if (this.modelType == ModelType.MDP) {
            for (n = 0; n < this.maxNumChoices; ++n) {
                JDDNode jDDNode;
                this.ddChoiceVars[n] = jDDNode = JDD.Var(n2++);
                this.ddVarNames.add("l" + n);
            }
        }
        for (n = 0; n < this.numVars; ++n) {
            int n3 = this.varList.getRangeLogTwo(n);
            for (int i = 0; i < n3; ++i) {
                JDDNode jDDNode = JDD.Var(n2++);
                JDDNode jDDNode2 = JDD.Var(n2++);
                this.varDDRowVars[n].addVar(jDDNode);
                this.varDDColVars[n].addVar(jDDNode2);
                this.ddVarNames.add(this.varList.getName(n) + "." + i);
                this.ddVarNames.add(this.varList.getName(n) + "'." + i);
            }
        }
    }

    private void sortDDVars() {
        int n;
        this.moduleDDRowVars = new JDDVars[1];
        this.moduleDDColVars = new JDDVars[1];
        this.moduleDDRowVars[0] = new JDDVars();
        this.moduleDDColVars[0] = new JDDVars();
        for (n = 0; n < this.numVars; ++n) {
            this.varDDRowVars[n].refAll();
            this.varDDColVars[n].refAll();
            this.moduleDDRowVars[0].addVars(this.varDDRowVars[n]);
            this.moduleDDColVars[0].addVars(this.varDDColVars[n]);
        }
        this.allDDRowVars = new JDDVars();
        this.allDDColVars = new JDDVars();
        if (this.modelType == ModelType.MDP) {
            this.allDDSynchVars = new JDDVars();
            this.allDDSchedVars = new JDDVars();
            this.allDDChoiceVars = new JDDVars();
            this.allDDNondetVars = new JDDVars();
        }
        for (n = 0; n < this.numVars; ++n) {
            this.varDDRowVars[n].refAll();
            this.varDDColVars[n].refAll();
            this.allDDRowVars.addVars(this.varDDRowVars[n]);
            this.allDDColVars.addVars(this.varDDColVars[n]);
        }
        if (this.modelType == ModelType.MDP) {
            for (n = 0; n < this.ddChoiceVars.length; ++n) {
                JDD.Ref(this.ddChoiceVars[n]);
                JDD.Ref(this.ddChoiceVars[n]);
                this.allDDChoiceVars.addVar(this.ddChoiceVars[n]);
                this.allDDNondetVars.addVar(this.ddChoiceVars[n]);
            }
        }
    }

    private void sortIdentities() {
        int n;
        JDDNode jDDNode;
        this.varIdentities = new JDDNode[this.numVars];
        for (int i = 0; i < this.numVars; ++i) {
            jDDNode = JDD.Constant(0.0);
            for (n = 0; n < this.varList.getRange(i); ++n) {
                jDDNode = JDD.SetMatrixElement(jDDNode, this.varDDRowVars[i], this.varDDColVars[i], n, n, 1.0);
            }
            this.varIdentities[i] = jDDNode;
        }
        this.moduleIdentities = new JDDNode[1];
        jDDNode = JDD.Constant(1.0);
        for (n = 0; n < this.numVars; ++n) {
            if (this.varList.getModule(n) != 0) continue;
            JDD.Ref(this.varIdentities[n]);
            jDDNode = JDD.Apply(3, jDDNode, this.varIdentities[n]);
        }
        this.moduleIdentities[0] = jDDNode;
    }

    private void sortRanges() {
        this.range = JDD.Constant(1.0);
        this.varRangeDDs = new JDDNode[this.numVars];
        this.varColRangeDDs = new JDDNode[this.numVars];
        for (int i = 0; i < this.numVars; ++i) {
            JDD.Ref(this.varIdentities[i]);
            this.varRangeDDs[i] = JDD.SumAbstract(this.varIdentities[i], this.varDDColVars[i]);
            JDD.Ref(this.varIdentities[i]);
            this.varColRangeDDs[i] = JDD.SumAbstract(this.varIdentities[i], this.varDDRowVars[i]);
            JDD.Ref(this.varRangeDDs[i]);
            this.range = JDD.Apply(3, this.range, this.varRangeDDs[i]);
        }
        this.moduleRangeDDs = new JDDNode[1];
        JDD.Ref(this.moduleIdentities[0]);
        this.moduleRangeDDs[0] = JDD.SumAbstract(this.moduleIdentities[0], this.moduleDDColVars[0]);
    }

    private void buildTrans() throws PrismException {
        int n = 0;
        int n2 = 0;
        this.synchs = new Vector();
        this.trans = JDD.Constant(0.0);
        this.transRewards = JDD.Constant(0.0);
        if (this.modelType != ModelType.MDP) {
            this.transPerAction = new Vector();
            this.transPerAction.add(JDD.Constant(0.0));
        } else {
            this.transActions = JDD.Constant(0.0);
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.transFile));
            bufferedReader.readLine();
            n2 = 1;
            String string = bufferedReader.readLine();
            ++n2;
            while (string != null) {
                if ((string = string.trim()).length() > 0) {
                    JDDNode jDDNode;
                    int n3;
                    JDDNode jDDNode2;
                    double d;
                    int n4;
                    int n5;
                    String string2 = "";
                    String[] stringArray = string.split(" ");
                    if (this.modelType != ModelType.MDP) {
                        if (stringArray.length < 3 || stringArray.length > 4) {
                            throw new PrismException("");
                        }
                        n5 = Integer.parseInt(stringArray[0]);
                        n4 = Integer.parseInt(stringArray[1]);
                        d = Double.parseDouble(stringArray[2]);
                        if (stringArray.length == 4) {
                            string2 = stringArray[3];
                        }
                    } else {
                        if (stringArray.length < 4 || stringArray.length > 5) {
                            throw new PrismException("");
                        }
                        n5 = Integer.parseInt(stringArray[0]);
                        n = Integer.parseInt(stringArray[1]);
                        n4 = Integer.parseInt(stringArray[2]);
                        d = Double.parseDouble(stringArray[3]);
                        if (stringArray.length == 5) {
                            string2 = stringArray[4];
                        }
                    }
                    if (this.statesFile == null) {
                        jDDNode2 = this.modelType != ModelType.MDP ? JDD.SetMatrixElement(JDD.Constant(0.0), this.varDDRowVars[0], this.varDDColVars[0], n5, n4, 1.0) : JDD.Set3DMatrixElement(JDD.Constant(0.0), this.varDDRowVars[0], this.varDDColVars[0], this.allDDChoiceVars, n5, n4, n, 1.0);
                    } else {
                        jDDNode2 = JDD.Constant(1.0);
                        for (int i = 0; i < this.numVars; ++i) {
                            jDDNode2 = JDD.Apply(3, jDDNode2, JDD.SetVectorElement(JDD.Constant(0.0), this.varDDRowVars[i], this.statesArray[n5][i], 1.0));
                            jDDNode2 = JDD.Apply(3, jDDNode2, JDD.SetVectorElement(JDD.Constant(0.0), this.varDDColVars[i], this.statesArray[n4][i], 1.0));
                        }
                        if (this.modelType == ModelType.MDP) {
                            jDDNode2 = JDD.Apply(3, jDDNode2, JDD.SetVectorElement(JDD.Constant(0.0), this.allDDChoiceVars, n, 1.0));
                        }
                    }
                    JDD.Ref(jDDNode2);
                    this.trans = JDD.Apply(1, this.trans, JDD.Apply(3, JDD.Constant(d), jDDNode2));
                    if (!"".equals(string2)) {
                        n3 = this.synchs.indexOf(string2);
                        if (n3 == -1) {
                            this.synchs.add(string2);
                            n3 = this.synchs.size() - 1;
                        }
                        ++n3;
                    } else {
                        n3 = 0;
                    }
                    if (this.modelType != ModelType.MDP) {
                        if (n3 < this.transPerAction.size()) {
                            jDDNode = this.transPerAction.get(n3);
                        } else {
                            jDDNode = JDD.Constant(0.0);
                            this.transPerAction.add(jDDNode);
                        }
                        JDD.Ref(jDDNode2);
                        jDDNode = JDD.Apply(1, jDDNode, JDD.Apply(3, JDD.Constant(d), jDDNode2));
                        this.transPerAction.set(n3, jDDNode);
                    } else {
                        JDD.Ref(jDDNode2);
                        jDDNode = JDD.ThereExists(jDDNode2, this.allDDColVars);
                        this.transActions = JDD.Apply(6, this.transActions, JDD.Apply(3, JDD.Constant(n3), jDDNode));
                    }
                    JDD.Deref(jDDNode2);
                }
                string = bufferedReader.readLine();
                ++n2;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new PrismException("File I/O error reading from \"" + this.transFile + "\"");
        }
        catch (NumberFormatException numberFormatException) {
            throw new PrismException("Error detected at line " + n2 + " of transition matrix file \"" + this.transFile + "\"");
        }
        catch (PrismException prismException) {
            throw new PrismException("Error detected " + prismException.getMessage() + "at line " + n2 + " of transition matrix file \"" + this.transFile + "\"");
        }
    }

    private void buildInit() throws PrismException {
        int n = 0;
        int n2 = 0;
        if (this.labelsFile == null) {
            this.start = JDD.Constant(1.0);
            for (int i = 0; i < this.numVars; ++i) {
                JDDNode jDDNode = JDD.SetVectorElement(JDD.Constant(0.0), this.varDDRowVars[i], 0L, 1.0);
                this.start = JDD.And(this.start, jDDNode);
            }
        } else {
            this.start = JDD.Constant(0.0);
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(this.labelsFile));
                bufferedReader.readLine();
                n = 1;
                String string = bufferedReader.readLine();
                ++n;
                while (string != null) {
                    if ((string = string.trim()).length() > 0) {
                        String[] stringArray = string.split(":");
                        String string2 = stringArray[0].trim();
                        String string3 = stringArray[1].trim();
                        stringArray = string3.split(" ");
                        for (int i = 0; i < stringArray.length; ++i) {
                            JDDNode jDDNode;
                            if (!stringArray[i].trim().equals("0")) continue;
                            ++n2;
                            int n3 = Integer.parseInt(string2);
                            if (this.statesFile == null) {
                                jDDNode = JDD.SetVectorElement(JDD.Constant(0.0), this.varDDRowVars[0], n3, 1.0);
                            } else {
                                jDDNode = JDD.Constant(1.0);
                                for (i = 0; i < this.numVars; ++i) {
                                    jDDNode = JDD.Apply(3, jDDNode, JDD.SetVectorElement(JDD.Constant(0.0), this.varDDRowVars[i], this.statesArray[n3][i], 1.0));
                                }
                            }
                            JDD.Ref(jDDNode);
                            this.start = JDD.Or(this.start, jDDNode);
                            JDD.Deref(jDDNode);
                        }
                    }
                    string = bufferedReader.readLine();
                    ++n;
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                throw new PrismException("File I/O error reading from \"" + this.statesFile + "\"");
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrismException("Error detected at line " + n + " of states file \"" + this.statesFile + "\"");
            }
            if (n2 < 1) {
                throw new PrismException("No initial states found in labels file");
            }
        }
    }

    private void computeStateRewards() throws PrismException {
        int n = 0;
        this.stateRewards = JDD.Constant(0.0);
        if (this.statesFile == null) {
            return;
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.statesFile));
            bufferedReader.readLine();
            n = 1;
            String string = bufferedReader.readLine();
            ++n;
            while (string != null) {
                if ((string = string.trim()).length() > 0) {
                    String[] stringArray = string.split(":");
                    int n2 = Integer.parseInt(stringArray[0]);
                    if ((stringArray = stringArray[1].split("=")).length == 2) {
                        JDDNode jDDNode;
                        double d = Double.parseDouble(stringArray[1]);
                        if (this.statesFile == null) {
                            jDDNode = JDD.SetVectorElement(JDD.Constant(0.0), this.varDDRowVars[0], n2, 1.0);
                        } else {
                            jDDNode = JDD.Constant(1.0);
                            for (int i = 0; i < this.numVars; ++i) {
                                jDDNode = JDD.Apply(3, jDDNode, JDD.SetVectorElement(JDD.Constant(0.0), this.varDDRowVars[i], this.statesArray[n2][i], 1.0));
                            }
                        }
                        this.stateRewards = JDD.Apply(1, this.stateRewards, JDD.Apply(3, JDD.Constant(d), jDDNode));
                    }
                }
                string = bufferedReader.readLine();
                ++n;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new PrismException("File I/O error reading from \"" + this.statesFile + "\"");
        }
        catch (NumberFormatException numberFormatException) {
            throw new PrismException("Error detected at line " + n + " of states file \"" + this.statesFile + "\"");
        }
    }
}

