/*
 * Decompiled with CFR 0.152.
 */
package parser.visitor;

import parser.ast.Command;
import parser.ast.ConstantList;
import parser.ast.Declaration;
import parser.ast.DeclarationArray;
import parser.ast.DeclarationInt;
import parser.ast.Expression;
import parser.ast.ExpressionBinaryOp;
import parser.ast.ExpressionConstant;
import parser.ast.ExpressionExists;
import parser.ast.ExpressionFilter;
import parser.ast.ExpressionForAll;
import parser.ast.ExpressionFormula;
import parser.ast.ExpressionFunc;
import parser.ast.ExpressionITE;
import parser.ast.ExpressionIdent;
import parser.ast.ExpressionLabel;
import parser.ast.ExpressionLiteral;
import parser.ast.ExpressionProb;
import parser.ast.ExpressionProp;
import parser.ast.ExpressionReward;
import parser.ast.ExpressionSS;
import parser.ast.ExpressionStrategy;
import parser.ast.ExpressionTemporal;
import parser.ast.ExpressionUnaryOp;
import parser.ast.ExpressionVar;
import parser.ast.FormulaList;
import parser.ast.LabelList;
import parser.ast.ModulesFile;
import parser.ast.PropertiesFile;
import parser.ast.Property;
import parser.ast.RewardStructItem;
import parser.ast.Update;
import parser.ast.Updates;
import parser.type.Type;
import parser.type.TypeBool;
import parser.type.TypeClock;
import parser.type.TypeDouble;
import parser.type.TypeInt;
import parser.type.TypeInterval;
import parser.type.TypePathBool;
import parser.type.TypePathDouble;
import parser.type.TypeVoid;
import parser.visitor.ASTTraverse;
import prism.PrismLangException;

public class TypeCheck
extends ASTTraverse {
    private PropertiesFile propertiesFile = null;

    public TypeCheck() {
        this.propertiesFile = null;
    }

    public TypeCheck(PropertiesFile propertiesFile) {
        this.propertiesFile = propertiesFile;
    }

    @Override
    public void visitPost(ModulesFile modulesFile) throws PrismLangException {
        if (modulesFile.getInitialStates() != null && !(modulesFile.getInitialStates().getType() instanceof TypeBool)) {
            throw new PrismLangException("Type error: Initial states definition must be Boolean", modulesFile.getInitialStates());
        }
    }

    @Override
    public void visitPost(Property property) throws PrismLangException {
        property.setType(property.getExpression().getType());
    }

    @Override
    public void visitPost(FormulaList formulaList) throws PrismLangException {
    }

    @Override
    public void visitPost(LabelList labelList) throws PrismLangException {
        int n = labelList.size();
        for (int i = 0; i < n; ++i) {
            if (labelList.getLabel(i).getType() instanceof TypeBool) continue;
            throw new PrismLangException("Type error: Label \"" + labelList.getLabelName(i) + "\" is not Boolean", labelList.getLabel(i));
        }
    }

    @Override
    public void visitPost(ConstantList constantList) throws PrismLangException {
        int n = constantList.size();
        for (int i = 0; i < n; ++i) {
            if (constantList.getConstant(i) == null || constantList.getConstantType(i).canAssign(constantList.getConstant(i).getType())) continue;
            throw new PrismLangException("Type mismatch in definition of constant \"" + constantList.getConstantName(i) + "\"", constantList.getConstant(i));
        }
    }

    @Override
    public void visitPost(Declaration declaration) throws PrismLangException {
        if (declaration.getStart() != null && !declaration.getType().canAssign(declaration.getStart().getType())) {
            throw new PrismLangException("Type error: Initial value of variable \"" + declaration.getName() + "\" does not match", declaration.getStart());
        }
    }

    @Override
    public void visitPost(DeclarationInt declarationInt) throws PrismLangException {
        if (declarationInt.getLow() != null && !TypeInt.getInstance().canAssign(declarationInt.getLow().getType())) {
            throw new PrismLangException("Type error: Integer range lower bound \"" + declarationInt.getLow() + "\" is not an integer", declarationInt.getLow());
        }
        if (declarationInt.getHigh() != null && !TypeInt.getInstance().canAssign(declarationInt.getHigh().getType())) {
            throw new PrismLangException("Type error: Integer range upper bound \"" + declarationInt.getHigh() + "\" is not an integer", declarationInt.getHigh());
        }
    }

    @Override
    public void visitPost(DeclarationArray declarationArray) throws PrismLangException {
        if (declarationArray.getLow() != null && !TypeInt.getInstance().canAssign(declarationArray.getLow().getType())) {
            throw new PrismLangException("Type error: Array lower bound \"" + declarationArray.getLow() + "\" is not an integer", declarationArray.getLow());
        }
        if (declarationArray.getHigh() != null && !TypeInt.getInstance().canAssign(declarationArray.getHigh().getType())) {
            throw new PrismLangException("Type error: Array upper bound \"" + declarationArray.getHigh() + "\" is not an integer", declarationArray.getHigh());
        }
    }

    @Override
    public void visitPost(Command command) throws PrismLangException {
        if (!(command.getGuard().getType() instanceof TypeBool)) {
            throw new PrismLangException("Type error: Guard is not Boolean", command.getGuard());
        }
    }

    @Override
    public void visitPost(Updates updates) throws PrismLangException {
        int n = updates.getNumUpdates();
        for (int i = 0; i < n; ++i) {
            if (updates.getProbability(i) == null || TypeDouble.getInstance().canAssign(updates.getProbability(i).getType())) continue;
            throw new PrismLangException("Type error: Update probability/rate must evaluate to a double", updates.getProbability(i));
        }
    }

    @Override
    public void visitPost(Update update) throws PrismLangException {
        int n = update.getNumElements();
        for (int i = 0; i < n; ++i) {
            if (!(update.getType(i) instanceof TypeClock)) {
                if (update.getType(i).canAssign(update.getExpression(i).getType())) continue;
                throw new PrismLangException("Type error in update to variable \"" + update.getVar(i) + "\"", update.getExpression(i));
            }
            if (!update.getExpression(i).getType().equals(TypeInt.getInstance())) {
                throw new PrismLangException("Clocks can only be reset to constant integer values", update);
            }
            if (update.getExpression(i).isConstant()) continue;
            throw new PrismLangException("Clocks can only be reset to constant integer values", update);
        }
    }

    @Override
    public void visitPost(RewardStructItem rewardStructItem) throws PrismLangException {
        if (!(rewardStructItem.getStates().getType() instanceof TypeBool)) {
            throw new PrismLangException("Type error in reward struct item: guard must be Boolean", rewardStructItem.getStates());
        }
        if (!TypeDouble.getInstance().canAssign(rewardStructItem.getReward().getType())) {
            throw new PrismLangException("Type error in reward struct item: value must be an int or double", rewardStructItem.getReward());
        }
    }

    @Override
    public void visitPost(ExpressionTemporal expressionTemporal) throws PrismLangException {
        if (expressionTemporal.getLowerBound() != null && !TypeDouble.getInstance().canAssign(expressionTemporal.getLowerBound().getType())) {
            throw new PrismLangException("Type error: Lower bound in " + expressionTemporal.getOperatorSymbol() + " operator must be an int or double", expressionTemporal.getLowerBound());
        }
        if (expressionTemporal.getUpperBound() != null && !TypeDouble.getInstance().canAssign(expressionTemporal.getUpperBound().getType())) {
            throw new PrismLangException("Type error: Upper bound in " + expressionTemporal.getOperatorSymbol() + " operator must be an int or double", expressionTemporal.getUpperBound());
        }
        switch (expressionTemporal.getOperator()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                Type type;
                if (expressionTemporal.getOperand1() != null && !((type = expressionTemporal.getOperand1().getType()) instanceof TypeBool) && !(type instanceof TypePathBool)) {
                    throw new PrismLangException("Type error: Argument of " + expressionTemporal.getOperatorSymbol() + " operator is not Boolean", expressionTemporal.getOperand1());
                }
                if (expressionTemporal.getOperand2() != null && !((type = expressionTemporal.getOperand2().getType()) instanceof TypeBool) && !(type instanceof TypePathBool)) {
                    throw new PrismLangException("Type error: Argument of " + expressionTemporal.getOperatorSymbol() + " operator is not Boolean", expressionTemporal.getOperand2());
                }
                expressionTemporal.setType(TypePathBool.getInstance());
                break;
            }
            case 13: {
                Type type;
                if (expressionTemporal.getOperand2() != null && !((type = expressionTemporal.getOperand2().getType()) instanceof TypeBool) && !(type instanceof TypePathBool)) {
                    throw new PrismLangException("Type error: Argument of " + expressionTemporal.getOperatorSymbol() + " operator is not Boolean", expressionTemporal.getOperand2());
                }
                expressionTemporal.setType(TypePathDouble.getInstance());
                break;
            }
            case 11: 
            case 12: 
            case 14: {
                expressionTemporal.setType(TypePathDouble.getInstance());
            }
        }
    }

    @Override
    public void visitPost(ExpressionITE expressionITE) throws PrismLangException {
        Type type = expressionITE.getOperand1().getType();
        Type type2 = expressionITE.getOperand2().getType();
        Type type3 = expressionITE.getOperand3().getType();
        if (!(type instanceof TypeBool)) {
            throw new PrismLangException("Type error: condition of ? operator is not Boolean", expressionITE.getOperand1());
        }
        if (!type2.canAssign(type3) && !type3.canAssign(type2)) {
            throw new PrismLangException("Type error: types for then/else operands of ? operator must match", expressionITE);
        }
        if (type2 instanceof TypeBool) {
            expressionITE.setType(TypeBool.getInstance());
        } else if (type2 instanceof TypeInt && type3 instanceof TypeInt) {
            expressionITE.setType(TypeInt.getInstance());
        } else {
            expressionITE.setType(TypeDouble.getInstance());
        }
    }

    @Override
    public void visitPost(ExpressionBinaryOp expressionBinaryOp) throws PrismLangException {
        Type type = expressionBinaryOp.getOperand1().getType();
        if (type == null) {
            expressionBinaryOp.getOperand1().getType();
        }
        Type type2 = expressionBinaryOp.getOperand2().getType();
        switch (expressionBinaryOp.getOperator()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                if (!(type instanceof TypeBool) && !(type instanceof TypePathBool)) {
                    throw new PrismLangException("Type error: " + expressionBinaryOp.getOperatorSymbol() + " applied to non-Boolean expression", expressionBinaryOp.getOperand1());
                }
                if (!(type2 instanceof TypeBool) && !(type2 instanceof TypePathBool)) {
                    throw new PrismLangException("Type error: " + expressionBinaryOp.getOperatorSymbol() + " applied to non-Boolean expression", expressionBinaryOp.getOperand2());
                }
                expressionBinaryOp.setType(type instanceof TypePathBool || type2 instanceof TypePathBool ? TypePathBool.getInstance() : TypeBool.getInstance());
                break;
            }
            case 5: 
            case 6: {
                boolean bl = false;
                if (type instanceof TypeBool && type2 instanceof TypeBool) {
                    bl = true;
                } else if ((type instanceof TypeInt || type instanceof TypeDouble) && (type2 instanceof TypeInt || type2 instanceof TypeDouble)) {
                    bl = true;
                } else if ((type instanceof TypeInt || type instanceof TypeClock) && (type2 instanceof TypeInt || type2 instanceof TypeClock)) {
                    bl = true;
                }
                if (!bl) {
                    if (type.equals(type2)) {
                        throw new PrismLangException("Type error: " + expressionBinaryOp.getOperatorSymbol() + " cannot compare " + type + "s", expressionBinaryOp);
                    }
                    throw new PrismLangException("Type error: " + expressionBinaryOp.getOperatorSymbol() + " cannot compare " + type + " and " + type2, expressionBinaryOp);
                }
                expressionBinaryOp.setType(TypeBool.getInstance());
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                boolean bl = false;
                if ((type instanceof TypeInt || type instanceof TypeDouble) && (type2 instanceof TypeInt || type2 instanceof TypeDouble)) {
                    bl = true;
                } else if ((type instanceof TypeInt || type instanceof TypeClock) && (type2 instanceof TypeInt || type2 instanceof TypeClock)) {
                    bl = true;
                }
                if (!bl) {
                    if (type.equals(type2)) {
                        throw new PrismLangException("Type error: " + expressionBinaryOp.getOperatorSymbol() + " cannot compare " + type + "s", expressionBinaryOp);
                    }
                    throw new PrismLangException("Type error: " + expressionBinaryOp.getOperatorSymbol() + " cannot compare " + type + " and " + type2, expressionBinaryOp);
                }
                expressionBinaryOp.setType(TypeBool.getInstance());
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                if (!(type instanceof TypeInt) && !(type instanceof TypeDouble)) {
                    throw new PrismLangException("Type error: " + expressionBinaryOp.getOperatorSymbol() + " can only be applied to ints or doubles", expressionBinaryOp.getOperand1());
                }
                if (!(type2 instanceof TypeInt) && !(type2 instanceof TypeDouble)) {
                    throw new PrismLangException("Type error: " + expressionBinaryOp.getOperatorSymbol() + " can only be applied to ints or doubles", expressionBinaryOp.getOperand2());
                }
                expressionBinaryOp.setType(type instanceof TypeDouble || type2 instanceof TypeDouble ? TypeDouble.getInstance() : TypeInt.getInstance());
                break;
            }
            case 14: {
                if (!(type instanceof TypeInt) && !(type instanceof TypeDouble)) {
                    throw new PrismLangException("Type error: " + expressionBinaryOp.getOperatorSymbol() + " can only be applied to ints or doubles", expressionBinaryOp.getOperand1());
                }
                if (!(type2 instanceof TypeInt) && !(type2 instanceof TypeDouble)) {
                    throw new PrismLangException("Type error: " + expressionBinaryOp.getOperatorSymbol() + " can only be applied to ints or doubles", expressionBinaryOp.getOperand2());
                }
                expressionBinaryOp.setType(TypeDouble.getInstance());
            }
        }
    }

    @Override
    public void visitPost(ExpressionUnaryOp expressionUnaryOp) throws PrismLangException {
        Type type = expressionUnaryOp.getOperand().getType();
        switch (expressionUnaryOp.getOperator()) {
            case 1: {
                if (!(type instanceof TypeBool) && !(type instanceof TypePathBool)) {
                    throw new PrismLangException("Type error: " + expressionUnaryOp.getOperatorSymbol() + " applied to non-Boolean expression", expressionUnaryOp.getOperand());
                }
                expressionUnaryOp.setType(type);
                break;
            }
            case 2: {
                if (!(type instanceof TypeInt) && !(type instanceof TypeDouble)) {
                    throw new PrismLangException("Type error: " + expressionUnaryOp.getOperatorSymbol() + " can only be applied to ints or doubles", expressionUnaryOp.getOperand());
                }
                expressionUnaryOp.setType(type);
                break;
            }
            case 3: {
                expressionUnaryOp.setType(type);
            }
        }
    }

    @Override
    public void visitPost(ExpressionFunc expressionFunc) throws PrismLangException {
        int n;
        int n2 = expressionFunc.getNumOperands();
        Type[] typeArray = new Type[n2];
        for (n = 0; n < n2; ++n) {
            typeArray[n] = expressionFunc.getOperand(n).getType();
        }
        switch (expressionFunc.getNameCode()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                for (n = 0; n < n2; ++n) {
                    if (!(typeArray[n] instanceof TypeBool)) continue;
                    throw new PrismLangException("Type error: Boolean argument not allowed as argument to function \"" + expressionFunc.getName() + "\"", expressionFunc.getOperand(n));
                }
                break;
            }
            case 5: {
                for (n = 0; n < n2; ++n) {
                    if (typeArray[n] instanceof TypeInt) continue;
                    throw new PrismLangException("Type error: non-integer argument to  function \"" + expressionFunc.getName() + "\"", expressionFunc.getOperand(n));
                }
                break;
            }
            case 7: {
                for (n = 0; n < n2; ++n) {
                    if (typeArray[n] instanceof TypeBool || typeArray[n] instanceof TypeDouble) continue;
                    throw new PrismLangException("Type error: non-Boolean/Double argument to  function \"" + expressionFunc.getName() + "\"", expressionFunc.getOperand(n));
                }
                break;
            }
            default: {
                throw new PrismLangException("Cannot type check unknown function", expressionFunc);
            }
        }
        block5 : switch (expressionFunc.getNameCode()) {
            case 0: 
            case 1: {
                expressionFunc.setType(TypeInt.getInstance());
                for (n = 0; n < n2; ++n) {
                    if (!(typeArray[n] instanceof TypeDouble)) continue;
                    expressionFunc.setType(TypeDouble.getInstance());
                    break block5;
                }
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                expressionFunc.setType(TypeInt.getInstance());
                break;
            }
            case 4: {
                expressionFunc.setType(typeArray[0] instanceof TypeDouble || typeArray[1] instanceof TypeDouble ? TypeDouble.getInstance() : TypeInt.getInstance());
                break;
            }
            case 6: {
                expressionFunc.setType(TypeDouble.getInstance());
                break;
            }
            case 7: {
                if (typeArray[0] instanceof TypeBool) {
                    expressionFunc.setType(TypeBool.getInstance());
                    break;
                }
                if (typeArray.length == 1 || typeArray[1] instanceof TypeBool) {
                    expressionFunc.setType(TypeDouble.getInstance());
                    break;
                }
                expressionFunc.setType(TypeVoid.getInstance());
            }
        }
    }

    @Override
    public void visitPost(ExpressionIdent expressionIdent) throws PrismLangException {
        throw new PrismLangException("Cannot determine type of unknown identifier", expressionIdent);
    }

    @Override
    public void visitPost(ExpressionLiteral expressionLiteral) throws PrismLangException {
    }

    @Override
    public void visitPost(ExpressionConstant expressionConstant) throws PrismLangException {
    }

    @Override
    public void visitPost(ExpressionFormula expressionFormula) throws PrismLangException {
        if (expressionFormula.getDefinition() == null) {
            throw new PrismLangException("Cannot determine type of formula", expressionFormula);
        }
        expressionFormula.setType(expressionFormula.getDefinition().getType());
    }

    @Override
    public void visitPost(ExpressionVar expressionVar) throws PrismLangException {
    }

    @Override
    public void visitPost(ExpressionProb expressionProb) throws PrismLangException {
        if (expressionProb.getProb() != null && !TypeDouble.getInstance().canAssign(expressionProb.getProb().getType())) {
            throw new PrismLangException("Type error: P operator probability bound is not a double", expressionProb.getProb());
        }
        if (expressionProb.getFilter() != null && !(expressionProb.getFilter().getExpression().getType() instanceof TypeBool)) {
            throw new PrismLangException("Type error: P operator filter is not a Boolean", expressionProb.getFilter().getExpression());
        }
        if (expressionProb.getProb() != null && expressionProb.getFilter() != null && (expressionProb.getFilter().minRequested() || expressionProb.getFilter().maxRequested())) {
            throw new PrismLangException("Type error: Cannot use min/max filters in Boolean-valued properties");
        }
        if (!(expressionProb.getExpression().getType() instanceof TypePathBool) && !(expressionProb.getExpression().getType() instanceof TypeBool)) {
            throw new PrismLangException("Type error: Contents of P operator is not a path formula", expressionProb.getExpression());
        }
        expressionProb.setType(expressionProb.getProb() == null ? TypeDouble.getInstance() : TypeBool.getInstance());
    }

    @Override
    public void visitPost(ExpressionReward expressionReward) throws PrismLangException {
        Expression expression;
        if (expressionReward.getRewardStructIndex() != null && expressionReward.getRewardStructIndex() instanceof Expression && !((expression = (Expression)expressionReward.getRewardStructIndex()).getType() instanceof TypeInt)) {
            throw new PrismLangException("Type error: Reward structure index must be string or integer", expression);
        }
        if (expressionReward.getRewardStructIndexDiv() != null && expressionReward.getRewardStructIndexDiv() instanceof Expression && !((expression = (Expression)expressionReward.getRewardStructIndexDiv()).getType() instanceof TypeInt)) {
            throw new PrismLangException("Type error: Reward structure index must be string or integer", expression);
        }
        if (expressionReward.getReward() != null && !TypeDouble.getInstance().canAssign(expressionReward.getReward().getType())) {
            throw new PrismLangException("Type error: R operator reward bound is not a double", expressionReward.getReward());
        }
        if (expressionReward.getFilter() != null && !(expressionReward.getFilter().getExpression().getType() instanceof TypeBool)) {
            throw new PrismLangException("Type error: R operator filter is not a Boolean", expressionReward.getFilter().getExpression());
        }
        if (expressionReward.getReward() != null && expressionReward.getFilter() != null && (expressionReward.getFilter().minRequested() || expressionReward.getFilter().maxRequested())) {
            throw new PrismLangException("Type error: Cannot use min/max filters in Boolean-valued properties");
        }
        if (!(expressionReward.getExpression().getType() instanceof TypePathDouble)) {
            throw new PrismLangException("Type error: Contents of R operator is invalid", expressionReward.getExpression());
        }
        expressionReward.setType(expressionReward.getReward() == null ? TypeDouble.getInstance() : TypeBool.getInstance());
    }

    @Override
    public void visitPost(ExpressionSS expressionSS) throws PrismLangException {
        if (expressionSS.getProb() != null && !TypeDouble.getInstance().canAssign(expressionSS.getProb().getType())) {
            throw new PrismLangException("Type error: S operator probability bound is not a double", expressionSS.getProb());
        }
        if (expressionSS.getFilter() != null && !(expressionSS.getFilter().getExpression().getType() instanceof TypeBool)) {
            throw new PrismLangException("Type error: S operator filter is not a Boolean", expressionSS.getFilter().getExpression());
        }
        if (expressionSS.getProb() != null && expressionSS.getFilter() != null && (expressionSS.getFilter().minRequested() || expressionSS.getFilter().maxRequested())) {
            throw new PrismLangException("Type error: Cannot use min/max filters in Boolean-valued properties");
        }
        if (!(expressionSS.getExpression().getType() instanceof TypeBool)) {
            throw new PrismLangException("Type error: Contents of S operator is not a Boolean-valued expression", expressionSS.getExpression());
        }
        expressionSS.setType(expressionSS.getProb() == null ? TypeDouble.getInstance() : TypeBool.getInstance());
    }

    @Override
    public void visitPost(ExpressionExists expressionExists) throws PrismLangException {
        expressionExists.setType(TypeBool.getInstance());
    }

    @Override
    public void visitPost(ExpressionForAll expressionForAll) throws PrismLangException {
        expressionForAll.setType(TypeBool.getInstance());
    }

    @Override
    public void visitPost(ExpressionStrategy expressionStrategy) throws PrismLangException {
        expressionStrategy.setType(expressionStrategy.getExpression().getType());
    }

    @Override
    public void visitPost(ExpressionLabel expressionLabel) throws PrismLangException {
        expressionLabel.setType(TypeBool.getInstance());
    }

    @Override
    public void visitPost(ExpressionProp expressionProp) throws PrismLangException {
        if (this.propertiesFile == null) {
            if (expressionProp.getTypeIfDefined() == null) {
                throw new PrismLangException("No properties file to look up type of property reference " + expressionProp);
            }
        } else {
            Property property = this.propertiesFile.lookUpPropertyObjectByName(expressionProp.getName());
            if (property == null) {
                throw new PrismLangException("Could not look up type of property reference " + expressionProp);
            }
            property.accept(this);
            expressionProp.setType(property.getType());
        }
    }

    @Override
    public void visitPost(ExpressionFilter expressionFilter) throws PrismLangException {
        Type type = expressionFilter.getOperand().getType();
        if (expressionFilter.getFilter() != null && !(expressionFilter.getFilter().getType() instanceof TypeBool)) {
            throw new PrismLangException("Type error: Second argument of filter is not a Boolean", expressionFilter.getFilter());
        }
        switch (expressionFilter.getOperatorType()) {
            case MIN: 
            case MAX: 
            case ARGMIN: 
            case ARGMAX: 
            case SUM: 
            case AVG: 
            case RANGE: {
                if (!(type instanceof TypeBool)) break;
                throw new PrismLangException("Type error: Boolean argument not allowed as operand for filter of type \"" + expressionFilter.getOperatorName() + "\"", expressionFilter.getOperand());
            }
            case COUNT: 
            case FORALL: 
            case EXISTS: {
                if (type instanceof TypeBool) break;
                throw new PrismLangException("Type error: Operand for filter of type \"" + expressionFilter.getOperatorName() + "\" must be Boolean", expressionFilter.getOperand());
            }
            case FIRST: 
            case PRINT: 
            case PRINTALL: 
            case STATE: {
                break;
            }
            default: {
                throw new PrismLangException("Cannot type check filter of unknown type", expressionFilter);
            }
        }
        switch (expressionFilter.getOperatorType()) {
            case MIN: 
            case MAX: 
            case SUM: 
            case FIRST: 
            case PRINT: 
            case PRINTALL: 
            case STATE: {
                expressionFilter.setType(type);
                break;
            }
            case RANGE: {
                expressionFilter.setType(TypeInterval.getInstance(type));
                break;
            }
            case COUNT: {
                expressionFilter.setType(TypeInt.getInstance());
                break;
            }
            case AVG: {
                expressionFilter.setType(TypeDouble.getInstance());
                break;
            }
            case ARGMIN: 
            case ARGMAX: 
            case FORALL: 
            case EXISTS: {
                expressionFilter.setType(TypeBool.getInstance());
            }
        }
    }
}

