/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import java.util.Vector;
import parser.ast.ModulesFile;
import parser.ast.SystemDefn;
import parser.visitor.ASTVisitor;
import prism.PrismLangException;

public class SystemInterleaved
extends SystemDefn {
    private Vector<SystemDefn> operands = new Vector();

    public void addOperand(SystemDefn systemDefn) {
        this.operands.addElement(systemDefn);
    }

    public void setOperand(int n, SystemDefn systemDefn) {
        this.operands.setElementAt(systemDefn, n);
    }

    public int getNumOperands() {
        return this.operands.size();
    }

    public SystemDefn getOperand(int n) {
        return this.operands.elementAt(n);
    }

    @Override
    public void getModules(Vector<String> vector) {
        int n = this.getNumOperands();
        for (int i = 0; i < n; ++i) {
            this.getOperand(i).getModules(vector);
        }
    }

    @Override
    public void getModules(Vector<String> vector, ModulesFile modulesFile) {
        int n = this.getNumOperands();
        for (int i = 0; i < n; ++i) {
            this.getOperand(i).getModules(vector, modulesFile);
        }
    }

    @Override
    public void getSynchs(Vector<String> vector) {
        int n = this.getNumOperands();
        for (int i = 0; i < n; ++i) {
            this.getOperand(i).getSynchs(vector);
        }
    }

    @Override
    public void getSynchs(Vector<String> vector, ModulesFile modulesFile) {
        int n = this.getNumOperands();
        for (int i = 0; i < n; ++i) {
            this.getOperand(i).getSynchs(vector, modulesFile);
        }
    }

    @Override
    public void getReferences(Vector<String> vector) {
        int n = this.getNumOperands();
        for (int i = 0; i < n; ++i) {
            this.getOperand(i).getReferences(vector);
        }
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public String toString() {
        String string = "";
        int n = this.getNumOperands();
        for (int i = 0; i < n - 1; ++i) {
            string = string + this.getOperand(i) + " ||| ";
        }
        if (n > 0) {
            string = string + this.getOperand(n - 1);
        }
        return string;
    }

    @Override
    public SystemDefn deepCopy() {
        SystemInterleaved systemInterleaved = new SystemInterleaved();
        int n = this.getNumOperands();
        for (int i = 0; i < n; ++i) {
            systemInterleaved.addOperand(this.getOperand(i).deepCopy());
        }
        systemInterleaved.setPosition(this);
        return systemInterleaved;
    }
}

