/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import parser.EvaluateContext;
import parser.ast.Expression;
import parser.type.Type;
import parser.visitor.ASTVisitor;
import prism.PrismLangException;

public class ExpressionLiteral
extends Expression {
    Object value;
    String string;

    public ExpressionLiteral(Type type, Object object) {
        this(type, object, "" + object);
    }

    public ExpressionLiteral(Type type, Object object, String string) {
        this.type = type;
        this.value = object;
        this.string = string;
    }

    public void setValue(Object object) {
        this.value = object;
        this.string = "" + object;
    }

    public void setString(String string) {
        this.string = string;
    }

    public Object getValue() {
        return this.value;
    }

    public String getString() {
        return this.string;
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    @Override
    public boolean isProposition() {
        return true;
    }

    @Override
    public Object evaluate(EvaluateContext evaluateContext) throws PrismLangException {
        return this.value;
    }

    @Override
    public boolean returnsSingleValue() {
        return true;
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public String toString() {
        return this.string;
    }

    @Override
    public Expression deepCopy() {
        ExpressionLiteral expressionLiteral = new ExpressionLiteral(this.type, this.value, this.string);
        expressionLiteral.setPosition(this);
        return expressionLiteral;
    }
}

