/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import parser.EvaluateContext;
import parser.ast.Expression;
import parser.ast.ExpressionLabel;
import parser.type.TypeBool;
import parser.visitor.ASTVisitor;
import prism.PrismLangException;

public class ExpressionFilter
extends Expression {
    private FilterOperator opType;
    private String opName;
    private Expression operand;
    private Expression filter;
    private boolean invisible = false;
    private boolean explanationEnabled = true;
    private boolean storeVector = false;
    private boolean param = false;

    public ExpressionFilter(String string, Expression expression) {
        this(string, expression, null);
    }

    public ExpressionFilter(String string, Expression expression, Expression expression2) {
        this.setOperator(string);
        this.setOperand(expression);
        this.setFilter(expression2);
    }

    public void setOperator(String string) {
        this.opName = string;
        this.opType = string.equals("min") ? FilterOperator.MIN : (string.equals("max") ? FilterOperator.MAX : (string.equals("argmin") ? FilterOperator.ARGMIN : (string.equals("argmax") ? FilterOperator.ARGMAX : (string.equals("count") ? FilterOperator.COUNT : (string.equals("sum") || string.equals("+") ? FilterOperator.SUM : (string.equals("avg") ? FilterOperator.AVG : (string.equals("first") ? FilterOperator.FIRST : (string.equals("range") ? FilterOperator.RANGE : (string.equals("forall") || string.equals("&") ? FilterOperator.FORALL : (string.equals("exists") || string.equals("|") ? FilterOperator.EXISTS : (string.equals("print") ? FilterOperator.PRINT : (string.equals("printall") ? FilterOperator.PRINTALL : (string.equals("state") ? FilterOperator.STATE : null)))))))))))));
    }

    public void setOperand(Expression expression) {
        this.operand = expression;
    }

    public void setFilter(Expression expression) {
        this.filter = expression;
    }

    public void setInvisible(boolean bl) {
        this.invisible = bl;
    }

    public void setExplanationEnabled(boolean bl) {
        this.explanationEnabled = bl;
    }

    public void setStoreVector(boolean bl) {
        this.storeVector = bl;
    }

    public void setParam() {
        this.param = true;
    }

    public FilterOperator getOperatorType() {
        return this.opType;
    }

    public String getOperatorName() {
        return this.opName;
    }

    public Expression getOperand() {
        return this.operand;
    }

    public Expression getFilter() {
        return this.filter;
    }

    public boolean isInvisible() {
        return this.invisible;
    }

    public boolean getExplanationEnabled() {
        return this.explanationEnabled;
    }

    public boolean getStoreVector() {
        return this.storeVector;
    }

    public boolean isParam() {
        return this.param;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isProposition() {
        return false;
    }

    @Override
    public Object evaluate(EvaluateContext evaluateContext) throws PrismLangException {
        throw new PrismLangException("Cannot evaluate a filter without a model");
    }

    @Override
    public boolean returnsSingleValue() {
        if (this.opType == FilterOperator.PRINT) {
            return false;
        }
        if (this.opType == FilterOperator.PRINTALL) {
            return false;
        }
        if (this.opType == FilterOperator.ARGMIN) {
            return false;
        }
        if (this.opType == FilterOperator.ARGMAX) {
            return false;
        }
        return !this.param;
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public String toString() {
        String string = "";
        if (this.invisible) {
            return this.operand.toString();
        }
        string = string + (this.param ? "paramfilter(" : "filter(") + this.opName + ", " + this.operand;
        if (this.filter != null) {
            string = string + ", " + this.filter;
        }
        string = string + ")";
        return string;
    }

    @Override
    public Expression deepCopy() {
        ExpressionFilter expressionFilter = new ExpressionFilter(this.opName, this.operand.deepCopy(), this.filter == null ? null : this.filter.deepCopy());
        expressionFilter.setInvisible(this.invisible);
        expressionFilter.setType(this.type);
        expressionFilter.setPosition(this);
        expressionFilter.param = this.param;
        return expressionFilter;
    }

    public static ExpressionFilter addDefaultFilterIfNeeded(Expression expression, boolean bl) throws PrismLangException {
        ExpressionFilter expressionFilter = null;
        if (!expression.returnsSingleValue()) {
            expressionFilter = expression.getType() instanceof TypeBool ? new ExpressionFilter("forall", expression, new ExpressionLabel("init")) : (bl ? new ExpressionFilter("state", expression, new ExpressionLabel("init")) : new ExpressionFilter("range", expression, new ExpressionLabel("init")));
        } else if (!(expression instanceof ExpressionFilter)) {
            expressionFilter = new ExpressionFilter("first", expression, new ExpressionLabel("init"));
            expressionFilter.setExplanationEnabled(false);
        }
        if (expressionFilter != null) {
            expressionFilter.setInvisible(true);
            expressionFilter.typeCheck();
            return expressionFilter;
        }
        return (ExpressionFilter)expression;
    }

    public static enum FilterOperator {
        MIN,
        MAX,
        ARGMIN,
        ARGMAX,
        COUNT,
        SUM,
        AVG,
        FIRST,
        RANGE,
        FORALL,
        EXISTS,
        PRINT,
        PRINTALL,
        STATE;

    }
}

