/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import parser.ast.ASTElement;
import parser.ast.DeclarationType;
import parser.ast.Expression;
import parser.visitor.ASTVisitor;
import prism.PrismLangException;

public class Declaration
extends ASTElement {
    protected String name;
    protected DeclarationType declType;
    protected Expression start;

    public Declaration(String string, DeclarationType declarationType) {
        this.setName(string);
        this.setDeclType(declarationType);
        this.setStart(null);
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setDeclType(DeclarationType declarationType) {
        this.declType = declarationType;
        this.setType(declarationType.getType());
    }

    public void setStart(Expression expression) {
        this.start = expression;
    }

    public String getName() {
        return this.name;
    }

    public DeclarationType getDeclType() {
        return this.declType;
    }

    public Expression getStart() {
        return this.start;
    }

    public Expression getStartOrDefault() {
        return this.isStartSpecified() ? this.start : this.declType.getDefaultStart();
    }

    public boolean isStartSpecified() {
        return this.start != null;
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public String toString() {
        String string = "";
        string = string + this.name + " : ";
        string = string + this.declType;
        if (this.start != null) {
            string = string + " init " + this.start;
        }
        return string;
    }

    @Override
    public ASTElement deepCopy() {
        Declaration declaration = new Declaration(this.getName(), (DeclarationType)this.getDeclType().deepCopy());
        if (this.getStart() != null) {
            declaration.setStart(this.getStart().deepCopy());
        }
        declaration.setPosition(this);
        return declaration;
    }
}

