/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import parser.Values;
import parser.ast.ASTElement;
import parser.ast.Expression;
import parser.ast.ExpressionIdent;
import parser.ast.ExpressionLiteral;
import parser.type.Type;
import parser.visitor.ASTVisitor;
import prism.PrismLangException;
import prism.PrismUtils;

public class ConstantList
extends ASTElement {
    private Vector<String> names = new Vector();
    private Vector<Expression> constants = new Vector();
    private Vector<Type> types = new Vector();
    private Vector<ExpressionIdent> nameIdents = new Vector();

    public void addConstant(ExpressionIdent expressionIdent, Expression expression, Type type) {
        this.names.addElement(expressionIdent.getName());
        this.constants.addElement(expression);
        this.types.addElement(type);
        this.nameIdents.addElement(expressionIdent);
    }

    public void setConstant(int n, Expression expression) {
        this.constants.setElementAt(expression, n);
    }

    public int size() {
        return this.constants.size();
    }

    public String getConstantName(int n) {
        return this.names.elementAt(n);
    }

    public Expression getConstant(int n) {
        return this.constants.elementAt(n);
    }

    public Type getConstantType(int n) {
        return this.types.elementAt(n);
    }

    public ExpressionIdent getConstantNameIdent(int n) {
        return this.nameIdents.elementAt(n);
    }

    public int getConstantIndex(String string) {
        return this.names.indexOf(string);
    }

    public void findCycles() throws PrismLangException {
        Object object;
        int n;
        int n2 = this.constants.size();
        boolean[][] blArray = new boolean[n2][n2];
        for (n = 0; n < n2; ++n) {
            object = this.getConstant(n);
            if (object == null) continue;
            Vector<String> vector = ((ASTElement)object).getAllConstants();
            for (int i = 0; i < vector.size(); ++i) {
                int n3 = this.getConstantIndex(vector.elementAt(i));
                if (n3 == -1) continue;
                blArray[n][n3] = true;
            }
        }
        n = PrismUtils.findCycle(blArray);
        if (n != -1) {
            object = "Cyclic dependency in definition of constant \"" + this.getConstantName(n) + "\"";
            throw new PrismLangException((String)object, this.getConstant(n));
        }
    }

    public int getNumUndefined() {
        int n = 0;
        int n2 = this.constants.size();
        for (int i = 0; i < n2; ++i) {
            Expression expression = this.getConstant(i);
            if (expression != null) continue;
            ++n;
        }
        return n;
    }

    public Vector<String> getUndefinedConstants() {
        Vector<String> vector = new Vector<String>();
        int n = this.constants.size();
        for (int i = 0; i < n; ++i) {
            Expression expression = this.getConstant(i);
            if (expression != null) continue;
            vector.addElement(this.getConstantName(i));
        }
        return vector;
    }

    public boolean isDefinedConstant(String string) {
        int n = this.getConstantIndex(string);
        if (n == -1) {
            return false;
        }
        return this.getConstant(n) != null;
    }

    public Values evaluateConstants(Values values, Values values2) throws PrismLangException {
        return this.evaluateSomeOrAllConstants(values, values2, true);
    }

    public Values evaluateSomeConstants(Values values, Values values2) throws PrismLangException {
        return this.evaluateSomeOrAllConstants(values, values2, false);
    }

    private Values evaluateSomeOrAllConstants(Values values, Values values2, boolean bl) throws PrismLangException {
        Expression expression;
        int n;
        Type type = null;
        ConstantList constantList = new ConstantList();
        int n2 = this.constants.size();
        for (n = 0; n < n2; ++n) {
            int n3;
            ExpressionIdent expressionIdent = this.getConstantNameIdent(n);
            expression = this.getConstant(n);
            type = this.getConstantType(n);
            if (expression != null) {
                constantList.addConstant((ExpressionIdent)expressionIdent.deepCopy(), expression.deepCopy(), type);
                continue;
            }
            if (values != null && (n3 = values.getIndexOf(expressionIdent.getName())) != -1) {
                constantList.addConstant((ExpressionIdent)expressionIdent.deepCopy(), new ExpressionLiteral(type, type.castValueTo(values.getValue(n3))), type);
                continue;
            }
            if (!bl) continue;
            throw new PrismLangException("No value specified for constant", expressionIdent);
        }
        int n4 = constantList.size();
        if (values2 != null) {
            n2 = values2.getNumValues();
            for (n = 0; n < n2; ++n) {
                Type type2 = values2.getType(n);
                constantList.addConstant(new ExpressionIdent(values2.getName(n)), new ExpressionLiteral(type2, type2.castValueTo(values2.getValue(n))), type2);
            }
        }
        for (n = 0; n < n4; ++n) {
            try {
                expression = (Expression)constantList.getConstant(n).expandConstants(constantList);
                constantList.setConstant(n, expression);
                continue;
            }
            catch (PrismLangException prismLangException) {
                if (bl) {
                    throw prismLangException;
                }
                constantList.setConstant(n, null);
            }
        }
        Values values3 = new Values();
        for (n = 0; n < n4; ++n) {
            if (constantList.getConstant(n) == null) continue;
            Object object = constantList.getConstant(n).evaluate(null, values2);
            values3.addValue(constantList.getConstantName(n), object);
        }
        return values3;
    }

    public Map<String, Expression> evaluateConstantsPartially(Values values, Values values2) throws PrismLangException {
        Object object;
        Expression expression;
        int n;
        Type type = null;
        ConstantList constantList = new ConstantList();
        int n2 = this.constants.size();
        for (n = 0; n < n2; ++n) {
            int n3;
            ExpressionIdent expressionIdent = this.getConstantNameIdent(n);
            expression = this.getConstant(n);
            type = this.getConstantType(n);
            if (expression != null) {
                constantList.addConstant((ExpressionIdent)expressionIdent.deepCopy(), expression.deepCopy(), type);
                continue;
            }
            if (values == null || (n3 = values.getIndexOf(expressionIdent.getName())) == -1) continue;
            constantList.addConstant((ExpressionIdent)expressionIdent.deepCopy(), new ExpressionLiteral(type, type.castValueTo(values.getValue(n3))), type);
        }
        int n4 = constantList.size();
        if (values2 != null) {
            n2 = values2.getNumValues();
            for (n = 0; n < n2; ++n) {
                object = values2.getType(n);
                constantList.addConstant(new ExpressionIdent(values2.getName(n)), new ExpressionLiteral((Type)object, ((Type)object).castValueTo(values2.getValue(n))), (Type)object);
            }
        }
        for (n = 0; n < n4; ++n) {
            try {
                expression = (Expression)constantList.getConstant(n).expandConstants(constantList);
                constantList.setConstant(n, expression);
                continue;
            }
            catch (PrismLangException prismLangException) {
                constantList.setConstant(n, null);
            }
        }
        object = new HashMap();
        for (n = 0; n < n4; ++n) {
            if (constantList.getConstant(n) == null) continue;
            object.put(constantList.getConstantName(n), constantList.getConstant(n).deepCopy());
        }
        return object;
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public String toString() {
        String string = "";
        int n = this.constants.size();
        for (int i = 0; i < n; ++i) {
            string = string + "const ";
            string = string + this.getConstantType(i).getTypeString() + " ";
            string = string + this.getConstantName(i);
            Expression expression = this.getConstant(i);
            if (expression != null) {
                string = string + " = " + expression;
            }
            string = string + ";\n";
        }
        return string;
    }

    @Override
    public ASTElement deepCopy() {
        ConstantList constantList = new ConstantList();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            Expression expression = this.getConstant(i) == null ? null : this.getConstant(i).deepCopy();
            constantList.addConstant((ExpressionIdent)this.getConstantNameIdent(i).deepCopy(), expression, this.getConstantType(i));
        }
        constantList.setPosition(this);
        return constantList;
    }
}

