/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import prism.PrismUtils;

public class Coalition {
    protected boolean allPlayers;
    protected List<String> players;

    public Coalition() {
        this.allPlayers = false;
        this.players = new ArrayList<String>();
    }

    public Coalition(Coalition coalition) {
        if (coalition.isAllPlayers()) {
            this.allPlayers = true;
        } else {
            this.players = new ArrayList<String>(coalition.getPlayers());
        }
    }

    public void setAllPlayers() {
        this.allPlayers = true;
        this.players = null;
    }

    public void setPlayers(List<String> list) {
        this.allPlayers = false;
        this.players.clear();
        this.players.addAll(list);
    }

    public boolean isAllPlayers() {
        return this.allPlayers;
    }

    public List<String> getPlayers() {
        return this.players;
    }

    public boolean isPlayerIndexInCoalition(int n, List<String> list) {
        if (this.allPlayers) {
            return true;
        }
        for (String string : this.players) {
            int n2;
            try {
                n2 = Integer.parseInt(string);
                if (n != n2) continue;
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                n2 = list.indexOf(string);
                if (n2 == -1 || n != n2) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isPlayerIndexInCoalition(int n, Map<String, Integer> map) {
        if (this.allPlayers) {
            return true;
        }
        for (String string : this.players) {
            try {
                int n2 = Integer.parseInt(string);
                if (n != n2) continue;
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                Integer n3 = map.get(string);
                if (n3 == null || n != n3) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.allPlayers ? "*" : PrismUtils.joinString(this.players, ",");
    }
}

