/*
 * Decompiled with CFR 0.152.
 */
package parser;

import java.util.Arrays;
import java.util.List;
import parser.Values;
import parser.ast.ModulesFile;
import prism.PrismLangException;

public class State
implements Comparable<State> {
    public Object[] varValues;

    public State(int n) {
        this.varValues = new Object[n];
    }

    public State(State state) {
        this(state.varValues.length);
        this.copy(state);
    }

    public State(State state, State state2) {
        int n;
        Object[] objectArray = state.varValues;
        Object[] objectArray2 = state2.varValues;
        this.varValues = new Object[objectArray.length + objectArray2.length];
        for (n = 0; n < objectArray.length; ++n) {
            this.varValues[n] = objectArray[n];
        }
        for (n = 0; n < objectArray2.length; ++n) {
            this.varValues[objectArray.length + n] = objectArray2[n];
        }
    }

    public State(Values values, ModulesFile modulesFile) throws PrismLangException {
        int n;
        int n2 = values.getNumValues();
        if (n2 != modulesFile.getNumVars()) {
            throw new PrismLangException("Wrong number of variables in state");
        }
        this.varValues = new Object[n2];
        for (n = 0; n < n2; ++n) {
            this.varValues[n] = null;
        }
        for (n = 0; n < n2; ++n) {
            int n3 = modulesFile.getVarIndex(values.getName(n));
            if (n3 == -1) {
                throw new PrismLangException("Unknown variable " + values.getName(n) + " in state");
            }
            if (this.varValues[n] != null) {
                throw new PrismLangException("Duplicated variable " + values.getName(n) + " in state");
            }
            this.varValues[n] = values.getValue(n);
        }
    }

    public void clear() {
        int n = this.varValues.length;
        for (int i = 0; i < n; ++i) {
            this.varValues[i] = null;
        }
    }

    public State setValue(int n, Object object) {
        this.varValues[n] = object;
        return this;
    }

    public void copy(State state) {
        int n = this.varValues.length;
        for (int i = 0; i < n; ++i) {
            this.varValues[i] = state.varValues[i];
        }
    }

    public int hashCode() {
        return Arrays.hashCode(this.varValues);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof State)) {
            return false;
        }
        State state = (State)object;
        int n = this.varValues.length;
        if (n != state.varValues.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.varValues[i].equals(state.varValues[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(State state) {
        return this.compareTo(state, 0);
    }

    public int compareTo(State state, int n) {
        int n2;
        Object object;
        Object object2;
        int n3;
        if (state == null) {
            throw new NullPointerException();
        }
        int n4 = this.varValues.length;
        Object[] objectArray = state.varValues;
        if (n4 != objectArray.length) {
            throw new ClassCastException("States are different sizes");
        }
        if (n > n4 - 1) {
            throw new ClassCastException("Variable index is incorrect");
        }
        for (n3 = n; n3 < n4; ++n3) {
            object2 = this.varValues[n3];
            object = objectArray[n3];
            if (object2 instanceof Integer && object instanceof Integer) {
                n2 = ((Integer)object2).compareTo((Integer)object);
                if (n2 == 0) continue;
                return n2;
            }
            if (object2 instanceof Boolean && object instanceof Boolean) {
                n2 = ((Boolean)object2).compareTo((Boolean)object);
                if (n2 == 0) continue;
                return n2;
            }
            throw new ClassCastException("Can't compare " + object2.getClass() + " and " + object.getClass());
        }
        for (n3 = 0; n3 < n; ++n3) {
            object2 = this.varValues[n3];
            object = objectArray[n3];
            if (object2 instanceof Integer && object instanceof Integer) {
                n2 = ((Integer)object2).compareTo((Integer)object);
                if (n2 == 0) continue;
                return n2;
            }
            if (object2 instanceof Boolean && object instanceof Boolean) {
                n2 = ((Boolean)object2).compareTo((Boolean)object);
                if (n2 == 0) continue;
                return n2;
            }
            throw new ClassCastException("Can't compare " + object2.getClass() + " and " + object.getClass());
        }
        return 0;
    }

    public String toString() {
        String string = "(";
        int n = this.varValues.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                string = string + ",";
            }
            string = string + this.varValues[i];
        }
        string = string + ")";
        return string;
    }

    public String toStringNoParentheses() {
        String string = "";
        int n = this.varValues.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                string = string + ",";
            }
            string = string + this.varValues[i];
        }
        return string;
    }

    public String toString(List<String> list) {
        String string = "(";
        int n = this.varValues.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                string = string + ",";
            }
            string = string + list.get(i) + "=" + this.varValues[i];
        }
        string = string + ")";
        return string;
    }

    public String toString(ModulesFile modulesFile) {
        String string = "(";
        int n = this.varValues.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                string = string + ",";
            }
            string = string + modulesFile.getVarName(i) + "=" + this.varValues[i];
        }
        string = string + ")";
        return string;
    }
}

