/*
 * Decompiled with CFR 0.152.
 */
package parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import parser.ast.Declaration;
import parser.ast.DeclarationBool;
import parser.ast.DeclarationInt;
import parser.ast.DeclarationType;
import parser.ast.Expression;
import parser.ast.Module;
import parser.ast.ModulesFile;
import parser.type.Type;
import parser.type.TypeBool;
import parser.type.TypeInt;
import prism.ModelType;
import prism.Prism;
import prism.PrismException;
import prism.PrismLog;

public class ExplicitFiles2ModulesFile {
    private Prism prism;
    private PrismLog mainLog;
    private int numStates = 0;

    public ExplicitFiles2ModulesFile(Prism prism) {
        this.prism = prism;
        this.mainLog = prism.getMainLog();
    }

    public int getNumStates() {
        return this.numStates;
    }

    public ModulesFile buildModulesFile(File file, File file2, ModelType modelType) throws PrismException {
        ModulesFile modulesFile = file != null ? this.createVarInfoFromStatesFile(file) : this.createVarInfoFromTransFile(file2);
        ModelType modelType2 = modelType == null ? ModelType.MDP : modelType;
        modulesFile.setModelType(modelType2);
        return modulesFile;
    }

    private ModulesFile createVarInfoFromStatesFile(File file) throws PrismException {
        int n;
        Type[] typeArray;
        int[] nArray;
        int[] nArray2;
        int n2;
        String[] stringArray;
        int n3 = 0;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string = bufferedReader.readLine();
            n3 = 1;
            if (string == null) {
                throw new PrismException("empty states file");
            }
            if ((string = string.trim()).charAt(0) != '(' || string.charAt(string.length() - 1) != ')') {
                throw new PrismException("badly formatted state");
            }
            string = string.substring(1, string.length() - 1);
            stringArray = string.split(",");
            n2 = stringArray.length;
            nArray2 = new int[n2];
            nArray = new int[n2];
            int[] nArray3 = new int[n2];
            typeArray = new Type[n2];
            string = bufferedReader.readLine();
            ++n3;
            this.numStates = 0;
            while (string != null) {
                if ((string = string.trim()).length() > 0) {
                    ++this.numStates;
                    String[] stringArray2 = (string = string.substring(string.indexOf(40) + 1, string.indexOf(41))).split(",");
                    if (stringArray2.length != n2) {
                        throw new PrismException("wrong number of variables");
                    }
                    for (n = 0; n < n2; ++n) {
                        if (this.numStates == 1) {
                            typeArray[n] = stringArray2[n].equals("true") || stringArray2[n].equals("false") ? TypeBool.getInstance() : TypeInt.getInstance();
                        }
                        if (!(typeArray[n] instanceof TypeInt)) continue;
                        int n4 = Integer.parseInt(stringArray2[n]);
                        if (this.numStates == 1) {
                            nArray2[n] = nArray[n] = n4;
                            continue;
                        }
                        if (n4 < nArray2[n]) {
                            nArray2[n] = n4;
                        }
                        if (n4 <= nArray[n]) continue;
                        nArray[n] = n4;
                    }
                }
                string = bufferedReader.readLine();
                ++n3;
            }
            for (n = 0; n < n2; ++n) {
                if (!(typeArray[n] instanceof TypeInt)) continue;
                nArray3[n] = nArray[n] - nArray2[n];
                if (nArray3[n] != 0) continue;
                int n5 = n;
                nArray[n5] = nArray[n5] + 1;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new PrismException("File I/O error reading from \"" + file + "\"");
        }
        catch (NumberFormatException numberFormatException) {
            throw new PrismException("Error detected at line " + n3 + " of states file \"" + file + "\"");
        }
        catch (PrismException prismException) {
            throw new PrismException("Error detected (" + prismException.getMessage() + ") at line " + n3 + " of states file \"" + file + "\"");
        }
        ModulesFile modulesFile = new ModulesFile();
        Module module = new Module("M");
        for (n = 0; n < n2; ++n) {
            Declaration declaration;
            DeclarationType declarationType;
            if (typeArray[n] instanceof TypeInt) {
                declarationType = new DeclarationInt(Expression.Int(nArray2[n]), Expression.Int(nArray[n]));
                declaration = new Declaration(stringArray[n], declarationType);
                declaration.setStart(Expression.Int(nArray2[n]));
            } else {
                declarationType = new DeclarationBool();
                declaration = new Declaration(stringArray[n], declarationType);
                declaration.setStart(Expression.False());
            }
            module.addDeclaration(declaration);
        }
        modulesFile.addModule(module);
        modulesFile.tidyUp();
        return modulesFile;
    }

    private ModulesFile createVarInfoFromTransFile(File file) throws PrismException {
        int n = 0;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string = bufferedReader.readLine();
            n = 1;
            if (string == null) {
                throw new PrismException("empty transitions file");
            }
            String[] stringArray = (string = string.trim()).split(" ");
            if (stringArray.length < 2) {
                throw new PrismException("");
            }
            this.numStates = Integer.parseInt(stringArray[0]);
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new PrismException("File I/O error reading from \"" + file + "\"");
        }
        catch (NumberFormatException numberFormatException) {
            throw new PrismException("Error detected at line " + n + " of transition matrix file \"" + file + "\"");
        }
        catch (PrismException prismException) {
            throw new PrismException("Error detected (" + prismException.getMessage() + ") at line " + n + " of transition matrix file \"" + file + "\"");
        }
        ModulesFile modulesFile = new ModulesFile();
        Module module = new Module("M");
        DeclarationInt declarationInt = new DeclarationInt(Expression.Int(0), Expression.Int(this.numStates - 1));
        Declaration declaration = new Declaration("x", declarationInt);
        declaration.setStart(Expression.Int(0));
        module.addDeclaration(declaration);
        modulesFile.addModule(module);
        modulesFile.tidyUp();
        return modulesFile;
    }
}

