/*
 * Decompiled with CFR 0.152.
 */
package param;

import java.util.Iterator;
import java.util.NoSuchElementException;
import param.Region;
import param.RegionIntersection;
import param.RegionValues;
import param.StateValues;

final class RegionValuesIntersections
implements Iterable<RegionIntersection> {
    private RegionValues regions1;
    private RegionValues regions2;

    public RegionValuesIntersections(RegionValues regionValues, RegionValues regionValues2) {
        regionValues.cosplit(regionValues2);
        this.regions1 = regionValues;
        this.regions2 = regionValues2;
    }

    @Override
    public Iterator<RegionIntersection> iterator() {
        return new RegionIntersectionOperator(this.regions1, this.regions2);
    }

    private final class RegionIntersectionOperator
    implements Iterator<RegionIntersection> {
        private RegionValues regions1;
        private RegionValues regions2;
        private int numRegions1;
        private int regions1Index;
        private boolean hasNext;
        private Region region;
        private StateValues stateValues1;
        private StateValues stateValues2;

        RegionIntersectionOperator(RegionValues regionValues, RegionValues regionValues2) {
            this.regions1 = regionValues;
            this.regions2 = regionValues2;
            this.regions1Index = 0;
            this.numRegions1 = regionValues.getNumRegions();
            this.region = null;
            this.stateValues1 = null;
            this.stateValues2 = null;
            this.findNext();
        }

        private void findNext() {
            boolean bl = false;
            while (this.regions1Index < this.numRegions1 && !bl) {
                this.region = this.regions1.getRegion(this.regions1Index);
                this.stateValues1 = this.regions1.getResult(this.region);
                this.stateValues2 = this.regions2.getResult(this.region);
                bl = this.stateValues2 != null;
                ++this.regions1Index;
            }
            this.hasNext = bl;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public RegionIntersection next() {
            if (this.hasNext) {
                RegionIntersection regionIntersection = new RegionIntersection(this.region, this.stateValues1, this.stateValues2);
                this.findNext();
                return regionIntersection;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

