/*
 * Decompiled with CFR 0.152.
 */
package param;

import explicit.ModelExplicit;
import java.io.File;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import param.Function;
import param.FunctionFactory;
import param.Point;
import parser.Values;
import prism.ModelType;
import prism.PrismException;
import prism.PrismLog;

final class ParamModel
extends ModelExplicit {
    private int numTotalChoices;
    private int numTotalTransitions;
    private int[] rows;
    private int[] choices;
    private int[] cols;
    private Function[] nonZeros;
    private String[] labels;
    private Function[] sumRates;
    private ModelType modelType;
    private FunctionFactory functionFactory;

    ParamModel() {
        this.numStates = 0;
        this.numTotalChoices = 0;
        this.numTotalTransitions = 0;
        this.initialStates = new LinkedList();
        this.deadlocks = new TreeSet();
    }

    void setModelType(ModelType modelType) {
        this.modelType = modelType;
    }

    @Override
    public ModelType getModelType() {
        return this.modelType;
    }

    @Override
    public Values getConstantValues() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNumTransitions() {
        return this.numTotalTransitions;
    }

    @Override
    public Iterator<Integer> getSuccessorsIterator(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSuccessor(int n, int n2) {
        for (int i = this.stateBegin(n); i < this.stateEnd(n); ++i) {
            for (int j = this.choiceBegin(i); j < this.choiceEnd(i); ++j) {
                if (this.succState(j) != n2) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean allSuccessorsInSet(int n, BitSet bitSet) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean someSuccessorsInSet(int n, BitSet bitSet) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void findDeadlocks(boolean bl) throws PrismException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkForDeadlocks() throws PrismException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkForDeadlocks(BitSet bitSet) throws PrismException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void exportToPrismExplicit(String string) throws PrismException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void exportToPrismExplicitTra(String string) throws PrismException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void exportToPrismExplicitTra(File file) throws PrismException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void exportToPrismExplicitTra(PrismLog prismLog) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void exportToDotFile(String string) throws PrismException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void exportToDotFile(String string, BitSet bitSet) throws PrismException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void exportToDotFile(PrismLog prismLog) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void exportToDotFile(PrismLog prismLog, BitSet bitSet) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void exportTransitionsToDotFile(int n, PrismLog prismLog) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void exportToPrismLanguage(String string) throws PrismException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String infoString() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String infoStringTable() {
        String string = "";
        string = string + "States:      " + this.numStates + " (" + this.getNumInitialStates() + " initial)\n";
        string = string + "Transitions: " + this.getNumTransitions() + "\n";
        return string;
    }

    public int getNumChoices(int n) {
        return this.stateEnd(n) - this.stateBegin(n);
    }

    public int getNumTotalChoices() {
        return this.numTotalChoices;
    }

    void reserveMem(int n, int n2, int n3) {
        this.rows = new int[n + 1];
        this.choices = new int[n2 + 1];
        this.labels = new String[n3];
        this.cols = new int[n3];
        this.nonZeros = new Function[n3];
        this.sumRates = new Function[n2];
    }

    void finishState() {
        this.rows[this.numStates + 1] = this.numTotalChoices;
        ++this.numStates;
    }

    void finishChoice() {
        this.choices[this.numTotalChoices + 1] = this.numTotalTransitions;
        ++this.numTotalChoices;
    }

    void addTransition(int n, Function function, String string) {
        this.cols[this.numTotalTransitions] = n;
        this.nonZeros[this.numTotalTransitions] = function;
        this.labels[this.numTotalTransitions] = string;
        ++this.numTotalTransitions;
    }

    void setSumLeaving(Function function) {
        this.sumRates[this.numTotalChoices] = function;
    }

    int stateBegin(int n) {
        return this.rows[n];
    }

    int stateEnd(int n) {
        return this.rows[n + 1];
    }

    int choiceBegin(int n) {
        return this.choices[n];
    }

    int choiceEnd(int n) {
        return this.choices[n + 1];
    }

    int succState(int n) {
        return this.cols[n];
    }

    Function succProb(int n) {
        return this.nonZeros[n];
    }

    String getLabel(int n) {
        return this.labels[n];
    }

    Function sumLeaving(int n) {
        return this.sumRates[n];
    }

    ParamModel instantiate(Point point) {
        ParamModel paramModel = new ParamModel();
        paramModel.reserveMem(this.numStates, this.numTotalChoices, this.numTotalTransitions);
        paramModel.initialStates = new LinkedList(this.initialStates);
        for (int i = 0; i < this.numStates; ++i) {
            for (int j = this.stateBegin(i); j < this.stateEnd(i); ++j) {
                for (int k = this.choiceBegin(j); k < this.choiceEnd(j); ++k) {
                    paramModel.addTransition(this.succState(k), this.functionFactory.fromBigRational(this.succProb(k).evaluate(point)), this.labels[k]);
                }
                paramModel.setSumLeaving(this.functionFactory.fromBigRational(this.sumLeaving(j).evaluate(point)));
                paramModel.finishChoice();
            }
            paramModel.finishState();
        }
        paramModel.functionFactory = this.functionFactory;
        return paramModel;
    }

    @Override
    public void buildFromPrismExplicit(String string) throws PrismException {
        throw new UnsupportedOperationException();
    }

    void setFunctionFactory(FunctionFactory functionFactory) {
        this.functionFactory = functionFactory;
    }

    FunctionFactory getFunctionFactory() {
        return this.functionFactory;
    }
}

