/*
 * Decompiled with CFR 0.152.
 */
package param;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Random;
import param.BigRational;
import param.DagFunction;
import param.DagOperator;
import param.Function;
import param.FunctionFactory;
import param.Point;

class DagFunctionFactory
extends FunctionFactory {
    private Point randomPosition;
    private HashMap<DagOperator, DagOperator> polynomials;
    private DagOperator zeroOp;
    private DagOperator oneOp;
    private DagFunction[] parameters;
    private DagFunction zero;
    private DagFunction one;
    private DagFunction nan;
    private DagFunction inf;
    private DagFunction minf;
    private HashMap<DagFunction, DagFunction> functions;

    DagFunctionFactory(String[] stringArray, BigRational[] bigRationalArray, BigRational[] bigRationalArray2, double d, boolean bl) {
        super(stringArray, bigRationalArray, bigRationalArray2);
        Object object;
        int n;
        Random random = new Random();
        BigRational[] bigRationalArray3 = new BigRational[stringArray.length];
        int n2 = (int)Math.ceil(Math.log((double)stringArray.length / d) / Math.log(2.0));
        for (n = 0; n < stringArray.length; ++n) {
            object = new BigInteger(n2, random);
            bigRationalArray3[n] = new BigRational((BigInteger)object, BigInteger.ONE);
        }
        this.randomPosition = new Point(bigRationalArray3);
        this.polynomials = new HashMap();
        this.functions = new HashMap();
        this.zeroOp = new Number(BigInteger.ZERO);
        this.polynomials.put(this.zeroOp, this.zeroOp);
        this.oneOp = new Number(BigInteger.ONE);
        this.polynomials.put(this.oneOp, this.oneOp);
        this.zero = new DagFunction(this, this.zeroOp, this.oneOp);
        this.functions.put(this.zero, this.zero);
        this.one = new DagFunction(this, this.oneOp, this.oneOp);
        this.functions.put(this.one, this.one);
        this.nan = new DagFunction(this, 3);
        this.functions.put(this.nan, this.nan);
        this.inf = new DagFunction(this, 1);
        this.functions.put(this.inf, this.inf);
        this.minf = new DagFunction(this, 2);
        this.functions.put(this.minf, this.minf);
        this.parameters = new DagFunction[stringArray.length];
        for (n = 0; n < stringArray.length; ++n) {
            object = new Variable(n);
            this.polynomials.put((DagOperator)object, (DagOperator)object);
            this.parameters[n] = new DagFunction(this, (DagOperator)object, this.oneOp);
            this.functions.put(this.parameters[n], this.parameters[n]);
        }
    }

    @Override
    Function getZero() {
        return this.zero;
    }

    @Override
    Function getOne() {
        return this.one;
    }

    @Override
    Function getNaN() {
        return this.nan;
    }

    @Override
    Function getInf() {
        return this.inf;
    }

    @Override
    Function getMInf() {
        return this.minf;
    }

    private DagOperator makeUnique(DagOperator dagOperator) {
        DagOperator dagOperator2 = this.polynomials.get(dagOperator);
        if (dagOperator2 == null) {
            dagOperator2 = dagOperator;
            this.polynomials.put(dagOperator2, dagOperator2);
        }
        return dagOperator2;
    }

    private DagFunction makeUnique(DagFunction dagFunction) {
        DagFunction dagFunction2 = this.functions.get(dagFunction);
        if (dagFunction2 == null) {
            dagFunction2 = dagFunction;
            this.functions.put(dagFunction2, dagFunction2);
        }
        return dagFunction2;
    }

    @Override
    Function fromBigRational(BigRational bigRational) {
        bigRational = bigRational.cancel();
        DagOperator dagOperator = new Number(bigRational.getNum());
        dagOperator = this.makeUnique(dagOperator);
        DagOperator dagOperator2 = new Number(bigRational.getDen());
        dagOperator2 = this.makeUnique(dagOperator2);
        DagFunction dagFunction = new DagFunction(this, dagOperator, dagOperator2);
        return this.makeUnique(dagFunction);
    }

    @Override
    Function getVar(int n) {
        return this.parameters[n];
    }

    private DagOperator opMultiply(DagOperator dagOperator, DagOperator dagOperator2) {
        return this.makeUnique(new Multiply(dagOperator, dagOperator2));
    }

    private DagOperator opAdd(DagOperator dagOperator, DagOperator dagOperator2) {
        return this.makeUnique(new Add(dagOperator, dagOperator2));
    }

    private DagOperator opNegate(DagOperator dagOperator) {
        return this.makeUnique(new Negate(dagOperator));
    }

    public Function add(DagFunction dagFunction, DagFunction dagFunction2) {
        DagOperator dagOperator = this.opAdd(this.opMultiply(dagFunction.getNum(), dagFunction2.getDen()), this.opMultiply(dagFunction.getDen(), dagFunction2.getNum()));
        DagOperator dagOperator2 = this.opMultiply(dagFunction.getDen(), dagFunction2.getDen());
        return this.makeUnique(new DagFunction(this, dagOperator, dagOperator2));
    }

    public DagFunction negate(DagFunction dagFunction) {
        DagOperator dagOperator = this.opNegate(dagFunction.getNum());
        return this.makeUnique(new DagFunction(this, dagOperator, dagFunction.getDen()));
    }

    public Function subtract(DagFunction dagFunction, DagFunction dagFunction2) {
        DagFunction dagFunction3 = this.negate(dagFunction2);
        return this.add(dagFunction, dagFunction3);
    }

    public Function multiply(DagFunction dagFunction, DagFunction dagFunction2) {
        DagOperator dagOperator = this.opMultiply(dagFunction.getNum(), dagFunction2.getNum());
        DagOperator dagOperator2 = this.opMultiply(dagFunction.getDen(), dagFunction2.getDen());
        return this.makeUnique(new DagFunction(this, dagOperator, dagOperator2));
    }

    public Function divide(DagFunction dagFunction, DagFunction dagFunction2) {
        DagOperator dagOperator = this.opMultiply(dagFunction.getNum(), dagFunction2.getDen());
        DagOperator dagOperator2 = this.opMultiply(dagFunction.getDen(), dagFunction2.getNum());
        return this.makeUnique(new DagFunction(this, dagOperator, dagOperator2));
    }

    public Function star(DagFunction dagFunction) {
        DagOperator dagOperator = dagFunction.getDen();
        DagOperator dagOperator2 = this.opAdd(dagFunction.getDen(), this.opNegate(dagFunction.getNum()));
        return this.makeUnique(new DagFunction(this, dagOperator, dagOperator2));
    }

    public Function toConstraint(DagFunction dagFunction) {
        DagOperator dagOperator = dagFunction.getNum();
        DagOperator dagOperator2 = this.oneOp;
        return this.makeUnique(new DagFunction(this, dagOperator, dagOperator2));
    }

    private BigRational evaluate(DagOperator dagOperator, Point point) {
        if (dagOperator instanceof Number) {
            Number number = (Number)dagOperator;
            return new BigRational(number.getNumber());
        }
        if (dagOperator instanceof Variable) {
            Variable variable = (Variable)dagOperator;
            return point.getDimension(variable.getVariable());
        }
        if (dagOperator instanceof Negate) {
            Negate negate = (Negate)dagOperator;
            return this.evaluate(negate.getWhat(), point).negate();
        }
        if (dagOperator instanceof Add) {
            Add add = (Add)dagOperator;
            return this.evaluate(add.getOp1(), point).add(this.evaluate(add.getOp2(), point));
        }
        if (dagOperator instanceof Multiply) {
            Multiply multiply = (Multiply)dagOperator;
            return this.evaluate(multiply.getOp1(), point).multiply(this.evaluate(multiply.getOp2(), point));
        }
        throw new RuntimeException("invalid operator");
    }

    public BigRational evaluate(DagFunction dagFunction, Point point, boolean bl) {
        if (dagFunction.getType() == 3) {
            return BigRational.NAN;
        }
        return this.evaluate(dagFunction.getNum(), point).divide(this.evaluate(dagFunction.getDen(), point));
    }

    public BigRational asBigRational(DagFunction dagFunction) {
        BigRational[] bigRationalArray = new BigRational[this.parameterNames.length];
        for (int i = 0; i < this.parameterNames.length; ++i) {
            bigRationalArray[i] = BigRational.ZERO;
        }
        return this.evaluate(dagFunction, new Point(bigRationalArray), true);
    }

    public boolean isOne(DagFunction dagFunction) {
        return dagFunction == this.one;
    }

    public boolean isZero(DagFunction dagFunction) {
        return dagFunction == this.zero;
    }

    public String toString(DagFunction dagFunction) {
        return "(" + dagFunction.getNum().toString() + ")/(" + dagFunction.getDen().toString() + ")";
    }

    private class Multiply
    extends DagOperator {
        private DagOperator op1;
        private DagOperator op2;

        Multiply(DagOperator dagOperator, DagOperator dagOperator2) {
            super(dagOperator.getCValue().multiply(dagOperator2.getCValue()));
            this.op1 = dagOperator;
            this.op2 = dagOperator2;
        }

        DagOperator getOp1() {
            return this.op1;
        }

        DagOperator getOp2() {
            return this.op2;
        }

        public String toString() {
            return "(" + this.op1.toString() + "*" + this.op2.toString() + ")";
        }
    }

    private class Add
    extends DagOperator {
        private DagOperator op1;
        private DagOperator op2;

        Add(DagOperator dagOperator, DagOperator dagOperator2) {
            super(dagOperator.getCValue().add(dagOperator2.getCValue()));
            this.op1 = dagOperator;
            this.op2 = dagOperator2;
        }

        DagOperator getOp1() {
            return this.op1;
        }

        DagOperator getOp2() {
            return this.op2;
        }

        public String toString() {
            return "(" + this.op1.toString() + "+" + this.op2.toString() + ")";
        }
    }

    private class Negate
    extends DagOperator {
        private DagOperator what;

        Negate(DagOperator dagOperator) {
            super(dagOperator.getCValue().negate());
            this.what = dagOperator;
        }

        DagOperator getWhat() {
            return this.what;
        }

        public String toString() {
            return "-(" + this.what.toString() + ")";
        }
    }

    private class Variable
    extends DagOperator {
        private int variable;

        Variable(int n) {
            super(DagFunctionFactory.this.randomPosition.getDimension(n).getNum());
            this.variable = n;
        }

        int getVariable() {
            return this.variable;
        }

        public String toString() {
            return DagFunctionFactory.this.parameterNames[this.variable];
        }
    }

    private class Number
    extends DagOperator {
        private BigInteger number;

        Number(BigInteger bigInteger) {
            super(bigInteger);
            this.number = bigInteger;
        }

        BigInteger getNumber() {
            return this.number;
        }

        public String toString() {
            return this.number.toString();
        }
    }
}

