/*
 * Decompiled with CFR 0.152.
 */
package jltl2dstar;

import java.io.PrintStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import jltl2ba.APElement;
import jltl2ba.APSet;
import jltl2ba.MyBitSet;
import jltl2dstar.APMonom;
import jltl2dstar.NBA_State;
import jltl2dstar.SCCs;
import prism.PrismException;

public class NBA
implements Iterable<NBA_State> {
    private int _state_count = 0;
    private Vector<NBA_State> _index;
    private APSet _apset;
    private NBA_State _start_state = null;
    private MyBitSet _final_states;
    private boolean _fail_if_disjoint = false;

    public NBA(APSet aPSet) {
        this._apset = aPSet;
        this._index = new Vector();
        this._final_states = new MyBitSet();
    }

    public NBA_State newState() {
        ++this._state_count;
        NBA_State nBA_State = new NBA_State(this);
        this._index.add(nBA_State);
        return nBA_State;
    }

    public int size() {
        return this._index.size();
    }

    public NBA_State get(int n) {
        return this._index.get(n);
    }

    public int getAPSize() {
        return this._apset.size();
    }

    public APSet getAPSet() {
        return this._apset;
    }

    public void switchAPSet(APSet aPSet) throws PrismException {
        if (aPSet.size() != this._apset.size()) {
            throw new PrismException("New APSet has to have the same size as the old APSet!");
        }
        this._apset = aPSet;
    }

    public int getIndexForState(NBA_State nBA_State) {
        return this._index.indexOf(nBA_State);
    }

    public void setStartState(NBA_State nBA_State) {
        this._start_state = nBA_State;
    }

    public NBA_State getStartState() {
        return this._start_state;
    }

    public MyBitSet getFinalStates() {
        return this._final_states;
    }

    public void removeRedundantFinalStates(SCCs sCCs) {
        for (int i = 0; i < sCCs.countSCCs(); ++i) {
            int n;
            NBA_State nBA_State;
            if (sCCs.get(i).cardinality() != 1 || !(nBA_State = this.get(n = sCCs.get(i).nextSetBit(0))).isFinal() || sCCs.stateIsReachable(n, n)) continue;
            nBA_State.setFinal(false);
        }
    }

    public boolean isDeterministic() {
        for (NBA_State nBA_State : this._index) {
            for (Map.Entry<APElement, MyBitSet> entry : nBA_State) {
                if (entry.getValue().cardinality() <= 1) continue;
                return false;
            }
        }
        return true;
    }

    public NBA product_automaton(NBA nBA) {
        int n;
        int n2;
        NBA nBA2 = this;
        NBA nBA3 = new NBA(nBA2.getAPSet());
        APSet aPSet = nBA2.getAPSet();
        for (n2 = 0; n2 < nBA2.size(); ++n2) {
            for (n = 0; n < nBA.size(); ++n) {
                for (int i = 0; i < 2; ++i) {
                    int n3 = nBA3.nba_i_newState();
                    int n4 = i;
                    if (i == 0 && nBA2.get(n2).isFinal()) {
                        n4 = 1;
                    }
                    if (i == 1 && nBA.get(n).isFinal()) {
                        nBA3.get(n3).setFinal(true);
                        n4 = 0;
                    }
                    APElement aPElement = new APElement(aPSet.size());
                    for (int j = 0; j < 1 << aPSet.size(); ++j) {
                        MyBitSet myBitSet = nBA2.get(n2).getEdge(aPElement);
                        MyBitSet myBitSet2 = nBA.get(n).getEdge(aPElement);
                        MyBitSet myBitSet3 = new MyBitSet();
                        int n5 = myBitSet.nextSetBit(0);
                        while (n5 != -1) {
                            int n6 = myBitSet2.nextSetBit(0);
                            while (n6 != -1) {
                                int n7 = 2 * (n5 * nBA.size() + n6) + n4;
                                myBitSet3.set(n7);
                                n6 = myBitSet2.nextSetBit(n6);
                            }
                            n5 = myBitSet.nextSetBit(n5);
                        }
                        nBA3.get(n3).addEdges(aPElement, myBitSet3);
                        aPElement.increment();
                    }
                }
            }
        }
        n2 = nBA2.getStartState().getName();
        n = nBA.getStartState().getName();
        nBA3.setStartState(nBA3.get(n2 * nBA.size() + n));
        return nBA3;
    }

    public void print(PrintStream printStream) {
        for (NBA_State nBA_State : this._index) {
            printStream.print("State " + nBA_State.getName());
            if (this.getStartState() == nBA_State) {
                printStream.print(" *");
            }
            if (nBA_State.isFinal()) {
                printStream.print(" !");
            }
            printStream.println();
            for (Map.Entry<APElement, MyBitSet> entry : nBA_State) {
                APElement aPElement = entry.getKey();
                MyBitSet myBitSet = entry.getValue();
                printStream.println(" " + aPElement.toString(this.getAPSet(), true) + " -> " + myBitSet.toString());
            }
        }
    }

    public int getStateCount() {
        return this._state_count;
    }

    public void setFailIfDisjoint(boolean bl) {
        this._fail_if_disjoint = bl;
    }

    public boolean getFailIfDisjoint() {
        return this._fail_if_disjoint;
    }

    public int nba_i_newState() {
        return this.newState().getName();
    }

    public void nba_i_addEdge(int n, APMonom aPMonom, int n2) {
        this.get(n).addEdge(aPMonom, this.get(n2));
    }

    public APSet nba_i_getAPSet() {
        return this.getAPSet();
    }

    public void nba_i_setFinal(int n, boolean bl) {
        this.get(n).setFinal(bl);
    }

    public void nba_i_setStartState(int n) {
        this.setStartState(this.get(n));
    }

    @Override
    public Iterator<NBA_State> iterator() {
        return this._index.iterator();
    }
}

