/*
 * Decompiled with CFR 0.152.
 */
package jltl2dstar;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import jltl2ba.APElement;
import jltl2ba.APElementIterator;
import jltl2ba.MyBitSet;
import jltl2dstar.DA;
import jltl2dstar.DA_State;
import jltl2dstar.DRA;
import prism.PrismException;

public class DRAOptimizations {
    public DRA optimizeBisimulation(DRA dRA, boolean bl, boolean bl2, boolean bl3) throws PrismException {
        Object object;
        int n;
        if (!dRA.isCompact()) {
            dRA.makeCompact();
        }
        Vector<Integer> vector = new Vector<Integer>(dRA.size());
        vector.setSize(dRA.size());
        for (int i = 0; i < dRA.size(); ++i) {
            vector.set(i, new Integer(i));
        }
        AcceptanceSignatureContainer acceptanceSignatureContainer = new AcceptanceSignatureContainer(dRA);
        AcceptanceSignatureComparator acceptanceSignatureComparator = new AcceptanceSignatureComparator(acceptanceSignatureContainer);
        Coloring coloring = new Coloring(dRA, bl2);
        Coloring coloring2 = this.generateColoring(vector, coloring, acceptanceSignatureComparator);
        int n2 = dRA.size();
        int n3 = coloring2.countColors();
        while ((n = coloring2.countColors()) != (coloring2 = (coloring = this.generateColoring(vector, coloring2, object = new ColoredStateComparator(coloring2, dRA)))).countColors()) {
        }
        if (bl) {
            coloring2.print(System.err);
        }
        object = this.generateDRAfromColoring(dRA, coloring2, bl2);
        int n4 = ((DA)object).size();
        if (bl3) {
            System.err.println("Bisimulation: From (" + n2 + ") To (" + n4 + ") Initial: (" + n3 + ")");
        }
        return object;
    }

    private <T extends Comparator<Integer>> Coloring generateColoring(Vector<Integer> vector, Coloring coloring, T object) {
        Integer[] integerArray = vector.toArray(new Integer[0]);
        Arrays.sort(integerArray, object);
        Vector<Integer> vector2 = new Vector<Integer>(Arrays.asList(integerArray));
        Coloring coloring2 = new Coloring(coloring.size(), coloring.getFlagDetailed());
        if (vector2.size() == 0) {
            return coloring2;
        }
        ListIterator<Integer> listIterator = vector2.listIterator(vector2.size());
        ListIterator<Integer> listIterator2 = vector2.listIterator(vector2.size());
        coloring2.setColor(listIterator.previous(), coloring2.newColor());
        while (listIterator.hasPrevious()) {
            Integer n = listIterator.previous();
            if (object.compare((Integer)n, (Integer)listIterator2.previous()) < 0) {
                coloring2.setColor(n, coloring2.newColor());
                continue;
            }
            coloring2.setColor(n, coloring2.currentColor());
        }
        return coloring2;
    }

    private DRA generateDRAfromColoring(DRA dRA, Coloring coloring, boolean bl) throws PrismException {
        int n;
        DRA dRA2 = new DRA(dRA.getAPSet());
        dRA2.acceptance().newAcceptancePairs(dRA.acceptance().size());
        for (n = 0; n < coloring.countColors(); ++n) {
            dRA2.newState();
        }
        n = dRA.getStartState().getName();
        int n2 = coloring.state2color(n);
        dRA2.setStartState(dRA2.get(n2));
        for (int i = 0; i < coloring.countColors(); ++i) {
            DA_State dA_State = dRA2.get(i);
            int n3 = coloring.color2state(i);
            DA_State dA_State2 = dRA.get(n3);
            if (bl) {
                MyBitSet myBitSet = coloring.color2states(i);
                if (myBitSet.cardinality() == 1) {
                    if (dA_State2.hasDescription()) {
                        dA_State.setDescription(dA_State2.getDescription());
                    }
                } else {
                    Object object = "<TABLE BORDER=\"1\" CELLBORDER=\"0\"><TR><TD>{</TD>";
                    boolean bl2 = true;
                    for (Integer n4 : myBitSet) {
                        boolean entry;
                        if (entry) {
                            entry = false;
                        } else {
                            object = (String)object + "<TD>,</TD>";
                        }
                        object = (String)object + "<TD>";
                        object = !dRA.get(n4).hasDescription() ? (String)object + n4 : (String)object + dRA.get(n4).getDescription();
                        object = (String)object + "</TD>";
                    }
                    object = (String)object + "<TD>}</TD></TR></TABLE>";
                    dA_State.setDescription((String)object);
                }
            }
            int n5 = dA_State2.getName();
            for (int j = 0; j < dRA.acceptance().size(); ++j) {
                if (dRA.acceptance().isStateInAcceptance_L(j, n5)) {
                    dA_State.acceptance().addTo_L(j);
                }
                if (!dRA.acceptance().isStateInAcceptance_U(j, n5)) continue;
                dA_State.acceptance().addTo_U(j);
            }
            for (Map.Entry entry : dA_State2.edges().entrySet()) {
                int n6 = coloring.state2color(((DA_State)entry.getValue()).getName());
                dA_State.edges().put((APElement)entry.getKey(), dRA2.get(n6));
            }
        }
        return dRA2;
    }

    public static class AcceptanceSignatureComparator
    implements Comparator<Integer> {
        private AcceptanceSignatureContainer _container;

        public AcceptanceSignatureComparator(AcceptanceSignatureContainer acceptanceSignatureContainer) {
            this._container = acceptanceSignatureContainer;
        }

        @Override
        public int compare(Integer n, Integer n2) {
            AcceptanceSignature acceptanceSignature = this._container.get(n);
            AcceptanceSignature acceptanceSignature2 = this._container.get(n2);
            return acceptanceSignature.l.compareTo(acceptanceSignature2.l) == 0 ? acceptanceSignature.u.compareTo(acceptanceSignature2.u) : acceptanceSignature.l.compareTo(acceptanceSignature2.l);
        }

        public boolean equals(Integer n, Integer n2) {
            return this.compare(n, n2) == 0;
        }
    }

    public static class AcceptanceSignatureContainer {
        private Vector<AcceptanceSignature> _acceptancesig_vector;

        public AcceptanceSignatureContainer(DRA dRA) {
            this._acceptancesig_vector = new Vector(dRA.size());
            for (int i = 0; i < dRA.size(); ++i) {
                this._acceptancesig_vector.add(new AcceptanceSignature());
                this._acceptancesig_vector.get((int)i).l = (MyBitSet)dRA.acceptance().getAcceptance_L_forState(i).clone();
                this._acceptancesig_vector.get((int)i).u = (MyBitSet)dRA.acceptance().getAcceptance_U_forState(i).clone();
            }
        }

        public AcceptanceSignature get(int n) {
            return this._acceptancesig_vector.get(n);
        }
    }

    public static class AcceptanceSignature {
        public MyBitSet l;
        public MyBitSet u;
    }

    public static class ColoredStateComparator
    implements Comparator<Integer> {
        private Coloring _coloring;
        private DRA _dra;

        public ColoredStateComparator(Coloring coloring, DRA dRA) {
            this._coloring = coloring;
            this._dra = dRA;
        }

        @Override
        public int compare(Integer n, Integer n2) {
            int n3;
            int n4 = this._coloring.state2color(n);
            if (n4 < (n3 = this._coloring.state2color(n2))) {
                return -1;
            }
            if (n4 > n3) {
                return 1;
            }
            APElementIterator aPElementIterator = new APElementIterator(this._dra.getAPSize());
            while (aPElementIterator.hasNext()) {
                int n5;
                APElement aPElement = aPElementIterator.next();
                DA_State dA_State = this._dra.get(n).edges().get(aPElement);
                DA_State dA_State2 = this._dra.get(n2).edges().get(aPElement);
                int n6 = this._coloring.state2color(dA_State.getName());
                if (n6 < (n5 = this._coloring.state2color(dA_State2.getName()))) {
                    return -1;
                }
                if (n6 <= n5) continue;
                return 1;
            }
            return 0;
        }
    }

    public static class Coloring {
        private int _nr_of_colors = 0;
        private Vector<Integer> _coloring;
        private boolean _detailed;
        private Vector<MyBitSet> _color2states;
        private Vector<Integer> _color2state;

        public Coloring(DRA dRA, boolean bl) {
            this._detailed = bl;
            this._coloring = new Vector(dRA.size());
            this._coloring.setSize(dRA.size());
            this._color2state = new Vector();
            this._color2states = this._detailed ? new Vector() : null;
        }

        public Coloring(int n, boolean bl) {
            this._detailed = bl;
            this._coloring = new Vector(n);
            this._coloring.setSize(n);
            this._color2state = new Vector();
            this._color2states = this._detailed ? new Vector() : null;
        }

        public void reset() {
            this._nr_of_colors = 0;
        }

        public boolean getFlagDetailed() {
            return this._detailed;
        }

        public int size() {
            return this._coloring.size();
        }

        public int newColor() {
            ++this._nr_of_colors;
            this._color2state.setSize(this._nr_of_colors);
            if (this._detailed) {
                this._color2states.setSize(this._nr_of_colors);
                this._color2states.set(this._nr_of_colors - 1, new MyBitSet());
            }
            return this._nr_of_colors - 1;
        }

        public int currentColor() {
            assert (this._nr_of_colors > 0);
            return this._nr_of_colors - 1;
        }

        public int countColors() {
            return this._nr_of_colors;
        }

        public void setColor(int n, int n2) {
            assert (n2 < this._nr_of_colors);
            this._coloring.set(n, new Integer(n2));
            this._color2state.set(n2, new Integer(n));
            if (this._detailed) {
                this._color2states.get(n2).set(n);
            }
        }

        public int state2color(int n) {
            return this._coloring.get(n);
        }

        public int color2state(int n) {
            assert (n < this._nr_of_colors);
            return this._color2state.get(n);
        }

        public MyBitSet color2states(int n) {
            assert (n < this._nr_of_colors);
            assert (this._detailed && this._color2states != null);
            return this._color2states.get(n);
        }

        public void print(PrintStream printStream) {
            for (int i = 0; i < this.size(); ++i) {
                printStream.println("color[" + i + "] = " + this.state2color(i));
            }
        }
    }
}

