/*
 * Decompiled with CFR 0.152.
 */
package jdd;

import java.util.Vector;
import jdd.JDD;
import jdd.JDDNode;

public class JDDVars {
    private Vector vars = new Vector();
    private long array = 0L;
    private boolean arrayBuilt = false;

    private native long DDV_BuildArray();

    private native void DDV_FreeArray(long var1);

    private native int DDV_GetIndex(long var1);

    public void addVar(JDDNode jDDNode) {
        this.vars.addElement(jDDNode);
        if (this.arrayBuilt) {
            this.DDV_FreeArray(this.array);
        }
        this.arrayBuilt = false;
    }

    public void addVars(JDDVars jDDVars) {
        this.vars.addAll(jDDVars.vars);
        if (this.arrayBuilt) {
            this.DDV_FreeArray(this.array);
        }
        this.arrayBuilt = false;
    }

    public void removeVars(JDDVars jDDVars) {
        this.vars.removeAll(jDDVars.vars);
        if (this.arrayBuilt) {
            this.DDV_FreeArray(this.array);
        }
        this.arrayBuilt = false;
    }

    public int getNumVars() {
        return this.vars.size();
    }

    public JDDNode getVar(int n) {
        return (JDDNode)this.vars.elementAt(n);
    }

    public long getVarPtr(int n) {
        return ((JDDNode)this.vars.elementAt(n)).ptr();
    }

    public int getVarIndex(int n) {
        return this.DDV_GetIndex(((JDDNode)this.vars.elementAt(n)).ptr());
    }

    public int getMinVarIndex() {
        int n = this.vars.size();
        if (n == 0) {
            return -1;
        }
        int n2 = this.getVarIndex(0);
        for (int i = 1; i < n; ++i) {
            int n3 = this.getVarIndex(i);
            if (n3 >= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    public int getMaxVarIndex() {
        int n = this.vars.size();
        if (n == 0) {
            return -1;
        }
        int n2 = this.getVarIndex(0);
        for (int i = 1; i < n; ++i) {
            int n3 = this.getVarIndex(i);
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    public void refAll() {
        for (int i = 0; i < this.vars.size(); ++i) {
            JDD.Ref((JDDNode)this.vars.elementAt(i));
        }
    }

    public void derefAll() {
        for (int i = 0; i < this.vars.size(); ++i) {
            JDD.Deref((JDDNode)this.vars.elementAt(i));
        }
    }

    public long array() {
        if (this.arrayBuilt) {
            return this.array;
        }
        this.array = this.DDV_BuildArray();
        this.arrayBuilt = true;
        return this.array;
    }

    public int n() {
        return this.vars.size();
    }

    public String toString() {
        String string = "{";
        for (int i = 0; i < this.vars.size() - 1; ++i) {
            string = string + this.getVarIndex(i) + ", ";
        }
        if (this.vars.size() > 0) {
            string = string + this.getVarIndex(this.vars.size() - 1);
        }
        string = string + "}";
        return string;
    }

    static {
        try {
            System.loadLibrary("jdd");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.out.println(unsatisfiedLinkError);
            System.exit(1);
        }
    }
}

